/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegionalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegionalSummary> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(RegionalSummary.getter(RegionalSummary::regionName)).setter(RegionalSummary.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").unmarshallLocationName("regionName").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_MATCHED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfMatchedAccounts").getter(RegionalSummary.getter(RegionalSummary::numberOfMatchedAccounts)).setter(RegionalSummary.setter(Builder::numberOfMatchedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMatchedAccounts").unmarshallLocationName("numberOfMatchedAccounts").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfUnmatchedAccounts").getter(RegionalSummary.getter(RegionalSummary::numberOfUnmatchedAccounts)).setter(RegionalSummary.setter(Builder::numberOfUnmatchedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfUnmatchedAccounts").unmarshallLocationName("numberOfUnmatchedAccounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, NUMBER_OF_MATCHED_ACCOUNTS_FIELD, NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegionalSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final Integer numberOfMatchedAccounts;
    private final Integer numberOfUnmatchedAccounts;

    private RegionalSummary(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.numberOfMatchedAccounts = builder.numberOfMatchedAccounts;
        this.numberOfUnmatchedAccounts = builder.numberOfUnmatchedAccounts;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final Integer numberOfMatchedAccounts() {
        return this.numberOfMatchedAccounts;
    }

    public final Integer numberOfUnmatchedAccounts() {
        return this.numberOfUnmatchedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMatchedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfUnmatchedAccounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionalSummary)) {
            return false;
        }
        RegionalSummary other = (RegionalSummary)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.numberOfMatchedAccounts(), other.numberOfMatchedAccounts()) && Objects.equals(this.numberOfUnmatchedAccounts(), other.numberOfUnmatchedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"RegionalSummary").add("RegionName", (Object)this.regionName()).add("NumberOfMatchedAccounts", (Object)this.numberOfMatchedAccounts()).add("NumberOfUnmatchedAccounts", (Object)this.numberOfUnmatchedAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "NumberOfMatchedAccounts": {
                return Optional.ofNullable(clazz.cast(this.numberOfMatchedAccounts()));
            }
            case "NumberOfUnmatchedAccounts": {
                return Optional.ofNullable(clazz.cast(this.numberOfUnmatchedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("NumberOfMatchedAccounts", NUMBER_OF_MATCHED_ACCOUNTS_FIELD);
        map.put("NumberOfUnmatchedAccounts", NUMBER_OF_UNMATCHED_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionalSummary, T> g) {
        return obj -> g.apply((RegionalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private Integer numberOfMatchedAccounts;
        private Integer numberOfUnmatchedAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionalSummary model) {
            this.regionName(model.regionName);
            this.numberOfMatchedAccounts(model.numberOfMatchedAccounts);
            this.numberOfUnmatchedAccounts(model.numberOfUnmatchedAccounts);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final Integer getNumberOfMatchedAccounts() {
            return this.numberOfMatchedAccounts;
        }

        public final void setNumberOfMatchedAccounts(Integer numberOfMatchedAccounts) {
            this.numberOfMatchedAccounts = numberOfMatchedAccounts;
        }

        @Override
        public final Builder numberOfMatchedAccounts(Integer numberOfMatchedAccounts) {
            this.numberOfMatchedAccounts = numberOfMatchedAccounts;
            return this;
        }

        public final Integer getNumberOfUnmatchedAccounts() {
            return this.numberOfUnmatchedAccounts;
        }

        public final void setNumberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts) {
            this.numberOfUnmatchedAccounts = numberOfUnmatchedAccounts;
        }

        @Override
        public final Builder numberOfUnmatchedAccounts(Integer numberOfUnmatchedAccounts) {
            this.numberOfUnmatchedAccounts = numberOfUnmatchedAccounts;
            return this;
        }

        public RegionalSummary build() {
            return new RegionalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegionalSummary> {
        public Builder regionName(String var1);

        public Builder numberOfMatchedAccounts(Integer var1);

        public Builder numberOfUnmatchedAccounts(Integer var1);
    }
}

