/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AllowedImagesSettingsEnabledState;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableAllowedImagesSettingsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, EnableAllowedImagesSettingsRequest> {
    private static final SdkField<String> ALLOWED_IMAGES_SETTINGS_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedImagesSettingsState").getter(EnableAllowedImagesSettingsRequest.getter(EnableAllowedImagesSettingsRequest::allowedImagesSettingsStateAsString)).setter(EnableAllowedImagesSettingsRequest.setter(Builder::allowedImagesSettingsState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedImagesSettingsState").unmarshallLocationName("AllowedImagesSettingsState").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(EnableAllowedImagesSettingsRequest.getter(EnableAllowedImagesSettingsRequest::dryRun)).setter(EnableAllowedImagesSettingsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_IMAGES_SETTINGS_STATE_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableAllowedImagesSettingsRequest.memberNameToFieldInitializer();
    private final String allowedImagesSettingsState;
    private final Boolean dryRun;

    private EnableAllowedImagesSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.allowedImagesSettingsState = builder.allowedImagesSettingsState;
        this.dryRun = builder.dryRun;
    }

    public final AllowedImagesSettingsEnabledState allowedImagesSettingsState() {
        return AllowedImagesSettingsEnabledState.fromValue(this.allowedImagesSettingsState);
    }

    public final String allowedImagesSettingsStateAsString() {
        return this.allowedImagesSettingsState;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedImagesSettingsStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAllowedImagesSettingsRequest)) {
            return false;
        }
        EnableAllowedImagesSettingsRequest other = (EnableAllowedImagesSettingsRequest)((Object)obj);
        return Objects.equals(this.allowedImagesSettingsStateAsString(), other.allowedImagesSettingsStateAsString()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"EnableAllowedImagesSettingsRequest").add("AllowedImagesSettingsState", (Object)this.allowedImagesSettingsStateAsString()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedImagesSettingsState": {
                return Optional.ofNullable(clazz.cast(this.allowedImagesSettingsStateAsString()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllowedImagesSettingsState", ALLOWED_IMAGES_SETTINGS_STATE_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableAllowedImagesSettingsRequest, T> g) {
        return obj -> g.apply((EnableAllowedImagesSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String allowedImagesSettingsState;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAllowedImagesSettingsRequest model) {
            super(model);
            this.allowedImagesSettingsState(model.allowedImagesSettingsState);
            this.dryRun(model.dryRun);
        }

        public final String getAllowedImagesSettingsState() {
            return this.allowedImagesSettingsState;
        }

        public final void setAllowedImagesSettingsState(String allowedImagesSettingsState) {
            this.allowedImagesSettingsState = allowedImagesSettingsState;
        }

        @Override
        public final Builder allowedImagesSettingsState(String allowedImagesSettingsState) {
            this.allowedImagesSettingsState = allowedImagesSettingsState;
            return this;
        }

        @Override
        public final Builder allowedImagesSettingsState(AllowedImagesSettingsEnabledState allowedImagesSettingsState) {
            this.allowedImagesSettingsState(allowedImagesSettingsState == null ? null : allowedImagesSettingsState.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableAllowedImagesSettingsRequest build() {
            return new EnableAllowedImagesSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableAllowedImagesSettingsRequest> {
        public Builder allowedImagesSettingsState(String var1);

        public Builder allowedImagesSettingsState(AllowedImagesSettingsEnabledState var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

