/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.node.pointInTime;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.legacy.pit.PointInTimeHandlerImpl;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.planner.physical.node.Paginate;

public class PointInTime
extends Paginate {
    private static final Logger LOG = LogManager.getLogger();
    private String pitId;
    private PointInTimeHandlerImpl pit;

    public PointInTime(TableInJoinRequestBuilder request, int pageSize) {
        super(request, pageSize);
    }

    @Override
    public void close() {
        if (this.searchResponse != null) {
            LOG.debug("Closing Point In Time (PIT) context");
            this.pit.delete();
            this.searchResponse = null;
        } else {
            LOG.debug("PIT context is already closed or was never opened");
        }
    }

    @Override
    protected void loadFirstBatch() {
        if (this.request.getHintJoinTimeout() != null) {
            TimeValue customTimeout = this.request.getHintJoinTimeout();
            LOG.info("PointInTime: Creating PIT with JOIN_TIME_OUT hint: {} seconds", (Object)customTimeout.getSeconds());
            this.pit = new PointInTimeHandlerImpl(this.client, this.request.getOriginalSelect().getIndexArr(), customTimeout);
        } else {
            LOG.info("PointInTime: Creating PIT with default timeout value: {}");
            this.pit = new PointInTimeHandlerImpl(this.client, this.request.getOriginalSelect().getIndexArr());
        }
        this.pit.create();
        this.pitId = this.pit.getPitId();
        LOG.info("Loading first batch of response using Point In Time");
        this.searchResponse = (SearchResponse)this.request.getRequestBuilder().addSort("_doc", SortOrder.ASC).addSort("_id", SortOrder.ASC).setSize(this.pageSize).setTimeout(TimeValue.timeValueSeconds((long)this.timeout.intValue())).setPointInTime(new PointInTimeBuilder(this.pitId)).get();
    }

    @Override
    protected void loadNextBatch() {
        SearchHit[] hits = this.searchResponse.getHits().getHits();
        if (hits != null && hits.length > 0) {
            Object[] sortValues = hits[hits.length - 1].getSortValues();
            LOG.info("Loading next batch of response using Point In Time. - " + this.pitId);
            this.searchResponse = (SearchResponse)this.request.getRequestBuilder().setSize(this.pageSize).setTimeout(TimeValue.timeValueSeconds((long)this.timeout.intValue())).setPointInTime(new PointInTimeBuilder(this.pitId)).searchAfter(sortValues).get();
        }
    }
}

