/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.sandbox.search.QueryProfilerBreakdown;
import org.apache.lucene.sandbox.search.QueryProfilerTimer;
import org.apache.lucene.sandbox.search.QueryProfilerTimingType;
import org.apache.lucene.sandbox.search.QueryProfilerWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

class QueryProfilerScorer
extends Scorer {
    private final Scorer scorer;
    private QueryProfilerWeight profileWeight;
    private final QueryProfilerTimer scoreTimer;
    private final QueryProfilerTimer nextDocTimer;
    private final QueryProfilerTimer advanceTimer;
    private final QueryProfilerTimer matchTimer;
    private final QueryProfilerTimer shallowAdvanceTimer;
    private final QueryProfilerTimer computeMaxScoreTimer;
    private final QueryProfilerTimer setMinCompetitiveScoreTimer;

    QueryProfilerScorer(QueryProfilerWeight w, Scorer scorer, QueryProfilerBreakdown profile) {
        super(w);
        this.scorer = scorer;
        this.profileWeight = w;
        this.scoreTimer = profile.getTimer(QueryProfilerTimingType.SCORE);
        this.nextDocTimer = profile.getTimer(QueryProfilerTimingType.NEXT_DOC);
        this.advanceTimer = profile.getTimer(QueryProfilerTimingType.ADVANCE);
        this.matchTimer = profile.getTimer(QueryProfilerTimingType.MATCH);
        this.shallowAdvanceTimer = profile.getTimer(QueryProfilerTimingType.SHALLOW_ADVANCE);
        this.computeMaxScoreTimer = profile.getTimer(QueryProfilerTimingType.COMPUTE_MAX_SCORE);
        this.setMinCompetitiveScoreTimer = profile.getTimer(QueryProfilerTimingType.SET_MIN_COMPETITIVE_SCORE);
    }

    @Override
    public int docID() {
        return this.scorer.docID();
    }

    @Override
    public float score() throws IOException {
        this.scoreTimer.start();
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.scoreTimer.stop();
        }
    }

    @Override
    public Weight getWeight() {
        return this.profileWeight;
    }

    @Override
    public Collection<Scorable.ChildScorable> getChildren() throws IOException {
        return this.scorer.getChildren();
    }

    @Override
    public DocIdSetIterator iterator() {
        final DocIdSetIterator in = this.scorer.iterator();
        return new DocIdSetIterator(){

            @Override
            public int advance(int target) throws IOException {
                QueryProfilerScorer.this.advanceTimer.start();
                try {
                    int n = in.advance(target);
                    return n;
                }
                finally {
                    QueryProfilerScorer.this.advanceTimer.stop();
                }
            }

            @Override
            public int nextDoc() throws IOException {
                QueryProfilerScorer.this.nextDocTimer.start();
                try {
                    int n = in.nextDoc();
                    return n;
                }
                finally {
                    QueryProfilerScorer.this.nextDocTimer.stop();
                }
            }

            @Override
            public int docID() {
                return in.docID();
            }

            @Override
            public long cost() {
                return in.cost();
            }
        };
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.scorer.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        DocIdSetIterator approximation = new DocIdSetIterator(){

            @Override
            public int advance(int target) throws IOException {
                QueryProfilerScorer.this.advanceTimer.start();
                try {
                    int n = inApproximation.advance(target);
                    return n;
                }
                finally {
                    QueryProfilerScorer.this.advanceTimer.stop();
                }
            }

            @Override
            public int nextDoc() throws IOException {
                QueryProfilerScorer.this.nextDocTimer.start();
                try {
                    int n = inApproximation.nextDoc();
                    return n;
                }
                finally {
                    QueryProfilerScorer.this.nextDocTimer.stop();
                }
            }

            @Override
            public int docID() {
                return inApproximation.docID();
            }

            @Override
            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                QueryProfilerScorer.this.matchTimer.start();
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    QueryProfilerScorer.this.matchTimer.stop();
                }
            }

            @Override
            public float matchCost() {
                return in.matchCost();
            }
        };
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        this.shallowAdvanceTimer.start();
        try {
            int n = this.scorer.advanceShallow(target);
            return n;
        }
        finally {
            this.shallowAdvanceTimer.stop();
        }
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        this.computeMaxScoreTimer.start();
        try {
            float f = this.scorer.getMaxScore(upTo);
            return f;
        }
        finally {
            this.computeMaxScoreTimer.stop();
        }
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.setMinCompetitiveScoreTimer.start();
        try {
            this.scorer.setMinCompetitiveScore(minScore);
        }
        finally {
            this.setMinCompetitiveScoreTimer.stop();
        }
    }
}

