/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90.compressing;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;

class StoredFieldsInts {
    private static final int BLOCK_SIZE = 128;
    private static final int BLOCK_SIZE_MINUS_ONE = 127;

    private StoredFieldsInts() {
    }

    static void writeInts(int[] values2, int start, int count, DataOutput out) throws IOException {
        boolean allEqual = true;
        for (int i = 1; i < count; ++i) {
            if (values2[start + i] == values2[start]) continue;
            allEqual = false;
            break;
        }
        if (allEqual) {
            out.writeByte((byte)0);
            out.writeVInt(values2[0]);
        } else {
            long max = 0L;
            for (int i = 0; i < count; ++i) {
                max |= Integer.toUnsignedLong(values2[start + i]);
            }
            if (max <= 255L) {
                out.writeByte((byte)8);
                StoredFieldsInts.writeInts8(out, count, values2, start);
            } else if (max <= 65535L) {
                out.writeByte((byte)16);
                StoredFieldsInts.writeInts16(out, count, values2, start);
            } else {
                out.writeByte((byte)32);
                StoredFieldsInts.writeInts32(out, count, values2, start);
            }
        }
    }

    private static void writeInts8(DataOutput out, int count, int[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            for (int i = 0; i < 16; ++i) {
                long l = (long)values2[step + i] << 56 | (long)values2[step + 16 + i] << 48 | (long)values2[step + 32 + i] << 40 | (long)values2[step + 48 + i] << 32 | (long)values2[step + 64 + i] << 24 | (long)values2[step + 80 + i] << 16 | (long)values2[step + 96 + i] << 8 | (long)values2[step + 112 + i];
                out.writeLong(l);
            }
        }
        while (k < count) {
            out.writeByte((byte)values2[offset + k]);
            ++k;
        }
    }

    private static void writeInts16(DataOutput out, int count, int[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            for (int i = 0; i < 32; ++i) {
                long l = (long)values2[step + i] << 48 | (long)values2[step + 32 + i] << 32 | (long)values2[step + 64 + i] << 16 | (long)values2[step + 96 + i];
                out.writeLong(l);
            }
        }
        while (k < count) {
            out.writeShort((short)values2[offset + k]);
            ++k;
        }
    }

    private static void writeInts32(DataOutput out, int count, int[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            for (int i = 0; i < 64; ++i) {
                long l = (long)values2[step + i] << 32 | (long)values2[step + 64 + i];
                out.writeLong(l);
            }
        }
        while (k < count) {
            out.writeInt(values2[offset + k]);
            ++k;
        }
    }

    static void readInts(IndexInput in, int count, long[] values2, int offset) throws IOException {
        byte bpv = in.readByte();
        switch (bpv) {
            case 0: {
                Arrays.fill(values2, offset, offset + count, (long)in.readVInt());
                break;
            }
            case 8: {
                StoredFieldsInts.readInts8(in, count, values2, offset);
                break;
            }
            case 16: {
                StoredFieldsInts.readInts16(in, count, values2, offset);
                break;
            }
            case 32: {
                StoredFieldsInts.readInts32(in, count, values2, offset);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private static void readInts8(IndexInput in, int count, long[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            in.readLongs(values2, step, 16);
            for (int i = 0; i < 16; ++i) {
                long l = values2[step + i];
                values2[step + i] = l >>> 56 & 0xFFL;
                values2[step + 16 + i] = l >>> 48 & 0xFFL;
                values2[step + 32 + i] = l >>> 40 & 0xFFL;
                values2[step + 48 + i] = l >>> 32 & 0xFFL;
                values2[step + 64 + i] = l >>> 24 & 0xFFL;
                values2[step + 80 + i] = l >>> 16 & 0xFFL;
                values2[step + 96 + i] = l >>> 8 & 0xFFL;
                values2[step + 112 + i] = l & 0xFFL;
            }
        }
        while (k < count) {
            values2[offset + k] = Byte.toUnsignedInt(in.readByte());
            ++k;
        }
    }

    private static void readInts16(IndexInput in, int count, long[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            in.readLongs(values2, step, 32);
            for (int i = 0; i < 32; ++i) {
                long l = values2[step + i];
                values2[step + i] = l >>> 48 & 0xFFFFL;
                values2[step + 32 + i] = l >>> 32 & 0xFFFFL;
                values2[step + 64 + i] = l >>> 16 & 0xFFFFL;
                values2[step + 96 + i] = l & 0xFFFFL;
            }
        }
        while (k < count) {
            values2[offset + k] = Short.toUnsignedInt(in.readShort());
            ++k;
        }
    }

    private static void readInts32(IndexInput in, int count, long[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            in.readLongs(values2, step, 64);
            for (int i = 0; i < 64; ++i) {
                long l = values2[step + i];
                values2[step + i] = l >>> 32;
                values2[step + 64 + i] = l & 0xFFFFFFFFL;
            }
        }
        while (k < count) {
            values2[offset + k] = in.readInt();
            ++k;
        }
    }
}

