/*
 * Decompiled with CFR 0.152.
 */
package mediathek.windows;

import com.sun.jna.platform.win32.Kernel32;
import java.awt.Taskbar;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.tool.threads.IndicatorThread;
import mediathek.windows.MediathekGuiWindows;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lmediathek/windows/TaskbarIndicatorThread;", "Lmediathek/tool/threads/IndicatorThread;", "parent", "Lmediathek/windows/MediathekGuiWindows;", "(Lmediathek/windows/MediathekGuiWindows;)V", "Ljavax/swing/JFrame;", "taskbar", "Ljava/awt/Taskbar;", "disableStandby", "", "enableStandby", "run", "Companion", "MediathekView"})
public final class TaskbarIndicatorThread
extends IndicatorThread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Taskbar taskbar;
    @NotNull
    private final JFrame parent;
    private static final Logger logger = LogManager.getLogger();

    public TaskbarIndicatorThread(@NotNull MediathekGuiWindows parent) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        this.setName("TaskbarIndicatorThread");
        Taskbar taskbar = Taskbar.getTaskbar();
        Intrinsics.checkNotNullExpressionValue(taskbar, "getTaskbar()");
        this.taskbar = taskbar;
        this.parent = parent;
    }

    private final void disableStandby() {
        if (Kernel32.INSTANCE.SetThreadExecutionState(-2147483647) == 0) {
            logger.error("disableStandby() failed!");
        }
    }

    private final void enableStandby() {
        if (Kernel32.INSTANCE.SetThreadExecutionState(Integer.MIN_VALUE) == 0) {
            logger.error("enableStandby() failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                int percentage = (int)this.calculateOverallPercentage();
                this.taskbar.setWindowProgressValue(this.parent, percentage);
                this.taskbar.setWindowProgressState(this.parent, Taskbar.State.NORMAL);
                this.disableStandby();
                TimeUnit.MILLISECONDS.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.taskbar.setWindowProgressState(this.parent, Taskbar.State.OFF);
            this.enableStandby();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/windows/TaskbarIndicatorThread$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

