/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.apple.eawt.Application;
import com.install4j.api.launcher.StartupNotification;
import java.io.File;
import java.net.URI;

class MacApiHelper {
    MacApiHelper() {
    }

    static void requestForeground() {
        Application.getApplication().requestForeground(true);
    }

    static void setMacStartupListener(StartupNotification.Listener startupListener) {
        try {
            if (startupListener != null) {
                Application.getApplication().setOpenFileHandler(openFilesEvent -> {
                    for (File file : openFilesEvent.getFiles()) {
                        startupListener.startupPerformed(file.getAbsolutePath());
                    }
                });
                Application.getApplication().setOpenURIHandler(openURIEvent -> {
                    URI uri = openURIEvent.getURI();
                    if (uri != null) {
                        startupListener.startupPerformed(uri.toString());
                    }
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void setMacHandleQuit(boolean handleQuit) {
        try {
            Application.getApplication().setQuitHandler((quitEvent, quitResponse) -> {
                if (handleQuit) {
                    quitResponse.performQuit();
                } else {
                    quitResponse.cancelQuit();
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void setMacQuitHandler(Runnable runnable2) {
        try {
            if (runnable2 != null) {
                Application.getApplication().setQuitHandler((quitEvent, quitResponse) -> {
                    quitResponse.cancelQuit();
                    runnable2.run();
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void setMacAboutHandler(Runnable runnable2) {
        try {
            if (runnable2 != null) {
                Application.getApplication().setAboutHandler(aboutEvent -> runnable2.run());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void setMacPreferencesHandler(Runnable runnable2) {
        try {
            if (runnable2 != null) {
                Application.getApplication().setPreferencesHandler(preferencesEvent -> runnable2.run());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

