/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.KeyValuePair;
import com.install4j.runtime.beans.actions.net.AbstractHttpRequestAction;
import com.install4j.runtime.beans.actions.net.HttpRequestMethod;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.HttpConnection;
import com.install4j.runtime.installer.helper.content.TextRequestHandler;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class HttpRequestAction
extends AbstractHttpRequestAction {
    private HttpRequestMethod requestMethod = HttpRequestMethod.GET;
    private boolean useRequestBody = false;
    private String requestBodyContentType = "";
    private String requestBody = "";
    private List<KeyValuePair> formData = new ArrayList<KeyValuePair>();
    private String responseVariableName = "";
    private String responseCodeVariableName = "";
    private String responseHeadersVariableName = "";
    private boolean performRollbackRequest = false;
    private String rollbackUrl = "";
    private HttpRequestMethod rollbackRequestMethod = HttpRequestMethod.GET;
    private boolean useRollbackRequestBody = false;
    private String rollbackRequestBodyContentType = "";
    private String rollbackRequestBody = "";
    private List<KeyValuePair> rollbackFormData = new ArrayList<KeyValuePair>();

    public HttpRequestMethod getRequestMethod() {
        return this.replaceWithTextOverride("requestMethod", this.requestMethod, HttpRequestMethod.class);
    }

    public void setRequestMethod(HttpRequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public boolean isUseRequestBody() {
        return this.replaceWithTextOverride("useRequestBody", this.useRequestBody);
    }

    public void setUseRequestBody(boolean useRequestBody) {
        this.useRequestBody = useRequestBody;
    }

    public String getRequestBodyContentType() {
        return HttpRequestAction.replaceVariables(HttpRequestAction.replaceVariables(this.requestBodyContentType));
    }

    public void setRequestBodyContentType(String requestBodyContentType) {
        this.requestBodyContentType = requestBodyContentType;
    }

    public String getRequestBody() {
        return HttpRequestAction.replaceVariables(HttpRequestAction.replaceVariables(this.requestBody));
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public List<KeyValuePair> getFormData() {
        return this.replaceWithTextOverride("formData", this.formData, List.class);
    }

    public void setFormData(List<KeyValuePair> formData) {
        this.formData = formData;
    }

    public String getResponseVariableName() {
        return HttpRequestAction.replaceVariables(this.responseVariableName);
    }

    public void setResponseVariableName(String responseVariableName) {
        this.responseVariableName = responseVariableName;
    }

    public String getResponseCodeVariableName() {
        return HttpRequestAction.replaceVariables(this.responseCodeVariableName);
    }

    public void setResponseCodeVariableName(String responseCodeVariableName) {
        this.responseCodeVariableName = responseCodeVariableName;
    }

    public String getResponseHeadersVariableName() {
        return HttpRequestAction.replaceVariables(this.responseHeadersVariableName);
    }

    public void setResponseHeadersVariableName(String responseHeadersVariableName) {
        this.responseHeadersVariableName = responseHeadersVariableName;
    }

    public boolean isPerformRollbackRequest() {
        return this.replaceWithTextOverride("performRollbackRequest", this.performRollbackRequest);
    }

    public void setPerformRollbackRequest(boolean performRollbackRequest) {
        this.performRollbackRequest = performRollbackRequest;
    }

    public String getRollbackUrl() {
        return HttpRequestAction.replaceVariables(this.rollbackUrl);
    }

    public void setRollbackUrl(String rollbackUrl) {
        this.rollbackUrl = rollbackUrl;
    }

    public HttpRequestMethod getRollbackRequestMethod() {
        return this.replaceWithTextOverride("rollbackRequestMethod", this.rollbackRequestMethod, HttpRequestMethod.class);
    }

    public void setRollbackRequestMethod(HttpRequestMethod rollbackRequestMethod) {
        this.rollbackRequestMethod = rollbackRequestMethod;
    }

    public boolean isUseRollbackRequestBody() {
        return this.replaceWithTextOverride("useRollbackRequestBody", this.useRollbackRequestBody);
    }

    public void setUseRollbackRequestBody(boolean useRollbackRequestBody) {
        this.useRollbackRequestBody = useRollbackRequestBody;
    }

    public String getRollbackRequestBodyContentType() {
        return HttpRequestAction.replaceVariables(HttpRequestAction.replaceVariables(this.rollbackRequestBodyContentType));
    }

    public void setRollbackRequestBodyContentType(String rollbackRequestBodyContentType) {
        this.rollbackRequestBodyContentType = rollbackRequestBodyContentType;
    }

    public String getRollbackRequestBody() {
        return HttpRequestAction.replaceVariables(HttpRequestAction.replaceVariables(this.rollbackRequestBody));
    }

    public void setRollbackRequestBody(String rollbackRequestBody) {
        this.rollbackRequestBody = rollbackRequestBody;
    }

    public List<KeyValuePair> getRollbackFormData() {
        return this.replaceWithTextOverride("rollbackFormData", this.rollbackFormData, List.class);
    }

    public void setRollbackFormData(List<KeyValuePair> rollbackFormData) {
        this.rollbackFormData = rollbackFormData;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        try {
            TextRequestHandler.TextResponse textResponse = this.performRequest(context, this.getUrl(), this.getRequestMethod(), this.getFormData(), this.isUseRequestBody(), this.getRequestBodyContentType(), this.getRequestBody());
            if (!this.getResponseVariableName().isEmpty()) {
                context.registerHiddenVariable(this.getResponseVariableName());
                context.setVariable(this.getResponseVariableName(), textResponse.getText());
            }
            if (!this.getResponseCodeVariableName().isEmpty()) {
                context.setVariable(this.getResponseCodeVariableName(), textResponse.getResponseCode());
            }
            if (!this.getResponseHeadersVariableName().isEmpty()) {
                context.registerHiddenVariable(this.getResponseHeadersVariableName());
                context.setVariable(this.getResponseHeadersVariableName(), textResponse.getHeaderFields());
            }
            return textResponse.isSuccess();
        }
        catch (UserCanceledException e) {
            if (context.isCancelling()) {
                throw new UserCanceledException();
            }
            return false;
        }
        catch (IOException e) {
            Logger.getInstance().error(this, "HTTP request failed");
            Logger.getInstance().log(e);
            return false;
        }
    }

    private TextRequestHandler.TextResponse performRequest(Context context, String url, HttpRequestMethod requestMethod, List<KeyValuePair> formData, boolean useRequestBody, String requestBodyContentType, String requestBody) throws IOException, UserCanceledException {
        try (TextRequestHandler handler = new TextRequestHandler(context);){
            this.applyCommonProperties(handler);
            try {
                HttpRequestAction.performRequest(handler, url, requestMethod, formData, useRequestBody, requestBodyContentType, requestBody);
                TextRequestHandler.TextResponse textResponse = handler.getTextResponse();
                return textResponse;
            }
            catch (IOException e) {
                block9: {
                    TextRequestHandler.TextResponse textResponse = handler.getTextResponse(true);
                    if (textResponse == null) break block9;
                    TextRequestHandler.TextResponse textResponse2 = textResponse;
                    handler.close();
                    return textResponse2;
                }
                throw e;
            }
        }
    }

    public static void performRequest(TextRequestHandler handler, String url, HttpRequestMethod requestMethod, List<KeyValuePair> formData, boolean useRequestBody, String requestBodyContentType, String requestBody) throws IOException, UserCanceledException {
        handler.connect(HttpRequestAction.createConnectionUrl(url, requestMethod, formData, useRequestBody), connection -> {
            connection.setRequestMethod(requestMethod.getMethodName());
            if (requestMethod.isBodyFormData()) {
                if (useRequestBody) {
                    HttpRequestAction.writeRequestBody(connection, requestBody, requestBodyContentType);
                } else {
                    HttpRequestAction.writeRequestBody(connection, HttpRequestAction.createRequestBody(formData), "application/x-www-form-urlencoded");
                }
            }
        });
    }

    public static void writeRequestBody(HttpConnection connection, String body, String contentType) throws IOException {
        if (!body.isEmpty()) {
            connection.setRequestProperty("Content-Type", contentType);
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setDoOutput(body.length());
            PrintStream out = new PrintStream(connection.getOutputStream());
            out.print(body);
            out.close();
        }
    }

    private static String createConnectionUrl(String url, HttpRequestMethod requestMethod, List<KeyValuePair> formData, boolean useRequestBody) {
        String requestData;
        StringBuilder buffer = new StringBuilder();
        buffer.append(url);
        if (!(requestMethod.isBodyFormData() && !useRequestBody || (requestData = HttpRequestAction.createRequestBody(formData)).isEmpty())) {
            if (!url.contains("?")) {
                buffer.append('?');
            }
            if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '?') {
                buffer.append('&');
            }
            buffer.append(requestData);
        }
        return buffer.toString();
    }

    private static String createRequestBody(List<KeyValuePair> formData) {
        StringBuilder buffer = new StringBuilder();
        for (KeyValuePair keyValuePair : formData) {
            if (buffer.length() > 0) {
                buffer.append("&");
            }
            buffer.append(HttpRequestAction.replaceVariables(keyValuePair.getKey()));
            buffer.append("=");
            try {
                buffer.append(URLEncoder.encode(HttpRequestAction.replaceVariables(keyValuePair.getValue()), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return buffer.toString();
    }

    @Override
    public void rollback(InstallerContext context) {
        super.rollback(context);
        if (this.isPerformRollbackRequest()) {
            try {
                this.performRequest(context, this.getRollbackUrl(), this.getRollbackRequestMethod(), this.getRollbackFormData(), this.isUseRollbackRequestBody(), this.getRollbackRequestBodyContentType(), this.getRollbackRequestBody());
            }
            catch (IOException e) {
                Logger.getInstance().error(this, "HTTP rollback request failed");
                Logger.getInstance().log(e);
                e.printStackTrace();
            }
            catch (UserCanceledException userCanceledException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isRollbackSupported() {
        return this.isPerformRollbackRequest();
    }
}

