/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ThresholdList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.swing.DefaultTableModelEventAdapterFactory;
import ca.odell.glazedlists.impl.swing.LowerThresholdRangeModel;
import ca.odell.glazedlists.impl.swing.ManyToOneTableModelEventAdapterFactory;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.impl.swing.UpperThresholdRangeModel;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.DefaultEventComboBoxModel;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.TableModelEventAdapter;
import javax.swing.BoundedRangeModel;

public final class GlazedListsSwing {
    private GlazedListsSwing() {
        throw new UnsupportedOperationException();
    }

    public static <E> TransformedList<E, E> swingThreadProxyList(EventList<E> source2) {
        return new SwingThreadProxyEventList<E>(source2);
    }

    public static boolean isSwingThreadProxyList(EventList list) {
        return list instanceof SwingThreadProxyEventList;
    }

    public static BoundedRangeModel lowerRangeModel(ThresholdList target) {
        return new LowerThresholdRangeModel(target);
    }

    public static BoundedRangeModel upperRangeModel(ThresholdList target) {
        return new UpperThresholdRangeModel(target);
    }

    public static <E> AdvancedTableModel<E> eventTableModel(EventList<E> source2, TableFormat<? super E> tableFormat) {
        return new DefaultEventTableModel<E>(source2, tableFormat);
    }

    public static <E> AdvancedTableModel<E> eventTableModelWithThreadProxyList(EventList<E> source2, TableFormat<? super E> tableFormat) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source2);
        return new DefaultEventTableModel<E>(proxySource, true, tableFormat);
    }

    public static <E> AdvancedTableModel<E> eventTableModel(EventList<E> source2, TableFormat<? super E> tableFormat, TableModelEventAdapter.Factory<E> eventAdapterFactory) {
        DefaultEventTableModel<E> result = new DefaultEventTableModel<E>(source2, tableFormat);
        TableModelEventAdapter<E> eventAdapter = eventAdapterFactory.create(result);
        result.setEventAdapter(eventAdapter);
        return result;
    }

    public static <E> AdvancedTableModel<E> eventTableModelWithThreadProxyList(EventList<E> source2, TableFormat<? super E> tableFormat, TableModelEventAdapter.Factory<E> eventAdapterFactory) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source2);
        DefaultEventTableModel<E> result = new DefaultEventTableModel<E>(proxySource, true, tableFormat);
        TableModelEventAdapter<E> eventAdapter = eventAdapterFactory.create(result);
        result.setEventAdapter(eventAdapter);
        return result;
    }

    public static <E> AdvancedTableModel<E> eventTableModel(EventList<E> source2, String[] propertyNames, String[] columnLabels, boolean[] writable) {
        return GlazedListsSwing.eventTableModel(source2, GlazedLists.tableFormat(propertyNames, columnLabels, writable));
    }

    public static <E> AdvancedTableModel<E> eventTableModelWithThreadProxyList(EventList<E> source2, String[] propertyNames, String[] columnLabels, boolean[] writable) {
        return GlazedListsSwing.eventTableModelWithThreadProxyList(source2, GlazedLists.tableFormat(propertyNames, columnLabels, writable));
    }

    public static <E> TableModelEventAdapter.Factory<E> defaultEventAdapterFactory() {
        return DefaultTableModelEventAdapterFactory.getInstance();
    }

    public static <E> TableModelEventAdapter.Factory<E> manyToOneEventAdapterFactory() {
        return ManyToOneTableModelEventAdapterFactory.getInstance();
    }

    public static <E> AdvancedListSelectionModel<E> eventSelectionModel(EventList<E> source2) {
        return new DefaultEventSelectionModel<E>(source2);
    }

    public static <E> AdvancedListSelectionModel<E> eventSelectionModelWithThreadProxyList(EventList<E> source2) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source2);
        return new DefaultEventSelectionModel<E>(proxySource, true);
    }

    public static <E> DefaultEventListModel<E> eventListModel(EventList<E> source2) {
        return new DefaultEventListModel<E>(source2);
    }

    public static <E> DefaultEventListModel<E> eventListModelWithThreadProxyList(EventList<E> source2) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source2);
        return new DefaultEventListModel<E>(proxySource, true);
    }

    public static <E> DefaultEventComboBoxModel<E> eventComboBoxModel(EventList<E> source2) {
        return new DefaultEventComboBoxModel<E>(source2);
    }

    public static <E> DefaultEventComboBoxModel<E> eventComboBoxModelWithThreadProxyList(EventList<E> source2) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source2);
        return new DefaultEventComboBoxModel<E>(proxySource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E> EventList<E> createSwingThreadProxyList(EventList<E> source2) {
        TransformedList<E, E> result;
        source2.getReadWriteLock().readLock().lock();
        try {
            result = GlazedListsSwing.swingThreadProxyList(source2);
        }
        finally {
            source2.getReadWriteLock().readLock().unlock();
        }
        return result;
    }
}

