/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.beans.container.internal;

import jakarta.enterprise.inject.spi.BeanManager;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.resource.beans.container.internal.CdiBeanContainerDelayedAccessImpl;
import org.hibernate.resource.beans.container.internal.CdiBeanContainerExtendedAccessImpl;
import org.hibernate.resource.beans.container.internal.CdiBeanContainerImmediateAccessImpl;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ExtendedBeanManager;
import org.hibernate.service.ServiceRegistry;

public class CdiBeanContainerBuilder {
    public static BeanContainer fromBeanManagerReference(Object beanManager, ServiceRegistry serviceRegistry) {
        if (beanManager instanceof ExtendedBeanManager) {
            ExtendedBeanManager extendedBeanManager = (ExtendedBeanManager)beanManager;
            return new CdiBeanContainerExtendedAccessImpl(extendedBeanManager);
        }
        if (beanManager instanceof BeanManager) {
            BeanManager cdiBeanManager = (BeanManager)beanManager;
            return CdiBeanContainerBuilder.delayCdiAccess(serviceRegistry) ? new CdiBeanContainerDelayedAccessImpl(cdiBeanManager) : new CdiBeanContainerImmediateAccessImpl(cdiBeanManager);
        }
        throw new AssertionFailure("Unsupported bean manager: " + String.valueOf(beanManager));
    }

    private static boolean delayCdiAccess(ServiceRegistry serviceRegistry) {
        return serviceRegistry.requireService(ConfigurationService.class).getSetting("hibernate.delay_cdi_access", StandardConverters.BOOLEAN, Boolean.valueOf(false));
    }
}

