/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Throwables {
    @SafeVarargs
    public static boolean isCausedBy(Throwable throwable, Class<? extends Exception> ... type) {
        Objects.requireNonNull(throwable, "Throwable must not be null");
        int limit = 3;
        List<Class<? extends Exception>> types = Arrays.asList(type);
        for (Throwable cause = throwable.getCause(); cause != null && limit-- != 0; cause = cause.getCause()) {
            if (!types.contains(cause.getClass())) continue;
            return true;
        }
        return false;
    }
}

