/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;

public class TotpLoginBean {
    private final String selectedCredentialId;
    private final List<OTPCredential> userOtpCredentials;
    private OTPPolicy policy;

    public TotpLoginBean(KeycloakSession session, RealmModel realm, UserModel user, String selectedCredentialId) {
        this.userOtpCredentials = user.credentialManager().getStoredCredentialsByTypeStream("otp").map(OTPCredential::new).collect(Collectors.toList());
        if (selectedCredentialId == null || selectedCredentialId.isEmpty()) {
            OTPCredentialProvider otpCredentialProvider = (OTPCredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp");
            OTPCredentialModel otpCredential = (OTPCredentialModel)otpCredentialProvider.getDefaultCredential(session, realm, user);
            selectedCredentialId = otpCredential == null ? null : otpCredential.getId();
        }
        this.selectedCredentialId = selectedCredentialId;
        this.policy = realm.getOTPPolicy();
    }

    public List<OTPCredential> getUserOtpCredentials() {
        return this.userOtpCredentials;
    }

    public String getSelectedCredentialId() {
        return this.selectedCredentialId;
    }

    public OTPPolicy getPolicy() {
        return this.policy;
    }

    public static class OTPCredential {
        private final String id;
        private final String userLabel;

        public OTPCredential(CredentialModel credentialModel) {
            this.id = credentialModel.getId();
            this.userLabel = credentialModel.getUserLabel() == null || credentialModel.getUserLabel().isEmpty() ? "unnamed" : credentialModel.getUserLabel();
        }

        public String getId() {
            return this.id;
        }

        public String getUserLabel() {
            return this.userLabel;
        }
    }
}

