/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.Distance;
import tim.prune.data.NumberUtils;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.NearbyPointsMethod;

public class NearbyDistMethod
extends NearbyPointsMethod {
    private final double _metricDistance;

    public NearbyDistMethod(double d) {
        this._metricDistance = d;
    }

    public NearbyDistMethod(String string) {
        this._metricDistance = NearbyDistMethod.recogniseString(string) ? NumberUtils.getDoubleOrZero(string.substring(4)) : 0.0;
    }

    @Override
    public CompressionMethodType getType() {
        return CompressionMethodType.NEARBY_WITH_DISTANCE;
    }

    @Override
    public String getParam() {
        return "" + Math.abs(this._metricDistance);
    }

    @Override
    public String getSettingsString() {
        return String.valueOf(this.getType().getKey()) + this._metricDistance;
    }

    static boolean recogniseString(String string) {
        return NearbyDistMethod.recogniseString(string, CompressionMethodType.NEARBY_WITH_DISTANCE);
    }

    @Override
    protected double getRadianThreshold(TrackDetails trackDetails) {
        return Distance.convertDistanceToRadians(this._metricDistance, UnitSetLibrary.UNITS_METRES);
    }
}

