/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.av;

import com.jogamp.common.av.AudioFormat;
import com.jogamp.common.av.PTS;
import com.jogamp.common.av.TimeFrameI;
import java.nio.ByteBuffer;
import jogamp.common.Debug;

public interface AudioSink {
    public static final boolean DEBUG = Debug.debug("AudioSink");
    public static final int DefaultFrameDuration = 32;
    public static final int DefaultQueueSize = 512;
    public static final int DefaultQueueSizeWithVideo = 1024;
    public static final AudioFormat DefaultFormat = new AudioFormat(44100, 16, 2, true, true, false, true);

    public boolean makeCurrent(boolean var1);

    public boolean release(boolean var1);

    public boolean isAvailable();

    public float getPlaySpeed();

    public boolean setPlaySpeed(float var1);

    public float getVolume();

    public boolean setVolume(float var1);

    public int getSourceCount();

    public float getDefaultLatency();

    public AudioFormat getNativeFormat();

    public AudioFormat getPreferredFormat();

    public void setChannelLimit(int var1);

    public boolean isSupported(AudioFormat var1);

    public boolean init(AudioFormat var1, int var2, int var3);

    public AudioFormat getChosenFormat();

    public float getLatency();

    public boolean isPlaying();

    public void play();

    public void pause();

    public void flush();

    public void destroy();

    public int getFrameCount();

    public int getEnqueuedFrameCount();

    public int getQueuedFrameCount();

    public int getQueuedByteCount();

    public float getQueuedDuration();

    public float getAvgFrameDuration();

    public PTS getPTS();

    public int getLastBufferedPTS();

    public int getFreeFrameCount();

    public AudioFrame enqueueData(int var1, ByteBuffer var2, int var3);

    public PTS updateQueue();

    public static class AudioDataFrame
    extends AudioFrame {
        protected final ByteBuffer data;

        public AudioDataFrame(int n, int n2, ByteBuffer byteBuffer, int n3) {
            super(n, n2, n3);
            if (n3 > byteBuffer.remaining()) {
                throw new IllegalArgumentException("Give size " + n3 + " exceeds remaining bytes in ls " + byteBuffer + ". " + this);
            }
            this.data = byteBuffer;
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public String toString() {
            return "AudioDataFrame[pts " + this.pts + " ms, l " + this.duration + " ms, " + this.byteSize + " bytes, " + this.data + "]";
        }
    }

    public static abstract class AudioFrame
    extends TimeFrameI {
        protected int byteSize;

        public AudioFrame() {
            this.byteSize = 0;
        }

        public AudioFrame(int n, int n2, int n3) {
            super(n, n2);
            this.byteSize = n3;
        }

        public final int getByteSize() {
            return this.byteSize;
        }

        public final void setByteSize(int n) {
            this.byteSize = n;
        }

        @Override
        public String toString() {
            return "AudioFrame[pts " + this.pts + " ms, l " + this.duration + " ms, " + this.byteSize + " bytes]";
        }
    }
}

