/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.ui;

import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.features.mode.Controller;

@SelectableAction(checkOnPopup=true)
public class ToggleToolbarAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final String toolbarName;

    public ToggleToolbarAction(String actionName, String toolbarName) {
        super(actionName);
        this.toolbarName = toolbarName;
    }

    protected JComponent getToolbar() {
        JComponent toolBar = Controller.getCurrentModeController().getUserInputListenerFactory().getToolBar(this.toolbarName);
        return toolBar;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JComponent toolBar = this.getToolbar();
        if (toolBar != null) {
            UIComponentVisibilityDispatcher.of(toolBar).toggleVisibility();
        }
    }

    @Override
    public void setSelected() {
        boolean isVisible = this.isVisible();
        this.setSelected(isVisible);
    }

    @Override
    public void afterMapChange(UserRole userRole) {
    }

    public boolean isVisible() {
        JComponent toolBar = this.getToolbar();
        return toolBar != null && UIComponentVisibilityDispatcher.of(toolBar).isVisible();
    }
}

