define(["exports","./../layoutmanager.js","./../common/datetime.js","./../mediainfo/mediainfo.js","./../common/playback/playbackmanager.js","./../dom.js","./../emby-apiclient/connectionmanager.js","./../common/inputmanager.js","./../common/usersettings/usersettings.js","./../input/keyboard.js","./../emby-apiclient/events.js","../focusmanager.js"],function(_exports,_layoutmanager,_datetime,_mediainfo,_playbackmanager,_dom,_connectionmanager,_inputmanager,_usersettings,_keyboard,_events,_focusmanager){function updateDurationText(elem,enableProgressByTimeOfDay,durationTicks,displayItem,enableTimeRemaining){var html;null==durationTicks||isNaN(durationTicks)||durationTicks<=0?elem.innerHTML="":(html=_datetime.default.getDisplayRunningTime(durationTicks),enableTimeRemaining&&0<durationTicks&&(html="-"+html,enableProgressByTimeOfDay||"Video"!==(null==displayItem?void 0:displayItem.MediaType)||(html+='<span class="osd-endsat"><span class="osd-endsat-dot">/</span>'+_mediainfo.default.getEndsAtFromPosition(durationTicks,0,!1).toLowerCase()+"</span>")),elem.innerHTML=html)}function getDisplayTimeWithoutAmPm(date,showSeconds){return function(date,showSeconds){return(showSeconds?_datetime.default.toLocaleTimeString(date,{hour:"numeric",minute:"2-digit",second:"2-digit"}):_datetime.default.getDisplayTime(date)).toLowerCase()}(date,showSeconds).replace("am","").replace("pm","").trim()}function setDisplayTime(elem,ms){var html;ms&&(html=getDisplayTimeWithoutAmPm(new Date(ms))),elem.innerHTML=html||""}function getDisplayPercentByTimeOfDay(startDateMs,programRuntimeMs,currentTimeMs){return(currentTimeMs-startDateMs)/programRuntimeMs*100}function getStep(runtimeTicks){runtimeTicks=(runtimeTicks=1e7*(_layoutmanager.default.tv?10:1)/runtimeTicks*100).toFixed(3);return runtimeTicks=Math.max(.01,runtimeTicks),runtimeTicks=Math.min(1,runtimeTicks)}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var insetInlineStartProp=CSS.supports("inset-inline-start","0")?"insetInlineStart":"left",SupportsCalc=CSS.supports("width","min(45.2%,calc(100% - .65em))"),SupportsMin=CSS.supports("width","min(10em, 5vw)"),SupportsCalcMin=SupportsCalc&&SupportsMin;function updateTimeText(instance,elem,ticks,pct){var html="",iconsBefore="",iconsAfter="",ticks=(null==ticks||isNaN(ticks)||(html=_datetime.default.getDisplayRunningTime(ticks)),instance.repeatingPositionSliderKey),speed=instance.repeatingPositionSliderKeySpeed,hasIcons=(instance.options.setPositionSliderPosition&&(instance.paused?iconsAfter+='<i class="md-icon button-icon-right osdcontroller-pauseicon" style="font-size:108%;">&#xe1a2;</i>':iconsAfter+='<i class="md-icon button-icon-right osdcontroller-pauseicon hide" style="font-size:108%;">&#xe1a2;</i>'),!1);switch(ticks){case"stepdown":iconsBefore='<i class="md-icon md-icon-fill autortl button-icon-left" style="margin-inline-end:.25em;font-size:170%;">&#xe020;</i>',1!==speed&&(iconsBefore='<div class="button-icon-left" style="margin-inline-end:.2em;">'+speed+"</div>"+iconsBefore),hasIcons=!0;break;case"stepup":iconsAfter+='<i class="md-icon md-icon-fill autortl button-icon-right" style="margin-inline-start:.25em;font-size:170%;">&#xe01f;</i>',1!==speed&&(iconsAfter+='<div class="button-icon-right" style="margin-inline-start:.2em;">'+speed+"</div>"),hasIcons=!0}iconsBefore&&(html='<div class="osd-controller-iconsbeforeposition flex align-items-center">'+iconsBefore+"</div>"+html),elem.innerHTML=html=iconsAfter?html+'<div class="osd-controller-iconsafterposition flex align-items-center">'+iconsAfter+"</div>":html,instance.options.setPositionSliderPosition&&(pct=pct||0,instance.enableProgressByTimeOfDay&&(pct=0),SupportsCalcMin)&&((ticks=elem.offsetWidth||0)?elem._lastOffsetWidth=ticks:html&&(ticks=elem._lastOffsetWidth||0),elem.style[insetInlineStartProp]="max(calc("+pct+"% - "+ticks/2+"px), 0%)",html=instance.options.durationTextElem)&&(html.style.opacity=(hasIcons?82:84)<=pct?0:null)}var DefaultSpeed=1;function setDefaultSpeed(instance){instance.repeatingPositionSliderKeySpeed=DefaultSpeed}function convertMsToNowPlayingSliderStep(instance,ms){var runtimeTicks=instance.nowPlayingSliderRunTimeTicks;return runtimeTicks?1e4*ms/runtimeTicks*100:(ms=instance.options.nowPlayingPositionSlider,parseFloat(ms.step))}function cancelPositionSliderEditing(instance){instance.options.nowPlayingPositionSlider.cancelEditing()}function onPositionSliderBeginEditing(e){this.ignoreStepKeyUp=!1,function(instance){instance.intervalForPositionSlider||(setDefaultSpeed(instance),instance.intervalForPositionSlider=setInterval(instance.bound_intervalForPositionSlider,100))}(this)}function onPositionSliderEndEditing(e){this.repeatingPositionSliderKey=null,setDefaultSpeed(this),function(instance){instance.intervalForPositionSlider&&(clearInterval(instance.intervalForPositionSlider),instance.intervalForPositionSlider=null)}(this)}function changeSpeed(instance,slider,direction){var currentDirection;slider.dragging&&(currentDirection=instance.repeatingPositionSliderKey)&&(currentDirection=currentDirection===direction?1:-1,direction=instance.repeatingPositionSliderKeySpeed,(currentDirection=Math.max(0,Math.min(4,direction+currentDirection)))<=DefaultSpeed-1&&currentDirection!==direction?(instance.ignoreStepKeyUp=!0,slider.endEditing(!0,instance.nowPlayingSliderValue)):instance.repeatingPositionSliderKeySpeed=currentDirection)}function beginOrEndEditing(instance,slider,newValue,positionSliderKey){var sliderMin=slider.min,sliderMax=slider.max;newValue<=sliderMin?(instance.nowPlayingSliderValue=sliderMin,slider.endEditing(!0,sliderMin)):sliderMax<=newValue?(instance.nowPlayingSliderValue=sliderMax,slider.endEditing(!0,sliderMax)):(instance.repeatingPositionSliderKey!==positionSliderKey&&setDefaultSpeed(instance),instance.repeatingPositionSliderKey=positionSliderKey,slider.beginEditing(instance.nowPlayingSliderValue))}function OsdController(options){this.options=options,this.visualStartDateMs=0,this.visualEndDateMs=0,this.wallClockStartTimeMs=0,this.nowPlayingSliderValue=0;var nowPlayingPositionSlider=options.nowPlayingPositionSlider,nowPlayingPositionSlider=(_inputmanager.default.on(nowPlayingPositionSlider,function(e){var stepUpCommand,sliderMin,sliderMax,slider=e.target,stepDownCommand="rtl"===document.dir?(stepUpCommand="left","right"):(stepUpCommand="right","left");switch(e.detail.command){case stepDownCommand:case"rewind":e.preventDefault(),e.detail.repeat?(sliderMin=slider.min,sliderMax=slider.max,beginOrEndEditing(this,slider,Math.min(Math.max(this.nowPlayingSliderValue-convertMsToNowPlayingSliderStep(this,1e3),sliderMin),sliderMax),"stepdown")):changeSpeed(this,slider,"stepdown");break;case stepUpCommand:case"fastforward":e.preventDefault(),e.detail.repeat?(sliderMin=slider.min,sliderMax=slider.max,beginOrEndEditing(this,slider,Math.min(Math.max(this.nowPlayingSliderValue+convertMsToNowPlayingSliderStep(this,1e3),sliderMin),sliderMax),"stepup")):changeSpeed(this,slider,"stepup");break;case"channelup":this.onChannelUp(e);break;case"channeldown":this.onChannelDown(e);break;case"pageup":this.onPageUp(e);break;case"pagedown":this.onPageDown(e);break;case"back":slider.dragging&&e.preventDefault(),cancelPositionSliderEditing(this);break;case"play":case"playpause":slider.dragging&&(e.preventDefault(),e.stopPropagation(),console.log("osdcontroller - endEditing"),slider.endEditing(!0,this.nowPlayingSliderValue));break;case"select":slider.dragging?(e.preventDefault(),e.stopPropagation(),slider.endEditing(!0,this.nowPlayingSliderValue)):this.intervalForPositionSlider||(console.log("osdcontroller - playpause from select command"),_playbackmanager.default.playPause(this.currentPlayer),e.preventDefault())}}.bind(this)),_dom.default.addEventListener(nowPlayingPositionSlider,"keyup",function(e){var stepUpCommand,slider=e.target,e=_keyboard.default.normalizeKeyFromEvent(e),stepDownCommand="rtl"===document.dir?(stepUpCommand="ArrowLeft","ArrowRight"):(stepUpCommand="ArrowRight","ArrowLeft"),ignoreStepKeyUp=this.ignoreStepKeyUp,wasRepeating=(console.log("onPositionSliderKeyUp, repeatingPositionSliderKey: "+this.repeatingPositionSliderKey+", ignoreStepKeyUp: "+ignoreStepKeyUp),this.repeatingPositionSliderKey);switch(e){case"MediaRewind":case stepDownCommand:wasRepeating||ignoreStepKeyUp||(console.log("OsdController: rewind"),this.nowPlayingSliderValue=Math.min(Math.max(this.nowPlayingSliderValue-convertMsToNowPlayingSliderStep(this,_usersettings.default.skipBackLength()),slider.min),slider.max),slider.dragging?slider.endEditing(!0,this.nowPlayingSliderValue):(slider.endEditing(!1,this.nowPlayingSliderValue),_playbackmanager.default.rewind(this.currentPlayer))),this.ignoreStepKeyUp=!1;break;case"MediaFastForward":case stepUpCommand:wasRepeating||ignoreStepKeyUp||(console.log("OsdController: fastForward"),this.nowPlayingSliderValue=Math.min(Math.max(this.nowPlayingSliderValue+convertMsToNowPlayingSliderStep(this,_usersettings.default.skipForwardLength()),slider.min),slider.max),slider.dragging?slider.endEditing(!0,this.nowPlayingSliderValue):(slider.endEditing(!1,this.nowPlayingSliderValue),_playbackmanager.default.fastForward(this.currentPlayer))),this.ignoreStepKeyUp=!1}}.bind(this),{passive:!0}),_dom.default.addEventListener(nowPlayingPositionSlider,"input",function(e){onPositionSliderEndEditing.call(this,e)}.bind(this),{passive:!0}),nowPlayingPositionSlider.addEventListener("beginediting",onPositionSliderBeginEditing.bind(this)),nowPlayingPositionSlider.addEventListener("endediting",onPositionSliderEndEditing.bind(this)),nowPlayingPositionSlider.addEventListener("displayvaluechange",function(e){var currentRuntimeTicks,e=e.detail.value;this.enableProgressByTimeOfDay||(currentRuntimeTicks=this.nowPlayingSliderRunTimeTicks)&&updateTimeText(this,this.options.positionTextElem,currentRuntimeTicks/100*e,e)}.bind(this)),_dom.default.addEventListener(nowPlayingPositionSlider,"change",function(e){var startDateMs,e=e.target,player=this.currentPlayer,e=parseFloat(e.value);this.enableProgressByTimeOfDay?(startDateMs=this.visualStartDateMs,startDateMs=1e4*((this.visualEndDateMs-startDateMs)*(e/100)+startDateMs-this.wallClockStartTimeMs),_playbackmanager.default.seek(startDateMs,player)):_playbackmanager.default.seekPercent(e,player)}.bind(this),{passive:!0}),this.bound_intervalForPositionSlider=function(){var slider=this.options.nowPlayingPositionSlider,key=this.repeatingPositionSliderKey,speed=this.repeatingPositionSliderKeySpeed,sliderMin=slider.min,sliderMax=slider.max,stepMultiplier=[1,3,6,12,18][speed-1];switch(key){case"stepdown":this.nowPlayingSliderValue=Math.min(Math.max(this.nowPlayingSliderValue-stepMultiplier*convertMsToNowPlayingSliderStep(this,1e3),sliderMin),sliderMax);break;case"stepup":this.nowPlayingSliderValue=Math.min(Math.max(this.nowPlayingSliderValue+stepMultiplier*convertMsToNowPlayingSliderStep(this,1e3),sliderMin),sliderMax);break;default:return}console.log("onIntervalPositionSlider, key: "+key+", speed: "+speed),this.nowPlayingSliderValue<=sliderMin?(this.nowPlayingSliderValue=sliderMin,slider.endEditing(!0,sliderMin)):this.nowPlayingSliderValue>=sliderMax?(this.nowPlayingSliderValue=sliderMax,slider.endEditing(!0,sliderMax)):slider.beginEditing(this.nowPlayingSliderValue)}.bind(this),setDefaultSpeed(this),options.positionTextElem);nowPlayingPositionSlider&&(nowPlayingPositionSlider.style.height="1.7em")}function setElementDisabled(instance,btn,disabled){var isFocused=btn===document.activeElement;(btn.disabled=disabled)&&isFocused&&_focusmanager.default.autoFocus(instance.options.parentElement)}function updatePositionSliderDisabled(instance,state){var nowPlayingPositionSlider=instance.options.nowPlayingPositionSlider;nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging&&setElementDisabled(instance,nowPlayingPositionSlider,!(state.PlayState||{}).CanSeek||!0===instance.disablePositionSlider)}function getThumbnailBubbleHtml(nowPlayingPositionSlider,enableProgressByTimeOfDay,apiClient,itemId,mediaSourceId,thumbnailSet,chapters,positionTicks,maxThumbnailWidth){var thumbnail,thumbnails=(thumbnailSet=thumbnailSet||{}).Thumbnails||{},bubbleElement=nowPlayingPositionSlider.getBubbleElement();thumbnails.length?(bubbleElement.classList.add("chapterThumbImageContainer"),thumbnailSet.AspectRatio&&thumbnailSet.AspectRatio<1.4?bubbleElement.classList.add("chapterThumbImageContainer-fourthree"):bubbleElement.classList.remove("chapterThumbImageContainer-fourthree"),bubbleElement.classList.remove("chapterThumbImageContainer-noimg")):(bubbleElement.classList.remove("chapterThumbImageContainer","chapterThumbImageContainer-fourthree"),bubbleElement.classList.add("chapterThumbImageContainer-noimg")),_layoutmanager.default.tv?bubbleElement.classList.add("chapterThumbImageContainer-tv"):bubbleElement.classList.remove("chapterThumbImageContainer-tv");for(var i=0,length=thumbnails.length;i<length;i++){var currentThumbnail=thumbnails[i];if(positionTicks>=currentThumbnail.PositionTicks)thumbnail=currentThumbnail;else if(thumbnail)break}for(var _i=0,_length=chapters.length;_i<_length;_i++){var currentChapter=chapters[_i];if(positionTicks>=currentChapter.StartPositionTicks)chapter=currentChapter;else if(chapter)break}var chapter=chapter||{Name:""},thumbnailSet=thumbnail?function(itemId,mediaSourceId,thumbnail,maxWidth,apiClient){return thumbnail.ImageTag?apiClient.getImageUrl(itemId,{maxWidth:maxWidth,tag:thumbnail.ImageTag,type:"Thumbnail",PositionTicks:thumbnail.PositionTicks,MediaSourceId:mediaSourceId}):null}(itemId,mediaSourceId,thumbnail,maxThumbnailWidth,apiClient):null,bubbleElement="",itemId="chapterThumbTextContainer",mediaSourceId=(thumbnailSet||(itemId+=" chapterThumbTextContainer-noimg"),nowPlayingPositionSlider.getBubbleElement().style.backgroundImage=thumbnailSet?"url('"+thumbnailSet+"')":null,enableProgressByTimeOfDay||!_layoutmanager.default.tv),bubbleElement=(bubbleElement=bubbleElement+('<div class="'+itemId+'">')+'<div class="chapterThumbText">')+(chapter?_dom.default.htmlEncode(chapter.Name):"")+"</div>";return mediaSourceId&&(bubbleElement=(bubbleElement+=thumbnailSet?'<div class="chapterThumbText">':'<div class="chapterThumbText secondaryText">')+_datetime.default.getDisplayRunningTime(positionTicks)+"</div>"),bubbleElement+="</div>"}function refreshThumbnailsIfNeeded(instance,item,mediaSourceId,apiClient,maxThumbnailWidth){!item.Id||"Audio"===item.MediaType||instance.currentItemThumbnails||instance.currentItemThumbnailsPromise||!function(instance,itemId,mediaSourceId,apiClient,maxThumbnailWidth){if(instance.currentItemThumbnailsPromise)return instance.currentItemThumbnailsPromise;apiClient=apiClient.getThumbnails(itemId,{MediaSourceId:mediaSourceId,Width:maxThumbnailWidth}).then(function(result){return instance.currentItemThumbnails=result,Promise.resolve(result)},function(){instance.currentItemThumbnailsPromise=null}),instance.currentItemThumbnailsPromise=apiClient}(instance,item.Id,mediaSourceId,apiClient,maxThumbnailWidth)}function showChannelChanger(currentItem,offset){Emby.importModule("./modules/channelchanger/channelchanger.js").then(function(ChannelChanger){return ChannelChanger.onChannelChangeRequest({currentItem:currentItem,offset:offset})})}OsdController.prototype.updatePlayerState=function(event,player,state){var nowPlayingPositionSlider=this.options.nowPlayingPositionSlider,isProgressClear=(updatePositionSliderDisabled(this,state),state.MediaSource&&null==state.MediaSource.RunTimeTicks&&state.MediaSource.IsInfiniteStream);nowPlayingPositionSlider.setIsClear(isProgressClear),null!=(nowPlayingPositionSlider=state.MediaSource)&&nowPlayingPositionSlider.WallClockStart&&(isProgressClear=_datetime.default.parseISO8601Date(state.MediaSource.WallClockStart),console.log("wall clock start: "+isProgressClear),this.wallClockStartTimeMs=isProgressClear.getTime(),this.visualStartDateMs=Math.min(this.visualStartDateMs||this.wallClockStartTimeMs,this.wallClockStartTimeMs||this.visualStartDateMs)),this.updateNowPlayingInfo(event,player,state)},OsdController.prototype.updateNowPlayingInfo=function(event,player,state){this.currentItemThumbnailsPromise=null,this.currentItemThumbnails=null;var item=state.NowPlayingItem;this.currentItem=item;var instance,nowPlayingPositionSlider=this.options.nowPlayingPositionSlider;item?(this.currentMediaSource=state.MediaSource,this.enableProgressByTimeOfDay=function(item,mediaSource){return!("TvChannel"!==item.Type||!item.CurrentProgram||!mediaSource||mediaSource.RunTimeTicks)||!(!("Recording"===item.Type&&item.StartDate&&item.EndDate&&mediaSource)||mediaSource.RunTimeTicks)}(item,state.MediaSource),nowPlayingPositionSlider.setForceDisplayThumb(this.enableProgressByTimeOfDay),this.enableProgressByTimeOfDay?nowPlayingPositionSlider.getTrackBackgroundUpper().classList.add("emby-slider-background-upper-accent"):nowPlayingPositionSlider.getTrackBackgroundUpper().classList.remove("emby-slider-background-upper-accent"),function(item,currentDisplayItem){return item.Id?currentDisplayItem&&currentDisplayItem.Id===item.Id?Promise.resolve({originalItem:item,displayItem:currentDisplayItem.CurrentProgram||currentDisplayItem}):(currentDisplayItem=_connectionmanager.default.getApiClient(item.ServerId)).getItem(currentDisplayItem.getCurrentUserId(),item.Id,{ExcludeFields:"VideoChapters,VideoMediaSources,MediaStreams"}).then(function(refreshedItem){return{originalItem:item,displayItem:refreshedItem.CurrentProgram||refreshedItem}}):Promise.resolve({originalItem:item})}(item,(instance=this).currentDisplayItem).then(function(itemInfo){var item=itemInfo.originalItem,itemInfo=(instance.currentItem=item,itemInfo.displayItem||item);instance.currentDisplayItem=itemInfo,_events.default.trigger(instance,"displayitemupdated",[item,itemInfo,state]),instance.updateDisplayItem(state,item,itemInfo)})):(setElementDisabled(this,nowPlayingPositionSlider,!0),this.enableProgressByTimeOfDay=!1,this.currentChapters=null,this.currentDisplayChapters=null,this.currentDisplayItem=null,this.currentMediaSource=null,_events.default.trigger(this,"displayitemupdated",[item,null,state]))},OsdController.prototype.updateDisplayItem=function(state,item,displayItem){this.currentChapters=item.Chapters||displayItem.Chapters||[],function(chapters,displayItem,mediaSource){var videoStream=((mediaSource||{}).MediaStreams||[]).filter(function(i){return"Video"===i.Type})[0]||{},aspect=null;videoStream.Width&&videoStream.Height&&(aspect=videoStream.Width/videoStream.Height);for(var i=0,length=chapters.length;i<length;i++){var chapter=chapters[i];chapter.ServerId=displayItem.ServerId,chapter.MediaType=displayItem.MediaType,chapter.PrimaryImageAspectRatio=aspect,null==chapter.ItemId&&(chapter.ItemId=displayItem.Id),chapter.MediaSourceId=mediaSource.Id,chapter.Type="Chapter",chapter.Id="chapter_"+chapter.ItemId+"_"+chapter.StartPositionTicks,null==chapter.ChapterIndex&&(chapter.ChapterIndex=i)}}(this.currentChapters,this.currentDisplayItem,this.currentMediaSource),this.currentDisplayChapters=function(chapters,mediaSource){for(var list=[],i=0,length=chapters.length;i<length;i++){var nextChapter,chapter=chapters[i];chapter.MarkerType&&"Chapter"!==chapter.MarkerType||(0<=(nextChapter=((null==(nextChapter=chapters[i+1])?void 0:nextChapter.StartPositionTicks)||(null==mediaSource?void 0:mediaSource.RunTimeTicks)||0)-chapter.StartPositionTicks)&&(chapter.DurationTicks=nextChapter),list.push(chapter))}return list}(this.currentChapters,state.MediaSource),this.currentItemThumbnailsPromise=null,this.currentItemThumbnails=null,updatePositionSliderDisabled(this,state),this.enableProgressByTimeOfDay?(item=displayItem.StartDate?_datetime.default.parseISO8601Date(displayItem.StartDate).getTime():0,this.visualStartDateMs=Math.min(item||this.wallClockStartTimeMs,this.wallClockStartTimeMs||item),this.visualEndDateMs=displayItem.EndDate?_datetime.default.parseISO8601Date(displayItem.EndDate).getTime():0):(this.visualStartDateMs=0,this.visualEndDateMs=0)},OsdController.prototype.onPlayPauseStateChanged=function(paused){this.paused=paused;var positionTextElem=this.options.positionTextElem;paused?null!=(paused=positionTextElem.querySelector(".osdcontroller-pauseicon"))&&paused.classList.remove("hide"):null!=(paused=positionTextElem.querySelector(".osdcontroller-pauseicon"))&&paused.classList.add("hide")},OsdController.prototype.onPlayerTimeUpdate=function(positionTicks,runtimeTicks,seekableRanges){var wallClockStartTimeMs,visualEndDateMs,currentTimeMs,visualStartDateMs,seekRuntimeMs,options=this.options,nowPlayingPositionSlider=options.nowPlayingPositionSlider,enableProgressByTimeOfDay=this.enableProgressByTimeOfDay,positionTextElem=options.positionTextElem,options=options.durationTextElem,isPositionSliderDragging=null==nowPlayingPositionSlider?void 0:nowPlayingPositionSlider.dragging;enableProgressByTimeOfDay?nowPlayingPositionSlider&&!isPositionSliderDragging&&(wallClockStartTimeMs=this.wallClockStartTimeMs,visualStartDateMs=this.visualStartDateMs,visualEndDateMs=this.visualEndDateMs,(visualStartDateMs=visualStartDateMs)&&visualEndDateMs?(currentTimeMs=wallClockStartTimeMs+(positionTicks||0)/1e4,seekRuntimeMs=visualEndDateMs-visualStartDateMs,setDisplayTime(positionTextElem,visualStartDateMs),options&&setDisplayTime(options,visualEndDateMs),this.nowPlayingSliderRunTimeTicks=1e4*seekRuntimeMs,nowPlayingPositionSlider.step=getStep(this.nowPlayingSliderRunTimeTicks),this.nowPlayingSliderValue=(currentTimeMs-visualStartDateMs)/seekRuntimeMs*100,nowPlayingPositionSlider.setValue(this.nowPlayingSliderValue),seekableRanges.length?(visualEndDateMs=getDisplayPercentByTimeOfDay(visualStartDateMs,seekRuntimeMs,wallClockStartTimeMs+(seekableRanges[0].start||0)/1e4),currentTimeMs=getDisplayPercentByTimeOfDay(visualStartDateMs,seekRuntimeMs,wallClockStartTimeMs+(seekableRanges[0].end||0)/1e4),nowPlayingPositionSlider.setSeekRanges([{start:visualEndDateMs,end:currentTimeMs}])):nowPlayingPositionSlider.setSeekRanges([])):(nowPlayingPositionSlider.step=.01,this.nowPlayingSliderRunTimeTicks=null,this.nowPlayingSliderValue=0,nowPlayingPositionSlider.setValue(0),nowPlayingPositionSlider.setSeekRanges([]))):(visualStartDateMs=0,(this.nowPlayingSliderRunTimeTicks=runtimeTicks)&&(visualStartDateMs=positionTicks/runtimeTicks,visualStartDateMs*=100),nowPlayingPositionSlider&&!isPositionSliderDragging&&(runtimeTicks?(nowPlayingPositionSlider.step=getStep(runtimeTicks),this.nowPlayingSliderValue=visualStartDateMs,nowPlayingPositionSlider.setValue(visualStartDateMs),options&&(!(seekRuntimeMs=this.currentMediaSource)||seekRuntimeMs.RunTimeTicks?updateDurationText(options,enableProgressByTimeOfDay,runtimeTicks-positionTicks,this.currentDisplayItem,!0):updateDurationText(options,enableProgressByTimeOfDay,runtimeTicks,this.currentDisplayItem,!1))):(nowPlayingPositionSlider.step=.01,this.nowPlayingSliderValue=0,nowPlayingPositionSlider.setValue(0),options&&updateDurationText(options,enableProgressByTimeOfDay,runtimeTicks,this.currentDisplayItem))),nowPlayingPositionSlider&&nowPlayingPositionSlider.setSeekRanges([]),isPositionSliderDragging&&runtimeTicks||updateTimeText(this,positionTextElem,positionTicks,visualStartDateMs))},OsdController.prototype.getPositionBubbleHtml=function(value,currentRuntimeTicks){var enableProgressByTimeOfDay=this.enableProgressByTimeOfDay;if(enableProgressByTimeOfDay)return(startDateMs=this.visualStartDateMs)&&this.visualEndDateMs?(ms=this.visualEndDateMs-startDateMs,ms=(ms/=100)*value+startDateMs,'<h3 class="sliderBubbleText">'+getDisplayTimeWithoutAmPm(new Date(parseInt(ms)),!0)+"</h3>"):"--:--";if(!currentRuntimeTicks)return"--:--";var startDateMs=currentRuntimeTicks,ms=(startDateMs=startDateMs/100*value,this.currentItem);if(ms&&this.options.enableSeekThumbnails){var currentRuntimeTicks=_connectionmanager.default.getApiClient(ms.ServerId),value=null==(value=this.currentMediaSource)?void 0:value.Id,thumbnailSet=(refreshThumbnailsIfNeeded(this,ms,value,currentRuntimeTicks,400),this.currentItemThumbnails),chapters=this.currentDisplayChapters||[],nowPlayingPositionSlider=this.options.nowPlayingPositionSlider,thumbnails=(null==thumbnailSet?void 0:thumbnailSet.Thumbnails)||{};if(chapters.length||thumbnails.length){thumbnails=getThumbnailBubbleHtml(nowPlayingPositionSlider,enableProgressByTimeOfDay,currentRuntimeTicks,ms.Id,value,thumbnailSet,chapters,startDateMs,400);if(thumbnails)return thumbnails}}return'<h2 class="sliderBubbleText">'+_datetime.default.getDisplayRunningTime(startDateMs)+"</h2>"},OsdController.prototype.onChannelUp=function(e){},OsdController.prototype.onChannelDown=function(e){},OsdController.prototype.onPageUp=function(e){e.preventDefault();e=this.currentItem;e&&"TvChannel"===e.Type?showChannelChanger(e,1):_playbackmanager.default.nextChapter(this.currentPlayer)},OsdController.prototype.onPageDown=function(e){e.preventDefault();e=this.currentItem;e&&"TvChannel"===e.Type?showChannelChanger(e,-1):_playbackmanager.default.previousChapter(this.currentPlayer)},OsdController.prototype.onPlaybackStart=function(e,player,state){cancelPositionSliderEditing(this)},OsdController.prototype.onPlaybackStopped=function(e,state){cancelPositionSliderEditing(this)},OsdController.prototype.bindToPlayer=function(player){this.currentPlayer=player},OsdController.prototype.releaseCurrentPlayer=function(){cancelPositionSliderEditing(this),this.currentPlayer=null},OsdController.prototype.destroy=function(){var _this$options;this.releaseCurrentPlayer(),null!=(_this$options=this.options)&&_this$options.positionTextElem&&(this.options.positionTextElem.innerHTML=""),this.currentItemThumbnailsPromise=null,this.currentItemThumbnails=null,this.currentChapters=null,this.currentDisplayChapters=null,this.currentItem=null,this.currentDisplayItem=null,this.currentMediaSource=null,this.options=null};_exports.default=OsdController});