﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/rds/RDS_EXPORTS.h>
#include <aws/rds/model/DBSnapshot.h>
#include <aws/rds/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace RDS {
namespace Model {
class ModifyDBSnapshotResult {
 public:
  AWS_RDS_API ModifyDBSnapshotResult() = default;
  AWS_RDS_API ModifyDBSnapshotResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_RDS_API ModifyDBSnapshotResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{

  inline const DBSnapshot& GetDBSnapshot() const { return m_dBSnapshot; }
  template <typename DBSnapshotT = DBSnapshot>
  void SetDBSnapshot(DBSnapshotT&& value) {
    m_dBSnapshotHasBeenSet = true;
    m_dBSnapshot = std::forward<DBSnapshotT>(value);
  }
  template <typename DBSnapshotT = DBSnapshot>
  ModifyDBSnapshotResult& WithDBSnapshot(DBSnapshotT&& value) {
    SetDBSnapshot(std::forward<DBSnapshotT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ModifyDBSnapshotResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  DBSnapshot m_dBSnapshot;

  ResponseMetadata m_responseMetadata;
  bool m_dBSnapshotHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace RDS
}  // namespace Aws
