﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/GlueSchema.h>
#include <aws/glue/model/TransformConfigParameter.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>Specifies the set of parameters needed to perform the dynamic
 * transform.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DynamicTransform">AWS
 * API Reference</a></p>
 */
class DynamicTransform {
 public:
  AWS_GLUE_API DynamicTransform() = default;
  AWS_GLUE_API DynamicTransform(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API DynamicTransform& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Specifies the name of the dynamic transform.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DynamicTransform& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the name of the dynamic transform as it appears in the Glue Studio
   * visual editor.</p>
   */
  inline const Aws::String& GetTransformName() const { return m_transformName; }
  inline bool TransformNameHasBeenSet() const { return m_transformNameHasBeenSet; }
  template <typename TransformNameT = Aws::String>
  void SetTransformName(TransformNameT&& value) {
    m_transformNameHasBeenSet = true;
    m_transformName = std::forward<TransformNameT>(value);
  }
  template <typename TransformNameT = Aws::String>
  DynamicTransform& WithTransformName(TransformNameT&& value) {
    SetTransformName(std::forward<TransformNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the inputs for the dynamic transform that are required.</p>
   */
  inline const Aws::Vector<Aws::String>& GetInputs() const { return m_inputs; }
  inline bool InputsHasBeenSet() const { return m_inputsHasBeenSet; }
  template <typename InputsT = Aws::Vector<Aws::String>>
  void SetInputs(InputsT&& value) {
    m_inputsHasBeenSet = true;
    m_inputs = std::forward<InputsT>(value);
  }
  template <typename InputsT = Aws::Vector<Aws::String>>
  DynamicTransform& WithInputs(InputsT&& value) {
    SetInputs(std::forward<InputsT>(value));
    return *this;
  }
  template <typename InputsT = Aws::String>
  DynamicTransform& AddInputs(InputsT&& value) {
    m_inputsHasBeenSet = true;
    m_inputs.emplace_back(std::forward<InputsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the parameters of the dynamic transform.</p>
   */
  inline const Aws::Vector<TransformConfigParameter>& GetParameters() const { return m_parameters; }
  inline bool ParametersHasBeenSet() const { return m_parametersHasBeenSet; }
  template <typename ParametersT = Aws::Vector<TransformConfigParameter>>
  void SetParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters = std::forward<ParametersT>(value);
  }
  template <typename ParametersT = Aws::Vector<TransformConfigParameter>>
  DynamicTransform& WithParameters(ParametersT&& value) {
    SetParameters(std::forward<ParametersT>(value));
    return *this;
  }
  template <typename ParametersT = TransformConfigParameter>
  DynamicTransform& AddParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters.emplace_back(std::forward<ParametersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the name of the function of the dynamic transform.</p>
   */
  inline const Aws::String& GetFunctionName() const { return m_functionName; }
  inline bool FunctionNameHasBeenSet() const { return m_functionNameHasBeenSet; }
  template <typename FunctionNameT = Aws::String>
  void SetFunctionName(FunctionNameT&& value) {
    m_functionNameHasBeenSet = true;
    m_functionName = std::forward<FunctionNameT>(value);
  }
  template <typename FunctionNameT = Aws::String>
  DynamicTransform& WithFunctionName(FunctionNameT&& value) {
    SetFunctionName(std::forward<FunctionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the path of the dynamic transform source and config files.</p>
   */
  inline const Aws::String& GetPath() const { return m_path; }
  inline bool PathHasBeenSet() const { return m_pathHasBeenSet; }
  template <typename PathT = Aws::String>
  void SetPath(PathT&& value) {
    m_pathHasBeenSet = true;
    m_path = std::forward<PathT>(value);
  }
  template <typename PathT = Aws::String>
  DynamicTransform& WithPath(PathT&& value) {
    SetPath(std::forward<PathT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This field is not used and will be deprecated in future release.</p>
   */
  inline const Aws::String& GetVersion() const { return m_version; }
  inline bool VersionHasBeenSet() const { return m_versionHasBeenSet; }
  template <typename VersionT = Aws::String>
  void SetVersion(VersionT&& value) {
    m_versionHasBeenSet = true;
    m_version = std::forward<VersionT>(value);
  }
  template <typename VersionT = Aws::String>
  DynamicTransform& WithVersion(VersionT&& value) {
    SetVersion(std::forward<VersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the data schema for the dynamic transform.</p>
   */
  inline const Aws::Vector<GlueSchema>& GetOutputSchemas() const { return m_outputSchemas; }
  inline bool OutputSchemasHasBeenSet() const { return m_outputSchemasHasBeenSet; }
  template <typename OutputSchemasT = Aws::Vector<GlueSchema>>
  void SetOutputSchemas(OutputSchemasT&& value) {
    m_outputSchemasHasBeenSet = true;
    m_outputSchemas = std::forward<OutputSchemasT>(value);
  }
  template <typename OutputSchemasT = Aws::Vector<GlueSchema>>
  DynamicTransform& WithOutputSchemas(OutputSchemasT&& value) {
    SetOutputSchemas(std::forward<OutputSchemasT>(value));
    return *this;
  }
  template <typename OutputSchemasT = GlueSchema>
  DynamicTransform& AddOutputSchemas(OutputSchemasT&& value) {
    m_outputSchemasHasBeenSet = true;
    m_outputSchemas.emplace_back(std::forward<OutputSchemasT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_transformName;

  Aws::Vector<Aws::String> m_inputs;

  Aws::Vector<TransformConfigParameter> m_parameters;

  Aws::String m_functionName;

  Aws::String m_path;

  Aws::String m_version;

  Aws::Vector<GlueSchema> m_outputSchemas;
  bool m_nameHasBeenSet = false;
  bool m_transformNameHasBeenSet = false;
  bool m_inputsHasBeenSet = false;
  bool m_parametersHasBeenSet = false;
  bool m_functionNameHasBeenSet = false;
  bool m_pathHasBeenSet = false;
  bool m_versionHasBeenSet = false;
  bool m_outputSchemasHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
