/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DynamicOptions
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DynamicOptions> {
    @Nonnull
    private final Map<String, JsonData> authFailureListeners;
    @Nonnull
    private final Map<String, JsonData> authc;
    @Nonnull
    private final Map<String, JsonData> authz;
    @Nullable
    private final Boolean disableIntertransportAuth;
    @Nullable
    private final Boolean disableRestAuth;
    @Nullable
    private final Boolean doNotFailOnForbidden;
    @Nullable
    private final Boolean doNotFailOnForbiddenEmpty;
    @Nullable
    private final String filteredAliasMode;
    @Nullable
    private final String hostsResolverMode;
    @Nonnull
    private final Map<String, JsonData> http;
    @Nonnull
    private final Map<String, JsonData> kibana;
    @Nullable
    private final Boolean multiRolespanEnabled;
    @Nonnull
    private final Map<String, JsonData> onBehalfOf;
    @Nonnull
    private final Map<String, JsonData> opensearchDashboards;
    @Nullable
    private final Boolean respectRequestIndicesOptions;
    public static final JsonpDeserializer<DynamicOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DynamicOptions::setupDynamicOptionsDeserializer);

    private DynamicOptions(Builder builder) {
        this.authFailureListeners = ApiTypeHelper.unmodifiable(builder.authFailureListeners);
        this.authc = ApiTypeHelper.unmodifiable(builder.authc);
        this.authz = ApiTypeHelper.unmodifiable(builder.authz);
        this.disableIntertransportAuth = builder.disableIntertransportAuth;
        this.disableRestAuth = builder.disableRestAuth;
        this.doNotFailOnForbidden = builder.doNotFailOnForbidden;
        this.doNotFailOnForbiddenEmpty = builder.doNotFailOnForbiddenEmpty;
        this.filteredAliasMode = builder.filteredAliasMode;
        this.hostsResolverMode = builder.hostsResolverMode;
        this.http = ApiTypeHelper.unmodifiable(builder.http);
        this.kibana = ApiTypeHelper.unmodifiable(builder.kibana);
        this.multiRolespanEnabled = builder.multiRolespanEnabled;
        this.onBehalfOf = ApiTypeHelper.unmodifiable(builder.onBehalfOf);
        this.opensearchDashboards = ApiTypeHelper.unmodifiable(builder.opensearchDashboards);
        this.respectRequestIndicesOptions = builder.respectRequestIndicesOptions;
    }

    public static DynamicOptions of(Function<Builder, ObjectBuilder<DynamicOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, JsonData> authFailureListeners() {
        return this.authFailureListeners;
    }

    @Nonnull
    public final Map<String, JsonData> authc() {
        return this.authc;
    }

    @Nonnull
    public final Map<String, JsonData> authz() {
        return this.authz;
    }

    @Nullable
    public final Boolean disableIntertransportAuth() {
        return this.disableIntertransportAuth;
    }

    @Nullable
    public final Boolean disableRestAuth() {
        return this.disableRestAuth;
    }

    @Nullable
    public final Boolean doNotFailOnForbidden() {
        return this.doNotFailOnForbidden;
    }

    @Nullable
    public final Boolean doNotFailOnForbiddenEmpty() {
        return this.doNotFailOnForbiddenEmpty;
    }

    @Nullable
    public final String filteredAliasMode() {
        return this.filteredAliasMode;
    }

    @Nullable
    public final String hostsResolverMode() {
        return this.hostsResolverMode;
    }

    @Nonnull
    public final Map<String, JsonData> http() {
        return this.http;
    }

    @Nonnull
    public final Map<String, JsonData> kibana() {
        return this.kibana;
    }

    @Nullable
    public final Boolean multiRolespanEnabled() {
        return this.multiRolespanEnabled;
    }

    @Nonnull
    public final Map<String, JsonData> onBehalfOf() {
        return this.onBehalfOf;
    }

    @Nonnull
    public final Map<String, JsonData> opensearchDashboards() {
        return this.opensearchDashboards;
    }

    @Nullable
    public final Boolean respectRequestIndicesOptions() {
        return this.respectRequestIndicesOptions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.authFailureListeners)) {
            generator.writeKey("auth_failure_listeners");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.authFailureListeners.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.authc)) {
            generator.writeKey("authc");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.authc.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.authz)) {
            generator.writeKey("authz");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.authz.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.disableIntertransportAuth != null) {
            generator.writeKey("disable_intertransport_auth");
            generator.write(this.disableIntertransportAuth.booleanValue());
        }
        if (this.disableRestAuth != null) {
            generator.writeKey("disable_rest_auth");
            generator.write(this.disableRestAuth.booleanValue());
        }
        if (this.doNotFailOnForbidden != null) {
            generator.writeKey("do_not_fail_on_forbidden");
            generator.write(this.doNotFailOnForbidden.booleanValue());
        }
        if (this.doNotFailOnForbiddenEmpty != null) {
            generator.writeKey("do_not_fail_on_forbidden_empty");
            generator.write(this.doNotFailOnForbiddenEmpty.booleanValue());
        }
        if (this.filteredAliasMode != null) {
            generator.writeKey("filtered_alias_mode");
            generator.write(this.filteredAliasMode);
        }
        if (this.hostsResolverMode != null) {
            generator.writeKey("hosts_resolver_mode");
            generator.write(this.hostsResolverMode);
        }
        if (ApiTypeHelper.isDefined(this.http)) {
            generator.writeKey("http");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.http.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.kibana)) {
            generator.writeKey("kibana");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.kibana.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.multiRolespanEnabled != null) {
            generator.writeKey("multi_rolespan_enabled");
            generator.write(this.multiRolespanEnabled.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.onBehalfOf)) {
            generator.writeKey("on_behalf_of");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.onBehalfOf.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.opensearchDashboards)) {
            generator.writeKey("opensearch-dashboards");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.opensearchDashboards.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.respectRequestIndicesOptions != null) {
            generator.writeKey("respect_request_indices_options");
            generator.write(this.respectRequestIndicesOptions.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDynamicOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::authFailureListeners, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "auth_failure_listeners");
        op.add(Builder::authc, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "authc");
        op.add(Builder::authz, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "authz");
        op.add(Builder::disableIntertransportAuth, JsonpDeserializer.booleanDeserializer(), "disable_intertransport_auth");
        op.add(Builder::disableRestAuth, JsonpDeserializer.booleanDeserializer(), "disable_rest_auth");
        op.add(Builder::doNotFailOnForbidden, JsonpDeserializer.booleanDeserializer(), "do_not_fail_on_forbidden");
        op.add(Builder::doNotFailOnForbiddenEmpty, JsonpDeserializer.booleanDeserializer(), "do_not_fail_on_forbidden_empty");
        op.add(Builder::filteredAliasMode, JsonpDeserializer.stringDeserializer(), "filtered_alias_mode");
        op.add(Builder::hostsResolverMode, JsonpDeserializer.stringDeserializer(), "hosts_resolver_mode");
        op.add(Builder::http, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "http");
        op.add(Builder::kibana, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "kibana");
        op.add(Builder::multiRolespanEnabled, JsonpDeserializer.booleanDeserializer(), "multi_rolespan_enabled");
        op.add(Builder::onBehalfOf, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "on_behalf_of");
        op.add(Builder::opensearchDashboards, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "opensearch-dashboards");
        op.add(Builder::respectRequestIndicesOptions, JsonpDeserializer.booleanDeserializer(), "respect_request_indices_options");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.authFailureListeners);
        result = 31 * result + Objects.hashCode(this.authc);
        result = 31 * result + Objects.hashCode(this.authz);
        result = 31 * result + Objects.hashCode(this.disableIntertransportAuth);
        result = 31 * result + Objects.hashCode(this.disableRestAuth);
        result = 31 * result + Objects.hashCode(this.doNotFailOnForbidden);
        result = 31 * result + Objects.hashCode(this.doNotFailOnForbiddenEmpty);
        result = 31 * result + Objects.hashCode(this.filteredAliasMode);
        result = 31 * result + Objects.hashCode(this.hostsResolverMode);
        result = 31 * result + Objects.hashCode(this.http);
        result = 31 * result + Objects.hashCode(this.kibana);
        result = 31 * result + Objects.hashCode(this.multiRolespanEnabled);
        result = 31 * result + Objects.hashCode(this.onBehalfOf);
        result = 31 * result + Objects.hashCode(this.opensearchDashboards);
        result = 31 * result + Objects.hashCode(this.respectRequestIndicesOptions);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicOptions other = (DynamicOptions)o;
        return Objects.equals(this.authFailureListeners, other.authFailureListeners) && Objects.equals(this.authc, other.authc) && Objects.equals(this.authz, other.authz) && Objects.equals(this.disableIntertransportAuth, other.disableIntertransportAuth) && Objects.equals(this.disableRestAuth, other.disableRestAuth) && Objects.equals(this.doNotFailOnForbidden, other.doNotFailOnForbidden) && Objects.equals(this.doNotFailOnForbiddenEmpty, other.doNotFailOnForbiddenEmpty) && Objects.equals(this.filteredAliasMode, other.filteredAliasMode) && Objects.equals(this.hostsResolverMode, other.hostsResolverMode) && Objects.equals(this.http, other.http) && Objects.equals(this.kibana, other.kibana) && Objects.equals(this.multiRolespanEnabled, other.multiRolespanEnabled) && Objects.equals(this.onBehalfOf, other.onBehalfOf) && Objects.equals(this.opensearchDashboards, other.opensearchDashboards) && Objects.equals(this.respectRequestIndicesOptions, other.respectRequestIndicesOptions);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, DynamicOptions> {
        @Nullable
        private Map<String, JsonData> authFailureListeners;
        @Nullable
        private Map<String, JsonData> authc;
        @Nullable
        private Map<String, JsonData> authz;
        @Nullable
        private Boolean disableIntertransportAuth;
        @Nullable
        private Boolean disableRestAuth;
        @Nullable
        private Boolean doNotFailOnForbidden;
        @Nullable
        private Boolean doNotFailOnForbiddenEmpty;
        @Nullable
        private String filteredAliasMode;
        @Nullable
        private String hostsResolverMode;
        @Nullable
        private Map<String, JsonData> http;
        @Nullable
        private Map<String, JsonData> kibana;
        @Nullable
        private Boolean multiRolespanEnabled;
        @Nullable
        private Map<String, JsonData> onBehalfOf;
        @Nullable
        private Map<String, JsonData> opensearchDashboards;
        @Nullable
        private Boolean respectRequestIndicesOptions;

        public Builder() {
        }

        private Builder(DynamicOptions o) {
            this.authFailureListeners = Builder._mapCopy(o.authFailureListeners);
            this.authc = Builder._mapCopy(o.authc);
            this.authz = Builder._mapCopy(o.authz);
            this.disableIntertransportAuth = o.disableIntertransportAuth;
            this.disableRestAuth = o.disableRestAuth;
            this.doNotFailOnForbidden = o.doNotFailOnForbidden;
            this.doNotFailOnForbiddenEmpty = o.doNotFailOnForbiddenEmpty;
            this.filteredAliasMode = o.filteredAliasMode;
            this.hostsResolverMode = o.hostsResolverMode;
            this.http = Builder._mapCopy(o.http);
            this.kibana = Builder._mapCopy(o.kibana);
            this.multiRolespanEnabled = o.multiRolespanEnabled;
            this.onBehalfOf = Builder._mapCopy(o.onBehalfOf);
            this.opensearchDashboards = Builder._mapCopy(o.opensearchDashboards);
            this.respectRequestIndicesOptions = o.respectRequestIndicesOptions;
        }

        private Builder(Builder o) {
            this.authFailureListeners = Builder._mapCopy(o.authFailureListeners);
            this.authc = Builder._mapCopy(o.authc);
            this.authz = Builder._mapCopy(o.authz);
            this.disableIntertransportAuth = o.disableIntertransportAuth;
            this.disableRestAuth = o.disableRestAuth;
            this.doNotFailOnForbidden = o.doNotFailOnForbidden;
            this.doNotFailOnForbiddenEmpty = o.doNotFailOnForbiddenEmpty;
            this.filteredAliasMode = o.filteredAliasMode;
            this.hostsResolverMode = o.hostsResolverMode;
            this.http = Builder._mapCopy(o.http);
            this.kibana = Builder._mapCopy(o.kibana);
            this.multiRolespanEnabled = o.multiRolespanEnabled;
            this.onBehalfOf = Builder._mapCopy(o.onBehalfOf);
            this.opensearchDashboards = Builder._mapCopy(o.opensearchDashboards);
            this.respectRequestIndicesOptions = o.respectRequestIndicesOptions;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder authFailureListeners(Map<String, JsonData> map) {
            this.authFailureListeners = Builder._mapPutAll(this.authFailureListeners, map);
            return this;
        }

        @Nonnull
        public final Builder authFailureListeners(String key, JsonData value) {
            this.authFailureListeners = Builder._mapPut(this.authFailureListeners, key, value);
            return this;
        }

        @Nonnull
        public final Builder authc(Map<String, JsonData> map) {
            this.authc = Builder._mapPutAll(this.authc, map);
            return this;
        }

        @Nonnull
        public final Builder authc(String key, JsonData value) {
            this.authc = Builder._mapPut(this.authc, key, value);
            return this;
        }

        @Nonnull
        public final Builder authz(Map<String, JsonData> map) {
            this.authz = Builder._mapPutAll(this.authz, map);
            return this;
        }

        @Nonnull
        public final Builder authz(String key, JsonData value) {
            this.authz = Builder._mapPut(this.authz, key, value);
            return this;
        }

        @Nonnull
        public final Builder disableIntertransportAuth(@Nullable Boolean value) {
            this.disableIntertransportAuth = value;
            return this;
        }

        @Nonnull
        public final Builder disableRestAuth(@Nullable Boolean value) {
            this.disableRestAuth = value;
            return this;
        }

        @Nonnull
        public final Builder doNotFailOnForbidden(@Nullable Boolean value) {
            this.doNotFailOnForbidden = value;
            return this;
        }

        @Nonnull
        public final Builder doNotFailOnForbiddenEmpty(@Nullable Boolean value) {
            this.doNotFailOnForbiddenEmpty = value;
            return this;
        }

        @Nonnull
        public final Builder filteredAliasMode(@Nullable String value) {
            this.filteredAliasMode = value;
            return this;
        }

        @Nonnull
        public final Builder hostsResolverMode(@Nullable String value) {
            this.hostsResolverMode = value;
            return this;
        }

        @Nonnull
        public final Builder http(Map<String, JsonData> map) {
            this.http = Builder._mapPutAll(this.http, map);
            return this;
        }

        @Nonnull
        public final Builder http(String key, JsonData value) {
            this.http = Builder._mapPut(this.http, key, value);
            return this;
        }

        @Nonnull
        public final Builder kibana(Map<String, JsonData> map) {
            this.kibana = Builder._mapPutAll(this.kibana, map);
            return this;
        }

        @Nonnull
        public final Builder kibana(String key, JsonData value) {
            this.kibana = Builder._mapPut(this.kibana, key, value);
            return this;
        }

        @Nonnull
        public final Builder multiRolespanEnabled(@Nullable Boolean value) {
            this.multiRolespanEnabled = value;
            return this;
        }

        @Nonnull
        public final Builder onBehalfOf(Map<String, JsonData> map) {
            this.onBehalfOf = Builder._mapPutAll(this.onBehalfOf, map);
            return this;
        }

        @Nonnull
        public final Builder onBehalfOf(String key, JsonData value) {
            this.onBehalfOf = Builder._mapPut(this.onBehalfOf, key, value);
            return this;
        }

        @Nonnull
        public final Builder opensearchDashboards(Map<String, JsonData> map) {
            this.opensearchDashboards = Builder._mapPutAll(this.opensearchDashboards, map);
            return this;
        }

        @Nonnull
        public final Builder opensearchDashboards(String key, JsonData value) {
            this.opensearchDashboards = Builder._mapPut(this.opensearchDashboards, key, value);
            return this;
        }

        @Nonnull
        public final Builder respectRequestIndicesOptions(@Nullable Boolean value) {
            this.respectRequestIndicesOptions = value;
            return this;
        }

        @Override
        @Nonnull
        public DynamicOptions build() {
            this._checkSingleUse();
            return new DynamicOptions(this);
        }
    }
}

