﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/storagegateway/StorageGatewayRequest.h>
#include <aws/storagegateway/StorageGateway_EXPORTS.h>

#include <utility>

namespace Aws {
namespace StorageGateway {
namespace Model {

/**
 * <p>CancelArchivalInput</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchivalInput">AWS
 * API Reference</a></p>
 */
class CancelArchivalRequest : public StorageGatewayRequest {
 public:
  AWS_STORAGEGATEWAY_API CancelArchivalRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CancelArchival"; }

  AWS_STORAGEGATEWAY_API Aws::String SerializePayload() const override;

  AWS_STORAGEGATEWAY_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{

  inline const Aws::String& GetGatewayARN() const { return m_gatewayARN; }
  inline bool GatewayARNHasBeenSet() const { return m_gatewayARNHasBeenSet; }
  template <typename GatewayARNT = Aws::String>
  void SetGatewayARN(GatewayARNT&& value) {
    m_gatewayARNHasBeenSet = true;
    m_gatewayARN = std::forward<GatewayARNT>(value);
  }
  template <typename GatewayARNT = Aws::String>
  CancelArchivalRequest& WithGatewayARN(GatewayARNT&& value) {
    SetGatewayARN(std::forward<GatewayARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the virtual tape you want to cancel
   * archiving for.</p>
   */
  inline const Aws::String& GetTapeARN() const { return m_tapeARN; }
  inline bool TapeARNHasBeenSet() const { return m_tapeARNHasBeenSet; }
  template <typename TapeARNT = Aws::String>
  void SetTapeARN(TapeARNT&& value) {
    m_tapeARNHasBeenSet = true;
    m_tapeARN = std::forward<TapeARNT>(value);
  }
  template <typename TapeARNT = Aws::String>
  CancelArchivalRequest& WithTapeARN(TapeARNT&& value) {
    SetTapeARN(std::forward<TapeARNT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_gatewayARN;

  Aws::String m_tapeARN;
  bool m_gatewayARNHasBeenSet = false;
  bool m_tapeARNHasBeenSet = false;
};

}  // namespace Model
}  // namespace StorageGateway
}  // namespace Aws
