﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {
class GetContainerAPIMetadataResult {
 public:
  AWS_LIGHTSAIL_API GetContainerAPIMetadataResult() = default;
  AWS_LIGHTSAIL_API GetContainerAPIMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LIGHTSAIL_API GetContainerAPIMetadataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Metadata about Lightsail containers, such as the current version of the
   * Lightsail Control (lightsailctl) plugin.</p>
   */
  inline const Aws::Vector<Aws::Map<Aws::String, Aws::String>>& GetMetadata() const { return m_metadata; }
  template <typename MetadataT = Aws::Vector<Aws::Map<Aws::String, Aws::String>>>
  void SetMetadata(MetadataT&& value) {
    m_metadataHasBeenSet = true;
    m_metadata = std::forward<MetadataT>(value);
  }
  template <typename MetadataT = Aws::Vector<Aws::Map<Aws::String, Aws::String>>>
  GetContainerAPIMetadataResult& WithMetadata(MetadataT&& value) {
    SetMetadata(std::forward<MetadataT>(value));
    return *this;
  }
  template <typename MetadataT = Aws::Map<Aws::String, Aws::String>>
  GetContainerAPIMetadataResult& AddMetadata(MetadataT&& value) {
    m_metadataHasBeenSet = true;
    m_metadata.emplace_back(std::forward<MetadataT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetContainerAPIMetadataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::Map<Aws::String, Aws::String>> m_metadata;

  Aws::String m_requestId;
  bool m_metadataHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
