# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appconfiguration import AppConfigurationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAppConfigurationManagementSnapshotsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AppConfigurationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_snapshots_get(self, resource_group):
        response = self.client.snapshots.get(
            resource_group_name=resource_group.name,
            config_store_name="str",
            snapshot_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_snapshots_begin_create(self, resource_group):
        response = self.client.snapshots.begin_create(
            resource_group_name=resource_group.name,
            config_store_name="str",
            snapshot_name="str",
            body={
                "id": "str",
                "name": "str",
                "properties": {
                    "filters": [{"key": "str", "label": "str"}],
                    "compositionType": "str",
                    "created": "2020-02-20 00:00:00",
                    "etag": "str",
                    "expires": "2020-02-20 00:00:00",
                    "itemsCount": 0,
                    "provisioningState": "str",
                    "retentionPeriod": 0,
                    "size": 0,
                    "status": "str",
                    "tags": {"str": "str"},
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
