/*
 * @(#)IXmlReportConst.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.report;



/**
 * Contains constants for generating an XML Coverage report.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/12/19 17:07:29 $
 * @since     November 25, 2003
 */
public interface IXmlReportConst
{
    public static final String T_COVERAGEREPORT = "coveragereport";
    public static final String A_MEASURE = "measure";
    public static final String A_UNIT = "unit";
    
    public static final String T_CLASSCOVERAGE = "classcoverage";
    public static final String A_CLASSSIGNATURE = "classsignature";
    public static final String A_CLASSNAME = "classname";
    public static final String A_SOURCEFILE = "sourcefile";
    public static final String A_PACKAGE = "package";
    
    public static final String T_COVER = "cover";
    public static final String A_COVERED_DISP = "display-covered";
    public static final String A_COVERED = "covered";
    public static final String A_TOTAL_DISP = "display-total";
    public static final String A_TOTAL = "total";
    public static final String A_PERCENTCOVERED_DISP = "display-percentcovered";
    public static final String A_PERCENTCOVERED = "percentcovered";
    public static final String A_WEIGHTEDPERCENT_DISP = "display-weightedpercent";
    public static final String A_WEIGHTEDPERCENT = "weightedpercent";
    
    public static final String T_METHODCOVERAGE = "methodcoverage";
    public static final String A_METHODSIGNATURE = "methodsignature";
    public static final String A_METHODSIGNATURE_REAL = "real-methodsignature";
    
    public static final String T_MARK = "mark";
    // public static final String A_COVERED = "covered";
    public static final String A_INDEX = "index";
    public static final String A_TEXT = "text";
    public static final String A_WEIGHT = "weight";
    public static final String A_SOURCELINE = "sourceline";
    
    public static final String T_PACKAGE = "package";
    public static final String A_NAME = "name";
}

