/*--------------------------------------------------------------------------+
$Id: CounterSetTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import junit.framework.TestCase;

/**
 * JUnit test for <code>CounterArray</code> class.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * 
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 6B36F65F547A17614DF97548E5269D38
 */
public class CounterSetTest extends TestCase {

	/** Array under test. */
	private final CounterSet<String> array = new CounterSet<String>();

	/**
	 * Set up test fixture.
	 */
	@Override
	public void setUp() {
		array.inc("test1", 5);
		array.inc("test2", 1);
	}

	/**
	 * Test method for 'edu.tum.cs.commons.counters.CounterArray.add(E, int)'
	 */
	public void testIncWithIncrement() {
		assertEquals(5, array.getValue("test1"));
		array.inc("test1", 5);
		assertEquals(10, array.getValue("test1"));
		array.inc("testX", 3);
		assertEquals(3, array.getValue("testX"));
	}

	/**
	 * Test method for 'edu.tum.cs.commons.counters.CounterArray.inc(E)'
	 */
	public void testInc() {
		assertEquals(5, array.getValue("test1"));
		array.inc("test1");
		assertEquals(6, array.getValue("test1"));
		array.inc("testX");
		assertEquals(1, array.getValue("testX"));
	}

	/**
	 * Test method for 'edu.tum.cs.commons.counters.CounterArray.contains(E)'
	 */
	public void testContains() {
		assertTrue(array.contains("test1"));
		assertTrue(array.contains("test2"));
		assertFalse(array.contains("X"));
	}

	/**
	 * Test method for 'edu.tum.cs.commons.counters.CounterArray.getValue(E)'
	 */
	public void testGetValue() {
		assertEquals(5, array.getValue("test1"));
		assertEquals(1, array.getValue("test2"));
		assertEquals(0, array.getValue("X"));
	}

	/**
	 * Test method for 'edu.tum.cs.commons.counters.CounterArray.getElements()'
	 */
	public void testGetElements() {
		UnmodifiableSet<String> elements = array.getKeys();
		assertEquals(2, elements.size());
		assertTrue(elements.contains("test1"));
		assertTrue(elements.contains("test2"));
	}

	/**
	 * Test method for 'edu.tum.cs.commons.counters.CounterArray.getTotal()'
	 */
	public void testGetTotal() {
		assertEquals(6, array.getTotal());
	}
}