/*--------------------------------------------------------------------------+
$Id: ArrayBackedMapTest.java 29400 2010-07-27 15:03:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import java.util.Map;
import java.util.Set;

import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Tests the {@link ArrayBackedMap}.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 29400 $
 * @levd.rating GREEN Hash: 1C5A41EEF40720E299335AE31CB0C158
 */
public class ArrayBackedMapTest extends CCSMTestCaseBase {

	/** Tests the size method. */
	public void testSize() {
		Map<Integer, Integer> map = new ArrayBackedMap<Integer, Integer>();

		assertTrue(map.isEmpty());
		assertEquals(0, map.size());

		map.put(1, 1);
		assertFalse(map.isEmpty());
		assertEquals(1, map.size());

		map.put(2, 2);
		assertFalse(map.isEmpty());
		assertEquals(2, map.size());

		map.put(1, 3);
		assertFalse(map.isEmpty());
		assertEquals(2, map.size());

		map.remove(2);
		assertFalse(map.isEmpty());
		assertEquals(1, map.size());

		map.remove(2);
		assertFalse(map.isEmpty());
		assertEquals(1, map.size());

		map.remove(1);
		assertTrue(map.isEmpty());
		assertEquals(0, map.size());
	}

	/** Tests whether values are stored correctly. */
	public void testStore() {
		Map<Integer, Integer> map = new ArrayBackedMap<Integer, Integer>();

		for (int i = 0; i < 5; ++i) {
			map.put(i, i * i + 1);
		}

		for (int i = 0; i < 5; ++i) {
			assertTrue(map.containsKey(i));
			assertEquals((Integer) (i * i + 1), map.get(i));
		}

		assertTrue(!map.containsKey(6));
		assertNull(map.get(6));
		assertTrue(!map.containsKey("Foo"));
		assertNull(map.get("Foo"));

		// change values
		for (int i = 0; i < 5; ++i) {
			map.put(i, 3 * i);
		}

		for (int i = 0; i < 5; ++i) {
			assertTrue(map.containsKey(i));
			assertEquals((Integer) (3 * i), map.get(i));
		}

		for (int i = 0; i < 5; ++i) {
			assertEquals((Integer) (3 * i), map.remove(i));
		}
		assertNull(map.remove(6));
		assertNull(map.remove("Foo"));

		assertTrue(map.isEmpty());
	}

	/** Tests the set accessors of the map. */
	public void testSets() {
		Map<Integer, Integer> map = new ArrayBackedMap<Integer, Integer>();
		for (int i = 0; i < 10; ++i) {
			map.put(i, i);
		}

		Set<Integer> keys = map.keySet();
		assertEquals(10, keys.size());
		for (int i = 0; i < 10; ++i) {
			assertTrue(map.containsKey(i));
		}
	}

}
