## How can I contribute ?

### Code contribution

#### Issues

If you are unsure where to begin contribution to Num2Words, you can start by looking through the issues page.
Numerous issues are created and waiting for your love on the [issue board](https://github.com/savoirfairelinux/num2words/issues).

#### Pull Requests

Contributions will be accepted through the creation of Pull Requests. Here is the workflow:

* Fork the repository into yours and work from there
* Commit and push your changes into your fork
* When you are done, create a [Pull Request](https://github.com/savoirfairelinux/num2words/compare) on the **master** branch

A template is provided to create your Pull Request. Try to fill the information at the best of your knowledge.

#### Pull request checklist

For your pull request to be merged, the answer to the following questions must be 'yes':

##### General

* Can the branch be merged automatically?

##### Testing

* Do the unit tests pass?

##### Adding new code

* Is the code PEP8 compliant?
* Is the code covered by tests?

[TravisCI](https://travis-ci.org/) is configured to run those checks on every Pull-Request. It is recommended you configure your fork to do the same.

### Reporting bugs

Bugs are tracked as [GitHub issues](https://guides.github.com/features/issues/).

#### How to submit a good bug report

Please include as many details as possible. An issue template is automatically loaded when you create an issue.

* Use a clear and comprehensive title for the issue
* Describe the expected behaviour in as many details as possible
* Describe the actual behaviour in as many details as possible

### Testing the application

Our development process is based on Continuous Integration. We love to have a nice code coverage!
