# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementSensitivityLabelsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sensitivity_labels_list_current_by_database(self, resource_group):
        response = self.client.sensitivity_labels.list_current_by_database(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sensitivity_labels_update(self, resource_group):
        response = self.client.sensitivity_labels.update(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            parameters={
                "operations": [
                    {
                        "column": "str",
                        "id": "str",
                        "name": "str",
                        "op": "str",
                        "schema": "str",
                        "sensitivityLabel": {
                            "clientClassificationSource": "str",
                            "columnName": "str",
                            "id": "str",
                            "informationType": "str",
                            "informationTypeId": "str",
                            "isDisabled": bool,
                            "labelId": "str",
                            "labelName": "str",
                            "managedBy": "str",
                            "name": "str",
                            "rank": "str",
                            "schemaName": "str",
                            "tableName": "str",
                            "type": "str",
                        },
                        "table": "str",
                        "type": "str",
                    }
                ]
            },
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sensitivity_labels_list_recommended_by_database(self, resource_group):
        response = self.client.sensitivity_labels.list_recommended_by_database(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sensitivity_labels_get(self, resource_group):
        response = self.client.sensitivity_labels.get(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            schema_name="str",
            table_name="str",
            column_name="str",
            sensitivity_label_source="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sensitivity_labels_create_or_update(self, resource_group):
        response = self.client.sensitivity_labels.create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            schema_name="str",
            table_name="str",
            column_name="str",
            parameters={
                "clientClassificationSource": "str",
                "columnName": "str",
                "id": "str",
                "informationType": "str",
                "informationTypeId": "str",
                "isDisabled": bool,
                "labelId": "str",
                "labelName": "str",
                "managedBy": "str",
                "name": "str",
                "rank": "str",
                "schemaName": "str",
                "tableName": "str",
                "type": "str",
            },
            sensitivity_label_source="current",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sensitivity_labels_delete(self, resource_group):
        response = self.client.sensitivity_labels.delete(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            schema_name="str",
            table_name="str",
            column_name="str",
            sensitivity_label_source="current",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sensitivity_labels_disable_recommendation(self, resource_group):
        response = self.client.sensitivity_labels.disable_recommendation(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            schema_name="str",
            table_name="str",
            column_name="str",
            sensitivity_label_source="recommended",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sensitivity_labels_enable_recommendation(self, resource_group):
        response = self.client.sensitivity_labels.enable_recommendation(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            schema_name="str",
            table_name="str",
            column_name="str",
            sensitivity_label_source="recommended",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sensitivity_labels_list_by_database(self, resource_group):
        response = self.client.sensitivity_labels.list_by_database(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
