/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.util;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JSplitPaneWithZeroSizeDivider
extends JSplitPane {
    private static final int DIVIDER_DRAG_OFFSET = 4;

    public JSplitPaneWithZeroSizeDivider(int i) {
        super(i);
        this.setDividerSize(1);
        this.setContinuousLayout(true);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        Rectangle bounds = divider.getBounds();
        int dividerDragSize = 9;
        if (this.orientation == 1) {
            bounds.x -= 4;
            bounds.width = dividerDragSize;
        } else {
            bounds.y -= 4;
            bounds.height = dividerDragSize;
        }
        divider.setBounds(bounds);
    }

    @Override
    public void updateUI() {
        this.setUI(new SplitPaneWithZeroSizeDividerUI());
        this.revalidate();
    }

    private static class SplitPaneWithZeroSizeDividerUI
    extends BasicSplitPaneUI {
        private SplitPaneWithZeroSizeDividerUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new ZeroSizeDivider(this);
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            if (this.splitPane.getComponent(0) != this.divider) {
                this.splitPane.setLeftComponent(this.splitPane.getLeftComponent());
                this.splitPane.setRightComponent(this.splitPane.getRightComponent());
            }
        }
    }

    private static class ZeroSizeDivider
    extends BasicSplitPaneDivider {
        public ZeroSizeDivider(BasicSplitPaneUI ui) {
            super(ui);
            super.setBorder(null);
            this.setBackground(UIManager.getColor("controlShadow"));
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            if (this.orientation == 1) {
                g.drawLine(4, 0, 4, this.getHeight() - 1);
            } else {
                g.drawLine(0, 4, this.getWidth() - 1, 4);
            }
        }

        @Override
        protected void dragDividerTo(int location) {
            super.dragDividerTo(location + 4);
        }

        @Override
        protected void finishDraggingTo(int location) {
            super.finishDraggingTo(location + 4);
        }
    }
}

