// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalizeruntime

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opGetActionRecommendations = "GetActionRecommendations"

// GetActionRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the GetActionRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetActionRecommendations for more information on using the GetActionRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetActionRecommendationsRequest method.
//	req, resp := client.GetActionRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetActionRecommendations
func (c *PersonalizeRuntime) GetActionRecommendationsRequest(input *GetActionRecommendationsInput) (req *request.Request, output *GetActionRecommendationsOutput) {
	op := &request.Operation{
		Name:       opGetActionRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/action-recommendations",
	}

	if input == nil {
		input = &GetActionRecommendationsInput{}
	}

	output = &GetActionRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetActionRecommendations API operation for Amazon Personalize Runtime.
//
// Returns a list of recommended actions in sorted in descending order by prediction
// score. Use the GetActionRecommendations API if you have a custom campaign
// that deploys a solution version trained with a PERSONALIZED_ACTIONS recipe.
//
// For more information about PERSONALIZED_ACTIONS recipes, see PERSONALIZED_ACTIONS
// recipes (https://docs.aws.amazon.com/personalize/latest/dg/nexts-best-action-recipes.html).
// For more information about getting action recommendations, see Getting action
// recommendations (https://docs.aws.amazon.com/personalize/latest/dg/get-action-recommendations.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize Runtime's
// API operation GetActionRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetActionRecommendations
func (c *PersonalizeRuntime) GetActionRecommendations(input *GetActionRecommendationsInput) (*GetActionRecommendationsOutput, error) {
	req, out := c.GetActionRecommendationsRequest(input)
	return out, req.Send()
}

// GetActionRecommendationsWithContext is the same as GetActionRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See GetActionRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PersonalizeRuntime) GetActionRecommendationsWithContext(ctx aws.Context, input *GetActionRecommendationsInput, opts ...request.Option) (*GetActionRecommendationsOutput, error) {
	req, out := c.GetActionRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPersonalizedRanking = "GetPersonalizedRanking"

// GetPersonalizedRankingRequest generates a "aws/request.Request" representing the
// client's request for the GetPersonalizedRanking operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPersonalizedRanking for more information on using the GetPersonalizedRanking
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPersonalizedRankingRequest method.
//	req, resp := client.GetPersonalizedRankingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetPersonalizedRanking
func (c *PersonalizeRuntime) GetPersonalizedRankingRequest(input *GetPersonalizedRankingInput) (req *request.Request, output *GetPersonalizedRankingOutput) {
	op := &request.Operation{
		Name:       opGetPersonalizedRanking,
		HTTPMethod: "POST",
		HTTPPath:   "/personalize-ranking",
	}

	if input == nil {
		input = &GetPersonalizedRankingInput{}
	}

	output = &GetPersonalizedRankingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPersonalizedRanking API operation for Amazon Personalize Runtime.
//
// Re-ranks a list of recommended items for the given user. The first item in
// the list is deemed the most likely item to be of interest to the user.
//
// The solution backing the campaign must have been created using a recipe of
// type PERSONALIZED_RANKING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize Runtime's
// API operation GetPersonalizedRanking for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetPersonalizedRanking
func (c *PersonalizeRuntime) GetPersonalizedRanking(input *GetPersonalizedRankingInput) (*GetPersonalizedRankingOutput, error) {
	req, out := c.GetPersonalizedRankingRequest(input)
	return out, req.Send()
}

// GetPersonalizedRankingWithContext is the same as GetPersonalizedRanking with the addition of
// the ability to pass a context and additional request options.
//
// See GetPersonalizedRanking for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PersonalizeRuntime) GetPersonalizedRankingWithContext(ctx aws.Context, input *GetPersonalizedRankingInput, opts ...request.Option) (*GetPersonalizedRankingOutput, error) {
	req, out := c.GetPersonalizedRankingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecommendations = "GetRecommendations"

// GetRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the GetRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecommendations for more information on using the GetRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecommendationsRequest method.
//	req, resp := client.GetRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetRecommendations
func (c *PersonalizeRuntime) GetRecommendationsRequest(input *GetRecommendationsInput) (req *request.Request, output *GetRecommendationsOutput) {
	op := &request.Operation{
		Name:       opGetRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/recommendations",
	}

	if input == nil {
		input = &GetRecommendationsInput{}
	}

	output = &GetRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecommendations API operation for Amazon Personalize Runtime.
//
// Returns a list of recommended items. For campaigns, the campaign's Amazon
// Resource Name (ARN) is required and the required user and item input depends
// on the recipe type used to create the solution backing the campaign as follows:
//
//   - USER_PERSONALIZATION - userId required, itemId not used
//
//   - RELATED_ITEMS - itemId required, userId not used
//
// Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING
// use the API.
//
// For recommenders, the recommender's ARN is required and the required item
// and user input depends on the use case (domain-based recipe) backing the
// recommender. For information on use case requirements see Choosing recommender
// use cases (https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Personalize Runtime's
// API operation GetRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     Provide a valid value for the field or parameter.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetRecommendations
func (c *PersonalizeRuntime) GetRecommendations(input *GetRecommendationsInput) (*GetRecommendationsOutput, error) {
	req, out := c.GetRecommendationsRequest(input)
	return out, req.Send()
}

// GetRecommendationsWithContext is the same as GetRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PersonalizeRuntime) GetRecommendationsWithContext(ctx aws.Context, input *GetRecommendationsInput, opts ...request.Option) (*GetRecommendationsOutput, error) {
	req, out := c.GetRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type GetActionRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign to use for getting action
	// recommendations. This campaign must deploy a solution version trained with
	// a PERSONALIZED_ACTIONS recipe.
	CampaignArn *string `locationName:"campaignArn" type:"string"`

	// The ARN of the filter to apply to the returned recommendations. For more
	// information, see Filtering Recommendations (https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
	//
	// When using this parameter, be sure the filter resource is ACTIVE.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The values to use when filtering recommendations. For each placeholder parameter
	// in your filter expression, provide the parameter name (in matching case)
	// as a key and the filter value(s) as the corresponding value. Separate multiple
	// values for one parameter with a comma.
	//
	// For filter expressions that use an INCLUDE element to include actions, you
	// must provide values for all parameters that are defined in the expression.
	// For filters with expressions that use an EXCLUDE element to exclude actions,
	// you can omit the filter-values. In this case, Amazon Personalize doesn't
	// use that portion of the expression to filter recommendations.
	//
	// For more information, see Filtering recommendations and user segments (https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
	FilterValues map[string]*string `locationName:"filterValues" type:"map"`

	// The number of results to return. The default is 5. The maximum is 100.
	NumResults *int64 `locationName:"numResults" type:"integer"`

	// The user ID of the user to provide action recommendations for.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionRecommendationsInput) GoString() string {
	return s.String()
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *GetActionRecommendationsInput) SetCampaignArn(v string) *GetActionRecommendationsInput {
	s.CampaignArn = &v
	return s
}

// SetFilterArn sets the FilterArn field's value.
func (s *GetActionRecommendationsInput) SetFilterArn(v string) *GetActionRecommendationsInput {
	s.FilterArn = &v
	return s
}

// SetFilterValues sets the FilterValues field's value.
func (s *GetActionRecommendationsInput) SetFilterValues(v map[string]*string) *GetActionRecommendationsInput {
	s.FilterValues = v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *GetActionRecommendationsInput) SetNumResults(v int64) *GetActionRecommendationsInput {
	s.NumResults = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetActionRecommendationsInput) SetUserId(v string) *GetActionRecommendationsInput {
	s.UserId = &v
	return s
}

type GetActionRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of action recommendations sorted in descending order by prediction
	// score. There can be a maximum of 100 actions in the list. For information
	// about action scores, see How action recommendation scoring works (https://docs.aws.amazon.com/personalize/latest/dg/how-action-recommendation-scoring-works.html).
	ActionList []*PredictedAction `locationName:"actionList" type:"list"`

	// The ID of the recommendation.
	RecommendationId *string `locationName:"recommendationId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetActionRecommendationsOutput) GoString() string {
	return s.String()
}

// SetActionList sets the ActionList field's value.
func (s *GetActionRecommendationsOutput) SetActionList(v []*PredictedAction) *GetActionRecommendationsOutput {
	s.ActionList = v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *GetActionRecommendationsOutput) SetRecommendationId(v string) *GetActionRecommendationsOutput {
	s.RecommendationId = &v
	return s
}

type GetPersonalizedRankingInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign to use for generating the
	// personalized ranking.
	//
	// CampaignArn is a required field
	CampaignArn *string `locationName:"campaignArn" type:"string" required:"true"`

	// The contextual metadata to use when getting recommendations. Contextual metadata
	// includes any interaction information that might be relevant when getting
	// a user's recommendations, such as the user's current location or device type.
	Context map[string]*string `locationName:"context" type:"map"`

	// The Amazon Resource Name (ARN) of a filter you created to include items or
	// exclude items from recommendations for a given user. For more information,
	// see Filtering Recommendations (https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The values to use when filtering recommendations. For each placeholder parameter
	// in your filter expression, provide the parameter name (in matching case)
	// as a key and the filter value(s) as the corresponding value. Separate multiple
	// values for one parameter with a comma.
	//
	// For filter expressions that use an INCLUDE element to include items, you
	// must provide values for all parameters that are defined in the expression.
	// For filters with expressions that use an EXCLUDE element to exclude items,
	// you can omit the filter-values.In this case, Amazon Personalize doesn't use
	// that portion of the expression to filter recommendations.
	//
	// For more information, see Filtering Recommendations (https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
	FilterValues map[string]*string `locationName:"filterValues" type:"map"`

	// A list of items (by itemId) to rank. If an item was not included in the training
	// dataset, the item is appended to the end of the reranked list. If you are
	// including metadata in recommendations, the maximum is 50. Otherwise, the
	// maximum is 500.
	//
	// InputList is a required field
	InputList []*string `locationName:"inputList" type:"list" required:"true"`

	// If you enabled metadata in recommendations when you created or updated the
	// campaign, specify metadata columns from your Items dataset to include in
	// the personalized ranking. The map key is ITEMS and the value is a list of
	// column names from your Items dataset. The maximum number of columns you can
	// provide is 10.
	//
	// For information about enabling metadata for a campaign, see Enabling metadata
	// in recommendations for a campaign (https://docs.aws.amazon.com/personalize/latest/dg/create-campaign-return-metadata.html).
	MetadataColumns map[string][]*string `locationName:"metadataColumns" type:"map"`

	// The user for which you want the campaign to provide a personalized ranking.
	//
	// UserId is a required field
	UserId *string `locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPersonalizedRankingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPersonalizedRankingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPersonalizedRankingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPersonalizedRankingInput"}
	if s.CampaignArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignArn"))
	}
	if s.InputList == nil {
		invalidParams.Add(request.NewErrParamRequired("InputList"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *GetPersonalizedRankingInput) SetCampaignArn(v string) *GetPersonalizedRankingInput {
	s.CampaignArn = &v
	return s
}

// SetContext sets the Context field's value.
func (s *GetPersonalizedRankingInput) SetContext(v map[string]*string) *GetPersonalizedRankingInput {
	s.Context = v
	return s
}

// SetFilterArn sets the FilterArn field's value.
func (s *GetPersonalizedRankingInput) SetFilterArn(v string) *GetPersonalizedRankingInput {
	s.FilterArn = &v
	return s
}

// SetFilterValues sets the FilterValues field's value.
func (s *GetPersonalizedRankingInput) SetFilterValues(v map[string]*string) *GetPersonalizedRankingInput {
	s.FilterValues = v
	return s
}

// SetInputList sets the InputList field's value.
func (s *GetPersonalizedRankingInput) SetInputList(v []*string) *GetPersonalizedRankingInput {
	s.InputList = v
	return s
}

// SetMetadataColumns sets the MetadataColumns field's value.
func (s *GetPersonalizedRankingInput) SetMetadataColumns(v map[string][]*string) *GetPersonalizedRankingInput {
	s.MetadataColumns = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetPersonalizedRankingInput) SetUserId(v string) *GetPersonalizedRankingInput {
	s.UserId = &v
	return s
}

type GetPersonalizedRankingOutput struct {
	_ struct{} `type:"structure"`

	// A list of items in order of most likely interest to the user. The maximum
	// is 500.
	PersonalizedRanking []*PredictedItem `locationName:"personalizedRanking" type:"list"`

	// The ID of the recommendation.
	RecommendationId *string `locationName:"recommendationId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPersonalizedRankingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPersonalizedRankingOutput) GoString() string {
	return s.String()
}

// SetPersonalizedRanking sets the PersonalizedRanking field's value.
func (s *GetPersonalizedRankingOutput) SetPersonalizedRanking(v []*PredictedItem) *GetPersonalizedRankingOutput {
	s.PersonalizedRanking = v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *GetPersonalizedRankingOutput) SetRecommendationId(v string) *GetPersonalizedRankingOutput {
	s.RecommendationId = &v
	return s
}

type GetRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
	CampaignArn *string `locationName:"campaignArn" type:"string"`

	// The contextual metadata to use when getting recommendations. Contextual metadata
	// includes any interaction information that might be relevant when getting
	// a user's recommendations, such as the user's current location or device type.
	Context map[string]*string `locationName:"context" type:"map"`

	// The ARN of the filter to apply to the returned recommendations. For more
	// information, see Filtering Recommendations (https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
	//
	// When using this parameter, be sure the filter resource is ACTIVE.
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The values to use when filtering recommendations. For each placeholder parameter
	// in your filter expression, provide the parameter name (in matching case)
	// as a key and the filter value(s) as the corresponding value. Separate multiple
	// values for one parameter with a comma.
	//
	// For filter expressions that use an INCLUDE element to include items, you
	// must provide values for all parameters that are defined in the expression.
	// For filters with expressions that use an EXCLUDE element to exclude items,
	// you can omit the filter-values.In this case, Amazon Personalize doesn't use
	// that portion of the expression to filter recommendations.
	//
	// For more information, see Filtering recommendations and user segments (https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
	FilterValues map[string]*string `locationName:"filterValues" type:"map"`

	// The item ID to provide recommendations for.
	//
	// Required for RELATED_ITEMS recipe type.
	ItemId *string `locationName:"itemId" type:"string"`

	// If you enabled metadata in recommendations when you created or updated the
	// campaign or recommender, specify the metadata columns from your Items dataset
	// to include in item recommendations. The map key is ITEMS and the value is
	// a list of column names from your Items dataset. The maximum number of columns
	// you can provide is 10.
	//
	// For information about enabling metadata for a campaign, see Enabling metadata
	// in recommendations for a campaign (https://docs.aws.amazon.com/personalize/latest/dg/create-campaign-return-metadata.html).
	// For information about enabling metadata for a recommender, see Enabling metadata
	// in recommendations for a recommender (https://docs.aws.amazon.com/personalize/latest/dg/create-recommender-return-metadata.html).
	MetadataColumns map[string][]*string `locationName:"metadataColumns" type:"map"`

	// The number of results to return. The default is 25. If you are including
	// metadata in recommendations, the maximum is 50. Otherwise, the maximum is
	// 500.
	NumResults *int64 `locationName:"numResults" type:"integer"`

	// The promotions to apply to the recommendation request. A promotion defines
	// additional business rules that apply to a configurable subset of recommended
	// items.
	Promotions []*Promotion `locationName:"promotions" type:"list"`

	// The Amazon Resource Name (ARN) of the recommender to use to get recommendations.
	// Provide a recommender ARN if you created a Domain dataset group with a recommender
	// for a domain use case.
	RecommenderArn *string `locationName:"recommenderArn" type:"string"`

	// The user ID to provide recommendations for.
	//
	// Required for USER_PERSONALIZATION recipe type.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecommendationsInput"}
	if s.Promotions != nil {
		for i, v := range s.Promotions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Promotions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignArn sets the CampaignArn field's value.
func (s *GetRecommendationsInput) SetCampaignArn(v string) *GetRecommendationsInput {
	s.CampaignArn = &v
	return s
}

// SetContext sets the Context field's value.
func (s *GetRecommendationsInput) SetContext(v map[string]*string) *GetRecommendationsInput {
	s.Context = v
	return s
}

// SetFilterArn sets the FilterArn field's value.
func (s *GetRecommendationsInput) SetFilterArn(v string) *GetRecommendationsInput {
	s.FilterArn = &v
	return s
}

// SetFilterValues sets the FilterValues field's value.
func (s *GetRecommendationsInput) SetFilterValues(v map[string]*string) *GetRecommendationsInput {
	s.FilterValues = v
	return s
}

// SetItemId sets the ItemId field's value.
func (s *GetRecommendationsInput) SetItemId(v string) *GetRecommendationsInput {
	s.ItemId = &v
	return s
}

// SetMetadataColumns sets the MetadataColumns field's value.
func (s *GetRecommendationsInput) SetMetadataColumns(v map[string][]*string) *GetRecommendationsInput {
	s.MetadataColumns = v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *GetRecommendationsInput) SetNumResults(v int64) *GetRecommendationsInput {
	s.NumResults = &v
	return s
}

// SetPromotions sets the Promotions field's value.
func (s *GetRecommendationsInput) SetPromotions(v []*Promotion) *GetRecommendationsInput {
	s.Promotions = v
	return s
}

// SetRecommenderArn sets the RecommenderArn field's value.
func (s *GetRecommendationsInput) SetRecommenderArn(v string) *GetRecommendationsInput {
	s.RecommenderArn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetRecommendationsInput) SetUserId(v string) *GetRecommendationsInput {
	s.UserId = &v
	return s
}

type GetRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of recommendations sorted in descending order by prediction score.
	// There can be a maximum of 500 items in the list.
	ItemList []*PredictedItem `locationName:"itemList" type:"list"`

	// The ID of the recommendation.
	RecommendationId *string `locationName:"recommendationId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationsOutput) GoString() string {
	return s.String()
}

// SetItemList sets the ItemList field's value.
func (s *GetRecommendationsOutput) SetItemList(v []*PredictedItem) *GetRecommendationsOutput {
	s.ItemList = v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *GetRecommendationsOutput) SetRecommendationId(v string) *GetRecommendationsOutput {
	s.RecommendationId = &v
	return s
}

// Provide a valid value for the field or parameter.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that identifies an action.
//
// The API returns a list of PredictedActions.
type PredictedAction struct {
	_ struct{} `type:"structure"`

	// The ID of the recommended action.
	ActionId *string `locationName:"actionId" type:"string"`

	// The score of the recommended action. For information about action scores,
	// see How action recommendation scoring works (https://docs.aws.amazon.com/personalize/latest/dg/how-action-recommendation-scoring-works.html).
	Score *float64 `locationName:"score" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictedAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictedAction) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *PredictedAction) SetActionId(v string) *PredictedAction {
	s.ActionId = &v
	return s
}

// SetScore sets the Score field's value.
func (s *PredictedAction) SetScore(v float64) *PredictedAction {
	s.Score = &v
	return s
}

// An object that identifies an item.
//
// The and APIs return a list of PredictedItems.
type PredictedItem struct {
	_ struct{} `type:"structure"`

	// The recommended item ID.
	ItemId *string `locationName:"itemId" type:"string"`

	// Metadata about the item from your Items dataset.
	Metadata map[string]*string `locationName:"metadata" type:"map"`

	// The name of the promotion that included the predicted item.
	PromotionName *string `locationName:"promotionName" min:"1" type:"string"`

	// A numeric representation of the model's certainty that the item will be the
	// next user selection. For more information on scoring logic, see how-scores-work.
	Score *float64 `locationName:"score" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictedItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictedItem) GoString() string {
	return s.String()
}

// SetItemId sets the ItemId field's value.
func (s *PredictedItem) SetItemId(v string) *PredictedItem {
	s.ItemId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *PredictedItem) SetMetadata(v map[string]*string) *PredictedItem {
	s.Metadata = v
	return s
}

// SetPromotionName sets the PromotionName field's value.
func (s *PredictedItem) SetPromotionName(v string) *PredictedItem {
	s.PromotionName = &v
	return s
}

// SetScore sets the Score field's value.
func (s *PredictedItem) SetScore(v float64) *PredictedItem {
	s.Score = &v
	return s
}

// Contains information on a promotion. A promotion defines additional business
// rules that apply to a configurable subset of recommended items.
type Promotion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the filter used by the promotion. This
	// filter defines the criteria for promoted items. For more information, see
	// Promotion filters (https://docs.aws.amazon.com/personalize/latest/dg/promoting-items.html#promotion-filters).
	FilterArn *string `locationName:"filterArn" type:"string"`

	// The values to use when promoting items. For each placeholder parameter in
	// your promotion's filter expression, provide the parameter name (in matching
	// case) as a key and the filter value(s) as the corresponding value. Separate
	// multiple values for one parameter with a comma.
	//
	// For filter expressions that use an INCLUDE element to include items, you
	// must provide values for all parameters that are defined in the expression.
	// For filters with expressions that use an EXCLUDE element to exclude items,
	// you can omit the filter-values. In this case, Amazon Personalize doesn't
	// use that portion of the expression to filter recommendations.
	//
	// For more information on creating filters, see Filtering recommendations and
	// user segments (https://docs.aws.amazon.com/personalize/latest/dg/filter.html).
	FilterValues map[string]*string `locationName:"filterValues" type:"map"`

	// The name of the promotion.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The percentage of recommended items to apply the promotion to.
	PercentPromotedItems *int64 `locationName:"percentPromotedItems" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Promotion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Promotion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Promotion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Promotion"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PercentPromotedItems != nil && *s.PercentPromotedItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PercentPromotedItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterArn sets the FilterArn field's value.
func (s *Promotion) SetFilterArn(v string) *Promotion {
	s.FilterArn = &v
	return s
}

// SetFilterValues sets the FilterValues field's value.
func (s *Promotion) SetFilterValues(v map[string]*string) *Promotion {
	s.FilterValues = v
	return s
}

// SetName sets the Name field's value.
func (s *Promotion) SetName(v string) *Promotion {
	s.Name = &v
	return s
}

// SetPercentPromotedItems sets the PercentPromotedItems field's value.
func (s *Promotion) SetPercentPromotedItems(v int64) *Promotion {
	s.PercentPromotedItems = &v
	return s
}

// The specified resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}
