// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package finspace

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironment for more information on using the CreateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentRequest method.
//	req, resp := client.CreateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateEnvironment
//
// Deprecated: This method will be discontinued.
func (c *Finspace) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *CreateEnvironmentOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateEnvironment, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/environment",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	output = &CreateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironment API operation for FinSpace User Environment Management service.
//
// Create a new FinSpace environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation CreateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota. To perform the requested action, remove
//     some of the relevant resources, or use Service Quotas to request a service
//     quota increase.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateEnvironment
//
// Deprecated: This method will be discontinued.
func (c *Finspace) CreateEnvironment(input *CreateEnvironmentInput) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	return out, req.Send()
}

// CreateEnvironmentWithContext is the same as CreateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This method will be discontinued.
func (c *Finspace) CreateEnvironmentWithContext(ctx aws.Context, input *CreateEnvironmentInput, opts ...request.Option) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKxChangeset = "CreateKxChangeset"

// CreateKxChangesetRequest generates a "aws/request.Request" representing the
// client's request for the CreateKxChangeset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKxChangeset for more information on using the CreateKxChangeset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKxChangesetRequest method.
//	req, resp := client.CreateKxChangesetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxChangeset
func (c *Finspace) CreateKxChangesetRequest(input *CreateKxChangesetInput) (req *request.Request, output *CreateKxChangesetOutput) {
	op := &request.Operation{
		Name:       opCreateKxChangeset,
		HTTPMethod: "POST",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}/changesets",
	}

	if input == nil {
		input = &CreateKxChangesetInput{}
	}

	output = &CreateKxChangesetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKxChangeset API operation for FinSpace User Environment Management service.
//
// Creates a changeset for a kdb database. A changeset allows you to add and
// delete existing files by using an ordered list of change requests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation CreateKxChangeset for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxChangeset
func (c *Finspace) CreateKxChangeset(input *CreateKxChangesetInput) (*CreateKxChangesetOutput, error) {
	req, out := c.CreateKxChangesetRequest(input)
	return out, req.Send()
}

// CreateKxChangesetWithContext is the same as CreateKxChangeset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKxChangeset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) CreateKxChangesetWithContext(ctx aws.Context, input *CreateKxChangesetInput, opts ...request.Option) (*CreateKxChangesetOutput, error) {
	req, out := c.CreateKxChangesetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKxCluster = "CreateKxCluster"

// CreateKxClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateKxCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKxCluster for more information on using the CreateKxCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKxClusterRequest method.
//	req, resp := client.CreateKxClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxCluster
func (c *Finspace) CreateKxClusterRequest(input *CreateKxClusterInput) (req *request.Request, output *CreateKxClusterOutput) {
	op := &request.Operation{
		Name:       opCreateKxCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/kx/environments/{environmentId}/clusters",
	}

	if input == nil {
		input = &CreateKxClusterInput{}
	}

	output = &CreateKxClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKxCluster API operation for FinSpace User Environment Management service.
//
// Creates a new kdb cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation CreateKxCluster for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxCluster
func (c *Finspace) CreateKxCluster(input *CreateKxClusterInput) (*CreateKxClusterOutput, error) {
	req, out := c.CreateKxClusterRequest(input)
	return out, req.Send()
}

// CreateKxClusterWithContext is the same as CreateKxCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKxCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) CreateKxClusterWithContext(ctx aws.Context, input *CreateKxClusterInput, opts ...request.Option) (*CreateKxClusterOutput, error) {
	req, out := c.CreateKxClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKxDatabase = "CreateKxDatabase"

// CreateKxDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateKxDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKxDatabase for more information on using the CreateKxDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKxDatabaseRequest method.
//	req, resp := client.CreateKxDatabaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxDatabase
func (c *Finspace) CreateKxDatabaseRequest(input *CreateKxDatabaseInput) (req *request.Request, output *CreateKxDatabaseOutput) {
	op := &request.Operation{
		Name:       opCreateKxDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/kx/environments/{environmentId}/databases",
	}

	if input == nil {
		input = &CreateKxDatabaseInput{}
	}

	output = &CreateKxDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKxDatabase API operation for FinSpace User Environment Management service.
//
// Creates a new kdb database in the environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation CreateKxDatabase for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceAlreadyExistsException
//     The specified resource group already exists.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxDatabase
func (c *Finspace) CreateKxDatabase(input *CreateKxDatabaseInput) (*CreateKxDatabaseOutput, error) {
	req, out := c.CreateKxDatabaseRequest(input)
	return out, req.Send()
}

// CreateKxDatabaseWithContext is the same as CreateKxDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKxDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) CreateKxDatabaseWithContext(ctx aws.Context, input *CreateKxDatabaseInput, opts ...request.Option) (*CreateKxDatabaseOutput, error) {
	req, out := c.CreateKxDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKxDataview = "CreateKxDataview"

// CreateKxDataviewRequest generates a "aws/request.Request" representing the
// client's request for the CreateKxDataview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKxDataview for more information on using the CreateKxDataview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKxDataviewRequest method.
//	req, resp := client.CreateKxDataviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxDataview
func (c *Finspace) CreateKxDataviewRequest(input *CreateKxDataviewInput) (req *request.Request, output *CreateKxDataviewOutput) {
	op := &request.Operation{
		Name:       opCreateKxDataview,
		HTTPMethod: "POST",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}/dataviews",
	}

	if input == nil {
		input = &CreateKxDataviewInput{}
	}

	output = &CreateKxDataviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKxDataview API operation for FinSpace User Environment Management service.
//
// Creates a snapshot of kdb database with tiered storage capabilities and a
// pre-warmed cache, ready for mounting on kdb clusters. Dataviews are only
// available for clusters running on a scaling group. They are not supported
// on dedicated clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation CreateKxDataview for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ResourceAlreadyExistsException
//     The specified resource group already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxDataview
func (c *Finspace) CreateKxDataview(input *CreateKxDataviewInput) (*CreateKxDataviewOutput, error) {
	req, out := c.CreateKxDataviewRequest(input)
	return out, req.Send()
}

// CreateKxDataviewWithContext is the same as CreateKxDataview with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKxDataview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) CreateKxDataviewWithContext(ctx aws.Context, input *CreateKxDataviewInput, opts ...request.Option) (*CreateKxDataviewOutput, error) {
	req, out := c.CreateKxDataviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKxEnvironment = "CreateKxEnvironment"

// CreateKxEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateKxEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKxEnvironment for more information on using the CreateKxEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKxEnvironmentRequest method.
//	req, resp := client.CreateKxEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxEnvironment
func (c *Finspace) CreateKxEnvironmentRequest(input *CreateKxEnvironmentInput) (req *request.Request, output *CreateKxEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateKxEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/kx/environments",
	}

	if input == nil {
		input = &CreateKxEnvironmentInput{}
	}

	output = &CreateKxEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKxEnvironment API operation for FinSpace User Environment Management service.
//
// Creates a managed kdb environment for the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation CreateKxEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota. To perform the requested action, remove
//     some of the relevant resources, or use Service Quotas to request a service
//     quota increase.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxEnvironment
func (c *Finspace) CreateKxEnvironment(input *CreateKxEnvironmentInput) (*CreateKxEnvironmentOutput, error) {
	req, out := c.CreateKxEnvironmentRequest(input)
	return out, req.Send()
}

// CreateKxEnvironmentWithContext is the same as CreateKxEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKxEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) CreateKxEnvironmentWithContext(ctx aws.Context, input *CreateKxEnvironmentInput, opts ...request.Option) (*CreateKxEnvironmentOutput, error) {
	req, out := c.CreateKxEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKxScalingGroup = "CreateKxScalingGroup"

// CreateKxScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateKxScalingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKxScalingGroup for more information on using the CreateKxScalingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKxScalingGroupRequest method.
//	req, resp := client.CreateKxScalingGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxScalingGroup
func (c *Finspace) CreateKxScalingGroupRequest(input *CreateKxScalingGroupInput) (req *request.Request, output *CreateKxScalingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateKxScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/kx/environments/{environmentId}/scalingGroups",
	}

	if input == nil {
		input = &CreateKxScalingGroupInput{}
	}

	output = &CreateKxScalingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKxScalingGroup API operation for FinSpace User Environment Management service.
//
// Creates a new scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation CreateKxScalingGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxScalingGroup
func (c *Finspace) CreateKxScalingGroup(input *CreateKxScalingGroupInput) (*CreateKxScalingGroupOutput, error) {
	req, out := c.CreateKxScalingGroupRequest(input)
	return out, req.Send()
}

// CreateKxScalingGroupWithContext is the same as CreateKxScalingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKxScalingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) CreateKxScalingGroupWithContext(ctx aws.Context, input *CreateKxScalingGroupInput, opts ...request.Option) (*CreateKxScalingGroupOutput, error) {
	req, out := c.CreateKxScalingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKxUser = "CreateKxUser"

// CreateKxUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateKxUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKxUser for more information on using the CreateKxUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKxUserRequest method.
//	req, resp := client.CreateKxUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxUser
func (c *Finspace) CreateKxUserRequest(input *CreateKxUserInput) (req *request.Request, output *CreateKxUserOutput) {
	op := &request.Operation{
		Name:       opCreateKxUser,
		HTTPMethod: "POST",
		HTTPPath:   "/kx/environments/{environmentId}/users",
	}

	if input == nil {
		input = &CreateKxUserInput{}
	}

	output = &CreateKxUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKxUser API operation for FinSpace User Environment Management service.
//
// Creates a user in FinSpace kdb environment with an associated IAM role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation CreateKxUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceAlreadyExistsException
//     The specified resource group already exists.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxUser
func (c *Finspace) CreateKxUser(input *CreateKxUserInput) (*CreateKxUserOutput, error) {
	req, out := c.CreateKxUserRequest(input)
	return out, req.Send()
}

// CreateKxUserWithContext is the same as CreateKxUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKxUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) CreateKxUserWithContext(ctx aws.Context, input *CreateKxUserInput, opts ...request.Option) (*CreateKxUserOutput, error) {
	req, out := c.CreateKxUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKxVolume = "CreateKxVolume"

// CreateKxVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateKxVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKxVolume for more information on using the CreateKxVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKxVolumeRequest method.
//	req, resp := client.CreateKxVolumeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxVolume
func (c *Finspace) CreateKxVolumeRequest(input *CreateKxVolumeInput) (req *request.Request, output *CreateKxVolumeOutput) {
	op := &request.Operation{
		Name:       opCreateKxVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/kx/environments/{environmentId}/kxvolumes",
	}

	if input == nil {
		input = &CreateKxVolumeInput{}
	}

	output = &CreateKxVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKxVolume API operation for FinSpace User Environment Management service.
//
// Creates a new volume with a specific amount of throughput and storage capacity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation CreateKxVolume for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ResourceAlreadyExistsException
//     The specified resource group already exists.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxVolume
func (c *Finspace) CreateKxVolume(input *CreateKxVolumeInput) (*CreateKxVolumeOutput, error) {
	req, out := c.CreateKxVolumeRequest(input)
	return out, req.Send()
}

// CreateKxVolumeWithContext is the same as CreateKxVolume with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKxVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) CreateKxVolumeWithContext(ctx aws.Context, input *CreateKxVolumeInput, opts ...request.Option) (*CreateKxVolumeOutput, error) {
	req, out := c.CreateKxVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironment for more information on using the DeleteEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentRequest method.
//	req, resp := client.DeleteEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteEnvironment
//
// Deprecated: This method will be discontinued.
func (c *Finspace) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) (req *request.Request, output *DeleteEnvironmentOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteEnvironment, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/environment/{environmentId}",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	output = &DeleteEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEnvironment API operation for FinSpace User Environment Management service.
//
// Delete an FinSpace environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation DeleteEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteEnvironment
//
// Deprecated: This method will be discontinued.
func (c *Finspace) DeleteEnvironment(input *DeleteEnvironmentInput) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentWithContext is the same as DeleteEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This method will be discontinued.
func (c *Finspace) DeleteEnvironmentWithContext(ctx aws.Context, input *DeleteEnvironmentInput, opts ...request.Option) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKxCluster = "DeleteKxCluster"

// DeleteKxClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKxCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKxCluster for more information on using the DeleteKxCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKxClusterRequest method.
//	req, resp := client.DeleteKxClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxCluster
func (c *Finspace) DeleteKxClusterRequest(input *DeleteKxClusterInput) (req *request.Request, output *DeleteKxClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteKxCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/kx/environments/{environmentId}/clusters/{clusterName}",
	}

	if input == nil {
		input = &DeleteKxClusterInput{}
	}

	output = &DeleteKxClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKxCluster API operation for FinSpace User Environment Management service.
//
// Deletes a kdb cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation DeleteKxCluster for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxCluster
func (c *Finspace) DeleteKxCluster(input *DeleteKxClusterInput) (*DeleteKxClusterOutput, error) {
	req, out := c.DeleteKxClusterRequest(input)
	return out, req.Send()
}

// DeleteKxClusterWithContext is the same as DeleteKxCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKxCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) DeleteKxClusterWithContext(ctx aws.Context, input *DeleteKxClusterInput, opts ...request.Option) (*DeleteKxClusterOutput, error) {
	req, out := c.DeleteKxClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKxDatabase = "DeleteKxDatabase"

// DeleteKxDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKxDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKxDatabase for more information on using the DeleteKxDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKxDatabaseRequest method.
//	req, resp := client.DeleteKxDatabaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxDatabase
func (c *Finspace) DeleteKxDatabaseRequest(input *DeleteKxDatabaseInput) (req *request.Request, output *DeleteKxDatabaseOutput) {
	op := &request.Operation{
		Name:       opDeleteKxDatabase,
		HTTPMethod: "DELETE",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}",
	}

	if input == nil {
		input = &DeleteKxDatabaseInput{}
	}

	output = &DeleteKxDatabaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKxDatabase API operation for FinSpace User Environment Management service.
//
// Deletes the specified database and all of its associated data. This action
// is irreversible. You must copy any data out of the database before deleting
// it if the data is to be retained.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation DeleteKxDatabase for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxDatabase
func (c *Finspace) DeleteKxDatabase(input *DeleteKxDatabaseInput) (*DeleteKxDatabaseOutput, error) {
	req, out := c.DeleteKxDatabaseRequest(input)
	return out, req.Send()
}

// DeleteKxDatabaseWithContext is the same as DeleteKxDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKxDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) DeleteKxDatabaseWithContext(ctx aws.Context, input *DeleteKxDatabaseInput, opts ...request.Option) (*DeleteKxDatabaseOutput, error) {
	req, out := c.DeleteKxDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKxDataview = "DeleteKxDataview"

// DeleteKxDataviewRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKxDataview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKxDataview for more information on using the DeleteKxDataview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKxDataviewRequest method.
//	req, resp := client.DeleteKxDataviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxDataview
func (c *Finspace) DeleteKxDataviewRequest(input *DeleteKxDataviewInput) (req *request.Request, output *DeleteKxDataviewOutput) {
	op := &request.Operation{
		Name:       opDeleteKxDataview,
		HTTPMethod: "DELETE",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}/dataviews/{dataviewName}",
	}

	if input == nil {
		input = &DeleteKxDataviewInput{}
	}

	output = &DeleteKxDataviewOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKxDataview API operation for FinSpace User Environment Management service.
//
// Deletes the specified dataview. Before deleting a dataview, make sure that
// it is not in use by any cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation DeleteKxDataview for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxDataview
func (c *Finspace) DeleteKxDataview(input *DeleteKxDataviewInput) (*DeleteKxDataviewOutput, error) {
	req, out := c.DeleteKxDataviewRequest(input)
	return out, req.Send()
}

// DeleteKxDataviewWithContext is the same as DeleteKxDataview with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKxDataview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) DeleteKxDataviewWithContext(ctx aws.Context, input *DeleteKxDataviewInput, opts ...request.Option) (*DeleteKxDataviewOutput, error) {
	req, out := c.DeleteKxDataviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKxEnvironment = "DeleteKxEnvironment"

// DeleteKxEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKxEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKxEnvironment for more information on using the DeleteKxEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKxEnvironmentRequest method.
//	req, resp := client.DeleteKxEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxEnvironment
func (c *Finspace) DeleteKxEnvironmentRequest(input *DeleteKxEnvironmentInput) (req *request.Request, output *DeleteKxEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteKxEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/kx/environments/{environmentId}",
	}

	if input == nil {
		input = &DeleteKxEnvironmentInput{}
	}

	output = &DeleteKxEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKxEnvironment API operation for FinSpace User Environment Management service.
//
// Deletes the kdb environment. This action is irreversible. Deleting a kdb
// environment will remove all the associated data and any services running
// in it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation DeleteKxEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxEnvironment
func (c *Finspace) DeleteKxEnvironment(input *DeleteKxEnvironmentInput) (*DeleteKxEnvironmentOutput, error) {
	req, out := c.DeleteKxEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteKxEnvironmentWithContext is the same as DeleteKxEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKxEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) DeleteKxEnvironmentWithContext(ctx aws.Context, input *DeleteKxEnvironmentInput, opts ...request.Option) (*DeleteKxEnvironmentOutput, error) {
	req, out := c.DeleteKxEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKxScalingGroup = "DeleteKxScalingGroup"

// DeleteKxScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKxScalingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKxScalingGroup for more information on using the DeleteKxScalingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKxScalingGroupRequest method.
//	req, resp := client.DeleteKxScalingGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxScalingGroup
func (c *Finspace) DeleteKxScalingGroupRequest(input *DeleteKxScalingGroupInput) (req *request.Request, output *DeleteKxScalingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteKxScalingGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/kx/environments/{environmentId}/scalingGroups/{scalingGroupName}",
	}

	if input == nil {
		input = &DeleteKxScalingGroupInput{}
	}

	output = &DeleteKxScalingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKxScalingGroup API operation for FinSpace User Environment Management service.
//
// Deletes the specified scaling group. This action is irreversible. You cannot
// delete a scaling group until all the clusters running on it have been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation DeleteKxScalingGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxScalingGroup
func (c *Finspace) DeleteKxScalingGroup(input *DeleteKxScalingGroupInput) (*DeleteKxScalingGroupOutput, error) {
	req, out := c.DeleteKxScalingGroupRequest(input)
	return out, req.Send()
}

// DeleteKxScalingGroupWithContext is the same as DeleteKxScalingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKxScalingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) DeleteKxScalingGroupWithContext(ctx aws.Context, input *DeleteKxScalingGroupInput, opts ...request.Option) (*DeleteKxScalingGroupOutput, error) {
	req, out := c.DeleteKxScalingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKxUser = "DeleteKxUser"

// DeleteKxUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKxUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKxUser for more information on using the DeleteKxUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKxUserRequest method.
//	req, resp := client.DeleteKxUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxUser
func (c *Finspace) DeleteKxUserRequest(input *DeleteKxUserInput) (req *request.Request, output *DeleteKxUserOutput) {
	op := &request.Operation{
		Name:       opDeleteKxUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/kx/environments/{environmentId}/users/{userName}",
	}

	if input == nil {
		input = &DeleteKxUserInput{}
	}

	output = &DeleteKxUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKxUser API operation for FinSpace User Environment Management service.
//
// Deletes a user in the specified kdb environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation DeleteKxUser for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxUser
func (c *Finspace) DeleteKxUser(input *DeleteKxUserInput) (*DeleteKxUserOutput, error) {
	req, out := c.DeleteKxUserRequest(input)
	return out, req.Send()
}

// DeleteKxUserWithContext is the same as DeleteKxUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKxUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) DeleteKxUserWithContext(ctx aws.Context, input *DeleteKxUserInput, opts ...request.Option) (*DeleteKxUserOutput, error) {
	req, out := c.DeleteKxUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKxVolume = "DeleteKxVolume"

// DeleteKxVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKxVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKxVolume for more information on using the DeleteKxVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKxVolumeRequest method.
//	req, resp := client.DeleteKxVolumeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxVolume
func (c *Finspace) DeleteKxVolumeRequest(input *DeleteKxVolumeInput) (req *request.Request, output *DeleteKxVolumeOutput) {
	op := &request.Operation{
		Name:       opDeleteKxVolume,
		HTTPMethod: "DELETE",
		HTTPPath:   "/kx/environments/{environmentId}/kxvolumes/{volumeName}",
	}

	if input == nil {
		input = &DeleteKxVolumeInput{}
	}

	output = &DeleteKxVolumeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKxVolume API operation for FinSpace User Environment Management service.
//
// Deletes a volume. You can only delete a volume if it's not attached to a
// cluster or a dataview. When a volume is deleted, any data on the volume is
// lost. This action is irreversible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation DeleteKxVolume for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxVolume
func (c *Finspace) DeleteKxVolume(input *DeleteKxVolumeInput) (*DeleteKxVolumeOutput, error) {
	req, out := c.DeleteKxVolumeRequest(input)
	return out, req.Send()
}

// DeleteKxVolumeWithContext is the same as DeleteKxVolume with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKxVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) DeleteKxVolumeWithContext(ctx aws.Context, input *DeleteKxVolumeInput, opts ...request.Option) (*DeleteKxVolumeOutput, error) {
	req, out := c.DeleteKxVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironment = "GetEnvironment"

// GetEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironment for more information on using the GetEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentRequest method.
//	req, resp := client.GetEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetEnvironment
//
// Deprecated: This method will be discontinued.
func (c *Finspace) GetEnvironmentRequest(input *GetEnvironmentInput) (req *request.Request, output *GetEnvironmentOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetEnvironment, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetEnvironment,
		HTTPMethod: "GET",
		HTTPPath:   "/environment/{environmentId}",
	}

	if input == nil {
		input = &GetEnvironmentInput{}
	}

	output = &GetEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironment API operation for FinSpace User Environment Management service.
//
// Returns the FinSpace environment object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetEnvironment
//
// Deprecated: This method will be discontinued.
func (c *Finspace) GetEnvironment(input *GetEnvironmentInput) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	return out, req.Send()
}

// GetEnvironmentWithContext is the same as GetEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This method will be discontinued.
func (c *Finspace) GetEnvironmentWithContext(ctx aws.Context, input *GetEnvironmentInput, opts ...request.Option) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKxChangeset = "GetKxChangeset"

// GetKxChangesetRequest generates a "aws/request.Request" representing the
// client's request for the GetKxChangeset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKxChangeset for more information on using the GetKxChangeset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKxChangesetRequest method.
//	req, resp := client.GetKxChangesetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxChangeset
func (c *Finspace) GetKxChangesetRequest(input *GetKxChangesetInput) (req *request.Request, output *GetKxChangesetOutput) {
	op := &request.Operation{
		Name:       opGetKxChangeset,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}/changesets/{changesetId}",
	}

	if input == nil {
		input = &GetKxChangesetInput{}
	}

	output = &GetKxChangesetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKxChangeset API operation for FinSpace User Environment Management service.
//
// Returns information about a kdb changeset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetKxChangeset for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxChangeset
func (c *Finspace) GetKxChangeset(input *GetKxChangesetInput) (*GetKxChangesetOutput, error) {
	req, out := c.GetKxChangesetRequest(input)
	return out, req.Send()
}

// GetKxChangesetWithContext is the same as GetKxChangeset with the addition of
// the ability to pass a context and additional request options.
//
// See GetKxChangeset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) GetKxChangesetWithContext(ctx aws.Context, input *GetKxChangesetInput, opts ...request.Option) (*GetKxChangesetOutput, error) {
	req, out := c.GetKxChangesetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKxCluster = "GetKxCluster"

// GetKxClusterRequest generates a "aws/request.Request" representing the
// client's request for the GetKxCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKxCluster for more information on using the GetKxCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKxClusterRequest method.
//	req, resp := client.GetKxClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxCluster
func (c *Finspace) GetKxClusterRequest(input *GetKxClusterInput) (req *request.Request, output *GetKxClusterOutput) {
	op := &request.Operation{
		Name:       opGetKxCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/clusters/{clusterName}",
	}

	if input == nil {
		input = &GetKxClusterInput{}
	}

	output = &GetKxClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKxCluster API operation for FinSpace User Environment Management service.
//
// Retrieves information about a kdb cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetKxCluster for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxCluster
func (c *Finspace) GetKxCluster(input *GetKxClusterInput) (*GetKxClusterOutput, error) {
	req, out := c.GetKxClusterRequest(input)
	return out, req.Send()
}

// GetKxClusterWithContext is the same as GetKxCluster with the addition of
// the ability to pass a context and additional request options.
//
// See GetKxCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) GetKxClusterWithContext(ctx aws.Context, input *GetKxClusterInput, opts ...request.Option) (*GetKxClusterOutput, error) {
	req, out := c.GetKxClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKxConnectionString = "GetKxConnectionString"

// GetKxConnectionStringRequest generates a "aws/request.Request" representing the
// client's request for the GetKxConnectionString operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKxConnectionString for more information on using the GetKxConnectionString
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKxConnectionStringRequest method.
//	req, resp := client.GetKxConnectionStringRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxConnectionString
func (c *Finspace) GetKxConnectionStringRequest(input *GetKxConnectionStringInput) (req *request.Request, output *GetKxConnectionStringOutput) {
	op := &request.Operation{
		Name:       opGetKxConnectionString,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/connectionString",
	}

	if input == nil {
		input = &GetKxConnectionStringInput{}
	}

	output = &GetKxConnectionStringOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKxConnectionString API operation for FinSpace User Environment Management service.
//
// Retrieves a connection string for a user to connect to a kdb cluster. You
// must call this API using the same role that you have defined while creating
// a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetKxConnectionString for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxConnectionString
func (c *Finspace) GetKxConnectionString(input *GetKxConnectionStringInput) (*GetKxConnectionStringOutput, error) {
	req, out := c.GetKxConnectionStringRequest(input)
	return out, req.Send()
}

// GetKxConnectionStringWithContext is the same as GetKxConnectionString with the addition of
// the ability to pass a context and additional request options.
//
// See GetKxConnectionString for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) GetKxConnectionStringWithContext(ctx aws.Context, input *GetKxConnectionStringInput, opts ...request.Option) (*GetKxConnectionStringOutput, error) {
	req, out := c.GetKxConnectionStringRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKxDatabase = "GetKxDatabase"

// GetKxDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the GetKxDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKxDatabase for more information on using the GetKxDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKxDatabaseRequest method.
//	req, resp := client.GetKxDatabaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxDatabase
func (c *Finspace) GetKxDatabaseRequest(input *GetKxDatabaseInput) (req *request.Request, output *GetKxDatabaseOutput) {
	op := &request.Operation{
		Name:       opGetKxDatabase,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}",
	}

	if input == nil {
		input = &GetKxDatabaseInput{}
	}

	output = &GetKxDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKxDatabase API operation for FinSpace User Environment Management service.
//
// Returns database information for the specified environment ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetKxDatabase for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxDatabase
func (c *Finspace) GetKxDatabase(input *GetKxDatabaseInput) (*GetKxDatabaseOutput, error) {
	req, out := c.GetKxDatabaseRequest(input)
	return out, req.Send()
}

// GetKxDatabaseWithContext is the same as GetKxDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See GetKxDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) GetKxDatabaseWithContext(ctx aws.Context, input *GetKxDatabaseInput, opts ...request.Option) (*GetKxDatabaseOutput, error) {
	req, out := c.GetKxDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKxDataview = "GetKxDataview"

// GetKxDataviewRequest generates a "aws/request.Request" representing the
// client's request for the GetKxDataview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKxDataview for more information on using the GetKxDataview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKxDataviewRequest method.
//	req, resp := client.GetKxDataviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxDataview
func (c *Finspace) GetKxDataviewRequest(input *GetKxDataviewInput) (req *request.Request, output *GetKxDataviewOutput) {
	op := &request.Operation{
		Name:       opGetKxDataview,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}/dataviews/{dataviewName}",
	}

	if input == nil {
		input = &GetKxDataviewInput{}
	}

	output = &GetKxDataviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKxDataview API operation for FinSpace User Environment Management service.
//
// Retrieves details of the dataview.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetKxDataview for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxDataview
func (c *Finspace) GetKxDataview(input *GetKxDataviewInput) (*GetKxDataviewOutput, error) {
	req, out := c.GetKxDataviewRequest(input)
	return out, req.Send()
}

// GetKxDataviewWithContext is the same as GetKxDataview with the addition of
// the ability to pass a context and additional request options.
//
// See GetKxDataview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) GetKxDataviewWithContext(ctx aws.Context, input *GetKxDataviewInput, opts ...request.Option) (*GetKxDataviewOutput, error) {
	req, out := c.GetKxDataviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKxEnvironment = "GetKxEnvironment"

// GetKxEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetKxEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKxEnvironment for more information on using the GetKxEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKxEnvironmentRequest method.
//	req, resp := client.GetKxEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxEnvironment
func (c *Finspace) GetKxEnvironmentRequest(input *GetKxEnvironmentInput) (req *request.Request, output *GetKxEnvironmentOutput) {
	op := &request.Operation{
		Name:       opGetKxEnvironment,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}",
	}

	if input == nil {
		input = &GetKxEnvironmentInput{}
	}

	output = &GetKxEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKxEnvironment API operation for FinSpace User Environment Management service.
//
// Retrieves all the information for the specified kdb environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetKxEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxEnvironment
func (c *Finspace) GetKxEnvironment(input *GetKxEnvironmentInput) (*GetKxEnvironmentOutput, error) {
	req, out := c.GetKxEnvironmentRequest(input)
	return out, req.Send()
}

// GetKxEnvironmentWithContext is the same as GetKxEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetKxEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) GetKxEnvironmentWithContext(ctx aws.Context, input *GetKxEnvironmentInput, opts ...request.Option) (*GetKxEnvironmentOutput, error) {
	req, out := c.GetKxEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKxScalingGroup = "GetKxScalingGroup"

// GetKxScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetKxScalingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKxScalingGroup for more information on using the GetKxScalingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKxScalingGroupRequest method.
//	req, resp := client.GetKxScalingGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxScalingGroup
func (c *Finspace) GetKxScalingGroupRequest(input *GetKxScalingGroupInput) (req *request.Request, output *GetKxScalingGroupOutput) {
	op := &request.Operation{
		Name:       opGetKxScalingGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/scalingGroups/{scalingGroupName}",
	}

	if input == nil {
		input = &GetKxScalingGroupInput{}
	}

	output = &GetKxScalingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKxScalingGroup API operation for FinSpace User Environment Management service.
//
// Retrieves details of a scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetKxScalingGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxScalingGroup
func (c *Finspace) GetKxScalingGroup(input *GetKxScalingGroupInput) (*GetKxScalingGroupOutput, error) {
	req, out := c.GetKxScalingGroupRequest(input)
	return out, req.Send()
}

// GetKxScalingGroupWithContext is the same as GetKxScalingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetKxScalingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) GetKxScalingGroupWithContext(ctx aws.Context, input *GetKxScalingGroupInput, opts ...request.Option) (*GetKxScalingGroupOutput, error) {
	req, out := c.GetKxScalingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKxUser = "GetKxUser"

// GetKxUserRequest generates a "aws/request.Request" representing the
// client's request for the GetKxUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKxUser for more information on using the GetKxUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKxUserRequest method.
//	req, resp := client.GetKxUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxUser
func (c *Finspace) GetKxUserRequest(input *GetKxUserInput) (req *request.Request, output *GetKxUserOutput) {
	op := &request.Operation{
		Name:       opGetKxUser,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/users/{userName}",
	}

	if input == nil {
		input = &GetKxUserInput{}
	}

	output = &GetKxUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKxUser API operation for FinSpace User Environment Management service.
//
// Retrieves information about the specified kdb user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetKxUser for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxUser
func (c *Finspace) GetKxUser(input *GetKxUserInput) (*GetKxUserOutput, error) {
	req, out := c.GetKxUserRequest(input)
	return out, req.Send()
}

// GetKxUserWithContext is the same as GetKxUser with the addition of
// the ability to pass a context and additional request options.
//
// See GetKxUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) GetKxUserWithContext(ctx aws.Context, input *GetKxUserInput, opts ...request.Option) (*GetKxUserOutput, error) {
	req, out := c.GetKxUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKxVolume = "GetKxVolume"

// GetKxVolumeRequest generates a "aws/request.Request" representing the
// client's request for the GetKxVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKxVolume for more information on using the GetKxVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKxVolumeRequest method.
//	req, resp := client.GetKxVolumeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxVolume
func (c *Finspace) GetKxVolumeRequest(input *GetKxVolumeInput) (req *request.Request, output *GetKxVolumeOutput) {
	op := &request.Operation{
		Name:       opGetKxVolume,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/kxvolumes/{volumeName}",
	}

	if input == nil {
		input = &GetKxVolumeInput{}
	}

	output = &GetKxVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKxVolume API operation for FinSpace User Environment Management service.
//
// Retrieves the information about the volume.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation GetKxVolume for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxVolume
func (c *Finspace) GetKxVolume(input *GetKxVolumeInput) (*GetKxVolumeOutput, error) {
	req, out := c.GetKxVolumeRequest(input)
	return out, req.Send()
}

// GetKxVolumeWithContext is the same as GetKxVolume with the addition of
// the ability to pass a context and additional request options.
//
// See GetKxVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) GetKxVolumeWithContext(ctx aws.Context, input *GetKxVolumeInput, opts ...request.Option) (*GetKxVolumeOutput, error) {
	req, out := c.GetKxVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironments for more information on using the ListEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentsRequest method.
//	req, resp := client.ListEnvironmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListEnvironments
//
// Deprecated: This method will be discontinued.
func (c *Finspace) ListEnvironmentsRequest(input *ListEnvironmentsInput) (req *request.Request, output *ListEnvironmentsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListEnvironments, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "GET",
		HTTPPath:   "/environment",
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	output = &ListEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironments API operation for FinSpace User Environment Management service.
//
// A list of all of your FinSpace environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListEnvironments for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListEnvironments
//
// Deprecated: This method will be discontinued.
func (c *Finspace) ListEnvironments(input *ListEnvironmentsInput) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	return out, req.Send()
}

// ListEnvironmentsWithContext is the same as ListEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This method will be discontinued.
func (c *Finspace) ListEnvironmentsWithContext(ctx aws.Context, input *ListEnvironmentsInput, opts ...request.Option) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListKxChangesets = "ListKxChangesets"

// ListKxChangesetsRequest generates a "aws/request.Request" representing the
// client's request for the ListKxChangesets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKxChangesets for more information on using the ListKxChangesets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKxChangesetsRequest method.
//	req, resp := client.ListKxChangesetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxChangesets
func (c *Finspace) ListKxChangesetsRequest(input *ListKxChangesetsInput) (req *request.Request, output *ListKxChangesetsOutput) {
	op := &request.Operation{
		Name:       opListKxChangesets,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}/changesets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKxChangesetsInput{}
	}

	output = &ListKxChangesetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKxChangesets API operation for FinSpace User Environment Management service.
//
// Returns a list of all the changesets for a database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListKxChangesets for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxChangesets
func (c *Finspace) ListKxChangesets(input *ListKxChangesetsInput) (*ListKxChangesetsOutput, error) {
	req, out := c.ListKxChangesetsRequest(input)
	return out, req.Send()
}

// ListKxChangesetsWithContext is the same as ListKxChangesets with the addition of
// the ability to pass a context and additional request options.
//
// See ListKxChangesets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxChangesetsWithContext(ctx aws.Context, input *ListKxChangesetsInput, opts ...request.Option) (*ListKxChangesetsOutput, error) {
	req, out := c.ListKxChangesetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKxChangesetsPages iterates over the pages of a ListKxChangesets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKxChangesets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKxChangesets operation.
//	pageNum := 0
//	err := client.ListKxChangesetsPages(params,
//	    func(page *finspace.ListKxChangesetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Finspace) ListKxChangesetsPages(input *ListKxChangesetsInput, fn func(*ListKxChangesetsOutput, bool) bool) error {
	return c.ListKxChangesetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKxChangesetsPagesWithContext same as ListKxChangesetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxChangesetsPagesWithContext(ctx aws.Context, input *ListKxChangesetsInput, fn func(*ListKxChangesetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKxChangesetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKxChangesetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKxChangesetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKxClusterNodes = "ListKxClusterNodes"

// ListKxClusterNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListKxClusterNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKxClusterNodes for more information on using the ListKxClusterNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKxClusterNodesRequest method.
//	req, resp := client.ListKxClusterNodesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusterNodes
func (c *Finspace) ListKxClusterNodesRequest(input *ListKxClusterNodesInput) (req *request.Request, output *ListKxClusterNodesOutput) {
	op := &request.Operation{
		Name:       opListKxClusterNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/clusters/{clusterName}/nodes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKxClusterNodesInput{}
	}

	output = &ListKxClusterNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKxClusterNodes API operation for FinSpace User Environment Management service.
//
// Lists all the nodes in a kdb cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListKxClusterNodes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusterNodes
func (c *Finspace) ListKxClusterNodes(input *ListKxClusterNodesInput) (*ListKxClusterNodesOutput, error) {
	req, out := c.ListKxClusterNodesRequest(input)
	return out, req.Send()
}

// ListKxClusterNodesWithContext is the same as ListKxClusterNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListKxClusterNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxClusterNodesWithContext(ctx aws.Context, input *ListKxClusterNodesInput, opts ...request.Option) (*ListKxClusterNodesOutput, error) {
	req, out := c.ListKxClusterNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKxClusterNodesPages iterates over the pages of a ListKxClusterNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKxClusterNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKxClusterNodes operation.
//	pageNum := 0
//	err := client.ListKxClusterNodesPages(params,
//	    func(page *finspace.ListKxClusterNodesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Finspace) ListKxClusterNodesPages(input *ListKxClusterNodesInput, fn func(*ListKxClusterNodesOutput, bool) bool) error {
	return c.ListKxClusterNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKxClusterNodesPagesWithContext same as ListKxClusterNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxClusterNodesPagesWithContext(ctx aws.Context, input *ListKxClusterNodesInput, fn func(*ListKxClusterNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKxClusterNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKxClusterNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKxClusterNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKxClusters = "ListKxClusters"

// ListKxClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListKxClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKxClusters for more information on using the ListKxClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKxClustersRequest method.
//	req, resp := client.ListKxClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusters
func (c *Finspace) ListKxClustersRequest(input *ListKxClustersInput) (req *request.Request, output *ListKxClustersOutput) {
	op := &request.Operation{
		Name:       opListKxClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/clusters",
	}

	if input == nil {
		input = &ListKxClustersInput{}
	}

	output = &ListKxClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKxClusters API operation for FinSpace User Environment Management service.
//
// Returns a list of clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListKxClusters for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusters
func (c *Finspace) ListKxClusters(input *ListKxClustersInput) (*ListKxClustersOutput, error) {
	req, out := c.ListKxClustersRequest(input)
	return out, req.Send()
}

// ListKxClustersWithContext is the same as ListKxClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListKxClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxClustersWithContext(ctx aws.Context, input *ListKxClustersInput, opts ...request.Option) (*ListKxClustersOutput, error) {
	req, out := c.ListKxClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListKxDatabases = "ListKxDatabases"

// ListKxDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the ListKxDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKxDatabases for more information on using the ListKxDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKxDatabasesRequest method.
//	req, resp := client.ListKxDatabasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDatabases
func (c *Finspace) ListKxDatabasesRequest(input *ListKxDatabasesInput) (req *request.Request, output *ListKxDatabasesOutput) {
	op := &request.Operation{
		Name:       opListKxDatabases,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/databases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKxDatabasesInput{}
	}

	output = &ListKxDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKxDatabases API operation for FinSpace User Environment Management service.
//
// Returns a list of all the databases in the kdb environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListKxDatabases for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDatabases
func (c *Finspace) ListKxDatabases(input *ListKxDatabasesInput) (*ListKxDatabasesOutput, error) {
	req, out := c.ListKxDatabasesRequest(input)
	return out, req.Send()
}

// ListKxDatabasesWithContext is the same as ListKxDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See ListKxDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxDatabasesWithContext(ctx aws.Context, input *ListKxDatabasesInput, opts ...request.Option) (*ListKxDatabasesOutput, error) {
	req, out := c.ListKxDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKxDatabasesPages iterates over the pages of a ListKxDatabases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKxDatabases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKxDatabases operation.
//	pageNum := 0
//	err := client.ListKxDatabasesPages(params,
//	    func(page *finspace.ListKxDatabasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Finspace) ListKxDatabasesPages(input *ListKxDatabasesInput, fn func(*ListKxDatabasesOutput, bool) bool) error {
	return c.ListKxDatabasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKxDatabasesPagesWithContext same as ListKxDatabasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxDatabasesPagesWithContext(ctx aws.Context, input *ListKxDatabasesInput, fn func(*ListKxDatabasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKxDatabasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKxDatabasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKxDatabasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKxDataviews = "ListKxDataviews"

// ListKxDataviewsRequest generates a "aws/request.Request" representing the
// client's request for the ListKxDataviews operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKxDataviews for more information on using the ListKxDataviews
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKxDataviewsRequest method.
//	req, resp := client.ListKxDataviewsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDataviews
func (c *Finspace) ListKxDataviewsRequest(input *ListKxDataviewsInput) (req *request.Request, output *ListKxDataviewsOutput) {
	op := &request.Operation{
		Name:       opListKxDataviews,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}/dataviews",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKxDataviewsInput{}
	}

	output = &ListKxDataviewsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKxDataviews API operation for FinSpace User Environment Management service.
//
// Returns a list of all the dataviews in the database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListKxDataviews for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDataviews
func (c *Finspace) ListKxDataviews(input *ListKxDataviewsInput) (*ListKxDataviewsOutput, error) {
	req, out := c.ListKxDataviewsRequest(input)
	return out, req.Send()
}

// ListKxDataviewsWithContext is the same as ListKxDataviews with the addition of
// the ability to pass a context and additional request options.
//
// See ListKxDataviews for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxDataviewsWithContext(ctx aws.Context, input *ListKxDataviewsInput, opts ...request.Option) (*ListKxDataviewsOutput, error) {
	req, out := c.ListKxDataviewsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKxDataviewsPages iterates over the pages of a ListKxDataviews operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKxDataviews method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKxDataviews operation.
//	pageNum := 0
//	err := client.ListKxDataviewsPages(params,
//	    func(page *finspace.ListKxDataviewsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Finspace) ListKxDataviewsPages(input *ListKxDataviewsInput, fn func(*ListKxDataviewsOutput, bool) bool) error {
	return c.ListKxDataviewsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKxDataviewsPagesWithContext same as ListKxDataviewsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxDataviewsPagesWithContext(ctx aws.Context, input *ListKxDataviewsInput, fn func(*ListKxDataviewsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKxDataviewsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKxDataviewsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKxDataviewsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKxEnvironments = "ListKxEnvironments"

// ListKxEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListKxEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKxEnvironments for more information on using the ListKxEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKxEnvironmentsRequest method.
//	req, resp := client.ListKxEnvironmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxEnvironments
func (c *Finspace) ListKxEnvironmentsRequest(input *ListKxEnvironmentsInput) (req *request.Request, output *ListKxEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListKxEnvironments,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKxEnvironmentsInput{}
	}

	output = &ListKxEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKxEnvironments API operation for FinSpace User Environment Management service.
//
// Returns a list of kdb environments created in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListKxEnvironments for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxEnvironments
func (c *Finspace) ListKxEnvironments(input *ListKxEnvironmentsInput) (*ListKxEnvironmentsOutput, error) {
	req, out := c.ListKxEnvironmentsRequest(input)
	return out, req.Send()
}

// ListKxEnvironmentsWithContext is the same as ListKxEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListKxEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxEnvironmentsWithContext(ctx aws.Context, input *ListKxEnvironmentsInput, opts ...request.Option) (*ListKxEnvironmentsOutput, error) {
	req, out := c.ListKxEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKxEnvironmentsPages iterates over the pages of a ListKxEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKxEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKxEnvironments operation.
//	pageNum := 0
//	err := client.ListKxEnvironmentsPages(params,
//	    func(page *finspace.ListKxEnvironmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Finspace) ListKxEnvironmentsPages(input *ListKxEnvironmentsInput, fn func(*ListKxEnvironmentsOutput, bool) bool) error {
	return c.ListKxEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKxEnvironmentsPagesWithContext same as ListKxEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxEnvironmentsPagesWithContext(ctx aws.Context, input *ListKxEnvironmentsInput, fn func(*ListKxEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKxEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKxEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKxEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKxScalingGroups = "ListKxScalingGroups"

// ListKxScalingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListKxScalingGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKxScalingGroups for more information on using the ListKxScalingGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKxScalingGroupsRequest method.
//	req, resp := client.ListKxScalingGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxScalingGroups
func (c *Finspace) ListKxScalingGroupsRequest(input *ListKxScalingGroupsInput) (req *request.Request, output *ListKxScalingGroupsOutput) {
	op := &request.Operation{
		Name:       opListKxScalingGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/scalingGroups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKxScalingGroupsInput{}
	}

	output = &ListKxScalingGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKxScalingGroups API operation for FinSpace User Environment Management service.
//
// Returns a list of scaling groups in a kdb environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListKxScalingGroups for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxScalingGroups
func (c *Finspace) ListKxScalingGroups(input *ListKxScalingGroupsInput) (*ListKxScalingGroupsOutput, error) {
	req, out := c.ListKxScalingGroupsRequest(input)
	return out, req.Send()
}

// ListKxScalingGroupsWithContext is the same as ListKxScalingGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListKxScalingGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxScalingGroupsWithContext(ctx aws.Context, input *ListKxScalingGroupsInput, opts ...request.Option) (*ListKxScalingGroupsOutput, error) {
	req, out := c.ListKxScalingGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKxScalingGroupsPages iterates over the pages of a ListKxScalingGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKxScalingGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKxScalingGroups operation.
//	pageNum := 0
//	err := client.ListKxScalingGroupsPages(params,
//	    func(page *finspace.ListKxScalingGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Finspace) ListKxScalingGroupsPages(input *ListKxScalingGroupsInput, fn func(*ListKxScalingGroupsOutput, bool) bool) error {
	return c.ListKxScalingGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKxScalingGroupsPagesWithContext same as ListKxScalingGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxScalingGroupsPagesWithContext(ctx aws.Context, input *ListKxScalingGroupsInput, fn func(*ListKxScalingGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKxScalingGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKxScalingGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKxScalingGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKxUsers = "ListKxUsers"

// ListKxUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListKxUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKxUsers for more information on using the ListKxUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKxUsersRequest method.
//	req, resp := client.ListKxUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxUsers
func (c *Finspace) ListKxUsersRequest(input *ListKxUsersInput) (req *request.Request, output *ListKxUsersOutput) {
	op := &request.Operation{
		Name:       opListKxUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/users",
	}

	if input == nil {
		input = &ListKxUsersInput{}
	}

	output = &ListKxUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKxUsers API operation for FinSpace User Environment Management service.
//
// Lists all the users in a kdb environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListKxUsers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxUsers
func (c *Finspace) ListKxUsers(input *ListKxUsersInput) (*ListKxUsersOutput, error) {
	req, out := c.ListKxUsersRequest(input)
	return out, req.Send()
}

// ListKxUsersWithContext is the same as ListKxUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListKxUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxUsersWithContext(ctx aws.Context, input *ListKxUsersInput, opts ...request.Option) (*ListKxUsersOutput, error) {
	req, out := c.ListKxUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListKxVolumes = "ListKxVolumes"

// ListKxVolumesRequest generates a "aws/request.Request" representing the
// client's request for the ListKxVolumes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKxVolumes for more information on using the ListKxVolumes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKxVolumesRequest method.
//	req, resp := client.ListKxVolumesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxVolumes
func (c *Finspace) ListKxVolumesRequest(input *ListKxVolumesInput) (req *request.Request, output *ListKxVolumesOutput) {
	op := &request.Operation{
		Name:       opListKxVolumes,
		HTTPMethod: "GET",
		HTTPPath:   "/kx/environments/{environmentId}/kxvolumes",
	}

	if input == nil {
		input = &ListKxVolumesInput{}
	}

	output = &ListKxVolumesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKxVolumes API operation for FinSpace User Environment Management service.
//
// Lists all the volumes in a kdb environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListKxVolumes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxVolumes
func (c *Finspace) ListKxVolumes(input *ListKxVolumesInput) (*ListKxVolumesOutput, error) {
	req, out := c.ListKxVolumesRequest(input)
	return out, req.Send()
}

// ListKxVolumesWithContext is the same as ListKxVolumes with the addition of
// the ability to pass a context and additional request options.
//
// See ListKxVolumes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListKxVolumesWithContext(ctx aws.Context, input *ListKxVolumesInput, opts ...request.Option) (*ListKxVolumesOutput, error) {
	req, out := c.ListKxVolumesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListTagsForResource
func (c *Finspace) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for FinSpace User Environment Management service.
//
// A list of all tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - InvalidRequestException
//     The request is invalid. Something is wrong with the input to the request.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListTagsForResource
func (c *Finspace) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/TagResource
func (c *Finspace) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for FinSpace User Environment Management service.
//
// Adds metadata tags to a FinSpace resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - InvalidRequestException
//     The request is invalid. Something is wrong with the input to the request.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/TagResource
func (c *Finspace) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UntagResource
func (c *Finspace) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for FinSpace User Environment Management service.
//
// Removes metadata tags from a FinSpace resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - InvalidRequestException
//     The request is invalid. Something is wrong with the input to the request.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UntagResource
func (c *Finspace) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironment for more information on using the UpdateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentRequest method.
//	req, resp := client.UpdateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateEnvironment
//
// Deprecated: This method will be discontinued.
func (c *Finspace) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *UpdateEnvironmentOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateEnvironment, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "PUT",
		HTTPPath:   "/environment/{environmentId}",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	output = &UpdateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironment API operation for FinSpace User Environment Management service.
//
// Update your FinSpace environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UpdateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateEnvironment
//
// Deprecated: This method will be discontinued.
func (c *Finspace) UpdateEnvironment(input *UpdateEnvironmentInput) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentWithContext is the same as UpdateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This method will be discontinued.
func (c *Finspace) UpdateEnvironmentWithContext(ctx aws.Context, input *UpdateEnvironmentInput, opts ...request.Option) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKxClusterCodeConfiguration = "UpdateKxClusterCodeConfiguration"

// UpdateKxClusterCodeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKxClusterCodeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKxClusterCodeConfiguration for more information on using the UpdateKxClusterCodeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKxClusterCodeConfigurationRequest method.
//	req, resp := client.UpdateKxClusterCodeConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxClusterCodeConfiguration
func (c *Finspace) UpdateKxClusterCodeConfigurationRequest(input *UpdateKxClusterCodeConfigurationInput) (req *request.Request, output *UpdateKxClusterCodeConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateKxClusterCodeConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/kx/environments/{environmentId}/clusters/{clusterName}/configuration/code",
	}

	if input == nil {
		input = &UpdateKxClusterCodeConfigurationInput{}
	}

	output = &UpdateKxClusterCodeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateKxClusterCodeConfiguration API operation for FinSpace User Environment Management service.
//
// Allows you to update code configuration on a running cluster. By using this
// API you can update the code, the initialization script path, and the command
// line arguments for a specific cluster. The configuration that you want to
// update will override any existing configurations on the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UpdateKxClusterCodeConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxClusterCodeConfiguration
func (c *Finspace) UpdateKxClusterCodeConfiguration(input *UpdateKxClusterCodeConfigurationInput) (*UpdateKxClusterCodeConfigurationOutput, error) {
	req, out := c.UpdateKxClusterCodeConfigurationRequest(input)
	return out, req.Send()
}

// UpdateKxClusterCodeConfigurationWithContext is the same as UpdateKxClusterCodeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKxClusterCodeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) UpdateKxClusterCodeConfigurationWithContext(ctx aws.Context, input *UpdateKxClusterCodeConfigurationInput, opts ...request.Option) (*UpdateKxClusterCodeConfigurationOutput, error) {
	req, out := c.UpdateKxClusterCodeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKxClusterDatabases = "UpdateKxClusterDatabases"

// UpdateKxClusterDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKxClusterDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKxClusterDatabases for more information on using the UpdateKxClusterDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKxClusterDatabasesRequest method.
//	req, resp := client.UpdateKxClusterDatabasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxClusterDatabases
func (c *Finspace) UpdateKxClusterDatabasesRequest(input *UpdateKxClusterDatabasesInput) (req *request.Request, output *UpdateKxClusterDatabasesOutput) {
	op := &request.Operation{
		Name:       opUpdateKxClusterDatabases,
		HTTPMethod: "PUT",
		HTTPPath:   "/kx/environments/{environmentId}/clusters/{clusterName}/configuration/databases",
	}

	if input == nil {
		input = &UpdateKxClusterDatabasesInput{}
	}

	output = &UpdateKxClusterDatabasesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateKxClusterDatabases API operation for FinSpace User Environment Management service.
//
// Updates the databases mounted on a kdb cluster, which includes the changesetId
// and all the dbPaths to be cached. This API does not allow you to change a
// database name or add a database if you created a cluster without one.
//
// Using this API you can point a cluster to a different changeset and modify
// a list of partitions being cached.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UpdateKxClusterDatabases for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxClusterDatabases
func (c *Finspace) UpdateKxClusterDatabases(input *UpdateKxClusterDatabasesInput) (*UpdateKxClusterDatabasesOutput, error) {
	req, out := c.UpdateKxClusterDatabasesRequest(input)
	return out, req.Send()
}

// UpdateKxClusterDatabasesWithContext is the same as UpdateKxClusterDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKxClusterDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) UpdateKxClusterDatabasesWithContext(ctx aws.Context, input *UpdateKxClusterDatabasesInput, opts ...request.Option) (*UpdateKxClusterDatabasesOutput, error) {
	req, out := c.UpdateKxClusterDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKxDatabase = "UpdateKxDatabase"

// UpdateKxDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKxDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKxDatabase for more information on using the UpdateKxDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKxDatabaseRequest method.
//	req, resp := client.UpdateKxDatabaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxDatabase
func (c *Finspace) UpdateKxDatabaseRequest(input *UpdateKxDatabaseInput) (req *request.Request, output *UpdateKxDatabaseOutput) {
	op := &request.Operation{
		Name:       opUpdateKxDatabase,
		HTTPMethod: "PUT",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}",
	}

	if input == nil {
		input = &UpdateKxDatabaseInput{}
	}

	output = &UpdateKxDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKxDatabase API operation for FinSpace User Environment Management service.
//
// Updates information for the given kdb database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UpdateKxDatabase for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxDatabase
func (c *Finspace) UpdateKxDatabase(input *UpdateKxDatabaseInput) (*UpdateKxDatabaseOutput, error) {
	req, out := c.UpdateKxDatabaseRequest(input)
	return out, req.Send()
}

// UpdateKxDatabaseWithContext is the same as UpdateKxDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKxDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) UpdateKxDatabaseWithContext(ctx aws.Context, input *UpdateKxDatabaseInput, opts ...request.Option) (*UpdateKxDatabaseOutput, error) {
	req, out := c.UpdateKxDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKxDataview = "UpdateKxDataview"

// UpdateKxDataviewRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKxDataview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKxDataview for more information on using the UpdateKxDataview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKxDataviewRequest method.
//	req, resp := client.UpdateKxDataviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxDataview
func (c *Finspace) UpdateKxDataviewRequest(input *UpdateKxDataviewInput) (req *request.Request, output *UpdateKxDataviewOutput) {
	op := &request.Operation{
		Name:       opUpdateKxDataview,
		HTTPMethod: "PUT",
		HTTPPath:   "/kx/environments/{environmentId}/databases/{databaseName}/dataviews/{dataviewName}",
	}

	if input == nil {
		input = &UpdateKxDataviewInput{}
	}

	output = &UpdateKxDataviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKxDataview API operation for FinSpace User Environment Management service.
//
// Updates the specified dataview. The dataviews get automatically updated when
// any new changesets are ingested. Each update of the dataview creates a new
// version, including changeset details and cache configurations
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UpdateKxDataview for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceAlreadyExistsException
//     The specified resource group already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxDataview
func (c *Finspace) UpdateKxDataview(input *UpdateKxDataviewInput) (*UpdateKxDataviewOutput, error) {
	req, out := c.UpdateKxDataviewRequest(input)
	return out, req.Send()
}

// UpdateKxDataviewWithContext is the same as UpdateKxDataview with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKxDataview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) UpdateKxDataviewWithContext(ctx aws.Context, input *UpdateKxDataviewInput, opts ...request.Option) (*UpdateKxDataviewOutput, error) {
	req, out := c.UpdateKxDataviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKxEnvironment = "UpdateKxEnvironment"

// UpdateKxEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKxEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKxEnvironment for more information on using the UpdateKxEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKxEnvironmentRequest method.
//	req, resp := client.UpdateKxEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxEnvironment
func (c *Finspace) UpdateKxEnvironmentRequest(input *UpdateKxEnvironmentInput) (req *request.Request, output *UpdateKxEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateKxEnvironment,
		HTTPMethod: "PUT",
		HTTPPath:   "/kx/environments/{environmentId}",
	}

	if input == nil {
		input = &UpdateKxEnvironmentInput{}
	}

	output = &UpdateKxEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKxEnvironment API operation for FinSpace User Environment Management service.
//
// Updates information for the given kdb environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UpdateKxEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxEnvironment
func (c *Finspace) UpdateKxEnvironment(input *UpdateKxEnvironmentInput) (*UpdateKxEnvironmentOutput, error) {
	req, out := c.UpdateKxEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateKxEnvironmentWithContext is the same as UpdateKxEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKxEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) UpdateKxEnvironmentWithContext(ctx aws.Context, input *UpdateKxEnvironmentInput, opts ...request.Option) (*UpdateKxEnvironmentOutput, error) {
	req, out := c.UpdateKxEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKxEnvironmentNetwork = "UpdateKxEnvironmentNetwork"

// UpdateKxEnvironmentNetworkRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKxEnvironmentNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKxEnvironmentNetwork for more information on using the UpdateKxEnvironmentNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKxEnvironmentNetworkRequest method.
//	req, resp := client.UpdateKxEnvironmentNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxEnvironmentNetwork
func (c *Finspace) UpdateKxEnvironmentNetworkRequest(input *UpdateKxEnvironmentNetworkInput) (req *request.Request, output *UpdateKxEnvironmentNetworkOutput) {
	op := &request.Operation{
		Name:       opUpdateKxEnvironmentNetwork,
		HTTPMethod: "PUT",
		HTTPPath:   "/kx/environments/{environmentId}/network",
	}

	if input == nil {
		input = &UpdateKxEnvironmentNetworkInput{}
	}

	output = &UpdateKxEnvironmentNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKxEnvironmentNetwork API operation for FinSpace User Environment Management service.
//
// Updates environment network to connect to your internal network by using
// a transit gateway. This API supports request to create a transit gateway
// attachment from FinSpace VPC to your transit gateway ID and create a custom
// Route-53 outbound resolvers.
//
// Once you send a request to update a network, you cannot change it again.
// Network update might require termination of any clusters that are running
// in the existing network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UpdateKxEnvironmentNetwork for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxEnvironmentNetwork
func (c *Finspace) UpdateKxEnvironmentNetwork(input *UpdateKxEnvironmentNetworkInput) (*UpdateKxEnvironmentNetworkOutput, error) {
	req, out := c.UpdateKxEnvironmentNetworkRequest(input)
	return out, req.Send()
}

// UpdateKxEnvironmentNetworkWithContext is the same as UpdateKxEnvironmentNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKxEnvironmentNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) UpdateKxEnvironmentNetworkWithContext(ctx aws.Context, input *UpdateKxEnvironmentNetworkInput, opts ...request.Option) (*UpdateKxEnvironmentNetworkOutput, error) {
	req, out := c.UpdateKxEnvironmentNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKxUser = "UpdateKxUser"

// UpdateKxUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKxUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKxUser for more information on using the UpdateKxUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKxUserRequest method.
//	req, resp := client.UpdateKxUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxUser
func (c *Finspace) UpdateKxUserRequest(input *UpdateKxUserInput) (req *request.Request, output *UpdateKxUserOutput) {
	op := &request.Operation{
		Name:       opUpdateKxUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/kx/environments/{environmentId}/users/{userName}",
	}

	if input == nil {
		input = &UpdateKxUserInput{}
	}

	output = &UpdateKxUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKxUser API operation for FinSpace User Environment Management service.
//
// Updates the user details. You can only update the IAM role associated with
// a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UpdateKxUser for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxUser
func (c *Finspace) UpdateKxUser(input *UpdateKxUserInput) (*UpdateKxUserOutput, error) {
	req, out := c.UpdateKxUserRequest(input)
	return out, req.Send()
}

// UpdateKxUserWithContext is the same as UpdateKxUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKxUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) UpdateKxUserWithContext(ctx aws.Context, input *UpdateKxUserInput, opts ...request.Option) (*UpdateKxUserOutput, error) {
	req, out := c.UpdateKxUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKxVolume = "UpdateKxVolume"

// UpdateKxVolumeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKxVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKxVolume for more information on using the UpdateKxVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKxVolumeRequest method.
//	req, resp := client.UpdateKxVolumeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxVolume
func (c *Finspace) UpdateKxVolumeRequest(input *UpdateKxVolumeInput) (req *request.Request, output *UpdateKxVolumeOutput) {
	op := &request.Operation{
		Name:       opUpdateKxVolume,
		HTTPMethod: "PATCH",
		HTTPPath:   "/kx/environments/{environmentId}/kxvolumes/{volumeName}",
	}

	if input == nil {
		input = &UpdateKxVolumeInput{}
	}

	output = &UpdateKxVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKxVolume API operation for FinSpace User Environment Management service.
//
// Updates the throughput or capacity of a volume. During the update process,
// the filesystem might be unavailable for a few minutes. You can retry any
// operations after the update is complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for FinSpace User Environment Management service's
// API operation UpdateKxVolume for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - LimitExceededException
//     A service limit or quota is exceeded.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by an AWS service.
//
//   - ConflictException
//     There was a conflict with this action, and it could not be completed.
//
//   - ResourceNotFoundException
//     One or more resources can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxVolume
func (c *Finspace) UpdateKxVolume(input *UpdateKxVolumeInput) (*UpdateKxVolumeOutput, error) {
	req, out := c.UpdateKxVolumeRequest(input)
	return out, req.Send()
}

// UpdateKxVolumeWithContext is the same as UpdateKxVolume with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKxVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Finspace) UpdateKxVolumeWithContext(ctx aws.Context, input *UpdateKxVolumeInput, opts ...request.Option) (*UpdateKxVolumeOutput, error) {
	req, out := c.UpdateKxVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration based on which FinSpace will scale in or scale out nodes
// in your cluster.
type AutoScalingConfiguration struct {
	_ struct{} `type:"structure"`

	// The metric your cluster will track in order to scale in and out. For example,
	// CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all the nodes
	// in a cluster.
	AutoScalingMetric *string `locationName:"autoScalingMetric" type:"string" enum:"AutoScalingMetric"`

	// The highest number of nodes to scale. This value cannot be greater than 5.
	MaxNodeCount *int64 `locationName:"maxNodeCount" min:"1" type:"integer"`

	// The desired value of the chosen autoScalingMetric. When the metric drops
	// below this value, the cluster will scale in. When the metric goes above this
	// value, the cluster will scale out. You can set the target value between 1
	// and 100 percent.
	MetricTarget *float64 `locationName:"metricTarget" min:"1" type:"double"`

	// The lowest number of nodes to scale. This value must be at least 1 and less
	// than the maxNodeCount. If the nodes in a cluster belong to multiple availability
	// zones, then minNodeCount must be at least 3.
	MinNodeCount *int64 `locationName:"minNodeCount" min:"1" type:"integer"`

	// The duration in seconds that FinSpace will wait after a scale in event before
	// initiating another scaling event.
	ScaleInCooldownSeconds *float64 `locationName:"scaleInCooldownSeconds" type:"double"`

	// The duration in seconds that FinSpace will wait after a scale out event before
	// initiating another scaling event.
	ScaleOutCooldownSeconds *float64 `locationName:"scaleOutCooldownSeconds" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScalingConfiguration"}
	if s.MaxNodeCount != nil && *s.MaxNodeCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxNodeCount", 1))
	}
	if s.MetricTarget != nil && *s.MetricTarget < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MetricTarget", 1))
	}
	if s.MinNodeCount != nil && *s.MinNodeCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinNodeCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingMetric sets the AutoScalingMetric field's value.
func (s *AutoScalingConfiguration) SetAutoScalingMetric(v string) *AutoScalingConfiguration {
	s.AutoScalingMetric = &v
	return s
}

// SetMaxNodeCount sets the MaxNodeCount field's value.
func (s *AutoScalingConfiguration) SetMaxNodeCount(v int64) *AutoScalingConfiguration {
	s.MaxNodeCount = &v
	return s
}

// SetMetricTarget sets the MetricTarget field's value.
func (s *AutoScalingConfiguration) SetMetricTarget(v float64) *AutoScalingConfiguration {
	s.MetricTarget = &v
	return s
}

// SetMinNodeCount sets the MinNodeCount field's value.
func (s *AutoScalingConfiguration) SetMinNodeCount(v int64) *AutoScalingConfiguration {
	s.MinNodeCount = &v
	return s
}

// SetScaleInCooldownSeconds sets the ScaleInCooldownSeconds field's value.
func (s *AutoScalingConfiguration) SetScaleInCooldownSeconds(v float64) *AutoScalingConfiguration {
	s.ScaleInCooldownSeconds = &v
	return s
}

// SetScaleOutCooldownSeconds sets the ScaleOutCooldownSeconds field's value.
func (s *AutoScalingConfiguration) SetScaleOutCooldownSeconds(v float64) *AutoScalingConfiguration {
	s.ScaleOutCooldownSeconds = &v
	return s
}

// A structure for the metadata of a cluster. It includes information like the
// CPUs needed, memory of instances, and number of instances.
type CapacityConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of instances running in a cluster.
	NodeCount *int64 `locationName:"nodeCount" min:"1" type:"integer"`

	// The type that determines the hardware of the host computer used for your
	// cluster instance. Each node type offers different memory and storage capabilities.
	// Choose a node type based on the requirements of the application or software
	// that you plan to run on your instance.
	//
	// You can only specify one of the following values:
	//
	//    * kx.s.large – The node type with a configuration of 12 GiB memory and
	//    2 vCPUs.
	//
	//    * kx.s.xlarge – The node type with a configuration of 27 GiB memory
	//    and 4 vCPUs.
	//
	//    * kx.s.2xlarge – The node type with a configuration of 54 GiB memory
	//    and 8 vCPUs.
	//
	//    * kx.s.4xlarge – The node type with a configuration of 108 GiB memory
	//    and 16 vCPUs.
	//
	//    * kx.s.8xlarge – The node type with a configuration of 216 GiB memory
	//    and 32 vCPUs.
	//
	//    * kx.s.16xlarge – The node type with a configuration of 432 GiB memory
	//    and 64 vCPUs.
	//
	//    * kx.s.32xlarge – The node type with a configuration of 864 GiB memory
	//    and 128 vCPUs.
	NodeType *string `locationName:"nodeType" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacityConfiguration"}
	if s.NodeCount != nil && *s.NodeCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NodeCount", 1))
	}
	if s.NodeType != nil && len(*s.NodeType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNodeCount sets the NodeCount field's value.
func (s *CapacityConfiguration) SetNodeCount(v int64) *CapacityConfiguration {
	s.NodeCount = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *CapacityConfiguration) SetNodeType(v string) *CapacityConfiguration {
	s.NodeType = &v
	return s
}

// A list of change request objects.
type ChangeRequest struct {
	_ struct{} `type:"structure"`

	// Defines the type of change request. A changeType can have the following values:
	//
	//    * PUT – Adds or updates files in a database.
	//
	//    * DELETE – Deletes files in a database.
	//
	// ChangeType is a required field
	ChangeType *string `locationName:"changeType" type:"string" required:"true" enum:"ChangeType"`

	// Defines the path within the database directory.
	//
	// DbPath is a required field
	DbPath *string `locationName:"dbPath" min:"1" type:"string" required:"true"`

	// Defines the S3 path of the source file that is required to add or update
	// files in a database.
	S3Path *string `locationName:"s3Path" min:"9" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangeRequest"}
	if s.ChangeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeType"))
	}
	if s.DbPath == nil {
		invalidParams.Add(request.NewErrParamRequired("DbPath"))
	}
	if s.DbPath != nil && len(*s.DbPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DbPath", 1))
	}
	if s.S3Path != nil && len(*s.S3Path) < 9 {
		invalidParams.Add(request.NewErrParamMinLen("S3Path", 9))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeType sets the ChangeType field's value.
func (s *ChangeRequest) SetChangeType(v string) *ChangeRequest {
	s.ChangeType = &v
	return s
}

// SetDbPath sets the DbPath field's value.
func (s *ChangeRequest) SetDbPath(v string) *ChangeRequest {
	s.DbPath = &v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *ChangeRequest) SetS3Path(v string) *ChangeRequest {
	s.S3Path = &v
	return s
}

// The structure of the customer code available within the running cluster.
type CodeConfiguration struct {
	_ struct{} `type:"structure"`

	// A unique name for the S3 bucket.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The full S3 path (excluding bucket) to the .zip file. This file contains
	// the code that is loaded onto the cluster when it's started.
	S3Key *string `locationName:"s3Key" min:"1" type:"string"`

	// The version of an S3 object.
	S3ObjectVersion *string `locationName:"s3ObjectVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeConfiguration"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *CodeConfiguration) SetS3Bucket(v string) *CodeConfiguration {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *CodeConfiguration) SetS3Key(v string) *CodeConfiguration {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *CodeConfiguration) SetS3ObjectVersion(v string) *CodeConfiguration {
	s.S3ObjectVersion = &v
	return s
}

// There was a conflict with this action, and it could not be completed.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason for the conflict exception.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Resource Names (ARN) of the data bundles to install. Currently
	// supported data bundle ARNs:
	//
	//    * arn:aws:finspace:${Region}::data-bundle/capital-markets-sample - Contains
	//    sample Capital Markets datasets, categories and controlled vocabularies.
	//
	//    * arn:aws:finspace:${Region}::data-bundle/taq (default) - Contains trades
	//    and quotes data in addition to sample Capital Markets data.
	DataBundles []*string `locationName:"dataBundles" type:"list"`

	// The description of the FinSpace environment to be created.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Authentication mode for the environment.
	//
	//    * FEDERATED - Users access FinSpace through Single Sign On (SSO) via your
	//    Identity provider.
	//
	//    * LOCAL - Users access FinSpace via email and password managed within
	//    the FinSpace environment.
	FederationMode *string `locationName:"federationMode" type:"string" enum:"FederationMode"`

	// Configuration information when authentication mode is FEDERATED.
	FederationParameters *FederationParameters `locationName:"federationParameters" type:"structure"`

	// The KMS key id to encrypt your data in the FinSpace environment.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the FinSpace environment to be created.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Configuration information for the superuser.
	SuperuserParameters *SuperuserParameters `locationName:"superuserParameters" type:"structure"`

	// Add tags to your FinSpace environment.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.FederationParameters != nil {
		if err := s.FederationParameters.Validate(); err != nil {
			invalidParams.AddNested("FederationParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SuperuserParameters != nil {
		if err := s.SuperuserParameters.Validate(); err != nil {
			invalidParams.AddNested("SuperuserParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataBundles sets the DataBundles field's value.
func (s *CreateEnvironmentInput) SetDataBundles(v []*string) *CreateEnvironmentInput {
	s.DataBundles = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentInput) SetDescription(v string) *CreateEnvironmentInput {
	s.Description = &v
	return s
}

// SetFederationMode sets the FederationMode field's value.
func (s *CreateEnvironmentInput) SetFederationMode(v string) *CreateEnvironmentInput {
	s.FederationMode = &v
	return s
}

// SetFederationParameters sets the FederationParameters field's value.
func (s *CreateEnvironmentInput) SetFederationParameters(v *FederationParameters) *CreateEnvironmentInput {
	s.FederationParameters = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateEnvironmentInput) SetKmsKeyId(v string) *CreateEnvironmentInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentInput) SetName(v string) *CreateEnvironmentInput {
	s.Name = &v
	return s
}

// SetSuperuserParameters sets the SuperuserParameters field's value.
func (s *CreateEnvironmentInput) SetSuperuserParameters(v *SuperuserParameters) *CreateEnvironmentInput {
	s.SuperuserParameters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentInput) SetTags(v map[string]*string) *CreateEnvironmentInput {
	s.Tags = v
	return s
}

type CreateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the FinSpace environment that you created.
	EnvironmentArn *string `locationName:"environmentArn" min:"20" type:"string"`

	// The unique identifier for FinSpace environment that you created.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The sign-in URL for the web application of the FinSpace environment you created.
	EnvironmentUrl *string `locationName:"environmentUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *CreateEnvironmentOutput) SetEnvironmentArn(v string) *CreateEnvironmentOutput {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateEnvironmentOutput) SetEnvironmentId(v string) *CreateEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentUrl sets the EnvironmentUrl field's value.
func (s *CreateEnvironmentOutput) SetEnvironmentUrl(v string) *CreateEnvironmentOutput {
	s.EnvironmentUrl = &v
	return s
}

type CreateKxChangesetInput struct {
	_ struct{} `type:"structure"`

	// A list of change request objects that are run in order. A change request
	// object consists of changeType , s3Path, and dbPath. A changeType can has
	// the following values:
	//
	//    * PUT – Adds or updates files in a database.
	//
	//    * DELETE – Deletes files in a database.
	//
	// All the change requests require a mandatory dbPath attribute that defines
	// the path within the database directory. All database paths must start with
	// a leading / and end with a trailing /. The s3Path attribute defines the s3
	// source file path and is required for a PUT change type. The s3path must end
	// with a trailing / if it is a directory and must end without a trailing /
	// if it is a file.
	//
	// Here are few examples of how you can use the change request object:
	//
	// This request adds a single sym file at database root location.
	//
	// { "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}
	//
	// This request adds files in the given s3Path under the 2020.01.02 partition
	// of the database.
	//
	// { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}
	//
	// This request adds files in the given s3Path under the taq table partition
	// of the database.
	//
	// [ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]
	//
	// This request deletes the 2020.01.02 partition of the database.
	//
	// [{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]
	//
	// The DELETE request allows you to delete the existing files under the 2020.01.02
	// partition of the database, and the PUT request adds a new taq table under
	// it.
	//
	// [ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT",
	// "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]
	//
	// ChangeRequests is a required field
	ChangeRequests []*ChangeRequest `locationName:"changeRequests" min:"1" type:"list" required:"true"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the kdb database.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A unique identifier of the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxChangesetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxChangesetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKxChangesetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKxChangesetInput"}
	if s.ChangeRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeRequests"))
	}
	if s.ChangeRequests != nil && len(s.ChangeRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeRequests", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.ChangeRequests != nil {
		for i, v := range s.ChangeRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChangeRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeRequests sets the ChangeRequests field's value.
func (s *CreateKxChangesetInput) SetChangeRequests(v []*ChangeRequest) *CreateKxChangesetInput {
	s.ChangeRequests = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKxChangesetInput) SetClientToken(v string) *CreateKxChangesetInput {
	s.ClientToken = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateKxChangesetInput) SetDatabaseName(v string) *CreateKxChangesetInput {
	s.DatabaseName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxChangesetInput) SetEnvironmentId(v string) *CreateKxChangesetInput {
	s.EnvironmentId = &v
	return s
}

type CreateKxChangesetOutput struct {
	_ struct{} `type:"structure"`

	// A list of change requests.
	ChangeRequests []*ChangeRequest `locationName:"changeRequests" min:"1" type:"list"`

	// A unique identifier for the changeset.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The timestamp at which the changeset was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The name of the kdb database.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The details of the error that you receive when creating a changeset. It consists
	// of the type of error and the error message.
	ErrorInfo *ErrorInfo `locationName:"errorInfo" type:"structure"`

	// The timestamp at which the changeset was updated in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// Status of the changeset creation process.
	//
	//    * Pending – Changeset creation is pending.
	//
	//    * Processing – Changeset creation is running.
	//
	//    * Failed – Changeset creation has failed.
	//
	//    * Complete – Changeset creation has succeeded.
	Status *string `locationName:"status" type:"string" enum:"ChangesetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxChangesetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxChangesetOutput) GoString() string {
	return s.String()
}

// SetChangeRequests sets the ChangeRequests field's value.
func (s *CreateKxChangesetOutput) SetChangeRequests(v []*ChangeRequest) *CreateKxChangesetOutput {
	s.ChangeRequests = v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *CreateKxChangesetOutput) SetChangesetId(v string) *CreateKxChangesetOutput {
	s.ChangesetId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateKxChangesetOutput) SetCreatedTimestamp(v time.Time) *CreateKxChangesetOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateKxChangesetOutput) SetDatabaseName(v string) *CreateKxChangesetOutput {
	s.DatabaseName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxChangesetOutput) SetEnvironmentId(v string) *CreateKxChangesetOutput {
	s.EnvironmentId = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *CreateKxChangesetOutput) SetErrorInfo(v *ErrorInfo) *CreateKxChangesetOutput {
	s.ErrorInfo = v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *CreateKxChangesetOutput) SetLastModifiedTimestamp(v time.Time) *CreateKxChangesetOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateKxChangesetOutput) SetStatus(v string) *CreateKxChangesetOutput {
	s.Status = &v
	return s
}

type CreateKxClusterInput struct {
	_ struct{} `type:"structure"`

	// The configuration based on which FinSpace will scale in or scale out nodes
	// in your cluster.
	AutoScalingConfiguration *AutoScalingConfiguration `locationName:"autoScalingConfiguration" type:"structure"`

	// The availability zone identifiers for the requested regions.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of availability zones you want to assign per cluster. This can
	// be one of the following
	//
	//    * SINGLE – Assigns one availability zone per cluster.
	//
	//    * MULTI – Assigns all the availability zones per cluster.
	//
	// AzMode is a required field
	AzMode *string `locationName:"azMode" type:"string" required:"true" enum:"KxAzMode"`

	// The configurations for a read only cache storage associated with a cluster.
	// This cache will be stored as an FSx Lustre that reads from the S3 store.
	CacheStorageConfigurations []*KxCacheStorageConfiguration `locationName:"cacheStorageConfigurations" type:"list"`

	// A structure for the metadata of a cluster. It includes information like the
	// CPUs needed, memory of instances, and number of instances.
	CapacityConfiguration *CapacityConfiguration `locationName:"capacityConfiguration" type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the cluster.
	ClusterDescription *string `locationName:"clusterDescription" min:"1" type:"string"`

	// A unique name for the cluster that you want to create.
	//
	// ClusterName is a required field
	ClusterName *string `locationName:"clusterName" min:"3" type:"string" required:"true"`

	// Specifies the type of KDB database that is being created. The following types
	// are available:
	//
	//    * HDB – A Historical Database. The data is only accessible with read-only
	//    permissions from one of the FinSpace managed kdb databases mounted to
	//    the cluster.
	//
	//    * RDB – A Realtime Database. This type of database captures all the
	//    data from a ticker plant and stores it in memory until the end of day,
	//    after which it writes all of its data to a disk and reloads the HDB. This
	//    cluster type requires local storage for temporary storage of data during
	//    the savedown process. If you specify this field in your request, you must
	//    provide the savedownStorageConfiguration parameter.
	//
	//    * GATEWAY – A gateway cluster allows you to access data across processes
	//    in kdb systems. It allows you to create your own routing logic using the
	//    initialization scripts and custom code. This type of cluster does not
	//    require a writable local storage.
	//
	//    * GP – A general purpose cluster allows you to quickly iterate on code
	//    during development by granting greater access to system commands and enabling
	//    a fast reload of custom code. This cluster type can optionally mount databases
	//    including cache and savedown storage. For this cluster type, the node
	//    count is fixed at 1. It does not support autoscaling and supports only
	//    SINGLE AZ mode.
	//
	//    * Tickerplant – A tickerplant cluster allows you to subscribe to feed
	//    handlers based on IAM permissions. It can publish to RDBs, other Tickerplants,
	//    and real-time subscribers (RTS). Tickerplants can persist messages to
	//    log, which is readable by any RDB environment. It supports only single-node
	//    that is only one kdb process.
	//
	// ClusterType is a required field
	ClusterType *string `locationName:"clusterType" type:"string" required:"true" enum:"KxClusterType"`

	// The details of the custom code that you want to use inside a cluster when
	// analyzing a data. It consists of the S3 source bucket, location, S3 object
	// version, and the relative path from where the custom code is loaded into
	// the cluster.
	Code *CodeConfiguration `locationName:"code" type:"structure"`

	// Defines the key-value pairs to make them available inside the cluster.
	CommandLineArguments []*KxCommandLineArgument `locationName:"commandLineArguments" type:"list"`

	// A list of databases that will be available for querying.
	Databases []*KxDatabaseConfiguration `locationName:"databases" type:"list"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// An IAM role that defines a set of permissions associated with a cluster.
	// These permissions are assumed when a cluster attempts to access another cluster.
	ExecutionRole *string `locationName:"executionRole" min:"1" type:"string"`

	// Specifies a Q program that will be run at launch of a cluster. It is a relative
	// path within .zip file that contains the custom code, which will be loaded
	// on the cluster. It must include the file name itself. For example, somedir/init.q.
	InitializationScript *string `locationName:"initializationScript" min:"1" type:"string"`

	// The version of FinSpace managed kdb to run.
	//
	// ReleaseLabel is a required field
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string" required:"true"`

	// The size and type of the temporary storage that is used to hold data during
	// the savedown process. This parameter is required when you choose clusterType
	// as RDB. All the data written to this storage space is lost when the cluster
	// node is restarted.
	SavedownStorageConfiguration *KxSavedownStorageConfiguration `locationName:"savedownStorageConfiguration" type:"structure"`

	// The structure that stores the configuration details of a scaling group.
	ScalingGroupConfiguration *KxScalingGroupConfiguration `locationName:"scalingGroupConfiguration" type:"structure"`

	// A list of key-value pairs to label the cluster. You can add up to 50 tags
	// to a cluster.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// A configuration to store Tickerplant logs. It consists of a list of volumes
	// that will be mounted to your cluster. For the cluster type Tickerplant, the
	// location of the TP volume on the cluster will be available by using the global
	// variable .aws.tp_log_path.
	TickerplantLogConfiguration *TickerplantLogConfiguration `locationName:"tickerplantLogConfiguration" type:"structure"`

	// Configuration details about the network where the Privatelink endpoint of
	// the cluster resides.
	//
	// VpcConfiguration is a required field
	VpcConfiguration *VpcConfiguration `locationName:"vpcConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKxClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKxClusterInput"}
	if s.AzMode == nil {
		invalidParams.Add(request.NewErrParamRequired("AzMode"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ClusterDescription != nil && len(*s.ClusterDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterDescription", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 3))
	}
	if s.ClusterType == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterType"))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.ExecutionRole != nil && len(*s.ExecutionRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRole", 1))
	}
	if s.InitializationScript != nil && len(*s.InitializationScript) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitializationScript", 1))
	}
	if s.ReleaseLabel == nil {
		invalidParams.Add(request.NewErrParamRequired("ReleaseLabel"))
	}
	if s.ReleaseLabel != nil && len(*s.ReleaseLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReleaseLabel", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VpcConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcConfiguration"))
	}
	if s.AutoScalingConfiguration != nil {
		if err := s.AutoScalingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AutoScalingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CacheStorageConfigurations != nil {
		for i, v := range s.CacheStorageConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CacheStorageConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CapacityConfiguration != nil {
		if err := s.CapacityConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CapacityConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Code != nil {
		if err := s.Code.Validate(); err != nil {
			invalidParams.AddNested("Code", err.(request.ErrInvalidParams))
		}
	}
	if s.CommandLineArguments != nil {
		for i, v := range s.CommandLineArguments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CommandLineArguments", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Databases != nil {
		for i, v := range s.Databases {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Databases", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SavedownStorageConfiguration != nil {
		if err := s.SavedownStorageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SavedownStorageConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ScalingGroupConfiguration != nil {
		if err := s.ScalingGroupConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ScalingGroupConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingConfiguration sets the AutoScalingConfiguration field's value.
func (s *CreateKxClusterInput) SetAutoScalingConfiguration(v *AutoScalingConfiguration) *CreateKxClusterInput {
	s.AutoScalingConfiguration = v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *CreateKxClusterInput) SetAvailabilityZoneId(v string) *CreateKxClusterInput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *CreateKxClusterInput) SetAzMode(v string) *CreateKxClusterInput {
	s.AzMode = &v
	return s
}

// SetCacheStorageConfigurations sets the CacheStorageConfigurations field's value.
func (s *CreateKxClusterInput) SetCacheStorageConfigurations(v []*KxCacheStorageConfiguration) *CreateKxClusterInput {
	s.CacheStorageConfigurations = v
	return s
}

// SetCapacityConfiguration sets the CapacityConfiguration field's value.
func (s *CreateKxClusterInput) SetCapacityConfiguration(v *CapacityConfiguration) *CreateKxClusterInput {
	s.CapacityConfiguration = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKxClusterInput) SetClientToken(v string) *CreateKxClusterInput {
	s.ClientToken = &v
	return s
}

// SetClusterDescription sets the ClusterDescription field's value.
func (s *CreateKxClusterInput) SetClusterDescription(v string) *CreateKxClusterInput {
	s.ClusterDescription = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateKxClusterInput) SetClusterName(v string) *CreateKxClusterInput {
	s.ClusterName = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *CreateKxClusterInput) SetClusterType(v string) *CreateKxClusterInput {
	s.ClusterType = &v
	return s
}

// SetCode sets the Code field's value.
func (s *CreateKxClusterInput) SetCode(v *CodeConfiguration) *CreateKxClusterInput {
	s.Code = v
	return s
}

// SetCommandLineArguments sets the CommandLineArguments field's value.
func (s *CreateKxClusterInput) SetCommandLineArguments(v []*KxCommandLineArgument) *CreateKxClusterInput {
	s.CommandLineArguments = v
	return s
}

// SetDatabases sets the Databases field's value.
func (s *CreateKxClusterInput) SetDatabases(v []*KxDatabaseConfiguration) *CreateKxClusterInput {
	s.Databases = v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxClusterInput) SetEnvironmentId(v string) *CreateKxClusterInput {
	s.EnvironmentId = &v
	return s
}

// SetExecutionRole sets the ExecutionRole field's value.
func (s *CreateKxClusterInput) SetExecutionRole(v string) *CreateKxClusterInput {
	s.ExecutionRole = &v
	return s
}

// SetInitializationScript sets the InitializationScript field's value.
func (s *CreateKxClusterInput) SetInitializationScript(v string) *CreateKxClusterInput {
	s.InitializationScript = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *CreateKxClusterInput) SetReleaseLabel(v string) *CreateKxClusterInput {
	s.ReleaseLabel = &v
	return s
}

// SetSavedownStorageConfiguration sets the SavedownStorageConfiguration field's value.
func (s *CreateKxClusterInput) SetSavedownStorageConfiguration(v *KxSavedownStorageConfiguration) *CreateKxClusterInput {
	s.SavedownStorageConfiguration = v
	return s
}

// SetScalingGroupConfiguration sets the ScalingGroupConfiguration field's value.
func (s *CreateKxClusterInput) SetScalingGroupConfiguration(v *KxScalingGroupConfiguration) *CreateKxClusterInput {
	s.ScalingGroupConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKxClusterInput) SetTags(v map[string]*string) *CreateKxClusterInput {
	s.Tags = v
	return s
}

// SetTickerplantLogConfiguration sets the TickerplantLogConfiguration field's value.
func (s *CreateKxClusterInput) SetTickerplantLogConfiguration(v *TickerplantLogConfiguration) *CreateKxClusterInput {
	s.TickerplantLogConfiguration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *CreateKxClusterInput) SetVpcConfiguration(v *VpcConfiguration) *CreateKxClusterInput {
	s.VpcConfiguration = v
	return s
}

type CreateKxClusterOutput struct {
	_ struct{} `type:"structure"`

	// The configuration based on which FinSpace will scale in or scale out nodes
	// in your cluster.
	AutoScalingConfiguration *AutoScalingConfiguration `locationName:"autoScalingConfiguration" type:"structure"`

	// The availability zone identifiers for the requested regions.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of availability zones you want to assign per cluster. This can
	// be one of the following
	//
	//    * SINGLE – Assigns one availability zone per cluster.
	//
	//    * MULTI – Assigns all the availability zones per cluster.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// The configurations for a read only cache storage associated with a cluster.
	// This cache will be stored as an FSx Lustre that reads from the S3 store.
	CacheStorageConfigurations []*KxCacheStorageConfiguration `locationName:"cacheStorageConfigurations" type:"list"`

	// A structure for the metadata of a cluster. It includes information like the
	// CPUs needed, memory of instances, and number of instances.
	CapacityConfiguration *CapacityConfiguration `locationName:"capacityConfiguration" type:"structure"`

	// A description of the cluster.
	ClusterDescription *string `locationName:"clusterDescription" min:"1" type:"string"`

	// A unique name for the cluster.
	ClusterName *string `locationName:"clusterName" min:"3" type:"string"`

	// Specifies the type of KDB database that is being created. The following types
	// are available:
	//
	//    * HDB – A Historical Database. The data is only accessible with read-only
	//    permissions from one of the FinSpace managed kdb databases mounted to
	//    the cluster.
	//
	//    * RDB – A Realtime Database. This type of database captures all the
	//    data from a ticker plant and stores it in memory until the end of day,
	//    after which it writes all of its data to a disk and reloads the HDB. This
	//    cluster type requires local storage for temporary storage of data during
	//    the savedown process. If you specify this field in your request, you must
	//    provide the savedownStorageConfiguration parameter.
	//
	//    * GATEWAY – A gateway cluster allows you to access data across processes
	//    in kdb systems. It allows you to create your own routing logic using the
	//    initialization scripts and custom code. This type of cluster does not
	//    require a writable local storage.
	//
	//    * GP – A general purpose cluster allows you to quickly iterate on code
	//    during development by granting greater access to system commands and enabling
	//    a fast reload of custom code. This cluster type can optionally mount databases
	//    including cache and savedown storage. For this cluster type, the node
	//    count is fixed at 1. It does not support autoscaling and supports only
	//    SINGLE AZ mode.
	//
	//    * Tickerplant – A tickerplant cluster allows you to subscribe to feed
	//    handlers based on IAM permissions. It can publish to RDBs, other Tickerplants,
	//    and real-time subscribers (RTS). Tickerplants can persist messages to
	//    log, which is readable by any RDB environment. It supports only single-node
	//    that is only one kdb process.
	ClusterType *string `locationName:"clusterType" type:"string" enum:"KxClusterType"`

	// The details of the custom code that you want to use inside a cluster when
	// analyzing a data. It consists of the S3 source bucket, location, S3 object
	// version, and the relative path from where the custom code is loaded into
	// the cluster.
	Code *CodeConfiguration `locationName:"code" type:"structure"`

	// Defines the key-value pairs to make them available inside the cluster.
	CommandLineArguments []*KxCommandLineArgument `locationName:"commandLineArguments" type:"list"`

	// The timestamp at which the cluster was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// A list of databases that will be available for querying.
	Databases []*KxDatabaseConfiguration `locationName:"databases" type:"list"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// An IAM role that defines a set of permissions associated with a cluster.
	// These permissions are assumed when a cluster attempts to access another cluster.
	ExecutionRole *string `locationName:"executionRole" min:"1" type:"string"`

	// Specifies a Q program that will be run at launch of a cluster. It is a relative
	// path within .zip file that contains the custom code, which will be loaded
	// on the cluster. It must include the file name itself. For example, somedir/init.q.
	InitializationScript *string `locationName:"initializationScript" min:"1" type:"string"`

	// The last time that the cluster was modified. The value is determined as epoch
	// time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// A version of the FinSpace managed kdb to run.
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string"`

	// The size and type of the temporary storage that is used to hold data during
	// the savedown process. This parameter is required when you choose clusterType
	// as RDB. All the data written to this storage space is lost when the cluster
	// node is restarted.
	SavedownStorageConfiguration *KxSavedownStorageConfiguration `locationName:"savedownStorageConfiguration" type:"structure"`

	// The structure that stores the configuration details of a scaling group.
	ScalingGroupConfiguration *KxScalingGroupConfiguration `locationName:"scalingGroupConfiguration" type:"structure"`

	// The status of cluster creation.
	//
	//    * PENDING – The cluster is pending creation.
	//
	//    * CREATING – The cluster creation process is in progress.
	//
	//    * CREATE_FAILED – The cluster creation process has failed.
	//
	//    * RUNNING – The cluster creation process is running.
	//
	//    * UPDATING – The cluster is in the process of being updated.
	//
	//    * DELETING – The cluster is in the process of being deleted.
	//
	//    * DELETED – The cluster has been deleted.
	//
	//    * DELETE_FAILED – The cluster failed to delete.
	Status *string `locationName:"status" type:"string" enum:"KxClusterStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`

	// A configuration to store the Tickerplant logs. It consists of a list of volumes
	// that will be mounted to your cluster. For the cluster type Tickerplant, the
	// location of the TP volume on the cluster will be available by using the global
	// variable .aws.tp_log_path.
	TickerplantLogConfiguration *TickerplantLogConfiguration `locationName:"tickerplantLogConfiguration" type:"structure"`

	// A list of volumes mounted on the cluster.
	Volumes []*Volume `locationName:"volumes" type:"list"`

	// Configuration details about the network where the Privatelink endpoint of
	// the cluster resides.
	VpcConfiguration *VpcConfiguration `locationName:"vpcConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxClusterOutput) GoString() string {
	return s.String()
}

// SetAutoScalingConfiguration sets the AutoScalingConfiguration field's value.
func (s *CreateKxClusterOutput) SetAutoScalingConfiguration(v *AutoScalingConfiguration) *CreateKxClusterOutput {
	s.AutoScalingConfiguration = v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *CreateKxClusterOutput) SetAvailabilityZoneId(v string) *CreateKxClusterOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *CreateKxClusterOutput) SetAzMode(v string) *CreateKxClusterOutput {
	s.AzMode = &v
	return s
}

// SetCacheStorageConfigurations sets the CacheStorageConfigurations field's value.
func (s *CreateKxClusterOutput) SetCacheStorageConfigurations(v []*KxCacheStorageConfiguration) *CreateKxClusterOutput {
	s.CacheStorageConfigurations = v
	return s
}

// SetCapacityConfiguration sets the CapacityConfiguration field's value.
func (s *CreateKxClusterOutput) SetCapacityConfiguration(v *CapacityConfiguration) *CreateKxClusterOutput {
	s.CapacityConfiguration = v
	return s
}

// SetClusterDescription sets the ClusterDescription field's value.
func (s *CreateKxClusterOutput) SetClusterDescription(v string) *CreateKxClusterOutput {
	s.ClusterDescription = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateKxClusterOutput) SetClusterName(v string) *CreateKxClusterOutput {
	s.ClusterName = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *CreateKxClusterOutput) SetClusterType(v string) *CreateKxClusterOutput {
	s.ClusterType = &v
	return s
}

// SetCode sets the Code field's value.
func (s *CreateKxClusterOutput) SetCode(v *CodeConfiguration) *CreateKxClusterOutput {
	s.Code = v
	return s
}

// SetCommandLineArguments sets the CommandLineArguments field's value.
func (s *CreateKxClusterOutput) SetCommandLineArguments(v []*KxCommandLineArgument) *CreateKxClusterOutput {
	s.CommandLineArguments = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateKxClusterOutput) SetCreatedTimestamp(v time.Time) *CreateKxClusterOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabases sets the Databases field's value.
func (s *CreateKxClusterOutput) SetDatabases(v []*KxDatabaseConfiguration) *CreateKxClusterOutput {
	s.Databases = v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxClusterOutput) SetEnvironmentId(v string) *CreateKxClusterOutput {
	s.EnvironmentId = &v
	return s
}

// SetExecutionRole sets the ExecutionRole field's value.
func (s *CreateKxClusterOutput) SetExecutionRole(v string) *CreateKxClusterOutput {
	s.ExecutionRole = &v
	return s
}

// SetInitializationScript sets the InitializationScript field's value.
func (s *CreateKxClusterOutput) SetInitializationScript(v string) *CreateKxClusterOutput {
	s.InitializationScript = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *CreateKxClusterOutput) SetLastModifiedTimestamp(v time.Time) *CreateKxClusterOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *CreateKxClusterOutput) SetReleaseLabel(v string) *CreateKxClusterOutput {
	s.ReleaseLabel = &v
	return s
}

// SetSavedownStorageConfiguration sets the SavedownStorageConfiguration field's value.
func (s *CreateKxClusterOutput) SetSavedownStorageConfiguration(v *KxSavedownStorageConfiguration) *CreateKxClusterOutput {
	s.SavedownStorageConfiguration = v
	return s
}

// SetScalingGroupConfiguration sets the ScalingGroupConfiguration field's value.
func (s *CreateKxClusterOutput) SetScalingGroupConfiguration(v *KxScalingGroupConfiguration) *CreateKxClusterOutput {
	s.ScalingGroupConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateKxClusterOutput) SetStatus(v string) *CreateKxClusterOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *CreateKxClusterOutput) SetStatusReason(v string) *CreateKxClusterOutput {
	s.StatusReason = &v
	return s
}

// SetTickerplantLogConfiguration sets the TickerplantLogConfiguration field's value.
func (s *CreateKxClusterOutput) SetTickerplantLogConfiguration(v *TickerplantLogConfiguration) *CreateKxClusterOutput {
	s.TickerplantLogConfiguration = v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *CreateKxClusterOutput) SetVolumes(v []*Volume) *CreateKxClusterOutput {
	s.Volumes = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *CreateKxClusterOutput) SetVpcConfiguration(v *VpcConfiguration) *CreateKxClusterOutput {
	s.VpcConfiguration = v
	return s
}

type CreateKxDatabaseInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the kdb database.
	//
	// DatabaseName is a required field
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A description of the database.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// A list of key-value pairs to label the kdb database. You can add up to 50
	// tags to your kdb database
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKxDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKxDatabaseInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKxDatabaseInput) SetClientToken(v string) *CreateKxDatabaseInput {
	s.ClientToken = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateKxDatabaseInput) SetDatabaseName(v string) *CreateKxDatabaseInput {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKxDatabaseInput) SetDescription(v string) *CreateKxDatabaseInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxDatabaseInput) SetEnvironmentId(v string) *CreateKxDatabaseInput {
	s.EnvironmentId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKxDatabaseInput) SetTags(v map[string]*string) *CreateKxDatabaseInput {
	s.Tags = v
	return s
}

type CreateKxDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp at which the database is created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The ARN identifier of the database.
	DatabaseArn *string `locationName:"databaseArn" type:"string"`

	// The name of the kdb database.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// A description of the database.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The last time that the database was updated in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxDatabaseOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateKxDatabaseOutput) SetCreatedTimestamp(v time.Time) *CreateKxDatabaseOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabaseArn sets the DatabaseArn field's value.
func (s *CreateKxDatabaseOutput) SetDatabaseArn(v string) *CreateKxDatabaseOutput {
	s.DatabaseArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateKxDatabaseOutput) SetDatabaseName(v string) *CreateKxDatabaseOutput {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKxDatabaseOutput) SetDescription(v string) *CreateKxDatabaseOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxDatabaseOutput) SetEnvironmentId(v string) *CreateKxDatabaseOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *CreateKxDatabaseOutput) SetLastModifiedTimestamp(v time.Time) *CreateKxDatabaseOutput {
	s.LastModifiedTimestamp = &v
	return s
}

type CreateKxDataviewInput struct {
	_ struct{} `type:"structure"`

	// The option to specify whether you want to apply all the future additions
	// and corrections automatically to the dataview, when you ingest new changesets.
	// The default value is false.
	AutoUpdate *bool `locationName:"autoUpdate" type:"boolean"`

	// The identifier of the availability zones.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of availability zones you want to assign per cluster. This can
	// be one of the following
	//
	//    * SINGLE – Assigns one availability zone per cluster.
	//
	//    * MULTI – Assigns all the availability zones per cluster.
	//
	// AzMode is a required field
	AzMode *string `locationName:"azMode" type:"string" required:"true" enum:"KxAzMode"`

	// A unique identifier of the changeset that you want to use to ingest data.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the database where you want to create a dataview.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A unique identifier for the dataview.
	//
	// DataviewName is a required field
	DataviewName *string `locationName:"dataviewName" min:"3" type:"string" required:"true"`

	// A description of the dataview.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment, where you want to create the
	// dataview.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The configuration that contains the database path of the data that you want
	// to place on each selected volume. Each segment must have a unique database
	// path for each volume. If you do not explicitly specify any database path
	// for a volume, they are accessible from the cluster through the default S3/object
	// store segment.
	SegmentConfigurations []*KxDataviewSegmentConfiguration `locationName:"segmentConfigurations" type:"list"`

	// A list of key-value pairs to label the dataview. You can add up to 50 tags
	// to a dataview.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxDataviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxDataviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKxDataviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKxDataviewInput"}
	if s.AzMode == nil {
		invalidParams.Add(request.NewErrParamRequired("AzMode"))
	}
	if s.ChangesetId != nil && len(*s.ChangesetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangesetId", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.DataviewName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataviewName"))
	}
	if s.DataviewName != nil && len(*s.DataviewName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DataviewName", 3))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.SegmentConfigurations != nil {
		for i, v := range s.SegmentConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SegmentConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoUpdate sets the AutoUpdate field's value.
func (s *CreateKxDataviewInput) SetAutoUpdate(v bool) *CreateKxDataviewInput {
	s.AutoUpdate = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *CreateKxDataviewInput) SetAvailabilityZoneId(v string) *CreateKxDataviewInput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *CreateKxDataviewInput) SetAzMode(v string) *CreateKxDataviewInput {
	s.AzMode = &v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *CreateKxDataviewInput) SetChangesetId(v string) *CreateKxDataviewInput {
	s.ChangesetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKxDataviewInput) SetClientToken(v string) *CreateKxDataviewInput {
	s.ClientToken = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateKxDataviewInput) SetDatabaseName(v string) *CreateKxDataviewInput {
	s.DatabaseName = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *CreateKxDataviewInput) SetDataviewName(v string) *CreateKxDataviewInput {
	s.DataviewName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKxDataviewInput) SetDescription(v string) *CreateKxDataviewInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxDataviewInput) SetEnvironmentId(v string) *CreateKxDataviewInput {
	s.EnvironmentId = &v
	return s
}

// SetSegmentConfigurations sets the SegmentConfigurations field's value.
func (s *CreateKxDataviewInput) SetSegmentConfigurations(v []*KxDataviewSegmentConfiguration) *CreateKxDataviewInput {
	s.SegmentConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKxDataviewInput) SetTags(v map[string]*string) *CreateKxDataviewInput {
	s.Tags = v
	return s
}

type CreateKxDataviewOutput struct {
	_ struct{} `type:"structure"`

	// The option to select whether you want to apply all the future additions and
	// corrections automatically to the dataview when you ingest new changesets.
	// The default value is false.
	AutoUpdate *bool `locationName:"autoUpdate" type:"boolean"`

	// The identifier of the availability zones.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of availability zones you want to assign per cluster. This can
	// be one of the following
	//
	//    * SINGLE – Assigns one availability zone per cluster.
	//
	//    * MULTI – Assigns all the availability zones per cluster.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// A unique identifier for the changeset.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The timestamp at which the dataview was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The name of the database where you want to create a dataview.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// A unique identifier for the dataview.
	DataviewName *string `locationName:"dataviewName" min:"3" type:"string"`

	// A description of the dataview.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment, where you want to create the
	// dataview.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The last time that the dataview was updated in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The configuration that contains the database path of the data that you want
	// to place on each selected volume. Each segment must have a unique database
	// path for each volume. If you do not explicitly specify any database path
	// for a volume, they are accessible from the cluster through the default S3/object
	// store segment.
	SegmentConfigurations []*KxDataviewSegmentConfiguration `locationName:"segmentConfigurations" type:"list"`

	// The status of dataview creation.
	//
	//    * CREATING – The dataview creation is in progress.
	//
	//    * UPDATING – The dataview is in the process of being updated.
	//
	//    * ACTIVE – The dataview is active.
	Status *string `locationName:"status" type:"string" enum:"KxDataviewStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxDataviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxDataviewOutput) GoString() string {
	return s.String()
}

// SetAutoUpdate sets the AutoUpdate field's value.
func (s *CreateKxDataviewOutput) SetAutoUpdate(v bool) *CreateKxDataviewOutput {
	s.AutoUpdate = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *CreateKxDataviewOutput) SetAvailabilityZoneId(v string) *CreateKxDataviewOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *CreateKxDataviewOutput) SetAzMode(v string) *CreateKxDataviewOutput {
	s.AzMode = &v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *CreateKxDataviewOutput) SetChangesetId(v string) *CreateKxDataviewOutput {
	s.ChangesetId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateKxDataviewOutput) SetCreatedTimestamp(v time.Time) *CreateKxDataviewOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateKxDataviewOutput) SetDatabaseName(v string) *CreateKxDataviewOutput {
	s.DatabaseName = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *CreateKxDataviewOutput) SetDataviewName(v string) *CreateKxDataviewOutput {
	s.DataviewName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKxDataviewOutput) SetDescription(v string) *CreateKxDataviewOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxDataviewOutput) SetEnvironmentId(v string) *CreateKxDataviewOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *CreateKxDataviewOutput) SetLastModifiedTimestamp(v time.Time) *CreateKxDataviewOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSegmentConfigurations sets the SegmentConfigurations field's value.
func (s *CreateKxDataviewOutput) SetSegmentConfigurations(v []*KxDataviewSegmentConfiguration) *CreateKxDataviewOutput {
	s.SegmentConfigurations = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateKxDataviewOutput) SetStatus(v string) *CreateKxDataviewOutput {
	s.Status = &v
	return s
}

type CreateKxEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description for the kdb environment.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The KMS key ID to encrypt your data in the FinSpace environment.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string" required:"true"`

	// The name of the kdb environment that you want to create.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// A list of key-value pairs to label the kdb environment. You can add up to
	// 50 tags to your kdb environment.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKxEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKxEnvironmentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KmsKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyId"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKxEnvironmentInput) SetClientToken(v string) *CreateKxEnvironmentInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKxEnvironmentInput) SetDescription(v string) *CreateKxEnvironmentInput {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateKxEnvironmentInput) SetKmsKeyId(v string) *CreateKxEnvironmentInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateKxEnvironmentInput) SetName(v string) *CreateKxEnvironmentInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKxEnvironmentInput) SetTags(v map[string]*string) *CreateKxEnvironmentInput {
	s.Tags = v
	return s
}

type CreateKxEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp at which the kdb environment was created in FinSpace.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// A description for the kdb environment.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ARN identifier of the environment.
	EnvironmentArn *string `locationName:"environmentArn" min:"20" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The KMS key ID to encrypt your data in the FinSpace environment.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the kdb environment.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status of the kdb environment.
	Status *string `locationName:"status" type:"string" enum:"EnvironmentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxEnvironmentOutput) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateKxEnvironmentOutput) SetCreationTimestamp(v time.Time) *CreateKxEnvironmentOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKxEnvironmentOutput) SetDescription(v string) *CreateKxEnvironmentOutput {
	s.Description = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *CreateKxEnvironmentOutput) SetEnvironmentArn(v string) *CreateKxEnvironmentOutput {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxEnvironmentOutput) SetEnvironmentId(v string) *CreateKxEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateKxEnvironmentOutput) SetKmsKeyId(v string) *CreateKxEnvironmentOutput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateKxEnvironmentOutput) SetName(v string) *CreateKxEnvironmentOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateKxEnvironmentOutput) SetStatus(v string) *CreateKxEnvironmentOutput {
	s.Status = &v
	return s
}

type CreateKxScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones.
	//
	// AvailabilityZoneId is a required field
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string" required:"true"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A unique identifier for the kdb environment, where you want to create the
	// scaling group.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The memory and CPU capabilities of the scaling group host on which FinSpace
	// Managed kdb clusters will be placed.
	//
	// HostType is a required field
	HostType *string `locationName:"hostType" min:"1" type:"string" required:"true"`

	// A unique identifier for the kdb scaling group.
	//
	// ScalingGroupName is a required field
	ScalingGroupName *string `locationName:"scalingGroupName" min:"3" type:"string" required:"true"`

	// A list of key-value pairs to label the scaling group. You can add up to 50
	// tags to a scaling group.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKxScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKxScalingGroupInput"}
	if s.AvailabilityZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZoneId"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.HostType == nil {
		invalidParams.Add(request.NewErrParamRequired("HostType"))
	}
	if s.HostType != nil && len(*s.HostType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HostType", 1))
	}
	if s.ScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingGroupName"))
	}
	if s.ScalingGroupName != nil && len(*s.ScalingGroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingGroupName", 3))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *CreateKxScalingGroupInput) SetAvailabilityZoneId(v string) *CreateKxScalingGroupInput {
	s.AvailabilityZoneId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKxScalingGroupInput) SetClientToken(v string) *CreateKxScalingGroupInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxScalingGroupInput) SetEnvironmentId(v string) *CreateKxScalingGroupInput {
	s.EnvironmentId = &v
	return s
}

// SetHostType sets the HostType field's value.
func (s *CreateKxScalingGroupInput) SetHostType(v string) *CreateKxScalingGroupInput {
	s.HostType = &v
	return s
}

// SetScalingGroupName sets the ScalingGroupName field's value.
func (s *CreateKxScalingGroupInput) SetScalingGroupName(v string) *CreateKxScalingGroupInput {
	s.ScalingGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKxScalingGroupInput) SetTags(v map[string]*string) *CreateKxScalingGroupInput {
	s.Tags = v
	return s
}

type CreateKxScalingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The timestamp at which the scaling group was created in FinSpace. The value
	// is determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// A unique identifier for the kdb environment, where you create the scaling
	// group.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The memory and CPU capabilities of the scaling group host on which FinSpace
	// Managed kdb clusters will be placed.
	HostType *string `locationName:"hostType" min:"1" type:"string"`

	// The last time that the scaling group was updated in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// A unique identifier for the kdb scaling group.
	ScalingGroupName *string `locationName:"scalingGroupName" min:"3" type:"string"`

	// The status of scaling group.
	//
	//    * CREATING – The scaling group creation is in progress.
	//
	//    * CREATE_FAILED – The scaling group creation has failed.
	//
	//    * ACTIVE – The scaling group is active.
	//
	//    * UPDATING – The scaling group is in the process of being updated.
	//
	//    * UPDATE_FAILED – The update action failed.
	//
	//    * DELETING – The scaling group is in the process of being deleted.
	//
	//    * DELETE_FAILED – The system failed to delete the scaling group.
	//
	//    * DELETED – The scaling group is successfully deleted.
	Status *string `locationName:"status" type:"string" enum:"KxScalingGroupStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxScalingGroupOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *CreateKxScalingGroupOutput) SetAvailabilityZoneId(v string) *CreateKxScalingGroupOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateKxScalingGroupOutput) SetCreatedTimestamp(v time.Time) *CreateKxScalingGroupOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxScalingGroupOutput) SetEnvironmentId(v string) *CreateKxScalingGroupOutput {
	s.EnvironmentId = &v
	return s
}

// SetHostType sets the HostType field's value.
func (s *CreateKxScalingGroupOutput) SetHostType(v string) *CreateKxScalingGroupOutput {
	s.HostType = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *CreateKxScalingGroupOutput) SetLastModifiedTimestamp(v time.Time) *CreateKxScalingGroupOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetScalingGroupName sets the ScalingGroupName field's value.
func (s *CreateKxScalingGroupOutput) SetScalingGroupName(v string) *CreateKxScalingGroupOutput {
	s.ScalingGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateKxScalingGroupOutput) SetStatus(v string) *CreateKxScalingGroupOutput {
	s.Status = &v
	return s
}

type CreateKxUserInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A unique identifier for the kdb environment where you want to create a user.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The IAM role ARN that will be associated with the user.
	//
	// IamRole is a required field
	IamRole *string `locationName:"iamRole" min:"20" type:"string" required:"true"`

	// A list of key-value pairs to label the user. You can add up to 50 tags to
	// a user.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// A unique identifier for the user.
	//
	// UserName is a required field
	UserName *string `locationName:"userName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKxUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKxUserInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.IamRole == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRole"))
	}
	if s.IamRole != nil && len(*s.IamRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IamRole", 20))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKxUserInput) SetClientToken(v string) *CreateKxUserInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxUserInput) SetEnvironmentId(v string) *CreateKxUserInput {
	s.EnvironmentId = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *CreateKxUserInput) SetIamRole(v string) *CreateKxUserInput {
	s.IamRole = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKxUserInput) SetTags(v map[string]*string) *CreateKxUserInput {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateKxUserInput) SetUserName(v string) *CreateKxUserInput {
	s.UserName = &v
	return s
}

type CreateKxUserOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The IAM role ARN that will be associated with the user.
	IamRole *string `locationName:"iamRole" min:"20" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the user. For more information
	// about ARNs and how to use ARNs in policies, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	UserArn *string `locationName:"userArn" min:"20" type:"string"`

	// A unique identifier for the user.
	UserName *string `locationName:"userName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxUserOutput) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxUserOutput) SetEnvironmentId(v string) *CreateKxUserOutput {
	s.EnvironmentId = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *CreateKxUserOutput) SetIamRole(v string) *CreateKxUserOutput {
	s.IamRole = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *CreateKxUserOutput) SetUserArn(v string) *CreateKxUserOutput {
	s.UserArn = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateKxUserOutput) SetUserName(v string) *CreateKxUserOutput {
	s.UserName = &v
	return s
}

type CreateKxVolumeInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones.
	//
	// AvailabilityZoneIds is a required field
	AvailabilityZoneIds []*string `locationName:"availabilityZoneIds" type:"list" required:"true"`

	// The number of availability zones you want to assign per cluster. Currently,
	// FinSpace only support SINGLE for volumes.
	//
	// AzMode is a required field
	AzMode *string `locationName:"azMode" type:"string" required:"true" enum:"KxAzMode"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the volume.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment, whose clusters can attach to
	// the volume.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// Specifies the configuration for the Network attached storage (NAS_1) file
	// system volume. This parameter is required when you choose volumeType as NAS_1.
	Nas1Configuration *KxNAS1Configuration `locationName:"nas1Configuration" type:"structure"`

	// A list of key-value pairs to label the volume. You can add up to 50 tags
	// to a volume.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// A unique identifier for the volume.
	//
	// VolumeName is a required field
	VolumeName *string `locationName:"volumeName" min:"3" type:"string" required:"true"`

	// The type of file system volume. Currently, FinSpace only supports NAS_1 volume
	// type. When you select NAS_1 volume type, you must also provide nas1Configuration.
	//
	// VolumeType is a required field
	VolumeType *string `locationName:"volumeType" type:"string" required:"true" enum:"KxVolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKxVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKxVolumeInput"}
	if s.AvailabilityZoneIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZoneIds"))
	}
	if s.AzMode == nil {
		invalidParams.Add(request.NewErrParamRequired("AzMode"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VolumeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeName"))
	}
	if s.VolumeName != nil && len(*s.VolumeName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeName", 3))
	}
	if s.VolumeType == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeType"))
	}
	if s.Nas1Configuration != nil {
		if err := s.Nas1Configuration.Validate(); err != nil {
			invalidParams.AddNested("Nas1Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZoneIds sets the AvailabilityZoneIds field's value.
func (s *CreateKxVolumeInput) SetAvailabilityZoneIds(v []*string) *CreateKxVolumeInput {
	s.AvailabilityZoneIds = v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *CreateKxVolumeInput) SetAzMode(v string) *CreateKxVolumeInput {
	s.AzMode = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKxVolumeInput) SetClientToken(v string) *CreateKxVolumeInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKxVolumeInput) SetDescription(v string) *CreateKxVolumeInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxVolumeInput) SetEnvironmentId(v string) *CreateKxVolumeInput {
	s.EnvironmentId = &v
	return s
}

// SetNas1Configuration sets the Nas1Configuration field's value.
func (s *CreateKxVolumeInput) SetNas1Configuration(v *KxNAS1Configuration) *CreateKxVolumeInput {
	s.Nas1Configuration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKxVolumeInput) SetTags(v map[string]*string) *CreateKxVolumeInput {
	s.Tags = v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *CreateKxVolumeInput) SetVolumeName(v string) *CreateKxVolumeInput {
	s.VolumeName = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *CreateKxVolumeInput) SetVolumeType(v string) *CreateKxVolumeInput {
	s.VolumeType = &v
	return s
}

type CreateKxVolumeOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones.
	AvailabilityZoneIds []*string `locationName:"availabilityZoneIds" type:"list"`

	// The number of availability zones you want to assign per cluster. Currently,
	// FinSpace only support SINGLE for volumes.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// The timestamp at which the volume was created in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// A description of the volume.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment, whose clusters can attach to
	// the volume.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// Specifies the configuration for the Network attached storage (NAS_1) file
	// system volume.
	Nas1Configuration *KxNAS1Configuration `locationName:"nas1Configuration" type:"structure"`

	// The status of volume creation.
	//
	//    * CREATING – The volume creation is in progress.
	//
	//    * CREATE_FAILED – The volume creation has failed.
	//
	//    * ACTIVE – The volume is active.
	//
	//    * UPDATING – The volume is in the process of being updated.
	//
	//    * UPDATE_FAILED – The update action failed.
	//
	//    * UPDATED – The volume is successfully updated.
	//
	//    * DELETING – The volume is in the process of being deleted.
	//
	//    * DELETE_FAILED – The system failed to delete the volume.
	//
	//    * DELETED – The volume is successfully deleted.
	Status *string `locationName:"status" type:"string" enum:"KxVolumeStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`

	// The ARN identifier of the volume.
	VolumeArn *string `locationName:"volumeArn" min:"20" type:"string"`

	// A unique identifier for the volume.
	VolumeName *string `locationName:"volumeName" min:"3" type:"string"`

	// The type of file system volume. Currently, FinSpace only supports NAS_1 volume
	// type.
	VolumeType *string `locationName:"volumeType" type:"string" enum:"KxVolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKxVolumeOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneIds sets the AvailabilityZoneIds field's value.
func (s *CreateKxVolumeOutput) SetAvailabilityZoneIds(v []*string) *CreateKxVolumeOutput {
	s.AvailabilityZoneIds = v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *CreateKxVolumeOutput) SetAzMode(v string) *CreateKxVolumeOutput {
	s.AzMode = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateKxVolumeOutput) SetCreatedTimestamp(v time.Time) *CreateKxVolumeOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKxVolumeOutput) SetDescription(v string) *CreateKxVolumeOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateKxVolumeOutput) SetEnvironmentId(v string) *CreateKxVolumeOutput {
	s.EnvironmentId = &v
	return s
}

// SetNas1Configuration sets the Nas1Configuration field's value.
func (s *CreateKxVolumeOutput) SetNas1Configuration(v *KxNAS1Configuration) *CreateKxVolumeOutput {
	s.Nas1Configuration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateKxVolumeOutput) SetStatus(v string) *CreateKxVolumeOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *CreateKxVolumeOutput) SetStatusReason(v string) *CreateKxVolumeOutput {
	s.StatusReason = &v
	return s
}

// SetVolumeArn sets the VolumeArn field's value.
func (s *CreateKxVolumeOutput) SetVolumeArn(v string) *CreateKxVolumeOutput {
	s.VolumeArn = &v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *CreateKxVolumeOutput) SetVolumeName(v string) *CreateKxVolumeOutput {
	s.VolumeName = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *CreateKxVolumeOutput) SetVolumeType(v string) *CreateKxVolumeOutput {
	s.VolumeType = &v
	return s
}

// A list of DNS server name and server IP. This is used to set up Route-53
// outbound resolvers.
type CustomDNSServer struct {
	_ struct{} `type:"structure"`

	// The IP address of the DNS server.
	//
	// CustomDNSServerIP is a required field
	CustomDNSServerIP *string `locationName:"customDNSServerIP" type:"string" required:"true"`

	// The name of the DNS server.
	//
	// CustomDNSServerName is a required field
	CustomDNSServerName *string `locationName:"customDNSServerName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomDNSServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomDNSServer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomDNSServer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomDNSServer"}
	if s.CustomDNSServerIP == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomDNSServerIP"))
	}
	if s.CustomDNSServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomDNSServerName"))
	}
	if s.CustomDNSServerName != nil && len(*s.CustomDNSServerName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDNSServerName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomDNSServerIP sets the CustomDNSServerIP field's value.
func (s *CustomDNSServer) SetCustomDNSServerIP(v string) *CustomDNSServer {
	s.CustomDNSServerIP = &v
	return s
}

// SetCustomDNSServerName sets the CustomDNSServerName field's value.
func (s *CustomDNSServer) SetCustomDNSServerName(v string) *CustomDNSServer {
	s.CustomDNSServerName = &v
	return s
}

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the FinSpace environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteEnvironmentInput) SetEnvironmentId(v string) *DeleteEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) GoString() string {
	return s.String()
}

type DeleteKxClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the cluster that you want to delete.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"clusterName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKxClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKxClusterInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteKxClusterInput) SetClientToken(v string) *DeleteKxClusterInput {
	s.ClientToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteKxClusterInput) SetClusterName(v string) *DeleteKxClusterInput {
	s.ClusterName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteKxClusterInput) SetEnvironmentId(v string) *DeleteKxClusterInput {
	s.EnvironmentId = &v
	return s
}

type DeleteKxClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxClusterOutput) GoString() string {
	return s.String()
}

type DeleteKxDatabaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the kdb database that you want to delete.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKxDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKxDatabaseInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteKxDatabaseInput) SetClientToken(v string) *DeleteKxDatabaseInput {
	s.ClientToken = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteKxDatabaseInput) SetDatabaseName(v string) *DeleteKxDatabaseInput {
	s.DatabaseName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteKxDatabaseInput) SetEnvironmentId(v string) *DeleteKxDatabaseInput {
	s.EnvironmentId = &v
	return s
}

type DeleteKxDatabaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxDatabaseOutput) GoString() string {
	return s.String()
}

type DeleteKxDataviewInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the database whose dataview you want to delete.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// The name of the dataview that you want to delete.
	//
	// DataviewName is a required field
	DataviewName *string `location:"uri" locationName:"dataviewName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment, from where you want to delete
	// the dataview.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxDataviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxDataviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKxDataviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKxDataviewInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.DataviewName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataviewName"))
	}
	if s.DataviewName != nil && len(*s.DataviewName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DataviewName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteKxDataviewInput) SetClientToken(v string) *DeleteKxDataviewInput {
	s.ClientToken = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteKxDataviewInput) SetDatabaseName(v string) *DeleteKxDataviewInput {
	s.DatabaseName = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *DeleteKxDataviewInput) SetDataviewName(v string) *DeleteKxDataviewInput {
	s.DataviewName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteKxDataviewInput) SetEnvironmentId(v string) *DeleteKxDataviewInput {
	s.EnvironmentId = &v
	return s
}

type DeleteKxDataviewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxDataviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxDataviewOutput) GoString() string {
	return s.String()
}

type DeleteKxEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKxEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKxEnvironmentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteKxEnvironmentInput) SetClientToken(v string) *DeleteKxEnvironmentInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteKxEnvironmentInput) SetEnvironmentId(v string) *DeleteKxEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type DeleteKxEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxEnvironmentOutput) GoString() string {
	return s.String()
}

type DeleteKxScalingGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A unique identifier for the kdb environment, from where you want to delete
	// the dataview.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// A unique identifier for the kdb scaling group.
	//
	// ScalingGroupName is a required field
	ScalingGroupName *string `location:"uri" locationName:"scalingGroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKxScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKxScalingGroupInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.ScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingGroupName"))
	}
	if s.ScalingGroupName != nil && len(*s.ScalingGroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingGroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteKxScalingGroupInput) SetClientToken(v string) *DeleteKxScalingGroupInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteKxScalingGroupInput) SetEnvironmentId(v string) *DeleteKxScalingGroupInput {
	s.EnvironmentId = &v
	return s
}

// SetScalingGroupName sets the ScalingGroupName field's value.
func (s *DeleteKxScalingGroupInput) SetScalingGroupName(v string) *DeleteKxScalingGroupInput {
	s.ScalingGroupName = &v
	return s
}

type DeleteKxScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxScalingGroupOutput) GoString() string {
	return s.String()
}

type DeleteKxUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// A unique identifier for the user that you want to delete.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"userName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKxUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKxUserInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteKxUserInput) SetClientToken(v string) *DeleteKxUserInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteKxUserInput) SetEnvironmentId(v string) *DeleteKxUserInput {
	s.EnvironmentId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteKxUserInput) SetUserName(v string) *DeleteKxUserInput {
	s.UserName = &v
	return s
}

type DeleteKxUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxUserOutput) GoString() string {
	return s.String()
}

type DeleteKxVolumeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A unique identifier for the kdb environment, whose clusters can attach to
	// the volume.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The name of the volume that you want to delete.
	//
	// VolumeName is a required field
	VolumeName *string `location:"uri" locationName:"volumeName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKxVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKxVolumeInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.VolumeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeName"))
	}
	if s.VolumeName != nil && len(*s.VolumeName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteKxVolumeInput) SetClientToken(v string) *DeleteKxVolumeInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteKxVolumeInput) SetEnvironmentId(v string) *DeleteKxVolumeInput {
	s.EnvironmentId = &v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *DeleteKxVolumeInput) SetVolumeName(v string) *DeleteKxVolumeInput {
	s.VolumeName = &v
	return s
}

type DeleteKxVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKxVolumeOutput) GoString() string {
	return s.String()
}

// Represents an FinSpace environment.
type Environment struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account in which the FinSpace environment is created.
	AwsAccountId *string `locationName:"awsAccountId" min:"1" type:"string"`

	// The AWS account ID of the dedicated service account associated with your
	// FinSpace environment.
	DedicatedServiceAccountId *string `locationName:"dedicatedServiceAccountId" min:"1" type:"string"`

	// The description of the FinSpace environment.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of your FinSpace environment.
	EnvironmentArn *string `locationName:"environmentArn" min:"20" type:"string"`

	// The identifier of the FinSpace environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The sign-in URL for the web application of your FinSpace environment.
	EnvironmentUrl *string `locationName:"environmentUrl" min:"1" type:"string"`

	// The authentication mode for the environment.
	FederationMode *string `locationName:"federationMode" type:"string" enum:"FederationMode"`

	// Configuration information when authentication mode is FEDERATED.
	FederationParameters *FederationParameters `locationName:"federationParameters" type:"structure"`

	// The KMS key id used to encrypt in the FinSpace environment.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the FinSpace environment.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The URL of the integrated FinSpace notebook environment in your web application.
	SageMakerStudioDomainUrl *string `locationName:"sageMakerStudioDomainUrl" min:"1" type:"string"`

	// The current status of creation of the FinSpace environment.
	Status *string `locationName:"status" type:"string" enum:"EnvironmentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Environment) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *Environment) SetAwsAccountId(v string) *Environment {
	s.AwsAccountId = &v
	return s
}

// SetDedicatedServiceAccountId sets the DedicatedServiceAccountId field's value.
func (s *Environment) SetDedicatedServiceAccountId(v string) *Environment {
	s.DedicatedServiceAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Environment) SetDescription(v string) *Environment {
	s.Description = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *Environment) SetEnvironmentArn(v string) *Environment {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *Environment) SetEnvironmentId(v string) *Environment {
	s.EnvironmentId = &v
	return s
}

// SetEnvironmentUrl sets the EnvironmentUrl field's value.
func (s *Environment) SetEnvironmentUrl(v string) *Environment {
	s.EnvironmentUrl = &v
	return s
}

// SetFederationMode sets the FederationMode field's value.
func (s *Environment) SetFederationMode(v string) *Environment {
	s.FederationMode = &v
	return s
}

// SetFederationParameters sets the FederationParameters field's value.
func (s *Environment) SetFederationParameters(v *FederationParameters) *Environment {
	s.FederationParameters = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Environment) SetKmsKeyId(v string) *Environment {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Environment) SetName(v string) *Environment {
	s.Name = &v
	return s
}

// SetSageMakerStudioDomainUrl sets the SageMakerStudioDomainUrl field's value.
func (s *Environment) SetSageMakerStudioDomainUrl(v string) *Environment {
	s.SageMakerStudioDomainUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Environment) SetStatus(v string) *Environment {
	s.Status = &v
	return s
}

// Provides details in the event of a failed flow, including the error type
// and the related error message.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the error message that appears if a flow fails.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Specifies the type of error.
	ErrorType *string `locationName:"errorType" type:"string" enum:"ErrorDetails"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorInfo) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorInfo) SetErrorMessage(v string) *ErrorInfo {
	s.ErrorMessage = &v
	return s
}

// SetErrorType sets the ErrorType field's value.
func (s *ErrorInfo) SetErrorType(v string) *ErrorInfo {
	s.ErrorType = &v
	return s
}

// Configuration information when authentication mode is FEDERATED.
type FederationParameters struct {
	_ struct{} `type:"structure"`

	// The redirect or sign-in URL that should be entered into the SAML 2.0 compliant
	// identity provider configuration (IdP).
	ApplicationCallBackURL *string `locationName:"applicationCallBackURL" min:"1" type:"string"`

	// SAML attribute name and value. The name must always be Email and the value
	// should be set to the attribute definition in which user email is set. For
	// example, name would be Email and value http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress.
	// Please check your SAML 2.0 compliant identity provider (IdP) documentation
	// for details.
	AttributeMap map[string]*string `locationName:"attributeMap" type:"map"`

	// Name of the identity provider (IdP).
	FederationProviderName *string `locationName:"federationProviderName" min:"1" type:"string"`

	// The Uniform Resource Name (URN). Also referred as Service Provider URN or
	// Audience URI or Service Provider Entity ID.
	FederationURN *string `locationName:"federationURN" min:"1" type:"string"`

	// SAML 2.0 Metadata document from identity provider (IdP).
	SamlMetadataDocument *string `locationName:"samlMetadataDocument" min:"1000" type:"string"`

	// Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).
	SamlMetadataURL *string `locationName:"samlMetadataURL" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FederationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FederationParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FederationParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FederationParameters"}
	if s.ApplicationCallBackURL != nil && len(*s.ApplicationCallBackURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationCallBackURL", 1))
	}
	if s.FederationProviderName != nil && len(*s.FederationProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FederationProviderName", 1))
	}
	if s.FederationURN != nil && len(*s.FederationURN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FederationURN", 1))
	}
	if s.SamlMetadataDocument != nil && len(*s.SamlMetadataDocument) < 1000 {
		invalidParams.Add(request.NewErrParamMinLen("SamlMetadataDocument", 1000))
	}
	if s.SamlMetadataURL != nil && len(*s.SamlMetadataURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SamlMetadataURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationCallBackURL sets the ApplicationCallBackURL field's value.
func (s *FederationParameters) SetApplicationCallBackURL(v string) *FederationParameters {
	s.ApplicationCallBackURL = &v
	return s
}

// SetAttributeMap sets the AttributeMap field's value.
func (s *FederationParameters) SetAttributeMap(v map[string]*string) *FederationParameters {
	s.AttributeMap = v
	return s
}

// SetFederationProviderName sets the FederationProviderName field's value.
func (s *FederationParameters) SetFederationProviderName(v string) *FederationParameters {
	s.FederationProviderName = &v
	return s
}

// SetFederationURN sets the FederationURN field's value.
func (s *FederationParameters) SetFederationURN(v string) *FederationParameters {
	s.FederationURN = &v
	return s
}

// SetSamlMetadataDocument sets the SamlMetadataDocument field's value.
func (s *FederationParameters) SetSamlMetadataDocument(v string) *FederationParameters {
	s.SamlMetadataDocument = &v
	return s
}

// SetSamlMetadataURL sets the SamlMetadataURL field's value.
func (s *FederationParameters) SetSamlMetadataURL(v string) *FederationParameters {
	s.SamlMetadataURL = &v
	return s
}

type GetEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the FinSpace environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetEnvironmentInput) SetEnvironmentId(v string) *GetEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type GetEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The name of the FinSpace environment.
	Environment *Environment `locationName:"environment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *GetEnvironmentOutput) SetEnvironment(v *Environment) *GetEnvironmentOutput {
	s.Environment = v
	return s
}

type GetKxChangesetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier of the changeset for which you want to retrieve data.
	//
	// ChangesetId is a required field
	ChangesetId *string `location:"uri" locationName:"changesetId" min:"1" type:"string" required:"true"`

	// The name of the kdb database.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxChangesetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxChangesetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKxChangesetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKxChangesetInput"}
	if s.ChangesetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangesetId"))
	}
	if s.ChangesetId != nil && len(*s.ChangesetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangesetId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangesetId sets the ChangesetId field's value.
func (s *GetKxChangesetInput) SetChangesetId(v string) *GetKxChangesetInput {
	s.ChangesetId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetKxChangesetInput) SetDatabaseName(v string) *GetKxChangesetInput {
	s.DatabaseName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxChangesetInput) SetEnvironmentId(v string) *GetKxChangesetInput {
	s.EnvironmentId = &v
	return s
}

type GetKxChangesetOutput struct {
	_ struct{} `type:"structure"`

	// Beginning time from which the changeset is active. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	ActiveFromTimestamp *time.Time `locationName:"activeFromTimestamp" type:"timestamp"`

	// A list of change request objects that are run in order.
	ChangeRequests []*ChangeRequest `locationName:"changeRequests" min:"1" type:"list"`

	// A unique identifier for the changeset.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The timestamp at which the changeset was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The name of the kdb database.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// Provides details in the event of a failed flow, including the error type
	// and the related error message.
	ErrorInfo *ErrorInfo `locationName:"errorInfo" type:"structure"`

	// The timestamp at which the changeset was updated in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// Status of the changeset creation process.
	//
	//    * Pending – Changeset creation is pending.
	//
	//    * Processing – Changeset creation is running.
	//
	//    * Failed – Changeset creation has failed.
	//
	//    * Complete – Changeset creation has succeeded.
	Status *string `locationName:"status" type:"string" enum:"ChangesetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxChangesetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxChangesetOutput) GoString() string {
	return s.String()
}

// SetActiveFromTimestamp sets the ActiveFromTimestamp field's value.
func (s *GetKxChangesetOutput) SetActiveFromTimestamp(v time.Time) *GetKxChangesetOutput {
	s.ActiveFromTimestamp = &v
	return s
}

// SetChangeRequests sets the ChangeRequests field's value.
func (s *GetKxChangesetOutput) SetChangeRequests(v []*ChangeRequest) *GetKxChangesetOutput {
	s.ChangeRequests = v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *GetKxChangesetOutput) SetChangesetId(v string) *GetKxChangesetOutput {
	s.ChangesetId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetKxChangesetOutput) SetCreatedTimestamp(v time.Time) *GetKxChangesetOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetKxChangesetOutput) SetDatabaseName(v string) *GetKxChangesetOutput {
	s.DatabaseName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxChangesetOutput) SetEnvironmentId(v string) *GetKxChangesetOutput {
	s.EnvironmentId = &v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *GetKxChangesetOutput) SetErrorInfo(v *ErrorInfo) *GetKxChangesetOutput {
	s.ErrorInfo = v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *GetKxChangesetOutput) SetLastModifiedTimestamp(v time.Time) *GetKxChangesetOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetKxChangesetOutput) SetStatus(v string) *GetKxChangesetOutput {
	s.Status = &v
	return s
}

type GetKxClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the cluster that you want to retrieve.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"clusterName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKxClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKxClusterInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *GetKxClusterInput) SetClusterName(v string) *GetKxClusterInput {
	s.ClusterName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxClusterInput) SetEnvironmentId(v string) *GetKxClusterInput {
	s.EnvironmentId = &v
	return s
}

type GetKxClusterOutput struct {
	_ struct{} `type:"structure"`

	// The configuration based on which FinSpace will scale in or scale out nodes
	// in your cluster.
	AutoScalingConfiguration *AutoScalingConfiguration `locationName:"autoScalingConfiguration" type:"structure"`

	// The availability zone identifiers for the requested regions.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of availability zones you want to assign per cluster. This can
	// be one of the following
	//
	//    * SINGLE – Assigns one availability zone per cluster.
	//
	//    * MULTI – Assigns all the availability zones per cluster.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// The configurations for a read only cache storage associated with a cluster.
	// This cache will be stored as an FSx Lustre that reads from the S3 store.
	CacheStorageConfigurations []*KxCacheStorageConfiguration `locationName:"cacheStorageConfigurations" type:"list"`

	// A structure for the metadata of a cluster. It includes information like the
	// CPUs needed, memory of instances, and number of instances.
	CapacityConfiguration *CapacityConfiguration `locationName:"capacityConfiguration" type:"structure"`

	// A description of the cluster.
	ClusterDescription *string `locationName:"clusterDescription" min:"1" type:"string"`

	// A unique name for the cluster.
	ClusterName *string `locationName:"clusterName" min:"3" type:"string"`

	// Specifies the type of KDB database that is being created. The following types
	// are available:
	//
	//    * HDB – A Historical Database. The data is only accessible with read-only
	//    permissions from one of the FinSpace managed kdb databases mounted to
	//    the cluster.
	//
	//    * RDB – A Realtime Database. This type of database captures all the
	//    data from a ticker plant and stores it in memory until the end of day,
	//    after which it writes all of its data to a disk and reloads the HDB. This
	//    cluster type requires local storage for temporary storage of data during
	//    the savedown process. If you specify this field in your request, you must
	//    provide the savedownStorageConfiguration parameter.
	//
	//    * GATEWAY – A gateway cluster allows you to access data across processes
	//    in kdb systems. It allows you to create your own routing logic using the
	//    initialization scripts and custom code. This type of cluster does not
	//    require a writable local storage.
	//
	//    * GP – A general purpose cluster allows you to quickly iterate on code
	//    during development by granting greater access to system commands and enabling
	//    a fast reload of custom code. This cluster type can optionally mount databases
	//    including cache and savedown storage. For this cluster type, the node
	//    count is fixed at 1. It does not support autoscaling and supports only
	//    SINGLE AZ mode.
	//
	//    * Tickerplant – A tickerplant cluster allows you to subscribe to feed
	//    handlers based on IAM permissions. It can publish to RDBs, other Tickerplants,
	//    and real-time subscribers (RTS). Tickerplants can persist messages to
	//    log, which is readable by any RDB environment. It supports only single-node
	//    that is only one kdb process.
	ClusterType *string `locationName:"clusterType" type:"string" enum:"KxClusterType"`

	// The details of the custom code that you want to use inside a cluster when
	// analyzing a data. It consists of the S3 source bucket, location, S3 object
	// version, and the relative path from where the custom code is loaded into
	// the cluster.
	Code *CodeConfiguration `locationName:"code" type:"structure"`

	// Defines key-value pairs to make them available inside the cluster.
	CommandLineArguments []*KxCommandLineArgument `locationName:"commandLineArguments" type:"list"`

	// The timestamp at which the cluster was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// A list of databases mounted on the cluster.
	Databases []*KxDatabaseConfiguration `locationName:"databases" type:"list"`

	// An IAM role that defines a set of permissions associated with a cluster.
	// These permissions are assumed when a cluster attempts to access another cluster.
	ExecutionRole *string `locationName:"executionRole" min:"1" type:"string"`

	// Specifies a Q program that will be run at launch of a cluster. It is a relative
	// path within .zip file that contains the custom code, which will be loaded
	// on the cluster. It must include the file name itself. For example, somedir/init.q.
	InitializationScript *string `locationName:"initializationScript" min:"1" type:"string"`

	// The last time that the cluster was modified. The value is determined as epoch
	// time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The version of FinSpace managed kdb to run.
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string"`

	// The size and type of the temporary storage that is used to hold data during
	// the savedown process. This parameter is required when you choose clusterType
	// as RDB. All the data written to this storage space is lost when the cluster
	// node is restarted.
	SavedownStorageConfiguration *KxSavedownStorageConfiguration `locationName:"savedownStorageConfiguration" type:"structure"`

	// The structure that stores the capacity configuration details of a scaling
	// group.
	ScalingGroupConfiguration *KxScalingGroupConfiguration `locationName:"scalingGroupConfiguration" type:"structure"`

	// The status of cluster creation.
	//
	//    * PENDING – The cluster is pending creation.
	//
	//    * CREATING – The cluster creation process is in progress.
	//
	//    * CREATE_FAILED – The cluster creation process has failed.
	//
	//    * RUNNING – The cluster creation process is running.
	//
	//    * UPDATING – The cluster is in the process of being updated.
	//
	//    * DELETING – The cluster is in the process of being deleted.
	//
	//    * DELETED – The cluster has been deleted.
	//
	//    * DELETE_FAILED – The cluster failed to delete.
	Status *string `locationName:"status" type:"string" enum:"KxClusterStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`

	// A configuration to store the Tickerplant logs. It consists of a list of volumes
	// that will be mounted to your cluster. For the cluster type Tickerplant, the
	// location of the TP volume on the cluster will be available by using the global
	// variable .aws.tp_log_path.
	TickerplantLogConfiguration *TickerplantLogConfiguration `locationName:"tickerplantLogConfiguration" type:"structure"`

	// A list of volumes attached to the cluster.
	Volumes []*Volume `locationName:"volumes" type:"list"`

	// Configuration details about the network where the Privatelink endpoint of
	// the cluster resides.
	VpcConfiguration *VpcConfiguration `locationName:"vpcConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxClusterOutput) GoString() string {
	return s.String()
}

// SetAutoScalingConfiguration sets the AutoScalingConfiguration field's value.
func (s *GetKxClusterOutput) SetAutoScalingConfiguration(v *AutoScalingConfiguration) *GetKxClusterOutput {
	s.AutoScalingConfiguration = v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *GetKxClusterOutput) SetAvailabilityZoneId(v string) *GetKxClusterOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *GetKxClusterOutput) SetAzMode(v string) *GetKxClusterOutput {
	s.AzMode = &v
	return s
}

// SetCacheStorageConfigurations sets the CacheStorageConfigurations field's value.
func (s *GetKxClusterOutput) SetCacheStorageConfigurations(v []*KxCacheStorageConfiguration) *GetKxClusterOutput {
	s.CacheStorageConfigurations = v
	return s
}

// SetCapacityConfiguration sets the CapacityConfiguration field's value.
func (s *GetKxClusterOutput) SetCapacityConfiguration(v *CapacityConfiguration) *GetKxClusterOutput {
	s.CapacityConfiguration = v
	return s
}

// SetClusterDescription sets the ClusterDescription field's value.
func (s *GetKxClusterOutput) SetClusterDescription(v string) *GetKxClusterOutput {
	s.ClusterDescription = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *GetKxClusterOutput) SetClusterName(v string) *GetKxClusterOutput {
	s.ClusterName = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *GetKxClusterOutput) SetClusterType(v string) *GetKxClusterOutput {
	s.ClusterType = &v
	return s
}

// SetCode sets the Code field's value.
func (s *GetKxClusterOutput) SetCode(v *CodeConfiguration) *GetKxClusterOutput {
	s.Code = v
	return s
}

// SetCommandLineArguments sets the CommandLineArguments field's value.
func (s *GetKxClusterOutput) SetCommandLineArguments(v []*KxCommandLineArgument) *GetKxClusterOutput {
	s.CommandLineArguments = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetKxClusterOutput) SetCreatedTimestamp(v time.Time) *GetKxClusterOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabases sets the Databases field's value.
func (s *GetKxClusterOutput) SetDatabases(v []*KxDatabaseConfiguration) *GetKxClusterOutput {
	s.Databases = v
	return s
}

// SetExecutionRole sets the ExecutionRole field's value.
func (s *GetKxClusterOutput) SetExecutionRole(v string) *GetKxClusterOutput {
	s.ExecutionRole = &v
	return s
}

// SetInitializationScript sets the InitializationScript field's value.
func (s *GetKxClusterOutput) SetInitializationScript(v string) *GetKxClusterOutput {
	s.InitializationScript = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *GetKxClusterOutput) SetLastModifiedTimestamp(v time.Time) *GetKxClusterOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *GetKxClusterOutput) SetReleaseLabel(v string) *GetKxClusterOutput {
	s.ReleaseLabel = &v
	return s
}

// SetSavedownStorageConfiguration sets the SavedownStorageConfiguration field's value.
func (s *GetKxClusterOutput) SetSavedownStorageConfiguration(v *KxSavedownStorageConfiguration) *GetKxClusterOutput {
	s.SavedownStorageConfiguration = v
	return s
}

// SetScalingGroupConfiguration sets the ScalingGroupConfiguration field's value.
func (s *GetKxClusterOutput) SetScalingGroupConfiguration(v *KxScalingGroupConfiguration) *GetKxClusterOutput {
	s.ScalingGroupConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetKxClusterOutput) SetStatus(v string) *GetKxClusterOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetKxClusterOutput) SetStatusReason(v string) *GetKxClusterOutput {
	s.StatusReason = &v
	return s
}

// SetTickerplantLogConfiguration sets the TickerplantLogConfiguration field's value.
func (s *GetKxClusterOutput) SetTickerplantLogConfiguration(v *TickerplantLogConfiguration) *GetKxClusterOutput {
	s.TickerplantLogConfiguration = v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *GetKxClusterOutput) SetVolumes(v []*Volume) *GetKxClusterOutput {
	s.Volumes = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *GetKxClusterOutput) SetVpcConfiguration(v *VpcConfiguration) *GetKxClusterOutput {
	s.VpcConfiguration = v
	return s
}

type GetKxConnectionStringInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A name of the kdb cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"querystring" locationName:"clusterName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the user. For more information
	// about ARNs and how to use ARNs in policies, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	//
	// UserArn is a required field
	UserArn *string `location:"querystring" locationName:"userArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxConnectionStringInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxConnectionStringInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKxConnectionStringInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKxConnectionStringInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *GetKxConnectionStringInput) SetClusterName(v string) *GetKxConnectionStringInput {
	s.ClusterName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxConnectionStringInput) SetEnvironmentId(v string) *GetKxConnectionStringInput {
	s.EnvironmentId = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *GetKxConnectionStringInput) SetUserArn(v string) *GetKxConnectionStringInput {
	s.UserArn = &v
	return s
}

type GetKxConnectionStringOutput struct {
	_ struct{} `type:"structure"`

	// The signed connection string that you can use to connect to clusters.
	//
	// SignedConnectionString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetKxConnectionStringOutput's
	// String and GoString methods.
	SignedConnectionString *string `locationName:"signedConnectionString" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxConnectionStringOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxConnectionStringOutput) GoString() string {
	return s.String()
}

// SetSignedConnectionString sets the SignedConnectionString field's value.
func (s *GetKxConnectionStringOutput) SetSignedConnectionString(v string) *GetKxConnectionStringOutput {
	s.SignedConnectionString = &v
	return s
}

type GetKxDatabaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the kdb database.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKxDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKxDatabaseInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetKxDatabaseInput) SetDatabaseName(v string) *GetKxDatabaseInput {
	s.DatabaseName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxDatabaseInput) SetEnvironmentId(v string) *GetKxDatabaseInput {
	s.EnvironmentId = &v
	return s
}

type GetKxDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp at which the database is created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The ARN identifier of the database.
	DatabaseArn *string `locationName:"databaseArn" type:"string"`

	// The name of the kdb database for which the information is retrieved.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// A description of the database.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// A unique identifier for the changeset.
	LastCompletedChangesetId *string `locationName:"lastCompletedChangesetId" min:"1" type:"string"`

	// The last time that the database was modified. The value is determined as
	// epoch time in milliseconds. For example, the value for Monday, November 1,
	// 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The total number of bytes in the database.
	NumBytes *int64 `locationName:"numBytes" type:"long"`

	// The total number of changesets in the database.
	NumChangesets *int64 `locationName:"numChangesets" type:"integer"`

	// The total number of files in the database.
	NumFiles *int64 `locationName:"numFiles" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxDatabaseOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetKxDatabaseOutput) SetCreatedTimestamp(v time.Time) *GetKxDatabaseOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabaseArn sets the DatabaseArn field's value.
func (s *GetKxDatabaseOutput) SetDatabaseArn(v string) *GetKxDatabaseOutput {
	s.DatabaseArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetKxDatabaseOutput) SetDatabaseName(v string) *GetKxDatabaseOutput {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetKxDatabaseOutput) SetDescription(v string) *GetKxDatabaseOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxDatabaseOutput) SetEnvironmentId(v string) *GetKxDatabaseOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastCompletedChangesetId sets the LastCompletedChangesetId field's value.
func (s *GetKxDatabaseOutput) SetLastCompletedChangesetId(v string) *GetKxDatabaseOutput {
	s.LastCompletedChangesetId = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *GetKxDatabaseOutput) SetLastModifiedTimestamp(v time.Time) *GetKxDatabaseOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetNumBytes sets the NumBytes field's value.
func (s *GetKxDatabaseOutput) SetNumBytes(v int64) *GetKxDatabaseOutput {
	s.NumBytes = &v
	return s
}

// SetNumChangesets sets the NumChangesets field's value.
func (s *GetKxDatabaseOutput) SetNumChangesets(v int64) *GetKxDatabaseOutput {
	s.NumChangesets = &v
	return s
}

// SetNumFiles sets the NumFiles field's value.
func (s *GetKxDatabaseOutput) SetNumFiles(v int64) *GetKxDatabaseOutput {
	s.NumFiles = &v
	return s
}

type GetKxDataviewInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the database where you created the dataview.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A unique identifier for the dataview.
	//
	// DataviewName is a required field
	DataviewName *string `location:"uri" locationName:"dataviewName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment, from where you want to retrieve
	// the dataview details.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxDataviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxDataviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKxDataviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKxDataviewInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.DataviewName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataviewName"))
	}
	if s.DataviewName != nil && len(*s.DataviewName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DataviewName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetKxDataviewInput) SetDatabaseName(v string) *GetKxDataviewInput {
	s.DatabaseName = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *GetKxDataviewInput) SetDataviewName(v string) *GetKxDataviewInput {
	s.DataviewName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxDataviewInput) SetEnvironmentId(v string) *GetKxDataviewInput {
	s.EnvironmentId = &v
	return s
}

type GetKxDataviewOutput struct {
	_ struct{} `type:"structure"`

	// The current active changeset versions of the database on the given dataview.
	ActiveVersions []*KxDataviewActiveVersion `locationName:"activeVersions" type:"list"`

	// The option to specify whether you want to apply all the future additions
	// and corrections automatically to the dataview when new changesets are ingested.
	// The default value is false.
	AutoUpdate *bool `locationName:"autoUpdate" type:"boolean"`

	// The identifier of the availability zones.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of availability zones you want to assign per cluster. This can
	// be one of the following
	//
	//    * SINGLE – Assigns one availability zone per cluster.
	//
	//    * MULTI – Assigns all the availability zones per cluster.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// A unique identifier of the changeset that you want to use to ingest data.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The timestamp at which the dataview was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The name of the database where you created the dataview.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// A unique identifier for the dataview.
	DataviewName *string `locationName:"dataviewName" min:"3" type:"string"`

	// A description of the dataview.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment, from where you want to retrieve
	// the dataview details.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The last time that the dataview was updated in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The configuration that contains the database path of the data that you want
	// to place on each selected volume. Each segment must have a unique database
	// path for each volume. If you do not explicitly specify any database path
	// for a volume, they are accessible from the cluster through the default S3/object
	// store segment.
	SegmentConfigurations []*KxDataviewSegmentConfiguration `locationName:"segmentConfigurations" type:"list"`

	// The status of dataview creation.
	//
	//    * CREATING – The dataview creation is in progress.
	//
	//    * UPDATING – The dataview is in the process of being updated.
	//
	//    * ACTIVE – The dataview is active.
	Status *string `locationName:"status" type:"string" enum:"KxDataviewStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxDataviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxDataviewOutput) GoString() string {
	return s.String()
}

// SetActiveVersions sets the ActiveVersions field's value.
func (s *GetKxDataviewOutput) SetActiveVersions(v []*KxDataviewActiveVersion) *GetKxDataviewOutput {
	s.ActiveVersions = v
	return s
}

// SetAutoUpdate sets the AutoUpdate field's value.
func (s *GetKxDataviewOutput) SetAutoUpdate(v bool) *GetKxDataviewOutput {
	s.AutoUpdate = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *GetKxDataviewOutput) SetAvailabilityZoneId(v string) *GetKxDataviewOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *GetKxDataviewOutput) SetAzMode(v string) *GetKxDataviewOutput {
	s.AzMode = &v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *GetKxDataviewOutput) SetChangesetId(v string) *GetKxDataviewOutput {
	s.ChangesetId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetKxDataviewOutput) SetCreatedTimestamp(v time.Time) *GetKxDataviewOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetKxDataviewOutput) SetDatabaseName(v string) *GetKxDataviewOutput {
	s.DatabaseName = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *GetKxDataviewOutput) SetDataviewName(v string) *GetKxDataviewOutput {
	s.DataviewName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetKxDataviewOutput) SetDescription(v string) *GetKxDataviewOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxDataviewOutput) SetEnvironmentId(v string) *GetKxDataviewOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *GetKxDataviewOutput) SetLastModifiedTimestamp(v time.Time) *GetKxDataviewOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSegmentConfigurations sets the SegmentConfigurations field's value.
func (s *GetKxDataviewOutput) SetSegmentConfigurations(v []*KxDataviewSegmentConfiguration) *GetKxDataviewOutput {
	s.SegmentConfigurations = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetKxDataviewOutput) SetStatus(v string) *GetKxDataviewOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetKxDataviewOutput) SetStatusReason(v string) *GetKxDataviewOutput {
	s.StatusReason = &v
	return s
}

type GetKxEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKxEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKxEnvironmentInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxEnvironmentInput) SetEnvironmentId(v string) *GetKxEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type GetKxEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones where subnets for the environment
	// are created.
	AvailabilityZoneIds []*string `locationName:"availabilityZoneIds" type:"list"`

	// The unique identifier of the AWS account that is used to create the kdb environment.
	AwsAccountId *string `locationName:"awsAccountId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the certificate authority of the kdb environment.
	CertificateAuthorityArn *string `locationName:"certificateAuthorityArn" min:"1" type:"string"`

	// The timestamp at which the kdb environment was created in FinSpace.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// A list of DNS server name and server IP. This is used to set up Route-53
	// outbound resolvers.
	CustomDNSConfiguration []*CustomDNSServer `locationName:"customDNSConfiguration" type:"list"`

	// A unique identifier for the AWS environment infrastructure account.
	DedicatedServiceAccountId *string `locationName:"dedicatedServiceAccountId" min:"1" type:"string"`

	// A description for the kdb environment.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The status of DNS configuration.
	DnsStatus *string `locationName:"dnsStatus" type:"string" enum:"DnsStatus"`

	// The ARN identifier of the environment.
	EnvironmentArn *string `locationName:"environmentArn" min:"20" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// Specifies the error message that appears if a flow fails.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The KMS key ID to encrypt your data in the FinSpace environment.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the kdb environment.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status of the kdb environment.
	Status *string `locationName:"status" type:"string" enum:"EnvironmentStatus"`

	// The status of the network configuration.
	TgwStatus *string `locationName:"tgwStatus" type:"string" enum:"TgwStatus"`

	// The structure of the transit gateway and network configuration that is used
	// to connect the kdb environment to an internal network.
	TransitGatewayConfiguration *TransitGatewayConfiguration `locationName:"transitGatewayConfiguration" type:"structure"`

	// The timestamp at which the kdb environment was updated.
	UpdateTimestamp *time.Time `locationName:"updateTimestamp" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxEnvironmentOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneIds sets the AvailabilityZoneIds field's value.
func (s *GetKxEnvironmentOutput) SetAvailabilityZoneIds(v []*string) *GetKxEnvironmentOutput {
	s.AvailabilityZoneIds = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *GetKxEnvironmentOutput) SetAwsAccountId(v string) *GetKxEnvironmentOutput {
	s.AwsAccountId = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *GetKxEnvironmentOutput) SetCertificateAuthorityArn(v string) *GetKxEnvironmentOutput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetKxEnvironmentOutput) SetCreationTimestamp(v time.Time) *GetKxEnvironmentOutput {
	s.CreationTimestamp = &v
	return s
}

// SetCustomDNSConfiguration sets the CustomDNSConfiguration field's value.
func (s *GetKxEnvironmentOutput) SetCustomDNSConfiguration(v []*CustomDNSServer) *GetKxEnvironmentOutput {
	s.CustomDNSConfiguration = v
	return s
}

// SetDedicatedServiceAccountId sets the DedicatedServiceAccountId field's value.
func (s *GetKxEnvironmentOutput) SetDedicatedServiceAccountId(v string) *GetKxEnvironmentOutput {
	s.DedicatedServiceAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetKxEnvironmentOutput) SetDescription(v string) *GetKxEnvironmentOutput {
	s.Description = &v
	return s
}

// SetDnsStatus sets the DnsStatus field's value.
func (s *GetKxEnvironmentOutput) SetDnsStatus(v string) *GetKxEnvironmentOutput {
	s.DnsStatus = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *GetKxEnvironmentOutput) SetEnvironmentArn(v string) *GetKxEnvironmentOutput {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxEnvironmentOutput) SetEnvironmentId(v string) *GetKxEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetKxEnvironmentOutput) SetErrorMessage(v string) *GetKxEnvironmentOutput {
	s.ErrorMessage = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *GetKxEnvironmentOutput) SetKmsKeyId(v string) *GetKxEnvironmentOutput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetKxEnvironmentOutput) SetName(v string) *GetKxEnvironmentOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetKxEnvironmentOutput) SetStatus(v string) *GetKxEnvironmentOutput {
	s.Status = &v
	return s
}

// SetTgwStatus sets the TgwStatus field's value.
func (s *GetKxEnvironmentOutput) SetTgwStatus(v string) *GetKxEnvironmentOutput {
	s.TgwStatus = &v
	return s
}

// SetTransitGatewayConfiguration sets the TransitGatewayConfiguration field's value.
func (s *GetKxEnvironmentOutput) SetTransitGatewayConfiguration(v *TransitGatewayConfiguration) *GetKxEnvironmentOutput {
	s.TransitGatewayConfiguration = v
	return s
}

// SetUpdateTimestamp sets the UpdateTimestamp field's value.
func (s *GetKxEnvironmentOutput) SetUpdateTimestamp(v time.Time) *GetKxEnvironmentOutput {
	s.UpdateTimestamp = &v
	return s
}

type GetKxScalingGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// A unique identifier for the kdb scaling group.
	//
	// ScalingGroupName is a required field
	ScalingGroupName *string `location:"uri" locationName:"scalingGroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKxScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKxScalingGroupInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.ScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingGroupName"))
	}
	if s.ScalingGroupName != nil && len(*s.ScalingGroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingGroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxScalingGroupInput) SetEnvironmentId(v string) *GetKxScalingGroupInput {
	s.EnvironmentId = &v
	return s
}

// SetScalingGroupName sets the ScalingGroupName field's value.
func (s *GetKxScalingGroupInput) SetScalingGroupName(v string) *GetKxScalingGroupInput {
	s.ScalingGroupName = &v
	return s
}

type GetKxScalingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The list of Managed kdb clusters that are currently active in the given scaling
	// group.
	Clusters []*string `locationName:"clusters" type:"list"`

	// The timestamp at which the scaling group was created in FinSpace. The value
	// is determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The memory and CPU capabilities of the scaling group host on which FinSpace
	// Managed kdb clusters will be placed.
	HostType *string `locationName:"hostType" min:"1" type:"string"`

	// The last time that the scaling group was updated in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The ARN identifier for the scaling group.
	ScalingGroupArn *string `locationName:"scalingGroupArn" min:"20" type:"string"`

	// A unique identifier for the kdb scaling group.
	ScalingGroupName *string `locationName:"scalingGroupName" min:"3" type:"string"`

	// The status of scaling group.
	//
	//    * CREATING – The scaling group creation is in progress.
	//
	//    * CREATE_FAILED – The scaling group creation has failed.
	//
	//    * ACTIVE – The scaling group is active.
	//
	//    * UPDATING – The scaling group is in the process of being updated.
	//
	//    * UPDATE_FAILED – The update action failed.
	//
	//    * DELETING – The scaling group is in the process of being deleted.
	//
	//    * DELETE_FAILED – The system failed to delete the scaling group.
	//
	//    * DELETED – The scaling group is successfully deleted.
	Status *string `locationName:"status" type:"string" enum:"KxScalingGroupStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxScalingGroupOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *GetKxScalingGroupOutput) SetAvailabilityZoneId(v string) *GetKxScalingGroupOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetClusters sets the Clusters field's value.
func (s *GetKxScalingGroupOutput) SetClusters(v []*string) *GetKxScalingGroupOutput {
	s.Clusters = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetKxScalingGroupOutput) SetCreatedTimestamp(v time.Time) *GetKxScalingGroupOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetHostType sets the HostType field's value.
func (s *GetKxScalingGroupOutput) SetHostType(v string) *GetKxScalingGroupOutput {
	s.HostType = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *GetKxScalingGroupOutput) SetLastModifiedTimestamp(v time.Time) *GetKxScalingGroupOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetScalingGroupArn sets the ScalingGroupArn field's value.
func (s *GetKxScalingGroupOutput) SetScalingGroupArn(v string) *GetKxScalingGroupOutput {
	s.ScalingGroupArn = &v
	return s
}

// SetScalingGroupName sets the ScalingGroupName field's value.
func (s *GetKxScalingGroupOutput) SetScalingGroupName(v string) *GetKxScalingGroupOutput {
	s.ScalingGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetKxScalingGroupOutput) SetStatus(v string) *GetKxScalingGroupOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetKxScalingGroupOutput) SetStatusReason(v string) *GetKxScalingGroupOutput {
	s.StatusReason = &v
	return s
}

type GetKxUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// A unique identifier for the user.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"userName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKxUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKxUserInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxUserInput) SetEnvironmentId(v string) *GetKxUserInput {
	s.EnvironmentId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *GetKxUserInput) SetUserName(v string) *GetKxUserInput {
	s.UserName = &v
	return s
}

type GetKxUserOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The IAM role ARN that is associated with the user.
	IamRole *string `locationName:"iamRole" min:"20" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the user. For more information
	// about ARNs and how to use ARNs in policies, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	UserArn *string `locationName:"userArn" min:"20" type:"string"`

	// A unique identifier for the user.
	UserName *string `locationName:"userName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxUserOutput) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxUserOutput) SetEnvironmentId(v string) *GetKxUserOutput {
	s.EnvironmentId = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *GetKxUserOutput) SetIamRole(v string) *GetKxUserOutput {
	s.IamRole = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *GetKxUserOutput) SetUserArn(v string) *GetKxUserOutput {
	s.UserArn = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *GetKxUserOutput) SetUserName(v string) *GetKxUserOutput {
	s.UserName = &v
	return s
}

type GetKxVolumeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the kdb environment, whose clusters can attach to
	// the volume.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// A unique identifier for the volume.
	//
	// VolumeName is a required field
	VolumeName *string `location:"uri" locationName:"volumeName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKxVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKxVolumeInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.VolumeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeName"))
	}
	if s.VolumeName != nil && len(*s.VolumeName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxVolumeInput) SetEnvironmentId(v string) *GetKxVolumeInput {
	s.EnvironmentId = &v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *GetKxVolumeInput) SetVolumeName(v string) *GetKxVolumeInput {
	s.VolumeName = &v
	return s
}

type GetKxVolumeOutput struct {
	_ struct{} `type:"structure"`

	// A list of cluster identifiers that a volume is attached to.
	AttachedClusters []*KxAttachedCluster `locationName:"attachedClusters" type:"list"`

	// The identifier of the availability zones.
	AvailabilityZoneIds []*string `locationName:"availabilityZoneIds" type:"list"`

	// The number of availability zones you want to assign per cluster. Currently,
	// FinSpace only support SINGLE for volumes.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// The timestamp at which the volume was created in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// A description of the volume.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment, whose clusters can attach to
	// the volume.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The last time that the volume was updated in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// Specifies the configuration for the Network attached storage (NAS_1) file
	// system volume.
	Nas1Configuration *KxNAS1Configuration `locationName:"nas1Configuration" type:"structure"`

	// The status of volume creation.
	//
	//    * CREATING – The volume creation is in progress.
	//
	//    * CREATE_FAILED – The volume creation has failed.
	//
	//    * ACTIVE – The volume is active.
	//
	//    * UPDATING – The volume is in the process of being updated.
	//
	//    * UPDATE_FAILED – The update action failed.
	//
	//    * UPDATED – The volume is successfully updated.
	//
	//    * DELETING – The volume is in the process of being deleted.
	//
	//    * DELETE_FAILED – The system failed to delete the volume.
	//
	//    * DELETED – The volume is successfully deleted.
	Status *string `locationName:"status" type:"string" enum:"KxVolumeStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`

	// The ARN identifier of the volume.
	VolumeArn *string `locationName:"volumeArn" min:"20" type:"string"`

	// A unique identifier for the volume.
	VolumeName *string `locationName:"volumeName" min:"3" type:"string"`

	// The type of file system volume. Currently, FinSpace only supports NAS_1 volume
	// type.
	VolumeType *string `locationName:"volumeType" type:"string" enum:"KxVolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKxVolumeOutput) GoString() string {
	return s.String()
}

// SetAttachedClusters sets the AttachedClusters field's value.
func (s *GetKxVolumeOutput) SetAttachedClusters(v []*KxAttachedCluster) *GetKxVolumeOutput {
	s.AttachedClusters = v
	return s
}

// SetAvailabilityZoneIds sets the AvailabilityZoneIds field's value.
func (s *GetKxVolumeOutput) SetAvailabilityZoneIds(v []*string) *GetKxVolumeOutput {
	s.AvailabilityZoneIds = v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *GetKxVolumeOutput) SetAzMode(v string) *GetKxVolumeOutput {
	s.AzMode = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetKxVolumeOutput) SetCreatedTimestamp(v time.Time) *GetKxVolumeOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetKxVolumeOutput) SetDescription(v string) *GetKxVolumeOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetKxVolumeOutput) SetEnvironmentId(v string) *GetKxVolumeOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *GetKxVolumeOutput) SetLastModifiedTimestamp(v time.Time) *GetKxVolumeOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetNas1Configuration sets the Nas1Configuration field's value.
func (s *GetKxVolumeOutput) SetNas1Configuration(v *KxNAS1Configuration) *GetKxVolumeOutput {
	s.Nas1Configuration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetKxVolumeOutput) SetStatus(v string) *GetKxVolumeOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetKxVolumeOutput) SetStatusReason(v string) *GetKxVolumeOutput {
	s.StatusReason = &v
	return s
}

// SetVolumeArn sets the VolumeArn field's value.
func (s *GetKxVolumeOutput) SetVolumeArn(v string) *GetKxVolumeOutput {
	s.VolumeArn = &v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *GetKxVolumeOutput) SetVolumeName(v string) *GetKxVolumeOutput {
	s.VolumeName = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *GetKxVolumeOutput) SetVolumeType(v string) *GetKxVolumeOutput {
	s.VolumeType = &v
	return s
}

// Defines the ICMP protocol that consists of the ICMP type and code.
type IcmpTypeCode struct {
	_ struct{} `type:"structure"`

	// The ICMP code. A value of -1 means all codes for the specified ICMP type.
	//
	// Code is a required field
	Code *int64 `locationName:"code" type:"integer" required:"true"`

	// The ICMP type. A value of -1 means all types.
	//
	// Type is a required field
	Type *int64 `locationName:"type" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IcmpTypeCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IcmpTypeCode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IcmpTypeCode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IcmpTypeCode"}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCode sets the Code field's value.
func (s *IcmpTypeCode) SetCode(v int64) *IcmpTypeCode {
	s.Code = &v
	return s
}

// SetType sets the Type field's value.
func (s *IcmpTypeCode) SetType(v int64) *IcmpTypeCode {
	s.Type = &v
	return s
}

// The request processing has failed because of an unknown error, exception
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is invalid. Something is wrong with the input to the request.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The structure containing the metadata of the attached clusters.
type KxAttachedCluster struct {
	_ struct{} `type:"structure"`

	// A unique name for the attached cluster.
	ClusterName *string `locationName:"clusterName" min:"3" type:"string"`

	// The status of the attached cluster.
	//
	//    * PENDING – The cluster is pending creation.
	//
	//    * CREATING – The cluster creation process is in progress.
	//
	//    * CREATE_FAILED – The cluster creation process has failed.
	//
	//    * RUNNING – The cluster creation process is running.
	//
	//    * UPDATING – The cluster is in the process of being updated.
	//
	//    * DELETING – The cluster is in the process of being deleted.
	//
	//    * DELETED – The cluster has been deleted.
	//
	//    * DELETE_FAILED – The cluster failed to delete.
	ClusterStatus *string `locationName:"clusterStatus" type:"string" enum:"KxClusterStatus"`

	// Specifies the type of cluster. The volume for TP and RDB cluster types will
	// be used for TP logs.
	ClusterType *string `locationName:"clusterType" type:"string" enum:"KxClusterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxAttachedCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxAttachedCluster) GoString() string {
	return s.String()
}

// SetClusterName sets the ClusterName field's value.
func (s *KxAttachedCluster) SetClusterName(v string) *KxAttachedCluster {
	s.ClusterName = &v
	return s
}

// SetClusterStatus sets the ClusterStatus field's value.
func (s *KxAttachedCluster) SetClusterStatus(v string) *KxAttachedCluster {
	s.ClusterStatus = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *KxAttachedCluster) SetClusterType(v string) *KxAttachedCluster {
	s.ClusterType = &v
	return s
}

// The configuration for read only disk cache associated with a cluster.
type KxCacheStorageConfiguration struct {
	_ struct{} `type:"structure"`

	// The size of cache in Gigabytes.
	//
	// Size is a required field
	Size *int64 `locationName:"size" type:"integer" required:"true"`

	// The type of cache storage. The valid values are:
	//
	//    * CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
	//
	//    * CACHE_250 – This type provides at least 250 MB/s disk access throughput.
	//
	//    * CACHE_12 – This type provides at least 12 MB/s disk access throughput.
	//
	// For cache type CACHE_1000 and CACHE_250 you can select cache size as 1200
	// GB or increments of 2400 GB. For cache type CACHE_12 you can select the cache
	// size in increments of 6000 GB.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"8" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxCacheStorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxCacheStorageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxCacheStorageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxCacheStorageConfiguration"}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSize sets the Size field's value.
func (s *KxCacheStorageConfiguration) SetSize(v int64) *KxCacheStorageConfiguration {
	s.Size = &v
	return s
}

// SetType sets the Type field's value.
func (s *KxCacheStorageConfiguration) SetType(v string) *KxCacheStorageConfiguration {
	s.Type = &v
	return s
}

// Details of changeset.
type KxChangesetListEntry struct {
	_ struct{} `type:"structure"`

	// Beginning time from which the changeset is active. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	ActiveFromTimestamp *time.Time `locationName:"activeFromTimestamp" type:"timestamp"`

	// A unique identifier for the changeset.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The timestamp at which the changeset was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The timestamp at which the changeset was modified. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// Status of the changeset.
	//
	//    * Pending – Changeset creation is pending.
	//
	//    * Processing – Changeset creation is running.
	//
	//    * Failed – Changeset creation has failed.
	//
	//    * Complete – Changeset creation has succeeded.
	Status *string `locationName:"status" type:"string" enum:"ChangesetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxChangesetListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxChangesetListEntry) GoString() string {
	return s.String()
}

// SetActiveFromTimestamp sets the ActiveFromTimestamp field's value.
func (s *KxChangesetListEntry) SetActiveFromTimestamp(v time.Time) *KxChangesetListEntry {
	s.ActiveFromTimestamp = &v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *KxChangesetListEntry) SetChangesetId(v string) *KxChangesetListEntry {
	s.ChangesetId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *KxChangesetListEntry) SetCreatedTimestamp(v time.Time) *KxChangesetListEntry {
	s.CreatedTimestamp = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *KxChangesetListEntry) SetLastModifiedTimestamp(v time.Time) *KxChangesetListEntry {
	s.LastModifiedTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KxChangesetListEntry) SetStatus(v string) *KxChangesetListEntry {
	s.Status = &v
	return s
}

// The details of a kdb cluster.
type KxCluster struct {
	_ struct{} `type:"structure"`

	// The availability zone identifiers for the requested regions.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of availability zones assigned per cluster. This can be one of
	// the following:
	//
	//    * SINGLE – Assigns one availability zone per cluster.
	//
	//    * MULTI – Assigns all the availability zones per cluster.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// A description of the cluster.
	ClusterDescription *string `locationName:"clusterDescription" min:"1" type:"string"`

	// A unique name for the cluster.
	ClusterName *string `locationName:"clusterName" min:"3" type:"string"`

	// Specifies the type of KDB database that is being created. The following types
	// are available:
	//
	//    * HDB – A Historical Database. The data is only accessible with read-only
	//    permissions from one of the FinSpace managed kdb databases mounted to
	//    the cluster.
	//
	//    * RDB – A Realtime Database. This type of database captures all the
	//    data from a ticker plant and stores it in memory until the end of day,
	//    after which it writes all of its data to a disk and reloads the HDB. This
	//    cluster type requires local storage for temporary storage of data during
	//    the savedown process. If you specify this field in your request, you must
	//    provide the savedownStorageConfiguration parameter.
	//
	//    * GATEWAY – A gateway cluster allows you to access data across processes
	//    in kdb systems. It allows you to create your own routing logic using the
	//    initialization scripts and custom code. This type of cluster does not
	//    require a writable local storage.
	//
	//    * GP – A general purpose cluster allows you to quickly iterate on code
	//    during development by granting greater access to system commands and enabling
	//    a fast reload of custom code. This cluster type can optionally mount databases
	//    including cache and savedown storage. For this cluster type, the node
	//    count is fixed at 1. It does not support autoscaling and supports only
	//    SINGLE AZ mode.
	//
	//    * Tickerplant – A tickerplant cluster allows you to subscribe to feed
	//    handlers based on IAM permissions. It can publish to RDBs, other Tickerplants,
	//    and real-time subscribers (RTS). Tickerplants can persist messages to
	//    log, which is readable by any RDB environment. It supports only single-node
	//    that is only one kdb process.
	ClusterType *string `locationName:"clusterType" type:"string" enum:"KxClusterType"`

	// The timestamp at which the cluster was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// An IAM role that defines a set of permissions associated with a cluster.
	// These permissions are assumed when a cluster attempts to access another cluster.
	ExecutionRole *string `locationName:"executionRole" min:"1" type:"string"`

	// Specifies a Q program that will be run at launch of a cluster. It is a relative
	// path within .zip file that contains the custom code, which will be loaded
	// on the cluster. It must include the file name itself. For example, somedir/init.q.
	InitializationScript *string `locationName:"initializationScript" min:"1" type:"string"`

	// The last time that the cluster was modified. The value is determined as epoch
	// time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// A version of the FinSpace managed kdb to run.
	ReleaseLabel *string `locationName:"releaseLabel" min:"1" type:"string"`

	// The status of a cluster.
	//
	//    * PENDING – The cluster is pending creation.
	//
	//    * CREATING –The cluster creation process is in progress.
	//
	//    * CREATE_FAILED– The cluster creation process has failed.
	//
	//    * RUNNING – The cluster creation process is running.
	//
	//    * UPDATING – The cluster is in the process of being updated.
	//
	//    * DELETING – The cluster is in the process of being deleted.
	//
	//    * DELETED – The cluster has been deleted.
	//
	//    * DELETE_FAILED – The cluster failed to delete.
	Status *string `locationName:"status" type:"string" enum:"KxClusterStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`

	// A list of volumes attached to the cluster.
	Volumes []*Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxCluster) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *KxCluster) SetAvailabilityZoneId(v string) *KxCluster {
	s.AvailabilityZoneId = &v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *KxCluster) SetAzMode(v string) *KxCluster {
	s.AzMode = &v
	return s
}

// SetClusterDescription sets the ClusterDescription field's value.
func (s *KxCluster) SetClusterDescription(v string) *KxCluster {
	s.ClusterDescription = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *KxCluster) SetClusterName(v string) *KxCluster {
	s.ClusterName = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *KxCluster) SetClusterType(v string) *KxCluster {
	s.ClusterType = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *KxCluster) SetCreatedTimestamp(v time.Time) *KxCluster {
	s.CreatedTimestamp = &v
	return s
}

// SetExecutionRole sets the ExecutionRole field's value.
func (s *KxCluster) SetExecutionRole(v string) *KxCluster {
	s.ExecutionRole = &v
	return s
}

// SetInitializationScript sets the InitializationScript field's value.
func (s *KxCluster) SetInitializationScript(v string) *KxCluster {
	s.InitializationScript = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *KxCluster) SetLastModifiedTimestamp(v time.Time) *KxCluster {
	s.LastModifiedTimestamp = &v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *KxCluster) SetReleaseLabel(v string) *KxCluster {
	s.ReleaseLabel = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KxCluster) SetStatus(v string) *KxCluster {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *KxCluster) SetStatusReason(v string) *KxCluster {
	s.StatusReason = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *KxCluster) SetVolumes(v []*Volume) *KxCluster {
	s.Volumes = v
	return s
}

// The configuration that allows you to choose how you want to update code on
// a cluster. Depending on the option you choose, you can reduce the time it
// takes to update the cluster.
type KxClusterCodeDeploymentConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of deployment that you want on a cluster.
	//
	//    * ROLLING – This options updates the cluster by stopping the exiting
	//    q process and starting a new q process with updated configuration.
	//
	//    * NO_RESTART – This option updates the cluster without stopping the
	//    running q process. It is only available for GP type cluster. This option
	//    is quicker as it reduces the turn around time to update configuration
	//    on a cluster. With this deployment mode, you cannot update the initializationScript
	//    and commandLineArguments parameters.
	//
	//    * FORCE – This option updates the cluster by immediately stopping all
	//    the running processes before starting up new ones with the updated configuration.
	//
	// DeploymentStrategy is a required field
	DeploymentStrategy *string `locationName:"deploymentStrategy" type:"string" required:"true" enum:"KxClusterCodeDeploymentStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxClusterCodeDeploymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxClusterCodeDeploymentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxClusterCodeDeploymentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxClusterCodeDeploymentConfiguration"}
	if s.DeploymentStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentStrategy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentStrategy sets the DeploymentStrategy field's value.
func (s *KxClusterCodeDeploymentConfiguration) SetDeploymentStrategy(v string) *KxClusterCodeDeploymentConfiguration {
	s.DeploymentStrategy = &v
	return s
}

// Defines the key-value pairs to make them available inside the cluster.
type KxCommandLineArgument struct {
	_ struct{} `type:"structure"`

	// The name of the key.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The value of the key.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxCommandLineArgument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxCommandLineArgument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxCommandLineArgument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxCommandLineArgument"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *KxCommandLineArgument) SetKey(v string) *KxCommandLineArgument {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *KxCommandLineArgument) SetValue(v string) *KxCommandLineArgument {
	s.Value = &v
	return s
}

// The structure of database cache configuration that is used for mapping database
// paths to cache types in clusters.
type KxDatabaseCacheConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of disk cache. This parameter is used to map the database path to
	// cache storage. The valid values are:
	//
	//    * CACHE_1000 – This type provides at least 1000 MB/s disk access throughput.
	//
	// CacheType is a required field
	CacheType *string `locationName:"cacheType" min:"8" type:"string" required:"true"`

	// The name of the dataview to be used for caching historical data on disk.
	DataviewName *string `locationName:"dataviewName" min:"3" type:"string"`

	// Specifies the portions of database that will be loaded into the cache for
	// access.
	//
	// DbPaths is a required field
	DbPaths []*string `locationName:"dbPaths" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDatabaseCacheConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDatabaseCacheConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxDatabaseCacheConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxDatabaseCacheConfiguration"}
	if s.CacheType == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheType"))
	}
	if s.CacheType != nil && len(*s.CacheType) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("CacheType", 8))
	}
	if s.DataviewName != nil && len(*s.DataviewName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DataviewName", 3))
	}
	if s.DbPaths == nil {
		invalidParams.Add(request.NewErrParamRequired("DbPaths"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheType sets the CacheType field's value.
func (s *KxDatabaseCacheConfiguration) SetCacheType(v string) *KxDatabaseCacheConfiguration {
	s.CacheType = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *KxDatabaseCacheConfiguration) SetDataviewName(v string) *KxDatabaseCacheConfiguration {
	s.DataviewName = &v
	return s
}

// SetDbPaths sets the DbPaths field's value.
func (s *KxDatabaseCacheConfiguration) SetDbPaths(v []*string) *KxDatabaseCacheConfiguration {
	s.DbPaths = v
	return s
}

// The configuration of data that is available for querying from this database.
type KxDatabaseConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration details for the disk cache used to increase performance reading
	// from a kdb database mounted to the cluster.
	CacheConfigurations []*KxDatabaseCacheConfiguration `locationName:"cacheConfigurations" type:"list"`

	// A unique identifier of the changeset that is associated with the cluster.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The name of the kdb database. When this parameter is specified in the structure,
	// S3 with the whole database is included by default.
	//
	// DatabaseName is a required field
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string" required:"true"`

	// The configuration of the dataview to be used with specified cluster.
	DataviewConfiguration *KxDataviewConfiguration `locationName:"dataviewConfiguration" type:"structure"`

	// The name of the dataview to be used for caching historical data on disk.
	DataviewName *string `locationName:"dataviewName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDatabaseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDatabaseConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxDatabaseConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxDatabaseConfiguration"}
	if s.ChangesetId != nil && len(*s.ChangesetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangesetId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.DataviewName != nil && len(*s.DataviewName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DataviewName", 3))
	}
	if s.CacheConfigurations != nil {
		for i, v := range s.CacheConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CacheConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataviewConfiguration != nil {
		if err := s.DataviewConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataviewConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheConfigurations sets the CacheConfigurations field's value.
func (s *KxDatabaseConfiguration) SetCacheConfigurations(v []*KxDatabaseCacheConfiguration) *KxDatabaseConfiguration {
	s.CacheConfigurations = v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *KxDatabaseConfiguration) SetChangesetId(v string) *KxDatabaseConfiguration {
	s.ChangesetId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *KxDatabaseConfiguration) SetDatabaseName(v string) *KxDatabaseConfiguration {
	s.DatabaseName = &v
	return s
}

// SetDataviewConfiguration sets the DataviewConfiguration field's value.
func (s *KxDatabaseConfiguration) SetDataviewConfiguration(v *KxDataviewConfiguration) *KxDatabaseConfiguration {
	s.DataviewConfiguration = v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *KxDatabaseConfiguration) SetDataviewName(v string) *KxDatabaseConfiguration {
	s.DataviewName = &v
	return s
}

// Details about a FinSpace managed kdb database
type KxDatabaseListEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp at which the database was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The name of the kdb database.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// The last time that the database was modified. The value is determined as
	// epoch time in milliseconds. For example, the value for Monday, November 1,
	// 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDatabaseListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDatabaseListEntry) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *KxDatabaseListEntry) SetCreatedTimestamp(v time.Time) *KxDatabaseListEntry {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *KxDatabaseListEntry) SetDatabaseName(v string) *KxDatabaseListEntry {
	s.DatabaseName = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *KxDatabaseListEntry) SetLastModifiedTimestamp(v time.Time) *KxDatabaseListEntry {
	s.LastModifiedTimestamp = &v
	return s
}

// The active version of the dataview that is currently in use by this cluster.
type KxDataviewActiveVersion struct {
	_ struct{} `type:"structure"`

	// The list of clusters that are currently using this dataview.
	AttachedClusters []*string `locationName:"attachedClusters" type:"list"`

	// A unique identifier for the changeset.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The timestamp at which the dataview version was active. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The configuration that contains the database path of the data that you want
	// to place on each selected volume. Each segment must have a unique database
	// path for each volume. If you do not explicitly specify any database path
	// for a volume, they are accessible from the cluster through the default S3/object
	// store segment.
	SegmentConfigurations []*KxDataviewSegmentConfiguration `locationName:"segmentConfigurations" type:"list"`

	// A unique identifier of the active version.
	VersionId *string `locationName:"versionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDataviewActiveVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDataviewActiveVersion) GoString() string {
	return s.String()
}

// SetAttachedClusters sets the AttachedClusters field's value.
func (s *KxDataviewActiveVersion) SetAttachedClusters(v []*string) *KxDataviewActiveVersion {
	s.AttachedClusters = v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *KxDataviewActiveVersion) SetChangesetId(v string) *KxDataviewActiveVersion {
	s.ChangesetId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *KxDataviewActiveVersion) SetCreatedTimestamp(v time.Time) *KxDataviewActiveVersion {
	s.CreatedTimestamp = &v
	return s
}

// SetSegmentConfigurations sets the SegmentConfigurations field's value.
func (s *KxDataviewActiveVersion) SetSegmentConfigurations(v []*KxDataviewSegmentConfiguration) *KxDataviewActiveVersion {
	s.SegmentConfigurations = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *KxDataviewActiveVersion) SetVersionId(v string) *KxDataviewActiveVersion {
	s.VersionId = &v
	return s
}

// The structure that stores the configuration details of a dataview.
type KxDataviewConfiguration struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the changeset.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The unique identifier of the dataview.
	DataviewName *string `locationName:"dataviewName" min:"3" type:"string"`

	// The version of the dataview corresponding to a given changeset.
	DataviewVersionId *string `locationName:"dataviewVersionId" min:"1" type:"string"`

	// The db path and volume configuration for the segmented database.
	SegmentConfigurations []*KxDataviewSegmentConfiguration `locationName:"segmentConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDataviewConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDataviewConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxDataviewConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxDataviewConfiguration"}
	if s.ChangesetId != nil && len(*s.ChangesetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangesetId", 1))
	}
	if s.DataviewName != nil && len(*s.DataviewName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DataviewName", 3))
	}
	if s.DataviewVersionId != nil && len(*s.DataviewVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataviewVersionId", 1))
	}
	if s.SegmentConfigurations != nil {
		for i, v := range s.SegmentConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SegmentConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangesetId sets the ChangesetId field's value.
func (s *KxDataviewConfiguration) SetChangesetId(v string) *KxDataviewConfiguration {
	s.ChangesetId = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *KxDataviewConfiguration) SetDataviewName(v string) *KxDataviewConfiguration {
	s.DataviewName = &v
	return s
}

// SetDataviewVersionId sets the DataviewVersionId field's value.
func (s *KxDataviewConfiguration) SetDataviewVersionId(v string) *KxDataviewConfiguration {
	s.DataviewVersionId = &v
	return s
}

// SetSegmentConfigurations sets the SegmentConfigurations field's value.
func (s *KxDataviewConfiguration) SetSegmentConfigurations(v []*KxDataviewSegmentConfiguration) *KxDataviewConfiguration {
	s.SegmentConfigurations = v
	return s
}

// A collection of kdb dataview entries.
type KxDataviewListEntry struct {
	_ struct{} `type:"structure"`

	// The active changeset versions for the given dataview entry.
	ActiveVersions []*KxDataviewActiveVersion `locationName:"activeVersions" type:"list"`

	// The option to specify whether you want to apply all the future additions
	// and corrections automatically to the dataview when you ingest new changesets.
	// The default value is false.
	AutoUpdate *bool `locationName:"autoUpdate" type:"boolean"`

	// The identifier of the availability zones.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of availability zones you want to assign per cluster. This can
	// be one of the following
	//
	//    * SINGLE – Assigns one availability zone per cluster.
	//
	//    * MULTI – Assigns all the availability zones per cluster.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// A unique identifier for the changeset.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The timestamp at which the dataview list entry was created in FinSpace. The
	// value is determined as epoch time in milliseconds. For example, the value
	// for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// A unique identifier of the database.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// A unique identifier of the dataview.
	DataviewName *string `locationName:"dataviewName" min:"3" type:"string"`

	// A description for the dataview list entry.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The last time that the dataview list was updated in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The configuration that contains the database path of the data that you want
	// to place on each selected volume. Each segment must have a unique database
	// path for each volume. If you do not explicitly specify any database path
	// for a volume, they are accessible from the cluster through the default S3/object
	// store segment.
	SegmentConfigurations []*KxDataviewSegmentConfiguration `locationName:"segmentConfigurations" type:"list"`

	// The status of a given dataview entry.
	Status *string `locationName:"status" type:"string" enum:"KxDataviewStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDataviewListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDataviewListEntry) GoString() string {
	return s.String()
}

// SetActiveVersions sets the ActiveVersions field's value.
func (s *KxDataviewListEntry) SetActiveVersions(v []*KxDataviewActiveVersion) *KxDataviewListEntry {
	s.ActiveVersions = v
	return s
}

// SetAutoUpdate sets the AutoUpdate field's value.
func (s *KxDataviewListEntry) SetAutoUpdate(v bool) *KxDataviewListEntry {
	s.AutoUpdate = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *KxDataviewListEntry) SetAvailabilityZoneId(v string) *KxDataviewListEntry {
	s.AvailabilityZoneId = &v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *KxDataviewListEntry) SetAzMode(v string) *KxDataviewListEntry {
	s.AzMode = &v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *KxDataviewListEntry) SetChangesetId(v string) *KxDataviewListEntry {
	s.ChangesetId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *KxDataviewListEntry) SetCreatedTimestamp(v time.Time) *KxDataviewListEntry {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *KxDataviewListEntry) SetDatabaseName(v string) *KxDataviewListEntry {
	s.DatabaseName = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *KxDataviewListEntry) SetDataviewName(v string) *KxDataviewListEntry {
	s.DataviewName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KxDataviewListEntry) SetDescription(v string) *KxDataviewListEntry {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *KxDataviewListEntry) SetEnvironmentId(v string) *KxDataviewListEntry {
	s.EnvironmentId = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *KxDataviewListEntry) SetLastModifiedTimestamp(v time.Time) *KxDataviewListEntry {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSegmentConfigurations sets the SegmentConfigurations field's value.
func (s *KxDataviewListEntry) SetSegmentConfigurations(v []*KxDataviewSegmentConfiguration) *KxDataviewListEntry {
	s.SegmentConfigurations = v
	return s
}

// SetStatus sets the Status field's value.
func (s *KxDataviewListEntry) SetStatus(v string) *KxDataviewListEntry {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *KxDataviewListEntry) SetStatusReason(v string) *KxDataviewListEntry {
	s.StatusReason = &v
	return s
}

// The configuration that contains the database path of the data that you want
// to place on each selected volume. Each segment must have a unique database
// path for each volume. If you do not explicitly specify any database path
// for a volume, they are accessible from the cluster through the default S3/object
// store segment.
type KxDataviewSegmentConfiguration struct {
	_ struct{} `type:"structure"`

	// The database path of the data that you want to place on each selected volume
	// for the segment. Each segment must have a unique database path for each volume.
	//
	// DbPaths is a required field
	DbPaths []*string `locationName:"dbPaths" min:"1" type:"list" required:"true"`

	// The name of the volume where you want to add data.
	//
	// VolumeName is a required field
	VolumeName *string `locationName:"volumeName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDataviewSegmentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDataviewSegmentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxDataviewSegmentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxDataviewSegmentConfiguration"}
	if s.DbPaths == nil {
		invalidParams.Add(request.NewErrParamRequired("DbPaths"))
	}
	if s.DbPaths != nil && len(s.DbPaths) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DbPaths", 1))
	}
	if s.VolumeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeName"))
	}
	if s.VolumeName != nil && len(*s.VolumeName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDbPaths sets the DbPaths field's value.
func (s *KxDataviewSegmentConfiguration) SetDbPaths(v []*string) *KxDataviewSegmentConfiguration {
	s.DbPaths = v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *KxDataviewSegmentConfiguration) SetVolumeName(v string) *KxDataviewSegmentConfiguration {
	s.VolumeName = &v
	return s
}

// The configuration that allows you to choose how you want to update the databases
// on a cluster. Depending on the option you choose, you can reduce the time
// it takes to update the cluster.
type KxDeploymentConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of deployment that you want on a cluster.
	//
	//    * ROLLING – This options updates the cluster by stopping the exiting
	//    q process and starting a new q process with updated configuration.
	//
	//    * NO_RESTART – This option updates the cluster without stopping the
	//    running q process. It is only available for HDB type cluster. This option
	//    is quicker as it reduces the turn around time to update configuration
	//    on a cluster. With this deployment mode, you cannot update the initializationScript
	//    and commandLineArguments parameters.
	//
	// DeploymentStrategy is a required field
	DeploymentStrategy *string `locationName:"deploymentStrategy" type:"string" required:"true" enum:"KxDeploymentStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDeploymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxDeploymentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxDeploymentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxDeploymentConfiguration"}
	if s.DeploymentStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentStrategy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentStrategy sets the DeploymentStrategy field's value.
func (s *KxDeploymentConfiguration) SetDeploymentStrategy(v string) *KxDeploymentConfiguration {
	s.DeploymentStrategy = &v
	return s
}

// The details of a kdb environment.
type KxEnvironment struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones where subnets for the environment
	// are created.
	AvailabilityZoneIds []*string `locationName:"availabilityZoneIds" type:"list"`

	// The unique identifier of the AWS account in which you create the kdb environment.
	AwsAccountId *string `locationName:"awsAccountId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the certificate authority:
	CertificateAuthorityArn *string `locationName:"certificateAuthorityArn" min:"1" type:"string"`

	// The timestamp at which the kdb environment was created in FinSpace. The value
	// is determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// A list of DNS server name and server IP. This is used to set up Route-53
	// outbound resolvers.
	CustomDNSConfiguration []*CustomDNSServer `locationName:"customDNSConfiguration" type:"list"`

	// A unique identifier for the AWS environment infrastructure account.
	DedicatedServiceAccountId *string `locationName:"dedicatedServiceAccountId" min:"1" type:"string"`

	// A description of the kdb environment.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The status of DNS configuration.
	DnsStatus *string `locationName:"dnsStatus" type:"string" enum:"DnsStatus"`

	// The Amazon Resource Name (ARN) of your kdb environment.
	EnvironmentArn *string `locationName:"environmentArn" min:"20" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// Specifies the error message that appears if a flow fails.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The unique identifier of the KMS key.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the kdb environment.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status of the environment creation.
	//
	//    * CREATE_REQUESTED – Environment creation has been requested.
	//
	//    * CREATING – Environment is in the process of being created.
	//
	//    * FAILED_CREATION – Environment creation has failed.
	//
	//    * CREATED – Environment is successfully created and is currently active.
	//
	//    * DELETE REQUESTED – Environment deletion has been requested.
	//
	//    * DELETING – Environment is in the process of being deleted.
	//
	//    * RETRY_DELETION – Initial environment deletion failed, system is reattempting
	//    delete.
	//
	//    * DELETED – Environment has been deleted.
	//
	//    * FAILED_DELETION – Environment deletion has failed.
	Status *string `locationName:"status" type:"string" enum:"EnvironmentStatus"`

	// The status of the network configuration.
	TgwStatus *string `locationName:"tgwStatus" type:"string" enum:"TgwStatus"`

	// Specifies the transit gateway and network configuration to connect the kdb
	// environment to an internal network.
	TransitGatewayConfiguration *TransitGatewayConfiguration `locationName:"transitGatewayConfiguration" type:"structure"`

	// The timestamp at which the kdb environment was modified in FinSpace. The
	// value is determined as epoch time in milliseconds. For example, the value
	// for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	UpdateTimestamp *time.Time `locationName:"updateTimestamp" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxEnvironment) GoString() string {
	return s.String()
}

// SetAvailabilityZoneIds sets the AvailabilityZoneIds field's value.
func (s *KxEnvironment) SetAvailabilityZoneIds(v []*string) *KxEnvironment {
	s.AvailabilityZoneIds = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *KxEnvironment) SetAwsAccountId(v string) *KxEnvironment {
	s.AwsAccountId = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *KxEnvironment) SetCertificateAuthorityArn(v string) *KxEnvironment {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *KxEnvironment) SetCreationTimestamp(v time.Time) *KxEnvironment {
	s.CreationTimestamp = &v
	return s
}

// SetCustomDNSConfiguration sets the CustomDNSConfiguration field's value.
func (s *KxEnvironment) SetCustomDNSConfiguration(v []*CustomDNSServer) *KxEnvironment {
	s.CustomDNSConfiguration = v
	return s
}

// SetDedicatedServiceAccountId sets the DedicatedServiceAccountId field's value.
func (s *KxEnvironment) SetDedicatedServiceAccountId(v string) *KxEnvironment {
	s.DedicatedServiceAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KxEnvironment) SetDescription(v string) *KxEnvironment {
	s.Description = &v
	return s
}

// SetDnsStatus sets the DnsStatus field's value.
func (s *KxEnvironment) SetDnsStatus(v string) *KxEnvironment {
	s.DnsStatus = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *KxEnvironment) SetEnvironmentArn(v string) *KxEnvironment {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *KxEnvironment) SetEnvironmentId(v string) *KxEnvironment {
	s.EnvironmentId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *KxEnvironment) SetErrorMessage(v string) *KxEnvironment {
	s.ErrorMessage = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *KxEnvironment) SetKmsKeyId(v string) *KxEnvironment {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *KxEnvironment) SetName(v string) *KxEnvironment {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KxEnvironment) SetStatus(v string) *KxEnvironment {
	s.Status = &v
	return s
}

// SetTgwStatus sets the TgwStatus field's value.
func (s *KxEnvironment) SetTgwStatus(v string) *KxEnvironment {
	s.TgwStatus = &v
	return s
}

// SetTransitGatewayConfiguration sets the TransitGatewayConfiguration field's value.
func (s *KxEnvironment) SetTransitGatewayConfiguration(v *TransitGatewayConfiguration) *KxEnvironment {
	s.TransitGatewayConfiguration = v
	return s
}

// SetUpdateTimestamp sets the UpdateTimestamp field's value.
func (s *KxEnvironment) SetUpdateTimestamp(v time.Time) *KxEnvironment {
	s.UpdateTimestamp = &v
	return s
}

// The structure containing the size and type of the network attached storage
// (NAS_1) file system volume.
type KxNAS1Configuration struct {
	_ struct{} `type:"structure"`

	// The size of the network attached storage.
	Size *int64 `locationName:"size" min:"1200" type:"integer"`

	// The type of the network attached storage.
	Type *string `locationName:"type" type:"string" enum:"KxNAS1Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxNAS1Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxNAS1Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxNAS1Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxNAS1Configuration"}
	if s.Size != nil && *s.Size < 1200 {
		invalidParams.Add(request.NewErrParamMinValue("Size", 1200))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSize sets the Size field's value.
func (s *KxNAS1Configuration) SetSize(v int64) *KxNAS1Configuration {
	s.Size = &v
	return s
}

// SetType sets the Type field's value.
func (s *KxNAS1Configuration) SetType(v string) *KxNAS1Configuration {
	s.Type = &v
	return s
}

// A structure that stores metadata for a kdb node.
type KxNode struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones where subnets for the environment
	// are created.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The time when a particular node is started. The value is determined as epoch
	// time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LaunchTime *time.Time `locationName:"launchTime" type:"timestamp"`

	// A unique identifier for the node.
	NodeId *string `locationName:"nodeId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxNode) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *KxNode) SetAvailabilityZoneId(v string) *KxNode {
	s.AvailabilityZoneId = &v
	return s
}

// SetLaunchTime sets the LaunchTime field's value.
func (s *KxNode) SetLaunchTime(v time.Time) *KxNode {
	s.LaunchTime = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *KxNode) SetNodeId(v string) *KxNode {
	s.NodeId = &v
	return s
}

// The size and type of temporary storage that is used to hold data during the
// savedown process. All the data written to this storage space is lost when
// the cluster node is restarted.
type KxSavedownStorageConfiguration struct {
	_ struct{} `type:"structure"`

	// The size of temporary storage in gibibytes.
	Size *int64 `locationName:"size" min:"10" type:"integer"`

	// The type of writeable storage space for temporarily storing your savedown
	// data. The valid values are:
	//
	//    * SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
	Type *string `locationName:"type" type:"string" enum:"KxSavedownStorageType"`

	// The name of the kdb volume that you want to use as writeable save-down storage
	// for clusters.
	VolumeName *string `locationName:"volumeName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxSavedownStorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxSavedownStorageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxSavedownStorageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxSavedownStorageConfiguration"}
	if s.Size != nil && *s.Size < 10 {
		invalidParams.Add(request.NewErrParamMinValue("Size", 10))
	}
	if s.VolumeName != nil && len(*s.VolumeName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSize sets the Size field's value.
func (s *KxSavedownStorageConfiguration) SetSize(v int64) *KxSavedownStorageConfiguration {
	s.Size = &v
	return s
}

// SetType sets the Type field's value.
func (s *KxSavedownStorageConfiguration) SetType(v string) *KxSavedownStorageConfiguration {
	s.Type = &v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *KxSavedownStorageConfiguration) SetVolumeName(v string) *KxSavedownStorageConfiguration {
	s.VolumeName = &v
	return s
}

// A structure for storing metadata of scaling group.
type KxScalingGroup struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The list of clusters currently active in a given scaling group.
	Clusters []*string `locationName:"clusters" type:"list"`

	// The timestamp at which the scaling group was created in FinSpace. The value
	// is determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The memory and CPU capabilities of the scaling group host on which FinSpace
	// Managed kdb clusters will be placed.
	HostType *string `locationName:"hostType" min:"1" type:"string"`

	// The last time that the scaling group was updated in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// A unique identifier for the kdb scaling group.
	ScalingGroupName *string `locationName:"scalingGroupName" min:"3" type:"string"`

	// The status of scaling groups.
	Status *string `locationName:"status" type:"string" enum:"KxScalingGroupStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxScalingGroup) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *KxScalingGroup) SetAvailabilityZoneId(v string) *KxScalingGroup {
	s.AvailabilityZoneId = &v
	return s
}

// SetClusters sets the Clusters field's value.
func (s *KxScalingGroup) SetClusters(v []*string) *KxScalingGroup {
	s.Clusters = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *KxScalingGroup) SetCreatedTimestamp(v time.Time) *KxScalingGroup {
	s.CreatedTimestamp = &v
	return s
}

// SetHostType sets the HostType field's value.
func (s *KxScalingGroup) SetHostType(v string) *KxScalingGroup {
	s.HostType = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *KxScalingGroup) SetLastModifiedTimestamp(v time.Time) *KxScalingGroup {
	s.LastModifiedTimestamp = &v
	return s
}

// SetScalingGroupName sets the ScalingGroupName field's value.
func (s *KxScalingGroup) SetScalingGroupName(v string) *KxScalingGroup {
	s.ScalingGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KxScalingGroup) SetStatus(v string) *KxScalingGroup {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *KxScalingGroup) SetStatusReason(v string) *KxScalingGroup {
	s.StatusReason = &v
	return s
}

// The structure that stores the capacity configuration details of a scaling
// group.
type KxScalingGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of vCPUs that you want to reserve for each node of this kdb cluster
	// on the scaling group host.
	Cpu *float64 `locationName:"cpu" min:"0.1" type:"double"`

	// An optional hard limit on the amount of memory a kdb cluster can use.
	MemoryLimit *int64 `locationName:"memoryLimit" min:"6" type:"integer"`

	// A reservation of the minimum amount of memory that should be available on
	// the scaling group for a kdb cluster to be successfully placed in a scaling
	// group.
	//
	// MemoryReservation is a required field
	MemoryReservation *int64 `locationName:"memoryReservation" min:"6" type:"integer" required:"true"`

	// The number of kdb cluster nodes.
	//
	// NodeCount is a required field
	NodeCount *int64 `locationName:"nodeCount" min:"1" type:"integer" required:"true"`

	// A unique identifier for the kdb scaling group.
	//
	// ScalingGroupName is a required field
	ScalingGroupName *string `locationName:"scalingGroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxScalingGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxScalingGroupConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KxScalingGroupConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KxScalingGroupConfiguration"}
	if s.Cpu != nil && *s.Cpu < 0.1 {
		invalidParams.Add(request.NewErrParamMinValue("Cpu", 0.1))
	}
	if s.MemoryLimit != nil && *s.MemoryLimit < 6 {
		invalidParams.Add(request.NewErrParamMinValue("MemoryLimit", 6))
	}
	if s.MemoryReservation == nil {
		invalidParams.Add(request.NewErrParamRequired("MemoryReservation"))
	}
	if s.MemoryReservation != nil && *s.MemoryReservation < 6 {
		invalidParams.Add(request.NewErrParamMinValue("MemoryReservation", 6))
	}
	if s.NodeCount == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeCount"))
	}
	if s.NodeCount != nil && *s.NodeCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NodeCount", 1))
	}
	if s.ScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingGroupName"))
	}
	if s.ScalingGroupName != nil && len(*s.ScalingGroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingGroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCpu sets the Cpu field's value.
func (s *KxScalingGroupConfiguration) SetCpu(v float64) *KxScalingGroupConfiguration {
	s.Cpu = &v
	return s
}

// SetMemoryLimit sets the MemoryLimit field's value.
func (s *KxScalingGroupConfiguration) SetMemoryLimit(v int64) *KxScalingGroupConfiguration {
	s.MemoryLimit = &v
	return s
}

// SetMemoryReservation sets the MemoryReservation field's value.
func (s *KxScalingGroupConfiguration) SetMemoryReservation(v int64) *KxScalingGroupConfiguration {
	s.MemoryReservation = &v
	return s
}

// SetNodeCount sets the NodeCount field's value.
func (s *KxScalingGroupConfiguration) SetNodeCount(v int64) *KxScalingGroupConfiguration {
	s.NodeCount = &v
	return s
}

// SetScalingGroupName sets the ScalingGroupName field's value.
func (s *KxScalingGroupConfiguration) SetScalingGroupName(v string) *KxScalingGroupConfiguration {
	s.ScalingGroupName = &v
	return s
}

// A structure that stores metadata for a kdb user.
type KxUser struct {
	_ struct{} `type:"structure"`

	// The timestamp at which the kdb user was created.
	CreateTimestamp *time.Time `locationName:"createTimestamp" type:"timestamp"`

	// The IAM role ARN that is associated with the user.
	IamRole *string `locationName:"iamRole" min:"20" type:"string"`

	// The timestamp at which the kdb user was updated.
	UpdateTimestamp *time.Time `locationName:"updateTimestamp" type:"timestamp"`

	// The Amazon Resource Name (ARN) that identifies the user. For more information
	// about ARNs and how to use ARNs in policies, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	UserArn *string `locationName:"userArn" min:"20" type:"string"`

	// A unique identifier for the user.
	UserName *string `locationName:"userName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxUser) GoString() string {
	return s.String()
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *KxUser) SetCreateTimestamp(v time.Time) *KxUser {
	s.CreateTimestamp = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *KxUser) SetIamRole(v string) *KxUser {
	s.IamRole = &v
	return s
}

// SetUpdateTimestamp sets the UpdateTimestamp field's value.
func (s *KxUser) SetUpdateTimestamp(v time.Time) *KxUser {
	s.UpdateTimestamp = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *KxUser) SetUserArn(v string) *KxUser {
	s.UserArn = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *KxUser) SetUserName(v string) *KxUser {
	s.UserName = &v
	return s
}

// The structure that contains the metadata of the volume.
type KxVolume struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones.
	AvailabilityZoneIds []*string `locationName:"availabilityZoneIds" type:"list"`

	// The number of availability zones assigned to the volume. Currently, only
	// SINGLE is supported.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// The timestamp at which the volume was created in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// A description of the volume.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The last time that the volume was updated in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The status of volume.
	//
	//    * CREATING – The volume creation is in progress.
	//
	//    * CREATE_FAILED – The volume creation has failed.
	//
	//    * ACTIVE – The volume is active.
	//
	//    * UPDATING – The volume is in the process of being updated.
	//
	//    * UPDATE_FAILED – The update action failed.
	//
	//    * UPDATED – The volume is successfully updated.
	//
	//    * DELETING – The volume is in the process of being deleted.
	//
	//    * DELETE_FAILED – The system failed to delete the volume.
	//
	//    * DELETED – The volume is successfully deleted.
	Status *string `locationName:"status" type:"string" enum:"KxVolumeStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`

	// A unique identifier for the volume.
	VolumeName *string `locationName:"volumeName" min:"3" type:"string"`

	// The type of file system volume. Currently, FinSpace only supports NAS_1 volume
	// type.
	VolumeType *string `locationName:"volumeType" type:"string" enum:"KxVolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KxVolume) GoString() string {
	return s.String()
}

// SetAvailabilityZoneIds sets the AvailabilityZoneIds field's value.
func (s *KxVolume) SetAvailabilityZoneIds(v []*string) *KxVolume {
	s.AvailabilityZoneIds = v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *KxVolume) SetAzMode(v string) *KxVolume {
	s.AzMode = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *KxVolume) SetCreatedTimestamp(v time.Time) *KxVolume {
	s.CreatedTimestamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KxVolume) SetDescription(v string) *KxVolume {
	s.Description = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *KxVolume) SetLastModifiedTimestamp(v time.Time) *KxVolume {
	s.LastModifiedTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KxVolume) SetStatus(v string) *KxVolume {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *KxVolume) SetStatusReason(v string) *KxVolume {
	s.StatusReason = &v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *KxVolume) SetVolumeName(v string) *KxVolume {
	s.VolumeName = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *KxVolume) SetVolumeType(v string) *KxVolume {
	s.VolumeType = &v
	return s
}

// A service limit or quota is exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListEnvironmentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token generated by FinSpace that specifies where to continue pagination
	// if a previous request was truncated. To get the next set of pages, pass in
	// the nextTokennextToken value from the response object of the previous page
	// call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentsInput) SetMaxResults(v int64) *ListEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsInput) SetNextToken(v string) *ListEnvironmentsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of all of your FinSpace environments.
	Environments []*Environment `locationName:"environments" type:"list"`

	// A token that you can use in a subsequent call to retrieve the next set of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironments sets the Environments field's value.
func (s *ListEnvironmentsOutput) SetEnvironments(v []*Environment) *ListEnvironmentsOutput {
	s.Environments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsOutput) SetNextToken(v string) *ListEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type ListKxChangesetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the kdb database.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token that indicates where a results page should begin.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxChangesetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxChangesetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKxChangesetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKxChangesetsInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ListKxChangesetsInput) SetDatabaseName(v string) *ListKxChangesetsInput {
	s.DatabaseName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListKxChangesetsInput) SetEnvironmentId(v string) *ListKxChangesetsInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKxChangesetsInput) SetMaxResults(v int64) *ListKxChangesetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxChangesetsInput) SetNextToken(v string) *ListKxChangesetsInput {
	s.NextToken = &v
	return s
}

type ListKxChangesetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of changesets for a database.
	KxChangesets []*KxChangesetListEntry `locationName:"kxChangesets" type:"list"`

	// A token that indicates where a results page should begin.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxChangesetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxChangesetsOutput) GoString() string {
	return s.String()
}

// SetKxChangesets sets the KxChangesets field's value.
func (s *ListKxChangesetsOutput) SetKxChangesets(v []*KxChangesetListEntry) *ListKxChangesetsOutput {
	s.KxChangesets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxChangesetsOutput) SetNextToken(v string) *ListKxChangesetsOutput {
	s.NextToken = &v
	return s
}

type ListKxClusterNodesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique name for the cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"clusterName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token that indicates where a results page should begin.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxClusterNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxClusterNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKxClusterNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKxClusterNodesInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListKxClusterNodesInput) SetClusterName(v string) *ListKxClusterNodesInput {
	s.ClusterName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListKxClusterNodesInput) SetEnvironmentId(v string) *ListKxClusterNodesInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKxClusterNodesInput) SetMaxResults(v int64) *ListKxClusterNodesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxClusterNodesInput) SetNextToken(v string) *ListKxClusterNodesInput {
	s.NextToken = &v
	return s
}

type ListKxClusterNodesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates where a results page should begin.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of nodes associated with the cluster.
	Nodes []*KxNode `locationName:"nodes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxClusterNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxClusterNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxClusterNodesOutput) SetNextToken(v string) *ListKxClusterNodesOutput {
	s.NextToken = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *ListKxClusterNodesOutput) SetNodes(v []*KxNode) *ListKxClusterNodesOutput {
	s.Nodes = v
	return s
}

type ListKxClustersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies the type of KDB database that is being created. The following types
	// are available:
	//
	//    * HDB – A Historical Database. The data is only accessible with read-only
	//    permissions from one of the FinSpace managed kdb databases mounted to
	//    the cluster.
	//
	//    * RDB – A Realtime Database. This type of database captures all the
	//    data from a ticker plant and stores it in memory until the end of day,
	//    after which it writes all of its data to a disk and reloads the HDB. This
	//    cluster type requires local storage for temporary storage of data during
	//    the savedown process. If you specify this field in your request, you must
	//    provide the savedownStorageConfiguration parameter.
	//
	//    * GATEWAY – A gateway cluster allows you to access data across processes
	//    in kdb systems. It allows you to create your own routing logic using the
	//    initialization scripts and custom code. This type of cluster does not
	//    require a writable local storage.
	//
	//    * GP – A general purpose cluster allows you to quickly iterate on code
	//    during development by granting greater access to system commands and enabling
	//    a fast reload of custom code. This cluster type can optionally mount databases
	//    including cache and savedown storage. For this cluster type, the node
	//    count is fixed at 1. It does not support autoscaling and supports only
	//    SINGLE AZ mode.
	//
	//    * Tickerplant – A tickerplant cluster allows you to subscribe to feed
	//    handlers based on IAM permissions. It can publish to RDBs, other Tickerplants,
	//    and real-time subscribers (RTS). Tickerplants can persist messages to
	//    log, which is readable by any RDB environment. It supports only single-node
	//    that is only one kdb process.
	ClusterType *string `location:"querystring" locationName:"clusterType" type:"string" enum:"KxClusterType"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token that indicates where a results page should begin.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKxClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKxClustersInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterType sets the ClusterType field's value.
func (s *ListKxClustersInput) SetClusterType(v string) *ListKxClustersInput {
	s.ClusterType = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListKxClustersInput) SetEnvironmentId(v string) *ListKxClustersInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKxClustersInput) SetMaxResults(v int64) *ListKxClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxClustersInput) SetNextToken(v string) *ListKxClustersInput {
	s.NextToken = &v
	return s
}

type ListKxClustersOutput struct {
	_ struct{} `type:"structure"`

	// Lists the cluster details.
	KxClusterSummaries []*KxCluster `locationName:"kxClusterSummaries" type:"list"`

	// A token that indicates where a results page should begin.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxClustersOutput) GoString() string {
	return s.String()
}

// SetKxClusterSummaries sets the KxClusterSummaries field's value.
func (s *ListKxClustersOutput) SetKxClusterSummaries(v []*KxCluster) *ListKxClustersOutput {
	s.KxClusterSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxClustersOutput) SetNextToken(v string) *ListKxClustersOutput {
	s.NextToken = &v
	return s
}

type ListKxDatabasesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token that indicates where a results page should begin.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKxDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKxDatabasesInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListKxDatabasesInput) SetEnvironmentId(v string) *ListKxDatabasesInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKxDatabasesInput) SetMaxResults(v int64) *ListKxDatabasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxDatabasesInput) SetNextToken(v string) *ListKxDatabasesInput {
	s.NextToken = &v
	return s
}

type ListKxDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of databases in the kdb environment.
	KxDatabases []*KxDatabaseListEntry `locationName:"kxDatabases" type:"list"`

	// A token that indicates where a results page should begin.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxDatabasesOutput) GoString() string {
	return s.String()
}

// SetKxDatabases sets the KxDatabases field's value.
func (s *ListKxDatabasesOutput) SetKxDatabases(v []*KxDatabaseListEntry) *ListKxDatabasesOutput {
	s.KxDatabases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxDatabasesOutput) SetNextToken(v string) *ListKxDatabasesOutput {
	s.NextToken = &v
	return s
}

type ListKxDataviewsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the database where the dataviews were created.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A unique identifier for the kdb environment, for which you want to retrieve
	// a list of dataviews.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token that indicates where a results page should begin.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxDataviewsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxDataviewsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKxDataviewsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKxDataviewsInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ListKxDataviewsInput) SetDatabaseName(v string) *ListKxDataviewsInput {
	s.DatabaseName = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListKxDataviewsInput) SetEnvironmentId(v string) *ListKxDataviewsInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKxDataviewsInput) SetMaxResults(v int64) *ListKxDataviewsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxDataviewsInput) SetNextToken(v string) *ListKxDataviewsInput {
	s.NextToken = &v
	return s
}

type ListKxDataviewsOutput struct {
	_ struct{} `type:"structure"`

	// The list of kdb dataviews that are currently active for the given database.
	KxDataviews []*KxDataviewListEntry `locationName:"kxDataviews" type:"list"`

	// A token that indicates where a results page should begin.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxDataviewsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxDataviewsOutput) GoString() string {
	return s.String()
}

// SetKxDataviews sets the KxDataviews field's value.
func (s *ListKxDataviewsOutput) SetKxDataviews(v []*KxDataviewListEntry) *ListKxDataviewsOutput {
	s.KxDataviews = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxDataviewsOutput) SetNextToken(v string) *ListKxDataviewsOutput {
	s.NextToken = &v
	return s
}

type ListKxEnvironmentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token that indicates where a results page should begin.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKxEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKxEnvironmentsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKxEnvironmentsInput) SetMaxResults(v int64) *ListKxEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxEnvironmentsInput) SetNextToken(v string) *ListKxEnvironmentsInput {
	s.NextToken = &v
	return s
}

type ListKxEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of environments in an account.
	Environments []*KxEnvironment `locationName:"environments" type:"list"`

	// A token that indicates where a results page should begin.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironments sets the Environments field's value.
func (s *ListKxEnvironmentsOutput) SetEnvironments(v []*KxEnvironment) *ListKxEnvironmentsOutput {
	s.Environments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxEnvironmentsOutput) SetNextToken(v string) *ListKxEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type ListKxScalingGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the kdb environment, for which you want to retrieve
	// a list of scaling groups.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token that indicates where a results page should begin.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxScalingGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxScalingGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKxScalingGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKxScalingGroupsInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListKxScalingGroupsInput) SetEnvironmentId(v string) *ListKxScalingGroupsInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKxScalingGroupsInput) SetMaxResults(v int64) *ListKxScalingGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxScalingGroupsInput) SetNextToken(v string) *ListKxScalingGroupsInput {
	s.NextToken = &v
	return s
}

type ListKxScalingGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates where a results page should begin.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of scaling groups available in a kdb environment.
	ScalingGroups []*KxScalingGroup `locationName:"scalingGroups" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxScalingGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxScalingGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxScalingGroupsOutput) SetNextToken(v string) *ListKxScalingGroupsOutput {
	s.NextToken = &v
	return s
}

// SetScalingGroups sets the ScalingGroups field's value.
func (s *ListKxScalingGroupsOutput) SetScalingGroups(v []*KxScalingGroup) *ListKxScalingGroupsOutput {
	s.ScalingGroups = v
	return s
}

type ListKxUsersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token that indicates where a results page should begin.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKxUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKxUsersInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListKxUsersInput) SetEnvironmentId(v string) *ListKxUsersInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKxUsersInput) SetMaxResults(v int64) *ListKxUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxUsersInput) SetNextToken(v string) *ListKxUsersInput {
	s.NextToken = &v
	return s
}

type ListKxUsersOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates where a results page should begin.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of users in a kdb environment.
	Users []*KxUser `locationName:"users" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxUsersOutput) SetNextToken(v string) *ListKxUsersOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListKxUsersOutput) SetUsers(v []*KxUser) *ListKxUsersOutput {
	s.Users = v
	return s
}

type ListKxVolumesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the kdb environment, whose clusters can attach to
	// the volume.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in this request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A token that indicates where a results page should begin.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The type of file system volume. Currently, FinSpace only supports NAS_1 volume
	// type.
	VolumeType *string `location:"querystring" locationName:"volumeType" type:"string" enum:"KxVolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKxVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKxVolumesInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListKxVolumesInput) SetEnvironmentId(v string) *ListKxVolumesInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKxVolumesInput) SetMaxResults(v int64) *ListKxVolumesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxVolumesInput) SetNextToken(v string) *ListKxVolumesInput {
	s.NextToken = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *ListKxVolumesInput) SetVolumeType(v string) *ListKxVolumesInput {
	s.VolumeType = &v
	return s
}

type ListKxVolumesOutput struct {
	_ struct{} `type:"structure"`

	// A summary of volumes.
	KxVolumeSummaries []*KxVolume `locationName:"kxVolumeSummaries" type:"list"`

	// A token that indicates where a results page should begin.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKxVolumesOutput) GoString() string {
	return s.String()
}

// SetKxVolumeSummaries sets the KxVolumeSummaries field's value.
func (s *ListKxVolumesOutput) SetKxVolumeSummaries(v []*KxVolume) *ListKxVolumesOutput {
	s.KxVolumeSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKxVolumesOutput) SetNextToken(v string) *ListKxVolumesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of all tags for a resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The network access control list (ACL) is an optional layer of security for
// your VPC that acts as a firewall for controlling traffic in and out of one
// or more subnets. The entry is a set of numbered ingress and egress rules
// that determine whether a packet should be allowed in or out of a subnet associated
// with the ACL. We process the entries in the ACL according to the rule numbers,
// in ascending order.
type NetworkACLEntry struct {
	_ struct{} `type:"structure"`

	// The IPv4 network range to allow or deny, in CIDR notation. For example, 172.16.0.0/24.
	// We modify the specified CIDR block to its canonical form. For example, if
	// you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
	//
	// CidrBlock is a required field
	CidrBlock *string `locationName:"cidrBlock" min:"1" type:"string" required:"true"`

	// Defines the ICMP protocol that consists of the ICMP type and code.
	IcmpTypeCode *IcmpTypeCode `locationName:"icmpTypeCode" type:"structure"`

	// The range of ports the rule applies to.
	PortRange *PortRange `locationName:"portRange" type:"structure"`

	// The protocol number. A value of -1 means all the protocols.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" min:"1" type:"string" required:"true"`

	// Indicates whether to allow or deny the traffic that matches the rule.
	//
	// RuleAction is a required field
	RuleAction *string `locationName:"ruleAction" type:"string" required:"true" enum:"RuleAction"`

	// The rule number for the entry. For example 100. All the network ACL entries
	// are processed in ascending order by rule number.
	//
	// RuleNumber is a required field
	RuleNumber *int64 `locationName:"ruleNumber" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkACLEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkACLEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkACLEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkACLEntry"}
	if s.CidrBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("CidrBlock"))
	}
	if s.CidrBlock != nil && len(*s.CidrBlock) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CidrBlock", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.Protocol != nil && len(*s.Protocol) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Protocol", 1))
	}
	if s.RuleAction == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleAction"))
	}
	if s.RuleNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleNumber"))
	}
	if s.RuleNumber != nil && *s.RuleNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RuleNumber", 1))
	}
	if s.IcmpTypeCode != nil {
		if err := s.IcmpTypeCode.Validate(); err != nil {
			invalidParams.AddNested("IcmpTypeCode", err.(request.ErrInvalidParams))
		}
	}
	if s.PortRange != nil {
		if err := s.PortRange.Validate(); err != nil {
			invalidParams.AddNested("PortRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *NetworkACLEntry) SetCidrBlock(v string) *NetworkACLEntry {
	s.CidrBlock = &v
	return s
}

// SetIcmpTypeCode sets the IcmpTypeCode field's value.
func (s *NetworkACLEntry) SetIcmpTypeCode(v *IcmpTypeCode) *NetworkACLEntry {
	s.IcmpTypeCode = v
	return s
}

// SetPortRange sets the PortRange field's value.
func (s *NetworkACLEntry) SetPortRange(v *PortRange) *NetworkACLEntry {
	s.PortRange = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *NetworkACLEntry) SetProtocol(v string) *NetworkACLEntry {
	s.Protocol = &v
	return s
}

// SetRuleAction sets the RuleAction field's value.
func (s *NetworkACLEntry) SetRuleAction(v string) *NetworkACLEntry {
	s.RuleAction = &v
	return s
}

// SetRuleNumber sets the RuleNumber field's value.
func (s *NetworkACLEntry) SetRuleNumber(v int64) *NetworkACLEntry {
	s.RuleNumber = &v
	return s
}

// The range of ports the rule applies to.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The first port in the range.
	//
	// From is a required field
	From *int64 `locationName:"from" type:"integer" required:"true"`

	// The last port in the range.
	//
	// To is a required field
	To *int64 `locationName:"to" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortRange"}
	if s.From == nil {
		invalidParams.Add(request.NewErrParamRequired("From"))
	}
	if s.To == nil {
		invalidParams.Add(request.NewErrParamRequired("To"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrom sets the From field's value.
func (s *PortRange) SetFrom(v int64) *PortRange {
	s.From = &v
	return s
}

// SetTo sets the To field's value.
func (s *PortRange) SetTo(v int64) *PortRange {
	s.To = &v
	return s
}

// The specified resource group already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more resources can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have exceeded your service quota. To perform the requested action, remove
// some of the relevant resources, or use Service Quotas to request a service
// quota increase.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration information for the superuser.
type SuperuserParameters struct {
	_ struct{} `type:"structure"`

	// The email address of the superuser.
	//
	// EmailAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SuperuserParameters's
	// String and GoString methods.
	//
	// EmailAddress is a required field
	EmailAddress *string `locationName:"emailAddress" min:"1" type:"string" required:"true" sensitive:"true"`

	// The first name of the superuser.
	//
	// FirstName is a required field
	FirstName *string `locationName:"firstName" min:"1" type:"string" required:"true"`

	// The last name of the superuser.
	//
	// LastName is a required field
	LastName *string `locationName:"lastName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuperuserParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuperuserParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SuperuserParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SuperuserParameters"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 1))
	}
	if s.FirstName == nil {
		invalidParams.Add(request.NewErrParamRequired("FirstName"))
	}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstName", 1))
	}
	if s.LastName == nil {
		invalidParams.Add(request.NewErrParamRequired("LastName"))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *SuperuserParameters) SetEmailAddress(v string) *SuperuserParameters {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *SuperuserParameters) SetFirstName(v string) *SuperuserParameters {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *SuperuserParameters) SetLastName(v string) *SuperuserParameters {
	s.LastName = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// One or more tags to be assigned to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A configuration to store the Tickerplant logs. It consists of a list of volumes
// that will be mounted to your cluster. For the cluster type Tickerplant, the
// location of the TP volume on the cluster will be available by using the global
// variable .aws.tp_log_path.
type TickerplantLogConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the volumes for tickerplant logs.
	TickerplantLogVolumes []*string `locationName:"tickerplantLogVolumes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TickerplantLogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TickerplantLogConfiguration) GoString() string {
	return s.String()
}

// SetTickerplantLogVolumes sets the TickerplantLogVolumes field's value.
func (s *TickerplantLogConfiguration) SetTickerplantLogVolumes(v []*string) *TickerplantLogConfiguration {
	s.TickerplantLogVolumes = v
	return s
}

// The structure of the transit gateway and network configuration that is used
// to connect the kdb environment to an internal network.
type TransitGatewayConfiguration struct {
	_ struct{} `type:"structure"`

	// The rules that define how you manage the outbound traffic from kdb network
	// to your internal network.
	AttachmentNetworkAclConfiguration []*NetworkACLEntry `locationName:"attachmentNetworkAclConfiguration" min:"1" type:"list"`

	// The routing CIDR on behalf of kdb environment. It could be any "/26 range
	// in the 100.64.0.0 CIDR space. After providing, it will be added to the customer's
	// transit gateway routing table so that the traffics could be routed to kdb
	// network.
	//
	// RoutableCIDRSpace is a required field
	RoutableCIDRSpace *string `locationName:"routableCIDRSpace" type:"string" required:"true"`

	// The identifier of the transit gateway created by the customer to connect
	// outbound traffics from kdb network to your internal network.
	//
	// TransitGatewayID is a required field
	TransitGatewayID *string `locationName:"transitGatewayID" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransitGatewayConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransitGatewayConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransitGatewayConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransitGatewayConfiguration"}
	if s.AttachmentNetworkAclConfiguration != nil && len(s.AttachmentNetworkAclConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttachmentNetworkAclConfiguration", 1))
	}
	if s.RoutableCIDRSpace == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutableCIDRSpace"))
	}
	if s.TransitGatewayID == nil {
		invalidParams.Add(request.NewErrParamRequired("TransitGatewayID"))
	}
	if s.TransitGatewayID != nil && len(*s.TransitGatewayID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransitGatewayID", 1))
	}
	if s.AttachmentNetworkAclConfiguration != nil {
		for i, v := range s.AttachmentNetworkAclConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttachmentNetworkAclConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentNetworkAclConfiguration sets the AttachmentNetworkAclConfiguration field's value.
func (s *TransitGatewayConfiguration) SetAttachmentNetworkAclConfiguration(v []*NetworkACLEntry) *TransitGatewayConfiguration {
	s.AttachmentNetworkAclConfiguration = v
	return s
}

// SetRoutableCIDRSpace sets the RoutableCIDRSpace field's value.
func (s *TransitGatewayConfiguration) SetRoutableCIDRSpace(v string) *TransitGatewayConfiguration {
	s.RoutableCIDRSpace = &v
	return s
}

// SetTransitGatewayID sets the TransitGatewayID field's value.
func (s *TransitGatewayConfiguration) SetTransitGatewayID(v string) *TransitGatewayConfiguration {
	s.TransitGatewayID = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A FinSpace resource from which you want to remove a tag or tags. The value
	// for this parameter is an Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The tag keys (names) of one or more tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The description of the environment.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The identifier of the FinSpace environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// Authentication mode for the environment.
	//
	//    * FEDERATED - Users access FinSpace through Single Sign On (SSO) via your
	//    Identity provider.
	//
	//    * LOCAL - Users access FinSpace via email and password managed within
	//    the FinSpace environment.
	FederationMode *string `locationName:"federationMode" type:"string" enum:"FederationMode"`

	// Configuration information when authentication mode is FEDERATED.
	FederationParameters *FederationParameters `locationName:"federationParameters" type:"structure"`

	// The name of the environment.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.FederationParameters != nil {
		if err := s.FederationParameters.Validate(); err != nil {
			invalidParams.AddNested("FederationParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateEnvironmentInput) SetDescription(v string) *UpdateEnvironmentInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateEnvironmentInput) SetEnvironmentId(v string) *UpdateEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

// SetFederationMode sets the FederationMode field's value.
func (s *UpdateEnvironmentInput) SetFederationMode(v string) *UpdateEnvironmentInput {
	s.FederationMode = &v
	return s
}

// SetFederationParameters sets the FederationParameters field's value.
func (s *UpdateEnvironmentInput) SetFederationParameters(v *FederationParameters) *UpdateEnvironmentInput {
	s.FederationParameters = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEnvironmentInput) SetName(v string) *UpdateEnvironmentInput {
	s.Name = &v
	return s
}

type UpdateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// Returns the FinSpace environment object.
	Environment *Environment `locationName:"environment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateEnvironmentOutput) SetEnvironment(v *Environment) *UpdateEnvironmentOutput {
	s.Environment = v
	return s
}

type UpdateKxClusterCodeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"clusterName" min:"3" type:"string" required:"true"`

	// The structure of the customer code available within the running cluster.
	//
	// Code is a required field
	Code *CodeConfiguration `locationName:"code" type:"structure" required:"true"`

	// Specifies the key-value pairs to make them available inside the cluster.
	//
	// You cannot update this parameter for a NO_RESTART deployment.
	CommandLineArguments []*KxCommandLineArgument `locationName:"commandLineArguments" type:"list"`

	// The configuration that allows you to choose how you want to update the code
	// on a cluster.
	DeploymentConfiguration *KxClusterCodeDeploymentConfiguration `locationName:"deploymentConfiguration" type:"structure"`

	// A unique identifier of the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// Specifies a Q program that will be run at launch of a cluster. It is a relative
	// path within .zip file that contains the custom code, which will be loaded
	// on the cluster. It must include the file name itself. For example, somedir/init.q.
	//
	// You cannot update this parameter for a NO_RESTART deployment.
	InitializationScript *string `locationName:"initializationScript" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxClusterCodeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxClusterCodeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKxClusterCodeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKxClusterCodeConfigurationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 3))
	}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.InitializationScript != nil && len(*s.InitializationScript) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitializationScript", 1))
	}
	if s.Code != nil {
		if err := s.Code.Validate(); err != nil {
			invalidParams.AddNested("Code", err.(request.ErrInvalidParams))
		}
	}
	if s.CommandLineArguments != nil {
		for i, v := range s.CommandLineArguments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CommandLineArguments", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DeploymentConfiguration != nil {
		if err := s.DeploymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DeploymentConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateKxClusterCodeConfigurationInput) SetClientToken(v string) *UpdateKxClusterCodeConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateKxClusterCodeConfigurationInput) SetClusterName(v string) *UpdateKxClusterCodeConfigurationInput {
	s.ClusterName = &v
	return s
}

// SetCode sets the Code field's value.
func (s *UpdateKxClusterCodeConfigurationInput) SetCode(v *CodeConfiguration) *UpdateKxClusterCodeConfigurationInput {
	s.Code = v
	return s
}

// SetCommandLineArguments sets the CommandLineArguments field's value.
func (s *UpdateKxClusterCodeConfigurationInput) SetCommandLineArguments(v []*KxCommandLineArgument) *UpdateKxClusterCodeConfigurationInput {
	s.CommandLineArguments = v
	return s
}

// SetDeploymentConfiguration sets the DeploymentConfiguration field's value.
func (s *UpdateKxClusterCodeConfigurationInput) SetDeploymentConfiguration(v *KxClusterCodeDeploymentConfiguration) *UpdateKxClusterCodeConfigurationInput {
	s.DeploymentConfiguration = v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxClusterCodeConfigurationInput) SetEnvironmentId(v string) *UpdateKxClusterCodeConfigurationInput {
	s.EnvironmentId = &v
	return s
}

// SetInitializationScript sets the InitializationScript field's value.
func (s *UpdateKxClusterCodeConfigurationInput) SetInitializationScript(v string) *UpdateKxClusterCodeConfigurationInput {
	s.InitializationScript = &v
	return s
}

type UpdateKxClusterCodeConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxClusterCodeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxClusterCodeConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateKxClusterDatabasesInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A unique name for the cluster that you want to modify.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"clusterName" min:"3" type:"string" required:"true"`

	// The structure of databases mounted on the cluster.
	//
	// Databases is a required field
	Databases []*KxDatabaseConfiguration `locationName:"databases" type:"list" required:"true"`

	// The configuration that allows you to choose how you want to update the databases
	// on a cluster.
	DeploymentConfiguration *KxDeploymentConfiguration `locationName:"deploymentConfiguration" type:"structure"`

	// The unique identifier of a kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxClusterDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxClusterDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKxClusterDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKxClusterDatabasesInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 3))
	}
	if s.Databases == nil {
		invalidParams.Add(request.NewErrParamRequired("Databases"))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.Databases != nil {
		for i, v := range s.Databases {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Databases", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DeploymentConfiguration != nil {
		if err := s.DeploymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DeploymentConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateKxClusterDatabasesInput) SetClientToken(v string) *UpdateKxClusterDatabasesInput {
	s.ClientToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateKxClusterDatabasesInput) SetClusterName(v string) *UpdateKxClusterDatabasesInput {
	s.ClusterName = &v
	return s
}

// SetDatabases sets the Databases field's value.
func (s *UpdateKxClusterDatabasesInput) SetDatabases(v []*KxDatabaseConfiguration) *UpdateKxClusterDatabasesInput {
	s.Databases = v
	return s
}

// SetDeploymentConfiguration sets the DeploymentConfiguration field's value.
func (s *UpdateKxClusterDatabasesInput) SetDeploymentConfiguration(v *KxDeploymentConfiguration) *UpdateKxClusterDatabasesInput {
	s.DeploymentConfiguration = v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxClusterDatabasesInput) SetEnvironmentId(v string) *UpdateKxClusterDatabasesInput {
	s.EnvironmentId = &v
	return s
}

type UpdateKxClusterDatabasesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxClusterDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxClusterDatabasesOutput) GoString() string {
	return s.String()
}

type UpdateKxDatabaseInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the kdb database.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// A description of the database.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKxDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKxDatabaseInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateKxDatabaseInput) SetClientToken(v string) *UpdateKxDatabaseInput {
	s.ClientToken = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateKxDatabaseInput) SetDatabaseName(v string) *UpdateKxDatabaseInput {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateKxDatabaseInput) SetDescription(v string) *UpdateKxDatabaseInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxDatabaseInput) SetEnvironmentId(v string) *UpdateKxDatabaseInput {
	s.EnvironmentId = &v
	return s
}

type UpdateKxDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// The name of the kdb database.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// A description of the database.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The last time that the database was modified. The value is determined as
	// epoch time in milliseconds. For example, the value for Monday, November 1,
	// 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateKxDatabaseOutput) SetDatabaseName(v string) *UpdateKxDatabaseOutput {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateKxDatabaseOutput) SetDescription(v string) *UpdateKxDatabaseOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxDatabaseOutput) SetEnvironmentId(v string) *UpdateKxDatabaseOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *UpdateKxDatabaseOutput) SetLastModifiedTimestamp(v time.Time) *UpdateKxDatabaseOutput {
	s.LastModifiedTimestamp = &v
	return s
}

type UpdateKxDataviewInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the changeset.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the database.
	//
	// DatabaseName is a required field
	DatabaseName *string `location:"uri" locationName:"databaseName" min:"3" type:"string" required:"true"`

	// The name of the dataview that you want to update.
	//
	// DataviewName is a required field
	DataviewName *string `location:"uri" locationName:"dataviewName" min:"3" type:"string" required:"true"`

	// The description for a dataview.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment, where you want to update the
	// dataview.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The configuration that contains the database path of the data that you want
	// to place on each selected volume. Each segment must have a unique database
	// path for each volume. If you do not explicitly specify any database path
	// for a volume, they are accessible from the cluster through the default S3/object
	// store segment.
	SegmentConfigurations []*KxDataviewSegmentConfiguration `locationName:"segmentConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxDataviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxDataviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKxDataviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKxDataviewInput"}
	if s.ChangesetId != nil && len(*s.ChangesetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangesetId", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 3))
	}
	if s.DataviewName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataviewName"))
	}
	if s.DataviewName != nil && len(*s.DataviewName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DataviewName", 3))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.SegmentConfigurations != nil {
		for i, v := range s.SegmentConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SegmentConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangesetId sets the ChangesetId field's value.
func (s *UpdateKxDataviewInput) SetChangesetId(v string) *UpdateKxDataviewInput {
	s.ChangesetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateKxDataviewInput) SetClientToken(v string) *UpdateKxDataviewInput {
	s.ClientToken = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateKxDataviewInput) SetDatabaseName(v string) *UpdateKxDataviewInput {
	s.DatabaseName = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *UpdateKxDataviewInput) SetDataviewName(v string) *UpdateKxDataviewInput {
	s.DataviewName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateKxDataviewInput) SetDescription(v string) *UpdateKxDataviewInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxDataviewInput) SetEnvironmentId(v string) *UpdateKxDataviewInput {
	s.EnvironmentId = &v
	return s
}

// SetSegmentConfigurations sets the SegmentConfigurations field's value.
func (s *UpdateKxDataviewInput) SetSegmentConfigurations(v []*KxDataviewSegmentConfiguration) *UpdateKxDataviewInput {
	s.SegmentConfigurations = v
	return s
}

type UpdateKxDataviewOutput struct {
	_ struct{} `type:"structure"`

	// The current active changeset versions of the database on the given dataview.
	ActiveVersions []*KxDataviewActiveVersion `locationName:"activeVersions" type:"list"`

	// The option to specify whether you want to apply all the future additions
	// and corrections automatically to the dataview when new changesets are ingested.
	// The default value is false.
	AutoUpdate *bool `locationName:"autoUpdate" type:"boolean"`

	// The identifier of the availability zones.
	AvailabilityZoneId *string `locationName:"availabilityZoneId" type:"string"`

	// The number of availability zones you want to assign per cluster. This can
	// be one of the following
	//
	//    * SINGLE – Assigns one availability zone per cluster.
	//
	//    * MULTI – Assigns all the availability zones per cluster.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// A unique identifier for the changeset.
	ChangesetId *string `locationName:"changesetId" min:"1" type:"string"`

	// The timestamp at which the dataview was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The name of the database.
	DatabaseName *string `locationName:"databaseName" min:"3" type:"string"`

	// The name of the database under which the dataview was created.
	DataviewName *string `locationName:"dataviewName" min:"3" type:"string"`

	// A description of the dataview.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment, where you want to update the
	// dataview.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The last time that the dataview was updated in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// The configuration that contains the database path of the data that you want
	// to place on each selected volume. Each segment must have a unique database
	// path for each volume. If you do not explicitly specify any database path
	// for a volume, they are accessible from the cluster through the default S3/object
	// store segment.
	SegmentConfigurations []*KxDataviewSegmentConfiguration `locationName:"segmentConfigurations" type:"list"`

	// The status of dataview creation.
	//
	//    * CREATING – The dataview creation is in progress.
	//
	//    * UPDATING – The dataview is in the process of being updated.
	//
	//    * ACTIVE – The dataview is active.
	Status *string `locationName:"status" type:"string" enum:"KxDataviewStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxDataviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxDataviewOutput) GoString() string {
	return s.String()
}

// SetActiveVersions sets the ActiveVersions field's value.
func (s *UpdateKxDataviewOutput) SetActiveVersions(v []*KxDataviewActiveVersion) *UpdateKxDataviewOutput {
	s.ActiveVersions = v
	return s
}

// SetAutoUpdate sets the AutoUpdate field's value.
func (s *UpdateKxDataviewOutput) SetAutoUpdate(v bool) *UpdateKxDataviewOutput {
	s.AutoUpdate = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *UpdateKxDataviewOutput) SetAvailabilityZoneId(v string) *UpdateKxDataviewOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *UpdateKxDataviewOutput) SetAzMode(v string) *UpdateKxDataviewOutput {
	s.AzMode = &v
	return s
}

// SetChangesetId sets the ChangesetId field's value.
func (s *UpdateKxDataviewOutput) SetChangesetId(v string) *UpdateKxDataviewOutput {
	s.ChangesetId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *UpdateKxDataviewOutput) SetCreatedTimestamp(v time.Time) *UpdateKxDataviewOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateKxDataviewOutput) SetDatabaseName(v string) *UpdateKxDataviewOutput {
	s.DatabaseName = &v
	return s
}

// SetDataviewName sets the DataviewName field's value.
func (s *UpdateKxDataviewOutput) SetDataviewName(v string) *UpdateKxDataviewOutput {
	s.DataviewName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateKxDataviewOutput) SetDescription(v string) *UpdateKxDataviewOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxDataviewOutput) SetEnvironmentId(v string) *UpdateKxDataviewOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *UpdateKxDataviewOutput) SetLastModifiedTimestamp(v time.Time) *UpdateKxDataviewOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSegmentConfigurations sets the SegmentConfigurations field's value.
func (s *UpdateKxDataviewOutput) SetSegmentConfigurations(v []*KxDataviewSegmentConfiguration) *UpdateKxDataviewOutput {
	s.SegmentConfigurations = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateKxDataviewOutput) SetStatus(v string) *UpdateKxDataviewOutput {
	s.Status = &v
	return s
}

type UpdateKxEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the kdb environment.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The name of the kdb environment.
	Name *string `locationName:"name" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKxEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKxEnvironmentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateKxEnvironmentInput) SetClientToken(v string) *UpdateKxEnvironmentInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateKxEnvironmentInput) SetDescription(v string) *UpdateKxEnvironmentInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxEnvironmentInput) SetEnvironmentId(v string) *UpdateKxEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateKxEnvironmentInput) SetName(v string) *UpdateKxEnvironmentInput {
	s.Name = &v
	return s
}

type UpdateKxEnvironmentNetworkInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A list of DNS server name and server IP. This is used to set up Route-53
	// outbound resolvers.
	CustomDNSConfiguration []*CustomDNSServer `locationName:"customDNSConfiguration" type:"list"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// Specifies the transit gateway and network configuration to connect the kdb
	// environment to an internal network.
	TransitGatewayConfiguration *TransitGatewayConfiguration `locationName:"transitGatewayConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxEnvironmentNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxEnvironmentNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKxEnvironmentNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKxEnvironmentNetworkInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.CustomDNSConfiguration != nil {
		for i, v := range s.CustomDNSConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomDNSConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TransitGatewayConfiguration != nil {
		if err := s.TransitGatewayConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TransitGatewayConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateKxEnvironmentNetworkInput) SetClientToken(v string) *UpdateKxEnvironmentNetworkInput {
	s.ClientToken = &v
	return s
}

// SetCustomDNSConfiguration sets the CustomDNSConfiguration field's value.
func (s *UpdateKxEnvironmentNetworkInput) SetCustomDNSConfiguration(v []*CustomDNSServer) *UpdateKxEnvironmentNetworkInput {
	s.CustomDNSConfiguration = v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxEnvironmentNetworkInput) SetEnvironmentId(v string) *UpdateKxEnvironmentNetworkInput {
	s.EnvironmentId = &v
	return s
}

// SetTransitGatewayConfiguration sets the TransitGatewayConfiguration field's value.
func (s *UpdateKxEnvironmentNetworkInput) SetTransitGatewayConfiguration(v *TransitGatewayConfiguration) *UpdateKxEnvironmentNetworkInput {
	s.TransitGatewayConfiguration = v
	return s
}

type UpdateKxEnvironmentNetworkOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones where subnets for the environment
	// are created.
	AvailabilityZoneIds []*string `locationName:"availabilityZoneIds" type:"list"`

	// The unique identifier of the AWS account that is used to create the kdb environment.
	AwsAccountId *string `locationName:"awsAccountId" min:"1" type:"string"`

	// The timestamp at which the kdb environment was created in FinSpace.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// A list of DNS server name and server IP. This is used to set up Route-53
	// outbound resolvers.
	CustomDNSConfiguration []*CustomDNSServer `locationName:"customDNSConfiguration" type:"list"`

	// A unique identifier for the AWS environment infrastructure account.
	DedicatedServiceAccountId *string `locationName:"dedicatedServiceAccountId" min:"1" type:"string"`

	// The description of the environment.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The status of DNS configuration.
	DnsStatus *string `locationName:"dnsStatus" type:"string" enum:"DnsStatus"`

	// The ARN identifier of the environment.
	EnvironmentArn *string `locationName:"environmentArn" min:"20" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// Specifies the error message that appears if a flow fails.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The KMS key ID to encrypt your data in the FinSpace environment.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the kdb environment.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status of the kdb environment.
	Status *string `locationName:"status" type:"string" enum:"EnvironmentStatus"`

	// The status of the network configuration.
	TgwStatus *string `locationName:"tgwStatus" type:"string" enum:"TgwStatus"`

	// The structure of the transit gateway and network configuration that is used
	// to connect the kdb environment to an internal network.
	TransitGatewayConfiguration *TransitGatewayConfiguration `locationName:"transitGatewayConfiguration" type:"structure"`

	// The timestamp at which the kdb environment was updated.
	UpdateTimestamp *time.Time `locationName:"updateTimestamp" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxEnvironmentNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxEnvironmentNetworkOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneIds sets the AvailabilityZoneIds field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetAvailabilityZoneIds(v []*string) *UpdateKxEnvironmentNetworkOutput {
	s.AvailabilityZoneIds = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetAwsAccountId(v string) *UpdateKxEnvironmentNetworkOutput {
	s.AwsAccountId = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetCreationTimestamp(v time.Time) *UpdateKxEnvironmentNetworkOutput {
	s.CreationTimestamp = &v
	return s
}

// SetCustomDNSConfiguration sets the CustomDNSConfiguration field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetCustomDNSConfiguration(v []*CustomDNSServer) *UpdateKxEnvironmentNetworkOutput {
	s.CustomDNSConfiguration = v
	return s
}

// SetDedicatedServiceAccountId sets the DedicatedServiceAccountId field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetDedicatedServiceAccountId(v string) *UpdateKxEnvironmentNetworkOutput {
	s.DedicatedServiceAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetDescription(v string) *UpdateKxEnvironmentNetworkOutput {
	s.Description = &v
	return s
}

// SetDnsStatus sets the DnsStatus field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetDnsStatus(v string) *UpdateKxEnvironmentNetworkOutput {
	s.DnsStatus = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetEnvironmentArn(v string) *UpdateKxEnvironmentNetworkOutput {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetEnvironmentId(v string) *UpdateKxEnvironmentNetworkOutput {
	s.EnvironmentId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetErrorMessage(v string) *UpdateKxEnvironmentNetworkOutput {
	s.ErrorMessage = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetKmsKeyId(v string) *UpdateKxEnvironmentNetworkOutput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetName(v string) *UpdateKxEnvironmentNetworkOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetStatus(v string) *UpdateKxEnvironmentNetworkOutput {
	s.Status = &v
	return s
}

// SetTgwStatus sets the TgwStatus field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetTgwStatus(v string) *UpdateKxEnvironmentNetworkOutput {
	s.TgwStatus = &v
	return s
}

// SetTransitGatewayConfiguration sets the TransitGatewayConfiguration field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetTransitGatewayConfiguration(v *TransitGatewayConfiguration) *UpdateKxEnvironmentNetworkOutput {
	s.TransitGatewayConfiguration = v
	return s
}

// SetUpdateTimestamp sets the UpdateTimestamp field's value.
func (s *UpdateKxEnvironmentNetworkOutput) SetUpdateTimestamp(v time.Time) *UpdateKxEnvironmentNetworkOutput {
	s.UpdateTimestamp = &v
	return s
}

type UpdateKxEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the availability zones where subnets for the environment
	// are created.
	AvailabilityZoneIds []*string `locationName:"availabilityZoneIds" type:"list"`

	// The unique identifier of the AWS account that is used to create the kdb environment.
	AwsAccountId *string `locationName:"awsAccountId" min:"1" type:"string"`

	// The timestamp at which the kdb environment was created in FinSpace.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// A list of DNS server name and server IP. This is used to set up Route-53
	// outbound resolvers.
	CustomDNSConfiguration []*CustomDNSServer `locationName:"customDNSConfiguration" type:"list"`

	// A unique identifier for the AWS environment infrastructure account.
	DedicatedServiceAccountId *string `locationName:"dedicatedServiceAccountId" min:"1" type:"string"`

	// The description of the environment.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The status of DNS configuration.
	DnsStatus *string `locationName:"dnsStatus" type:"string" enum:"DnsStatus"`

	// The ARN identifier of the environment.
	EnvironmentArn *string `locationName:"environmentArn" min:"20" type:"string"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// Specifies the error message that appears if a flow fails.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The KMS key ID to encrypt your data in the FinSpace environment.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the kdb environment.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The status of the kdb environment.
	Status *string `locationName:"status" type:"string" enum:"EnvironmentStatus"`

	// The status of the network configuration.
	TgwStatus *string `locationName:"tgwStatus" type:"string" enum:"TgwStatus"`

	// The structure of the transit gateway and network configuration that is used
	// to connect the kdb environment to an internal network.
	TransitGatewayConfiguration *TransitGatewayConfiguration `locationName:"transitGatewayConfiguration" type:"structure"`

	// The timestamp at which the kdb environment was updated.
	UpdateTimestamp *time.Time `locationName:"updateTimestamp" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxEnvironmentOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneIds sets the AvailabilityZoneIds field's value.
func (s *UpdateKxEnvironmentOutput) SetAvailabilityZoneIds(v []*string) *UpdateKxEnvironmentOutput {
	s.AvailabilityZoneIds = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateKxEnvironmentOutput) SetAwsAccountId(v string) *UpdateKxEnvironmentOutput {
	s.AwsAccountId = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *UpdateKxEnvironmentOutput) SetCreationTimestamp(v time.Time) *UpdateKxEnvironmentOutput {
	s.CreationTimestamp = &v
	return s
}

// SetCustomDNSConfiguration sets the CustomDNSConfiguration field's value.
func (s *UpdateKxEnvironmentOutput) SetCustomDNSConfiguration(v []*CustomDNSServer) *UpdateKxEnvironmentOutput {
	s.CustomDNSConfiguration = v
	return s
}

// SetDedicatedServiceAccountId sets the DedicatedServiceAccountId field's value.
func (s *UpdateKxEnvironmentOutput) SetDedicatedServiceAccountId(v string) *UpdateKxEnvironmentOutput {
	s.DedicatedServiceAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateKxEnvironmentOutput) SetDescription(v string) *UpdateKxEnvironmentOutput {
	s.Description = &v
	return s
}

// SetDnsStatus sets the DnsStatus field's value.
func (s *UpdateKxEnvironmentOutput) SetDnsStatus(v string) *UpdateKxEnvironmentOutput {
	s.DnsStatus = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *UpdateKxEnvironmentOutput) SetEnvironmentArn(v string) *UpdateKxEnvironmentOutput {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxEnvironmentOutput) SetEnvironmentId(v string) *UpdateKxEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UpdateKxEnvironmentOutput) SetErrorMessage(v string) *UpdateKxEnvironmentOutput {
	s.ErrorMessage = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateKxEnvironmentOutput) SetKmsKeyId(v string) *UpdateKxEnvironmentOutput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateKxEnvironmentOutput) SetName(v string) *UpdateKxEnvironmentOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateKxEnvironmentOutput) SetStatus(v string) *UpdateKxEnvironmentOutput {
	s.Status = &v
	return s
}

// SetTgwStatus sets the TgwStatus field's value.
func (s *UpdateKxEnvironmentOutput) SetTgwStatus(v string) *UpdateKxEnvironmentOutput {
	s.TgwStatus = &v
	return s
}

// SetTransitGatewayConfiguration sets the TransitGatewayConfiguration field's value.
func (s *UpdateKxEnvironmentOutput) SetTransitGatewayConfiguration(v *TransitGatewayConfiguration) *UpdateKxEnvironmentOutput {
	s.TransitGatewayConfiguration = v
	return s
}

// SetUpdateTimestamp sets the UpdateTimestamp field's value.
func (s *UpdateKxEnvironmentOutput) SetUpdateTimestamp(v time.Time) *UpdateKxEnvironmentOutput {
	s.UpdateTimestamp = &v
	return s
}

type UpdateKxUserInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A unique identifier for the kdb environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The IAM role ARN that is associated with the user.
	//
	// IamRole is a required field
	IamRole *string `locationName:"iamRole" min:"20" type:"string" required:"true"`

	// A unique identifier for the user.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"userName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKxUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKxUserInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.IamRole == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRole"))
	}
	if s.IamRole != nil && len(*s.IamRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("IamRole", 20))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateKxUserInput) SetClientToken(v string) *UpdateKxUserInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxUserInput) SetEnvironmentId(v string) *UpdateKxUserInput {
	s.EnvironmentId = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *UpdateKxUserInput) SetIamRole(v string) *UpdateKxUserInput {
	s.IamRole = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateKxUserInput) SetUserName(v string) *UpdateKxUserInput {
	s.UserName = &v
	return s
}

type UpdateKxUserOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the kdb environment.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The IAM role ARN that is associated with the user.
	IamRole *string `locationName:"iamRole" min:"20" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the user. For more information
	// about ARNs and how to use ARNs in policies, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	UserArn *string `locationName:"userArn" min:"20" type:"string"`

	// A unique identifier for the user.
	UserName *string `locationName:"userName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxUserOutput) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxUserOutput) SetEnvironmentId(v string) *UpdateKxUserOutput {
	s.EnvironmentId = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *UpdateKxUserOutput) SetIamRole(v string) *UpdateKxUserOutput {
	s.IamRole = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateKxUserOutput) SetUserArn(v string) *UpdateKxUserOutput {
	s.UserArn = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateKxUserOutput) SetUserName(v string) *UpdateKxUserOutput {
	s.UserName = &v
	return s
}

type UpdateKxVolumeInput struct {
	_ struct{} `type:"structure"`

	// A token that ensures idempotency. This token expires in 10 minutes.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the volume.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment where you created the storage
	// volume.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" min:"1" type:"string" required:"true"`

	// Specifies the configuration for the Network attached storage (NAS_1) file
	// system volume.
	Nas1Configuration *KxNAS1Configuration `locationName:"nas1Configuration" type:"structure"`

	// A unique identifier for the volume.
	//
	// VolumeName is a required field
	VolumeName *string `location:"uri" locationName:"volumeName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKxVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKxVolumeInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.VolumeName == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeName"))
	}
	if s.VolumeName != nil && len(*s.VolumeName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeName", 3))
	}
	if s.Nas1Configuration != nil {
		if err := s.Nas1Configuration.Validate(); err != nil {
			invalidParams.AddNested("Nas1Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateKxVolumeInput) SetClientToken(v string) *UpdateKxVolumeInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateKxVolumeInput) SetDescription(v string) *UpdateKxVolumeInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxVolumeInput) SetEnvironmentId(v string) *UpdateKxVolumeInput {
	s.EnvironmentId = &v
	return s
}

// SetNas1Configuration sets the Nas1Configuration field's value.
func (s *UpdateKxVolumeInput) SetNas1Configuration(v *KxNAS1Configuration) *UpdateKxVolumeInput {
	s.Nas1Configuration = v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *UpdateKxVolumeInput) SetVolumeName(v string) *UpdateKxVolumeInput {
	s.VolumeName = &v
	return s
}

type UpdateKxVolumeOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the clusters that a volume is attached to.
	AttachedClusters []*KxAttachedCluster `locationName:"attachedClusters" type:"list"`

	// The identifier of the availability zones.
	AvailabilityZoneIds []*string `locationName:"availabilityZoneIds" type:"list"`

	// The number of availability zones you want to assign per cluster. Currently,
	// FinSpace only support SINGLE for volumes.
	AzMode *string `locationName:"azMode" type:"string" enum:"KxAzMode"`

	// The timestamp at which the volume was created in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp"`

	// The description for the volume.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A unique identifier for the kdb environment where you want to update the
	// volume.
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string"`

	// The last time that the volume was updated in FinSpace. The value is determined
	// as epoch time in milliseconds. For example, the value for Monday, November
	// 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp"`

	// Specifies the configuration for the Network attached storage (NAS_1) file
	// system volume.
	Nas1Configuration *KxNAS1Configuration `locationName:"nas1Configuration" type:"structure"`

	// The status of the volume.
	//
	//    * CREATING – The volume creation is in progress.
	//
	//    * CREATE_FAILED – The volume creation has failed.
	//
	//    * ACTIVE – The volume is active.
	//
	//    * UPDATING – The volume is in the process of being updated.
	//
	//    * UPDATE_FAILED – The update action failed.
	//
	//    * UPDATED – The volume is successfully updated.
	//
	//    * DELETING – The volume is in the process of being deleted.
	//
	//    * DELETE_FAILED – The system failed to delete the volume.
	//
	//    * DELETED – The volume is successfully deleted.
	Status *string `locationName:"status" type:"string" enum:"KxVolumeStatus"`

	// The error message when a failed state occurs.
	StatusReason *string `locationName:"statusReason" min:"1" type:"string"`

	// The ARN identifier of the volume.
	VolumeArn *string `locationName:"volumeArn" min:"20" type:"string"`

	// A unique identifier for the volume that you want to update.
	VolumeName *string `locationName:"volumeName" min:"3" type:"string"`

	// The type of file system volume. Currently, FinSpace only supports NAS_1 volume
	// type.
	VolumeType *string `locationName:"volumeType" type:"string" enum:"KxVolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKxVolumeOutput) GoString() string {
	return s.String()
}

// SetAttachedClusters sets the AttachedClusters field's value.
func (s *UpdateKxVolumeOutput) SetAttachedClusters(v []*KxAttachedCluster) *UpdateKxVolumeOutput {
	s.AttachedClusters = v
	return s
}

// SetAvailabilityZoneIds sets the AvailabilityZoneIds field's value.
func (s *UpdateKxVolumeOutput) SetAvailabilityZoneIds(v []*string) *UpdateKxVolumeOutput {
	s.AvailabilityZoneIds = v
	return s
}

// SetAzMode sets the AzMode field's value.
func (s *UpdateKxVolumeOutput) SetAzMode(v string) *UpdateKxVolumeOutput {
	s.AzMode = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *UpdateKxVolumeOutput) SetCreatedTimestamp(v time.Time) *UpdateKxVolumeOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateKxVolumeOutput) SetDescription(v string) *UpdateKxVolumeOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateKxVolumeOutput) SetEnvironmentId(v string) *UpdateKxVolumeOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *UpdateKxVolumeOutput) SetLastModifiedTimestamp(v time.Time) *UpdateKxVolumeOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetNas1Configuration sets the Nas1Configuration field's value.
func (s *UpdateKxVolumeOutput) SetNas1Configuration(v *KxNAS1Configuration) *UpdateKxVolumeOutput {
	s.Nas1Configuration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateKxVolumeOutput) SetStatus(v string) *UpdateKxVolumeOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *UpdateKxVolumeOutput) SetStatusReason(v string) *UpdateKxVolumeOutput {
	s.StatusReason = &v
	return s
}

// SetVolumeArn sets the VolumeArn field's value.
func (s *UpdateKxVolumeOutput) SetVolumeArn(v string) *UpdateKxVolumeOutput {
	s.VolumeArn = &v
	return s
}

// SetVolumeName sets the VolumeName field's value.
func (s *UpdateKxVolumeOutput) SetVolumeName(v string) *UpdateKxVolumeOutput {
	s.VolumeName = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *UpdateKxVolumeOutput) SetVolumeType(v string) *UpdateKxVolumeOutput {
	s.VolumeType = &v
	return s
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The structure that consists of name and type of volume.
type Volume struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the volume.
	VolumeName *string `locationName:"volumeName" min:"3" type:"string"`

	// The type of file system volume. Currently, FinSpace only supports NAS_1 volume
	// type.
	VolumeType *string `locationName:"volumeType" type:"string" enum:"VolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Volume) GoString() string {
	return s.String()
}

// SetVolumeName sets the VolumeName field's value.
func (s *Volume) SetVolumeName(v string) *Volume {
	s.VolumeName = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *Volume) SetVolumeType(v string) *Volume {
	s.VolumeType = &v
	return s
}

// Configuration details about the network where the Privatelink endpoint of
// the cluster resides.
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// The IP address type for cluster network configuration parameters. The following
	// type is available:
	//
	//    * IP_V4 – IP address version 4
	IpAddressType *string `locationName:"ipAddressType" type:"string" enum:"IPAddressType"`

	// The unique identifier of the VPC security group applied to the VPC endpoint
	// ENI for the cluster.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The identifier of the subnet that the Privatelink VPC endpoint uses to connect
	// to the cluster.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The identifier of the VPC endpoint.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfiguration"}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *VpcConfiguration) SetIpAddressType(v string) *VpcConfiguration {
	s.IpAddressType = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfiguration) SetSecurityGroupIds(v []*string) *VpcConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfiguration) SetSubnetIds(v []*string) *VpcConfiguration {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfiguration) SetVpcId(v string) *VpcConfiguration {
	s.VpcId = &v
	return s
}

const (
	// AutoScalingMetricCpuUtilizationPercentage is a AutoScalingMetric enum value
	AutoScalingMetricCpuUtilizationPercentage = "CPU_UTILIZATION_PERCENTAGE"
)

// AutoScalingMetric_Values returns all elements of the AutoScalingMetric enum
func AutoScalingMetric_Values() []string {
	return []string{
		AutoScalingMetricCpuUtilizationPercentage,
	}
}

const (
	// ChangeTypePut is a ChangeType enum value
	ChangeTypePut = "PUT"

	// ChangeTypeDelete is a ChangeType enum value
	ChangeTypeDelete = "DELETE"
)

// ChangeType_Values returns all elements of the ChangeType enum
func ChangeType_Values() []string {
	return []string{
		ChangeTypePut,
		ChangeTypeDelete,
	}
}

const (
	// ChangesetStatusPending is a ChangesetStatus enum value
	ChangesetStatusPending = "PENDING"

	// ChangesetStatusProcessing is a ChangesetStatus enum value
	ChangesetStatusProcessing = "PROCESSING"

	// ChangesetStatusFailed is a ChangesetStatus enum value
	ChangesetStatusFailed = "FAILED"

	// ChangesetStatusCompleted is a ChangesetStatus enum value
	ChangesetStatusCompleted = "COMPLETED"
)

// ChangesetStatus_Values returns all elements of the ChangesetStatus enum
func ChangesetStatus_Values() []string {
	return []string{
		ChangesetStatusPending,
		ChangesetStatusProcessing,
		ChangesetStatusFailed,
		ChangesetStatusCompleted,
	}
}

const (
	// DnsStatusNone is a DnsStatus enum value
	DnsStatusNone = "NONE"

	// DnsStatusUpdateRequested is a DnsStatus enum value
	DnsStatusUpdateRequested = "UPDATE_REQUESTED"

	// DnsStatusUpdating is a DnsStatus enum value
	DnsStatusUpdating = "UPDATING"

	// DnsStatusFailedUpdate is a DnsStatus enum value
	DnsStatusFailedUpdate = "FAILED_UPDATE"

	// DnsStatusSuccessfullyUpdated is a DnsStatus enum value
	DnsStatusSuccessfullyUpdated = "SUCCESSFULLY_UPDATED"
)

// DnsStatus_Values returns all elements of the DnsStatus enum
func DnsStatus_Values() []string {
	return []string{
		DnsStatusNone,
		DnsStatusUpdateRequested,
		DnsStatusUpdating,
		DnsStatusFailedUpdate,
		DnsStatusSuccessfullyUpdated,
	}
}

const (
	// EnvironmentStatusCreateRequested is a EnvironmentStatus enum value
	EnvironmentStatusCreateRequested = "CREATE_REQUESTED"

	// EnvironmentStatusCreating is a EnvironmentStatus enum value
	EnvironmentStatusCreating = "CREATING"

	// EnvironmentStatusCreated is a EnvironmentStatus enum value
	EnvironmentStatusCreated = "CREATED"

	// EnvironmentStatusDeleteRequested is a EnvironmentStatus enum value
	EnvironmentStatusDeleteRequested = "DELETE_REQUESTED"

	// EnvironmentStatusDeleting is a EnvironmentStatus enum value
	EnvironmentStatusDeleting = "DELETING"

	// EnvironmentStatusDeleted is a EnvironmentStatus enum value
	EnvironmentStatusDeleted = "DELETED"

	// EnvironmentStatusFailedCreation is a EnvironmentStatus enum value
	EnvironmentStatusFailedCreation = "FAILED_CREATION"

	// EnvironmentStatusRetryDeletion is a EnvironmentStatus enum value
	EnvironmentStatusRetryDeletion = "RETRY_DELETION"

	// EnvironmentStatusFailedDeletion is a EnvironmentStatus enum value
	EnvironmentStatusFailedDeletion = "FAILED_DELETION"

	// EnvironmentStatusUpdateNetworkRequested is a EnvironmentStatus enum value
	EnvironmentStatusUpdateNetworkRequested = "UPDATE_NETWORK_REQUESTED"

	// EnvironmentStatusUpdatingNetwork is a EnvironmentStatus enum value
	EnvironmentStatusUpdatingNetwork = "UPDATING_NETWORK"

	// EnvironmentStatusFailedUpdatingNetwork is a EnvironmentStatus enum value
	EnvironmentStatusFailedUpdatingNetwork = "FAILED_UPDATING_NETWORK"

	// EnvironmentStatusSuspended is a EnvironmentStatus enum value
	EnvironmentStatusSuspended = "SUSPENDED"
)

// EnvironmentStatus_Values returns all elements of the EnvironmentStatus enum
func EnvironmentStatus_Values() []string {
	return []string{
		EnvironmentStatusCreateRequested,
		EnvironmentStatusCreating,
		EnvironmentStatusCreated,
		EnvironmentStatusDeleteRequested,
		EnvironmentStatusDeleting,
		EnvironmentStatusDeleted,
		EnvironmentStatusFailedCreation,
		EnvironmentStatusRetryDeletion,
		EnvironmentStatusFailedDeletion,
		EnvironmentStatusUpdateNetworkRequested,
		EnvironmentStatusUpdatingNetwork,
		EnvironmentStatusFailedUpdatingNetwork,
		EnvironmentStatusSuspended,
	}
}

const (
	// ErrorDetailsTheinputstothisrequestareinvalid is a ErrorDetails enum value
	ErrorDetailsTheinputstothisrequestareinvalid = "The inputs to this request are invalid."

	// ErrorDetailsServicelimitshavebeenexceeded is a ErrorDetails enum value
	ErrorDetailsServicelimitshavebeenexceeded = "Service limits have been exceeded."

	// ErrorDetailsMissingrequiredpermissiontoperformthisrequest is a ErrorDetails enum value
	ErrorDetailsMissingrequiredpermissiontoperformthisrequest = "Missing required permission to perform this request."

	// ErrorDetailsOneormoreinputstothisrequestwerenotfound is a ErrorDetails enum value
	ErrorDetailsOneormoreinputstothisrequestwerenotfound = "One or more inputs to this request were not found."

	// ErrorDetailsThesystemtemporarilylackssufficientresourcestoprocesstherequest is a ErrorDetails enum value
	ErrorDetailsThesystemtemporarilylackssufficientresourcestoprocesstherequest = "The system temporarily lacks sufficient resources to process the request."

	// ErrorDetailsAninternalerrorhasoccurred is a ErrorDetails enum value
	ErrorDetailsAninternalerrorhasoccurred = "An internal error has occurred."

	// ErrorDetailsCancelled is a ErrorDetails enum value
	ErrorDetailsCancelled = "Cancelled"

	// ErrorDetailsAuserrecoverableerrorhasoccurred is a ErrorDetails enum value
	ErrorDetailsAuserrecoverableerrorhasoccurred = "A user recoverable error has occurred"
)

// ErrorDetails_Values returns all elements of the ErrorDetails enum
func ErrorDetails_Values() []string {
	return []string{
		ErrorDetailsTheinputstothisrequestareinvalid,
		ErrorDetailsServicelimitshavebeenexceeded,
		ErrorDetailsMissingrequiredpermissiontoperformthisrequest,
		ErrorDetailsOneormoreinputstothisrequestwerenotfound,
		ErrorDetailsThesystemtemporarilylackssufficientresourcestoprocesstherequest,
		ErrorDetailsAninternalerrorhasoccurred,
		ErrorDetailsCancelled,
		ErrorDetailsAuserrecoverableerrorhasoccurred,
	}
}

const (
	// FederationModeFederated is a FederationMode enum value
	FederationModeFederated = "FEDERATED"

	// FederationModeLocal is a FederationMode enum value
	FederationModeLocal = "LOCAL"
)

// FederationMode_Values returns all elements of the FederationMode enum
func FederationMode_Values() []string {
	return []string{
		FederationModeFederated,
		FederationModeLocal,
	}
}

const (
	// IPAddressTypeIpV4 is a IPAddressType enum value
	IPAddressTypeIpV4 = "IP_V4"
)

// IPAddressType_Values returns all elements of the IPAddressType enum
func IPAddressType_Values() []string {
	return []string{
		IPAddressTypeIpV4,
	}
}

const (
	// KxAzModeSingle is a KxAzMode enum value
	KxAzModeSingle = "SINGLE"

	// KxAzModeMulti is a KxAzMode enum value
	KxAzModeMulti = "MULTI"
)

// KxAzMode_Values returns all elements of the KxAzMode enum
func KxAzMode_Values() []string {
	return []string{
		KxAzModeSingle,
		KxAzModeMulti,
	}
}

const (
	// KxClusterCodeDeploymentStrategyNoRestart is a KxClusterCodeDeploymentStrategy enum value
	KxClusterCodeDeploymentStrategyNoRestart = "NO_RESTART"

	// KxClusterCodeDeploymentStrategyRolling is a KxClusterCodeDeploymentStrategy enum value
	KxClusterCodeDeploymentStrategyRolling = "ROLLING"

	// KxClusterCodeDeploymentStrategyForce is a KxClusterCodeDeploymentStrategy enum value
	KxClusterCodeDeploymentStrategyForce = "FORCE"
)

// KxClusterCodeDeploymentStrategy_Values returns all elements of the KxClusterCodeDeploymentStrategy enum
func KxClusterCodeDeploymentStrategy_Values() []string {
	return []string{
		KxClusterCodeDeploymentStrategyNoRestart,
		KxClusterCodeDeploymentStrategyRolling,
		KxClusterCodeDeploymentStrategyForce,
	}
}

const (
	// KxClusterStatusPending is a KxClusterStatus enum value
	KxClusterStatusPending = "PENDING"

	// KxClusterStatusCreating is a KxClusterStatus enum value
	KxClusterStatusCreating = "CREATING"

	// KxClusterStatusCreateFailed is a KxClusterStatus enum value
	KxClusterStatusCreateFailed = "CREATE_FAILED"

	// KxClusterStatusRunning is a KxClusterStatus enum value
	KxClusterStatusRunning = "RUNNING"

	// KxClusterStatusUpdating is a KxClusterStatus enum value
	KxClusterStatusUpdating = "UPDATING"

	// KxClusterStatusDeleting is a KxClusterStatus enum value
	KxClusterStatusDeleting = "DELETING"

	// KxClusterStatusDeleted is a KxClusterStatus enum value
	KxClusterStatusDeleted = "DELETED"

	// KxClusterStatusDeleteFailed is a KxClusterStatus enum value
	KxClusterStatusDeleteFailed = "DELETE_FAILED"
)

// KxClusterStatus_Values returns all elements of the KxClusterStatus enum
func KxClusterStatus_Values() []string {
	return []string{
		KxClusterStatusPending,
		KxClusterStatusCreating,
		KxClusterStatusCreateFailed,
		KxClusterStatusRunning,
		KxClusterStatusUpdating,
		KxClusterStatusDeleting,
		KxClusterStatusDeleted,
		KxClusterStatusDeleteFailed,
	}
}

const (
	// KxClusterTypeHdb is a KxClusterType enum value
	KxClusterTypeHdb = "HDB"

	// KxClusterTypeRdb is a KxClusterType enum value
	KxClusterTypeRdb = "RDB"

	// KxClusterTypeGateway is a KxClusterType enum value
	KxClusterTypeGateway = "GATEWAY"

	// KxClusterTypeGp is a KxClusterType enum value
	KxClusterTypeGp = "GP"

	// KxClusterTypeTickerplant is a KxClusterType enum value
	KxClusterTypeTickerplant = "TICKERPLANT"
)

// KxClusterType_Values returns all elements of the KxClusterType enum
func KxClusterType_Values() []string {
	return []string{
		KxClusterTypeHdb,
		KxClusterTypeRdb,
		KxClusterTypeGateway,
		KxClusterTypeGp,
		KxClusterTypeTickerplant,
	}
}

const (
	// KxDataviewStatusCreating is a KxDataviewStatus enum value
	KxDataviewStatusCreating = "CREATING"

	// KxDataviewStatusActive is a KxDataviewStatus enum value
	KxDataviewStatusActive = "ACTIVE"

	// KxDataviewStatusUpdating is a KxDataviewStatus enum value
	KxDataviewStatusUpdating = "UPDATING"

	// KxDataviewStatusFailed is a KxDataviewStatus enum value
	KxDataviewStatusFailed = "FAILED"

	// KxDataviewStatusDeleting is a KxDataviewStatus enum value
	KxDataviewStatusDeleting = "DELETING"
)

// KxDataviewStatus_Values returns all elements of the KxDataviewStatus enum
func KxDataviewStatus_Values() []string {
	return []string{
		KxDataviewStatusCreating,
		KxDataviewStatusActive,
		KxDataviewStatusUpdating,
		KxDataviewStatusFailed,
		KxDataviewStatusDeleting,
	}
}

const (
	// KxDeploymentStrategyNoRestart is a KxDeploymentStrategy enum value
	KxDeploymentStrategyNoRestart = "NO_RESTART"

	// KxDeploymentStrategyRolling is a KxDeploymentStrategy enum value
	KxDeploymentStrategyRolling = "ROLLING"
)

// KxDeploymentStrategy_Values returns all elements of the KxDeploymentStrategy enum
func KxDeploymentStrategy_Values() []string {
	return []string{
		KxDeploymentStrategyNoRestart,
		KxDeploymentStrategyRolling,
	}
}

const (
	// KxNAS1TypeSsd1000 is a KxNAS1Type enum value
	KxNAS1TypeSsd1000 = "SSD_1000"

	// KxNAS1TypeSsd250 is a KxNAS1Type enum value
	KxNAS1TypeSsd250 = "SSD_250"

	// KxNAS1TypeHdd12 is a KxNAS1Type enum value
	KxNAS1TypeHdd12 = "HDD_12"
)

// KxNAS1Type_Values returns all elements of the KxNAS1Type enum
func KxNAS1Type_Values() []string {
	return []string{
		KxNAS1TypeSsd1000,
		KxNAS1TypeSsd250,
		KxNAS1TypeHdd12,
	}
}

const (
	// KxSavedownStorageTypeSds01 is a KxSavedownStorageType enum value
	KxSavedownStorageTypeSds01 = "SDS01"
)

// KxSavedownStorageType_Values returns all elements of the KxSavedownStorageType enum
func KxSavedownStorageType_Values() []string {
	return []string{
		KxSavedownStorageTypeSds01,
	}
}

const (
	// KxScalingGroupStatusCreating is a KxScalingGroupStatus enum value
	KxScalingGroupStatusCreating = "CREATING"

	// KxScalingGroupStatusCreateFailed is a KxScalingGroupStatus enum value
	KxScalingGroupStatusCreateFailed = "CREATE_FAILED"

	// KxScalingGroupStatusActive is a KxScalingGroupStatus enum value
	KxScalingGroupStatusActive = "ACTIVE"

	// KxScalingGroupStatusDeleting is a KxScalingGroupStatus enum value
	KxScalingGroupStatusDeleting = "DELETING"

	// KxScalingGroupStatusDeleted is a KxScalingGroupStatus enum value
	KxScalingGroupStatusDeleted = "DELETED"

	// KxScalingGroupStatusDeleteFailed is a KxScalingGroupStatus enum value
	KxScalingGroupStatusDeleteFailed = "DELETE_FAILED"
)

// KxScalingGroupStatus_Values returns all elements of the KxScalingGroupStatus enum
func KxScalingGroupStatus_Values() []string {
	return []string{
		KxScalingGroupStatusCreating,
		KxScalingGroupStatusCreateFailed,
		KxScalingGroupStatusActive,
		KxScalingGroupStatusDeleting,
		KxScalingGroupStatusDeleted,
		KxScalingGroupStatusDeleteFailed,
	}
}

const (
	// KxVolumeStatusCreating is a KxVolumeStatus enum value
	KxVolumeStatusCreating = "CREATING"

	// KxVolumeStatusCreateFailed is a KxVolumeStatus enum value
	KxVolumeStatusCreateFailed = "CREATE_FAILED"

	// KxVolumeStatusActive is a KxVolumeStatus enum value
	KxVolumeStatusActive = "ACTIVE"

	// KxVolumeStatusUpdating is a KxVolumeStatus enum value
	KxVolumeStatusUpdating = "UPDATING"

	// KxVolumeStatusUpdated is a KxVolumeStatus enum value
	KxVolumeStatusUpdated = "UPDATED"

	// KxVolumeStatusUpdateFailed is a KxVolumeStatus enum value
	KxVolumeStatusUpdateFailed = "UPDATE_FAILED"

	// KxVolumeStatusDeleting is a KxVolumeStatus enum value
	KxVolumeStatusDeleting = "DELETING"

	// KxVolumeStatusDeleted is a KxVolumeStatus enum value
	KxVolumeStatusDeleted = "DELETED"

	// KxVolumeStatusDeleteFailed is a KxVolumeStatus enum value
	KxVolumeStatusDeleteFailed = "DELETE_FAILED"
)

// KxVolumeStatus_Values returns all elements of the KxVolumeStatus enum
func KxVolumeStatus_Values() []string {
	return []string{
		KxVolumeStatusCreating,
		KxVolumeStatusCreateFailed,
		KxVolumeStatusActive,
		KxVolumeStatusUpdating,
		KxVolumeStatusUpdated,
		KxVolumeStatusUpdateFailed,
		KxVolumeStatusDeleting,
		KxVolumeStatusDeleted,
		KxVolumeStatusDeleteFailed,
	}
}

const (
	// KxVolumeTypeNas1 is a KxVolumeType enum value
	KxVolumeTypeNas1 = "NAS_1"
)

// KxVolumeType_Values returns all elements of the KxVolumeType enum
func KxVolumeType_Values() []string {
	return []string{
		KxVolumeTypeNas1,
	}
}

const (
	// RuleActionAllow is a RuleAction enum value
	RuleActionAllow = "allow"

	// RuleActionDeny is a RuleAction enum value
	RuleActionDeny = "deny"
)

// RuleAction_Values returns all elements of the RuleAction enum
func RuleAction_Values() []string {
	return []string{
		RuleActionAllow,
		RuleActionDeny,
	}
}

const (
	// TgwStatusNone is a TgwStatus enum value
	TgwStatusNone = "NONE"

	// TgwStatusUpdateRequested is a TgwStatus enum value
	TgwStatusUpdateRequested = "UPDATE_REQUESTED"

	// TgwStatusUpdating is a TgwStatus enum value
	TgwStatusUpdating = "UPDATING"

	// TgwStatusFailedUpdate is a TgwStatus enum value
	TgwStatusFailedUpdate = "FAILED_UPDATE"

	// TgwStatusSuccessfullyUpdated is a TgwStatus enum value
	TgwStatusSuccessfullyUpdated = "SUCCESSFULLY_UPDATED"
)

// TgwStatus_Values returns all elements of the TgwStatus enum
func TgwStatus_Values() []string {
	return []string{
		TgwStatusNone,
		TgwStatusUpdateRequested,
		TgwStatusUpdating,
		TgwStatusFailedUpdate,
		TgwStatusSuccessfullyUpdated,
	}
}

const (
	// VolumeTypeNas1 is a VolumeType enum value
	VolumeTypeNas1 = "NAS_1"
)

// VolumeType_Values returns all elements of the VolumeType enum
func VolumeType_Values() []string {
	return []string{
		VolumeTypeNas1,
	}
}
