// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package bedrockruntime

import (
	"bytes"
	"fmt"
	"io"
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/rest"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opInvokeModel = "InvokeModel"

// InvokeModelRequest generates a "aws/request.Request" representing the
// client's request for the InvokeModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvokeModel for more information on using the InvokeModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InvokeModelRequest method.
//	req, resp := client.InvokeModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModel
func (c *BedrockRuntime) InvokeModelRequest(input *InvokeModelInput) (req *request.Request, output *InvokeModelOutput) {
	op := &request.Operation{
		Name:       opInvokeModel,
		HTTPMethod: "POST",
		HTTPPath:   "/model/{modelId}/invoke",
	}

	if input == nil {
		input = &InvokeModelInput{}
	}

	output = &InvokeModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InvokeModel API operation for Amazon Bedrock Runtime.
//
// Invokes the specified Bedrock model to run inference using the input provided
// in the request body. You use InvokeModel to run inference for text models,
// image models, and embedding models.
//
// For more information, see Run inference (https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html)
// in the Bedrock User Guide.
//
// For example requests, see Examples (after the Errors section).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock Runtime's
// API operation InvokeModel for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ModelTimeoutException
//     The request took too long to process. Processing time exceeded the model
//     timeout length.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ModelNotReadyException
//     The model specified in the request is not ready to serve inference requests.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ModelErrorException
//     The request failed due to an error while processing the model.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModel
func (c *BedrockRuntime) InvokeModel(input *InvokeModelInput) (*InvokeModelOutput, error) {
	req, out := c.InvokeModelRequest(input)
	return out, req.Send()
}

// InvokeModelWithContext is the same as InvokeModel with the addition of
// the ability to pass a context and additional request options.
//
// See InvokeModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockRuntime) InvokeModelWithContext(ctx aws.Context, input *InvokeModelInput, opts ...request.Option) (*InvokeModelOutput, error) {
	req, out := c.InvokeModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInvokeModelWithResponseStream = "InvokeModelWithResponseStream"

// InvokeModelWithResponseStreamRequest generates a "aws/request.Request" representing the
// client's request for the InvokeModelWithResponseStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvokeModelWithResponseStream for more information on using the InvokeModelWithResponseStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InvokeModelWithResponseStreamRequest method.
//	req, resp := client.InvokeModelWithResponseStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModelWithResponseStream
func (c *BedrockRuntime) InvokeModelWithResponseStreamRequest(input *InvokeModelWithResponseStreamInput) (req *request.Request, output *InvokeModelWithResponseStreamOutput) {
	op := &request.Operation{
		Name:       opInvokeModelWithResponseStream,
		HTTPMethod: "POST",
		HTTPPath:   "/model/{modelId}/invoke-with-response-stream",
	}

	if input == nil {
		input = &InvokeModelWithResponseStreamInput{}
	}

	output = &InvokeModelWithResponseStreamOutput{}
	req = c.newRequest(op, input, output)

	es := NewInvokeModelWithResponseStreamEventStream()
	output.eventStream = es

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// InvokeModelWithResponseStream API operation for Amazon Bedrock Runtime.
//
// Invoke the specified Bedrock model to run inference using the input provided.
// Return the response in a stream.
//
// For more information, see Run inference (https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html)
// in the Bedrock User Guide.
//
// For an example request and response, see Examples (after the Errors section).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock Runtime's
// API operation InvokeModelWithResponseStream for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ModelTimeoutException
//     The request took too long to process. Processing time exceeded the model
//     timeout length.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ModelStreamErrorException
//     An error occurred while streaming the response.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ModelNotReadyException
//     The model specified in the request is not ready to serve inference requests.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ModelErrorException
//     The request failed due to an error while processing the model.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-runtime-2023-09-30/InvokeModelWithResponseStream
func (c *BedrockRuntime) InvokeModelWithResponseStream(input *InvokeModelWithResponseStreamInput) (*InvokeModelWithResponseStreamOutput, error) {
	req, out := c.InvokeModelWithResponseStreamRequest(input)
	return out, req.Send()
}

// InvokeModelWithResponseStreamWithContext is the same as InvokeModelWithResponseStream with the addition of
// the ability to pass a context and additional request options.
//
// See InvokeModelWithResponseStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockRuntime) InvokeModelWithResponseStreamWithContext(ctx aws.Context, input *InvokeModelWithResponseStreamInput, opts ...request.Option) (*InvokeModelWithResponseStreamOutput, error) {
	req, out := c.InvokeModelWithResponseStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error
var _ time.Time

// InvokeModelWithResponseStreamEventStream provides the event stream handling for the InvokeModelWithResponseStream.
//
// For testing and mocking the event stream this type should be initialized via
// the NewInvokeModelWithResponseStreamEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type InvokeModelWithResponseStreamEventStream struct {

	// Reader is the EventStream reader for the ResponseStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader ResponseStreamReader

	outputReader io.ReadCloser

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewInvokeModelWithResponseStreamEventStream initializes an InvokeModelWithResponseStreamEventStream.
// This function should only be used for testing and mocking the InvokeModelWithResponseStreamEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
//
//	es := NewInvokeModelWithResponseStreamEventStream(func(o *InvokeModelWithResponseStreamEventStream){
//	    es.Reader = myMockStreamReader
//	})
func NewInvokeModelWithResponseStreamEventStream(opts ...func(*InvokeModelWithResponseStreamEventStream)) *InvokeModelWithResponseStreamEventStream {
	es := &InvokeModelWithResponseStreamEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *InvokeModelWithResponseStreamEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *InvokeModelWithResponseStreamEventStream) waitStreamPartClose() {
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

// Events returns a channel to read events from.
//
// These events are:
//
//   - PayloadPart
//   - ResponseStreamUnknownEvent
func (es *InvokeModelWithResponseStreamEventStream) Events() <-chan ResponseStreamEvent {
	return es.Reader.Events()
}

func (es *InvokeModelWithResponseStreamEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForResponseStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadResponseStream(eventReader)
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
func (es *InvokeModelWithResponseStreamEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *InvokeModelWithResponseStreamEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *InvokeModelWithResponseStreamEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

// The request is denied because of missing access permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

// The InternalServerException is and event in the ResponseStream group of events.
func (s *InternalServerException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the InternalServerException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *InternalServerException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *InternalServerException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvokeModelInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The desired MIME type of the inference body in the response. The default
	// value is application/json.
	Accept *string `location:"header" locationName:"Accept" type:"string"`

	// Input data in the format specified in the content-type request header. To
	// see the format and content of this field for different models, refer to Inference
	// parameters (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
	//
	// Body is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InvokeModelInput's
	// String and GoString methods.
	//
	// Body is a required field
	Body []byte `locationName:"body" type:"blob" required:"true" sensitive:"true"`

	// The MIME type of the input data in the request. The default value is application/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Identifier of the model.
	//
	// ModelId is a required field
	ModelId *string `location:"uri" locationName:"modelId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeModelInput"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccept sets the Accept field's value.
func (s *InvokeModelInput) SetAccept(v string) *InvokeModelInput {
	s.Accept = &v
	return s
}

// SetBody sets the Body field's value.
func (s *InvokeModelInput) SetBody(v []byte) *InvokeModelInput {
	s.Body = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *InvokeModelInput) SetContentType(v string) *InvokeModelInput {
	s.ContentType = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *InvokeModelInput) SetModelId(v string) *InvokeModelInput {
	s.ModelId = &v
	return s
}

type InvokeModelOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// Inference response from the model in the format specified in the content-type
	// header field. To see the format and content of this field for different models,
	// refer to Inference parameters (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
	//
	// Body is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InvokeModelOutput's
	// String and GoString methods.
	//
	// Body is a required field
	Body []byte `locationName:"body" type:"blob" required:"true" sensitive:"true"`

	// The MIME type of the inference result.
	//
	// ContentType is a required field
	ContentType *string `location:"header" locationName:"Content-Type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeModelOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *InvokeModelOutput) SetBody(v []byte) *InvokeModelOutput {
	s.Body = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *InvokeModelOutput) SetContentType(v string) *InvokeModelOutput {
	s.ContentType = &v
	return s
}

type InvokeModelWithResponseStreamInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The desired MIME type of the inference body in the response. The default
	// value is application/json.
	Accept *string `location:"header" locationName:"X-Amzn-Bedrock-Accept" type:"string"`

	// Inference input in the format specified by the content-type. To see the format
	// and content of this field for different models, refer to Inference parameters
	// (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
	//
	// Body is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InvokeModelWithResponseStreamInput's
	// String and GoString methods.
	//
	// Body is a required field
	Body []byte `locationName:"body" type:"blob" required:"true" sensitive:"true"`

	// The MIME type of the input data in the request. The default value is application/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Id of the model to invoke using the streaming request.
	//
	// ModelId is a required field
	ModelId *string `location:"uri" locationName:"modelId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeModelWithResponseStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeModelWithResponseStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeModelWithResponseStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeModelWithResponseStreamInput"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccept sets the Accept field's value.
func (s *InvokeModelWithResponseStreamInput) SetAccept(v string) *InvokeModelWithResponseStreamInput {
	s.Accept = &v
	return s
}

// SetBody sets the Body field's value.
func (s *InvokeModelWithResponseStreamInput) SetBody(v []byte) *InvokeModelWithResponseStreamInput {
	s.Body = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *InvokeModelWithResponseStreamInput) SetContentType(v string) *InvokeModelWithResponseStreamInput {
	s.ContentType = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *InvokeModelWithResponseStreamInput) SetModelId(v string) *InvokeModelWithResponseStreamInput {
	s.ModelId = &v
	return s
}

type InvokeModelWithResponseStreamOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	eventStream *InvokeModelWithResponseStreamEventStream

	// The MIME type of the inference result.
	//
	// ContentType is a required field
	ContentType *string `location:"header" locationName:"X-Amzn-Bedrock-Content-Type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeModelWithResponseStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvokeModelWithResponseStreamOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *InvokeModelWithResponseStreamOutput) SetContentType(v string) *InvokeModelWithResponseStreamOutput {
	s.ContentType = &v
	return s
}

// GetStream returns the type to interact with the event stream.
func (s *InvokeModelWithResponseStreamOutput) GetStream() *InvokeModelWithResponseStreamEventStream {
	return s.eventStream
}

// The request failed due to an error while processing the model.
type ModelErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The original status code.
	OriginalStatusCode *int64 `locationName:"originalStatusCode" min:"100" type:"integer"`

	// The resource name.
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelErrorException) GoString() string {
	return s.String()
}

func newErrorModelErrorException(v protocol.ResponseMetadata) error {
	return &ModelErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ModelErrorException) Code() string {
	return "ModelErrorException"
}

// Message returns the exception's message.
func (s *ModelErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ModelErrorException) OrigErr() error {
	return nil
}

func (s *ModelErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ModelErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ModelErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The model specified in the request is not ready to serve inference requests.
type ModelNotReadyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelNotReadyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelNotReadyException) GoString() string {
	return s.String()
}

func newErrorModelNotReadyException(v protocol.ResponseMetadata) error {
	return &ModelNotReadyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ModelNotReadyException) Code() string {
	return "ModelNotReadyException"
}

// Message returns the exception's message.
func (s *ModelNotReadyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ModelNotReadyException) OrigErr() error {
	return nil
}

func (s *ModelNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ModelNotReadyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ModelNotReadyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An error occurred while streaming the response.
type ModelStreamErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The original message.
	OriginalMessage *string `locationName:"originalMessage" type:"string"`

	// The original status code.
	OriginalStatusCode *int64 `locationName:"originalStatusCode" min:"100" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelStreamErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelStreamErrorException) GoString() string {
	return s.String()
}

// The ModelStreamErrorException is and event in the ResponseStream group of events.
func (s *ModelStreamErrorException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ModelStreamErrorException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ModelStreamErrorException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ModelStreamErrorException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorModelStreamErrorException(v protocol.ResponseMetadata) error {
	return &ModelStreamErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ModelStreamErrorException) Code() string {
	return "ModelStreamErrorException"
}

// Message returns the exception's message.
func (s *ModelStreamErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ModelStreamErrorException) OrigErr() error {
	return nil
}

func (s *ModelStreamErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ModelStreamErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ModelStreamErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request took too long to process. Processing time exceeded the model
// timeout length.
type ModelTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelTimeoutException) GoString() string {
	return s.String()
}

// The ModelTimeoutException is and event in the ResponseStream group of events.
func (s *ModelTimeoutException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ModelTimeoutException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ModelTimeoutException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ModelTimeoutException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorModelTimeoutException(v protocol.ResponseMetadata) error {
	return &ModelTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ModelTimeoutException) Code() string {
	return "ModelTimeoutException"
}

// Message returns the exception's message.
func (s *ModelTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ModelTimeoutException) OrigErr() error {
	return nil
}

func (s *ModelTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ModelTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ModelTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Payload content included in the response.
type PayloadPart struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Base64-encoded bytes of payload data.
	//
	// Bytes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PayloadPart's
	// String and GoString methods.
	//
	// Bytes is automatically base64 encoded/decoded by the SDK.
	Bytes []byte `locationName:"bytes" type:"blob" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PayloadPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PayloadPart) GoString() string {
	return s.String()
}

// SetBytes sets the Bytes field's value.
func (s *PayloadPart) SetBytes(v []byte) *PayloadPart {
	s.Bytes = v
	return s
}

// The PayloadPart is and event in the ResponseStream group of events.
func (s *PayloadPart) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the PayloadPart value.
// This method is only used internally within the SDK's EventStream handling.
func (s *PayloadPart) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *PayloadPart) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// The specified resource ARN was not found. Check the ARN and try your request
// again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// ResponseStreamEvent groups together all EventStream
// events writes for ResponseStream.
//
// These events are:
//
//   - PayloadPart
type ResponseStreamEvent interface {
	eventResponseStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// ResponseStreamReader provides the interface for reading to the stream. The
// default implementation for this interface will be ResponseStream.
//
// The reader's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - PayloadPart
//   - ResponseStreamUnknownEvent
type ResponseStreamReader interface {
	// Returns a channel of events as they are read from the event stream.
	Events() <-chan ResponseStreamEvent

	// Close will stop the reader reading events from the stream.
	Close() error

	// Returns any error that has occurred while reading from the event stream.
	Err() error
}

type readResponseStream struct {
	eventReader *eventstreamapi.EventReader
	stream      chan ResponseStreamEvent
	err         *eventstreamapi.OnceError

	done      chan struct{}
	closeOnce sync.Once
}

func newReadResponseStream(eventReader *eventstreamapi.EventReader) *readResponseStream {
	r := &readResponseStream{
		eventReader: eventReader,
		stream:      make(chan ResponseStreamEvent),
		done:        make(chan struct{}),
		err:         eventstreamapi.NewOnceError(),
	}
	go r.readEventStream()

	return r
}

// Close will close the underlying event stream reader.
func (r *readResponseStream) Close() error {
	r.closeOnce.Do(r.safeClose)
	return r.Err()
}

func (r *readResponseStream) ErrorSet() <-chan struct{} {
	return r.err.ErrorSet()
}

func (r *readResponseStream) Closed() <-chan struct{} {
	return r.done
}

func (r *readResponseStream) safeClose() {
	close(r.done)
}

func (r *readResponseStream) Err() error {
	return r.err.Err()
}

func (r *readResponseStream) Events() <-chan ResponseStreamEvent {
	return r.stream
}

func (r *readResponseStream) readEventStream() {
	defer r.Close()
	defer close(r.stream)

	for {
		event, err := r.eventReader.ReadEvent()
		if err != nil {
			if err == io.EOF {
				return
			}
			select {
			case <-r.done:
				// If closed already ignore the error
				return
			default:
			}
			if _, ok := err.(*eventstreamapi.UnknownMessageTypeError); ok {
				continue
			}
			r.err.SetError(err)
			return
		}

		select {
		case r.stream <- event.(ResponseStreamEvent):
		case <-r.done:
			return
		}
	}
}

type unmarshalerForResponseStreamEvent struct {
	metadata protocol.ResponseMetadata
}

func (u unmarshalerForResponseStreamEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	switch eventType {
	case "chunk":
		return &PayloadPart{}, nil
	case "internalServerException":
		return newErrorInternalServerException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "modelStreamErrorException":
		return newErrorModelStreamErrorException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "modelTimeoutException":
		return newErrorModelTimeoutException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "throttlingException":
		return newErrorThrottlingException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "validationException":
		return newErrorValidationException(u.metadata).(eventstreamapi.Unmarshaler), nil
	default:
		return &ResponseStreamUnknownEvent{Type: eventType}, nil
	}
}

// ResponseStreamUnknownEvent provides a failsafe event for the
// ResponseStream group of events when an unknown event is received.
type ResponseStreamUnknownEvent struct {
	Type    string
	Message eventstream.Message
}

// The ResponseStreamUnknownEvent is and event in the ResponseStream
// group of events.
func (s *ResponseStreamUnknownEvent) eventResponseStream() {}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (e *ResponseStreamUnknownEvent) MarshalEvent(pm protocol.PayloadMarshaler) (
	msg eventstream.Message, err error,
) {
	return e.Message.Clone(), nil
}

// UnmarshalEvent unmarshals the EventStream Message into the ResponseStream value.
// This method is only used internally within the SDK's EventStream handling.
func (e *ResponseStreamUnknownEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	e.Message = msg.Clone()
	return nil
}

// The number of requests exceeds the service quota. Resubmit your request later.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The number of requests exceeds the limit. Resubmit your request later.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

// The ThrottlingException is and event in the ResponseStream group of events.
func (s *ThrottlingException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ThrottlingException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ThrottlingException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ThrottlingException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Input validation failed. Check your request parameters and retry the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

// The ValidationException is and event in the ResponseStream group of events.
func (s *ValidationException) eventResponseStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ValidationException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ValidationException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ValidationException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}
