/*    
  level.c - mulg built-in levels

  !!don't forget to updade LEVELS in mulg.h when adding new levels!!


   dont's:  never allow boxes to be pushed onto reversed paths,
            the start field, or switchable path/spaces
            (attribute will be lost)

            never let the player leave the game area (never place bombs
            near the side walls)

*/

#include "tiles.h"
#include "mulg.h"
#include "hole.h"


/* 0: Rolling home */
unsigned short level0[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH, STONE, STONE, STONE, STONE, STONE,  PATH, STONE, STONE,
  STONE,  PATH, STONE,  PATH,  PATH,  PATH, STONE,  PATH,  DOC1, STONE,
  STONE,  PATH,  PATH,  PATH, STONE,  PATH, STONE, STONE,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE,  PATH,  PATH, STONE,  PATH, STONE,
  STONE,  DOC0,  PATH,  PATH, STONE, STONE,  PATH, STONE,  PATH, STONE,
  STONE, START, STONE,  PATH,  PATH,  PATH,  PATH, STONE,  GOAL, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE};

/* 1: in the basement */
unsigned short level1[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,   STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,   STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE, SPACE,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,  PATH,  PATH,    PATH,  PATH, SPACE,  PATH,  PATH,  PATH, SPACE, SPACE, SPACE,   SPACE, SPACE, SPACE, SPACE, SPACE, STONE,   SW2,  PATH, STONE,
  STONE,  PATH,  PATH, STONE,   OWU, STONE,  PATH,  PATH,  PATH, STONE,   STONE,  PATH,  PATH,  PATH, STONE,  PATH,  PATH,  PATH,  PATH,    PATH,  PATH,  PATH,  PATH,  PATH, STONE, STONE,  PATH, STONE,
  STONE,   OWD, STONE, STONE,  PATH, STONE, STONE, STONE, STONE, STONE,   STONE, STONE, STONE, STONE, STONE,  PATH, STONE, SPACE, SPACE,   SPACE,   OWU, SPACE, SPACE,  PATH, STONE, STONE,  PATH, STONE,
  STONE,  PATH,  PATH, STONE,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,   STONE,  PATH,  PATH,  PATH, STONE,  PATH,VDOOR1,  PATH,  PATH,    PATH,  PATH,  PATH, SPACE,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, STONE,  PATH, STONE, STONE, STONE, SPACE, SPACE,  PATH, STONE,   STONE,  PATH, SPACE,   SW1, STONE, SPACE, STONE,  PATH, STONE,   STONE, STONE,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE, STONE,
  STONE, SPACE,  PATH,  PATH, SPACE,  PATH,  PATH,  PATH,  PATH, SPACE,   SPACE,  PATH,  PATH, STONE, STONE, STONE, STONE,  PATH, STONE,    DOC2, STONE,  PATH, STONE,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, SPACE, STONE,  PATH,  PATH,  PATH, SPACE, STONE,  PATH,  PATH,    PATH,  PATH,  PATH, STONE, START,  PATH,  PATH,  PATH, STONE,    PATH,  PATH,  PATH,VDOOR2,  PATH, SPACE, SPACE,  GOAL, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,   STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,   STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE
};

/* 2: Playground */
unsigned short level2[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH, STONE, WIPPU, STONE, STONE, WIPPU, STONE,  PATH, STONE,
  STONE,  PATH, WIPPL,  PATH, STONE, STONE,  PATH, WIPPR,  PATH, STONE,
  STONE,HDOOR1, STONE,  PATH,  GOAL,  PATH,  PATH, STONE,HDOOR2, STONE,
  STONE,  PATH, STONE, STONE, STONE, STONE, STONE, STONE,  PATH, STONE,
  STONE,HDOOR2, STONE,  PATH,   OWL, START,  PATH, STONE,HDOOR1, STONE,
  STONE,  PATH,  PATH,  PATH, STONE,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,   OWU, STONE,   OWD,   SW1, STONE,   OWU, STONE,   OWD, STONE,
  STONE,  PATH, SPACE,  PATH,  PATH,  PATH,  PATH, SPACE,  PATH,   SW2,
  STONE,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  PATH, STONE,
  STONE,  PATH, SPACE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH, SPACE,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE, STONE,
  STONE,  PATH, SPACE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE
};

/* 3: BOUNCIN' */
unsigned short level3[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,  BUMP,  PATH,  BUMP,  PATH,  BUMP,  GOAL,  BUMP, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  BUMP,  PATH,  BUMP,  PATH,  BUMP,  PATH,  BUMP,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  BUMP,  PATH,  BUMP,  PATH,  BUMP,  PATH,  BUMP,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, START,  BUMP,  PATH,  BUMP,  PATH,  BUMP,  PATH,  BUMP, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE  
};

/* 4: Round'n Round */
unsigned short level4[]={
  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,
  SPACE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  GOAL, STONE,  START,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,
  SPACE, LOCH1, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,RLOCH1, SPACE,
  SPACE,  PATH,RLOCH1,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH, LOCH1,  PATH, SPACE,
  SPACE,  PATH, SPACE, LOCH1, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE,RLOCH1, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE,  PATH,RLOCH1,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH,  PATH,  PATH,  PATH, LOCH1,  PATH, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE,  PATH, SPACE, LOCH1, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE,RLOCH1, SPACE,  PATH, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE,  PATH, SPACE,  PATH,RLOCH1,  PATH,  PATH,  PATH,   PATH,  PATH, LOCH1,  PATH, SPACE,  PATH, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE,  PATH, SPACE,  PATH, SPACE, LOCH1, LOCH1, SPACE,  SPACE,RLOCH1, SPACE,  PATH, SPACE,  PATH, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE,  PATH, SPACE,  PATH, SPACE,   SW1,  PATH,  PATH,   PATH,  PATH, SPACE,  PATH, SPACE,  PATH, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE,  PATH, SPACE,  PATH, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE,  PATH, SPACE,  PATH, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE,  PATH, SPACE,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH,  PATH,  PATH,  PATH, SPACE,  PATH, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE,  PATH, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,  PATH, SPACE,
  SPACE,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  PATH, SPACE,
  SPACE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,
  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE
};

/* 5: Offroad */
unsigned short level5[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,VDOOR1,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,   PATH,  HUMP,  PATH,  HOLE,  PATH,  HUMP,  PATH,  PATH, STONE,
  STONE,  PATH, STONE, STONE, STONE, STONE, STONE, STONE,  PATH, STONE,   PATH, STONE, STONE, STONE, STONE, STONE, STONE,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,  PATH, STONE,   PATH, STONE,  PATH,  PATH,  HUMP, SPACE, STONE,  PATH, STONE,
  STONE,  PATH, STONE, STONE, STONE, STONE,  PATH, STONE,  PATH, STONE,   PATH, STONE,  PATH, SPACE,  PATH, SPACE, STONE,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH, STONE,  PATH,  PATH, STONE,  PATH, STONE,   PATH, STONE,  PATH, SPACE,  PATH, SPACE, STONE,  PATH, STONE,
  STONE, STONE, STONE,  PATH, STONE,  PATH, STONE, STONE,  PATH,  PATH,   PATH,VDOOR2,  HUMP, SPACE,  PATH, SPACE, STONE,  PATH, STONE,
  STONE,  GOAL, STONE, START, STONE,  PATH,   SW1, STONE, SPACE, STONE,  STONE, STONE, SPACE, SPACE,  PATH, SPACE, STONE,   SW2, STONE,
  STONE,  PATH, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE,  PATH, STONE, STONE, STONE, STONE,

  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,   PATH,  PATH,  PATH, SPACE,  PATH, SPACE, STONE,   SW3, STONE,
  STONE,  PATH,  BUMP,  PATH,  BUMP,  PATH,  BUMP,  PATH,  BUMP, STONE,   PATH, STONE,  PATH,  BUMP,  PATH,  BUMP, STONE,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,   PATH, STONE,  PATH, SPACE,  PATH, SPACE, STONE,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  PATH, STONE,   PATH, STONE,HDOOR3, STONE,  PATH, STONE,  BUMP,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,   PATH, STONE,  PATH,  PATH,  PATH, STONE, STONE,  PATH, STONE,
  STONE, SPACE,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, STONE,   PATH, STONE, SPACE, SPACE,  PATH, SPACE,  BUMP,  PATH, STONE,
  STONE,  BUMP,  PATH,  PATH,  HOLE,  PATH,  HUMP,  PATH,  HOLE,  PATH,   PATH, STONE, SPACE,  BUMP,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE  
};

/* 6: HIT ME */
unsigned short level6[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH, STONE, SPACE, SPACE,  GOAL, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE, SPACE, SPACE, STONE,
  STONE,  PATH,BOXPTH,  PATH,BOXPTH, STONE, SPACE, SPACE, SPACE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH, STONE, STONE,  PATH, STONE, STONE,
  STONE,  PATH,  PATH,BOXPTH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,BOXPTH,  PATH,BOXPTH,  PATH,  PATH, STONE,
  STONE, START,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE  
};

/* 7: Slippery Slide */
unsigned short level7[]={
  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,
  SPACE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE, SPACE,
  SPACE,   ICE, START,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE, SPACE,
  SPACE,   ICE,   ICE,   ICE, SPACE, SPACE,   ICE,   ICE,   ICE, SPACE,
  SPACE,   ICE,   ICE, SPACE, SPACE, SPACE, SPACE,   ICE,   ICE, SPACE,
  SPACE,   ICE,   ICE,   ICE, SPACE, SPACE,   ICE,   ICE,   ICE, SPACE,
  SPACE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,  GOAL,   ICE, SPACE,
  SPACE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE, SPACE,
  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE  
};

/* 8: Sokoban */
unsigned short level8[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,   OWL,   OWL,   OWL,   OWL,   OWL,   OWL,  PATH, STONE,  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,   OWD, STONE, STONE, STONE, STONE, STONE, STONE,   OWU, STONE,  STONE,  PATH,BOXPTH, STONE,BOXPTH,  PATH, STONE,  PATH, STONE,
  STONE,   OWD, STONE,  GOAL,   OWL,   OWL,  PATH, STONE,   OWU, STONE,  STONE,  PATH,BOXPTH,  PATH,  PATH,BOXPTH, STONE,  PATH, STONE,
  STONE,   OWD, STONE, STONE, STONE, STONE,   OWU, STONE,   OWU, STONE,  STONE, STONE,BOXPTH,  PATH,BOXPTH,  PATH, STONE, START, STONE,
  STONE,  PATH,   OWR,   OWR,   OWR,   OWR,  PATH, STONE,   OWU, STONE,  STONE,  PATH,BOXPTH,  PATH, STONE,  PATH, STONE, STONE, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,HDOOR1, STONE,  STONE,  PATH,BOXPTH,  PATH,  PATH,BOXPTH,  PATH,  PATH, STONE,
    SW1, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE,BOXPTH,  PATH,  PATH,BOXPTH,  PATH,  PATH,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE
};

/* 9: Auto Reverse */
unsigned short level9[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,   PATH,  PATH,  PATH, SPACE,   KEY,  PATH,  PATH,  PATH, STONE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH, STONE, STONE, STONE, STONE, STONE, STONE,  PATH,   OWR,   PATH, SPACE,  PATH,   OWR,  PATH,  PATH, SPACE,  PATH,   OWL,   PATH,  PATH,  PATH, STONE, STONE,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH, STONE, START,  PATH,  PATH,   KH1, STONE,  PATH, STONE,   PATH, SPACE,  PATH, SPACE, SPACE,  PATH, SPACE,  PATH, STONE,   PATH,  PATH, STONE,  PATH,   KEY, STONE,  PATH,  PATH, STONE,
  STONE,  PATH, STONE,  PATH,  PATH,  PATH,  PATH, STONE,  PATH,   OWR,   PATH,  PATH,  PATH, SPACE, SPACE,  PATH,  PATH,  PATH,   OWL,   PATH,  PATH,VDOOR2,  PATH,  PATH, STONE,  PATH,  PATH, STONE,
  STONE,  PATH, STONE,  PATH,   KEY,  PATH, NPATH, STONE,  PATH, STONE,   PATH, SPACE,  PATH, SPACE, SPACE,  PATH, SPACE,  PATH, STONE,   PATH,  PATH, STONE,  PATH,   KEY, STONE,  PATH,  PATH, STONE,
  STONE,  PATH, STONE, STONE, STONE, STONE,HDOOR1, STONE,  PATH,   OWR,   PATH, SPACE,  PATH, SPACE, SPACE,  PATH, SPACE,  PATH,   OWL,   PATH,  PATH,  PATH, STONE, STONE,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH, RPATH,  PATH,  PATH, STONE,  SPACE,  PATH,  PATH,   OWR,  PATH,  PATH,  PATH, SPACE, STONE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, STONE,   OWU, STONE, STONE, STONE, STONE,   OWU, STONE, STONE,  STONE,   OWD, STONE, STONE, STONE, STONE,   OWD, STONE, STONE,  STONE,   OWU, STONE, STONE, STONE, STONE,   OWU, STONE, STONE,
  STONE, SPACE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE, SPACE, STONE,   PATH,  PATH,  PATH, SPACE, SPACE,  PATH,  PATH,  PATH, STONE,  SPACE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE, STONE,
  STONE, SPACE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   OWL,   PATH,  PATH,  PATH, SPACE, SPACE,  PATH,  PATH,  PATH,   OWR,   PATH,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, STONE,
  STONE, SPACE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE, STONE,   PATH,  PATH,  PATH, SPACE, SPACE,  PATH,  PATH,  PATH, STONE,   PATH, SPACE,  GOAL,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, SPACE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   OWL,   PATH,  PATH,BOXPTH, SPACE, SPACE,  PATH,  PATH,  PATH,   OWR,   PATH, SPACE, STONE, STONE, STONE, STONE,HDOOR5, STONE, STONE,
  STONE, SPACE,   ICE,   KH2,   ICE,   ICE,   ICE,   ICE,   ICE, STONE,   PATH,  PATH,  PATH, SPACE, SPACE,BOXPTH,  PATH,  PATH, STONE,   PATH,  PATH,  PATH,  PATH,VDOOR3,VDOOR4,  PATH,  PATH, STONE,
  STONE, SPACE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   OWL,   PATH,  PATH,  PATH, SPACE, SPACE,  PATH,  PATH,  PATH,   OWR,   PATH, SPACE,   KH3,   KH4, STONE, STONE,   KH5,  PATH, STONE,
  STONE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, STONE,   PATH,  PATH,  PATH, SPACE, SPACE,  PATH,  PATH,  PATH, STONE,  SPACE, SPACE,   KEY,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE
};

/* 10: The Maze */
unsigned short level10[]={
  S,S,S,S,S,S,S,S,S,S, S,S,S,S,S,S,S,S,S, S,S,S,S,S,S,S,S,S, S,S,S,S,S,S,S,S,S, 
  S,O,S,P,P,P,S,P,S,P, P,P,P,P,S,P,P,P,P, P,S,P,S,P,P,P,S,P, P,P,P,P,P,P,P,P,S,
  S,P,S,P,S,P,S,P,S,S, S,P,S,P,S,P,S,S,S, S,S,P,S,P,S,P,S,S, S,P,S,S,S,S,S,S,S, 
  S,P,P,P,S,P,S,P,P,P, P,P,S,P,P,P,P,P,S, P,P,P,P,P,S,P,P,P, P,P,S,P,P,P,P,P,S,
  S,S,S,S,S,P,S,S,S,S, S,P,S,S,S,P,S,S,S, P,S,S,S,S,S,S,S,S, S,P,S,S,S,P,S,S,S, 
  S,P,P,P,S,P,P,P,P,P, S,P,P,P,S,P,P,P,P, P,P,P,P,P,S,P,P,P, P,P,S,P,S,P,P,P,S,
  S,S,S,P,S,S,S,S,S,P, S,S,S,P,S,S,S,S,S, S,S,S,S,P,S,P,S,S, S,S,S,P,S,P,S,S,S, 
  S,P,S,P,P,P,P,P,P,P, S,P,S,P,S,P,S,P,S, P,S,P,S,P,S,P,P,P, P,P,P,P,P,P,S,P,S,
  S,P,S,S,S,P,S,P,S,S, S,P,S,P,S,P,S,P,S, P,S,P,S,P,S,P,S,S, S,P,S,S,S,S,S,P,S, 
  S,P,S,P,P,P,S,P,P,P, S,P,S,P,S,P,S,P,S, P,P,P,S,P,S,P,P,P, S,P,P,P,S,P,P,P,S,
  S,P,S,P,S,S,S,S,S,S, S,P,S,P,S,P,S,P,S, S,S,P,S,S,S,S,S,S, S,S,S,P,S,P,S,S,S, 
  S,P,S,P,P,P,P,P,P,P, P,P,S,P,S,P,P,P,S, P,P,P,S,P,P,P,P,P, P,P,S,P,S,P,P,P,S,
  S,P,S,S,S,P,S,S,S,S, S,P,S,P,S,P,S,S,S, P,S,S,S,P,S,S,S,P, S,S,S,P,S,P,S,P,S, 
  S,P,P,P,P,P,P,P,S,P, P,P,S,P,S,P,S,P,P, P,P,P,S,P,P,P,S,P, P,P,P,P,P,P,S,P,S,
  S,S,S,P,S,S,S,P,S,P, S,S,S,P,S,P,S,P,S, S,S,P,S,P,S,S,S,S, S,S,S,S,S,S,S,S,S, 
  S,P,S,P,S,P,S,P,S,P, P,P,P,P,S,P,P,P,S, P,S,P,P,P,S,P,P,P, S,P,P,P,P,P,S,P,S,
  S,P,S,S,S,P,S,S,S,S, S,S,S,S,S,S,S,P,S, P,S,S,S,P,S,P,S,S, S,P,S,S,S,P,S,P,S, 
  S,P,S,P,P,P,S,P,P,P, P,P,P,P,S,P,P,P,S, P,P,P,S,P,P,P,S,P, P,P,P,P,S,P,P,P,S,
  S,P,S,P,S,S,S,P,S,S, S,P,S,P,S,P,S,S,S, P,S,S,S,S,S,S,S,P, S,P,S,P,S,S,S,S,S, 
  S,P,S,P,P,P,P,P,S,P, S,P,S,P,P,P,P,P,S, P,S,P,P,P,P,P,P,P, S,P,S,P,P,P,S,P,S,
  S,P,S,P,S,S,S,P,S,P, S,S,S,S,S,P,S,P,S, P,S,P,S,P,S,S,S,S, S,S,S,S,S,P,S,P,S, 
  S,P,P,P,S,P,P,P,S,P, S,P,P,P,S,P,S,P,P, P,S,P,S,P,S,P,P,P, P,P,P,P,S,P,S,P,S,
  S,S,S,S,S,P,S,S,S,P, S,P,S,S,S,S,S,S,S, S,S,P,S,P,S,P,S,S, S,S,S,P,S,P,S,P,S, 
  S,P,P,P,P,P,P,P,S,P, P,P,S,P,P,P,P,P,P, P,P,P,S,P,S,P,S,P, S,P,P,P,S,P,S,P,S,
  S,P,S,S,S,S,S,S,S,S, S,P,S,P,S,S,S,S,S, P,S,S,S,S,S,P,S,P, S,P,S,S,S,P,S,P,S, 
  S,P,S,P,P,P,P,P,P,P, P,P,S,P,S,P,P,P,S, P,S,P,P,P,P,P,S,P, P,P,P,P,P,P,S,P,S,
  S,P,S,P,S,P,S,S,S,P, S,S,S,P,S,P,S,P,S, S,S,P,S,P,S,S,S,S, S,S,S,S,S,S,S,P,S, 
  S,P,P,P,S,P,S,P,P,P, S,P,P,P,S,P,S,P,P, P,P,P,S,P,P,P,P,P, P,P,S,P,P,P,P,P,S,
  S,S,S,S,S,P,S,P,S,S, S,P,S,S,S,S,S,S,S, P,S,S,S,S,S,S,S,S, S,P,S,P,S,S,S,P,S,
  S,P,S,P,P,P,S,P,P,P, S,P,P,P,P,P,S,P,P, P,S,P,P,P,P,P,P,P, S,P,P,P,P,P,S,P,S,
  S,P,S,P,S,P,S,P,S,S, S,S,S,P,S,P,S,P,S, S,S,P,S,P,S,P,S,S, S,P,S,S,S,S,S,S,S,
  S,P,P,P,S,P,S,P,P,P, P,P,P,P,S,P,S,P,S, P,P,P,S,P,S,P,P,P, P,P,P,P,P,P,P,X,S,
  S,S,S,S,S,S,S,S,S,S, S,S,S,S,S,S,S,S,S, S,S,S,S,S,S,S,S,S, S,S,S,S,S,S,S,S,S
};

/* 11: Happy New Year */
unsigned short level11[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH, STONE,   KEY, STONE,  PATH,  PATH,   PATH,  PATH,  PATH,  PATH,  PATH,VDOOR1,VDOOR2,  GOAL, STONE,
  STONE,  PATH, START,  PATH,  PATH, STONE, STONE, STONE,  PATH,  PATH,   PATH,  PATH,BOXPTH,  PATH,  PATH,   KH1,   KH2, STONE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  BOMB,  BOMB,  BOMB,  PATH,  PATH,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH, SPACE,   ICE,   ICE,   ICE, SPACE,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH, SPACE,  BOMB,  BOMB,  BOMB, SPACE,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH, MATCH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH, SPACE, STONE, STONE, STONE, SPACE,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH, SPACE, STONE,   KEY, STONE, SPACE,  PATH,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE
};

/* 12: Casino */
unsigned short level12[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,  GOAL, STONE,
  STONE,  PATH,DIC5_1,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,VDOOR1,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,BOXPTH,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE, STONE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,DIC2_1,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,DIC6_1,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,BOXPTH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,DIC1_1,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,BOXPTH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, START,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,DIC4_1,  PATH, STONE,
  STONE,  PATH,  PATH,BOXPTH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,DIC2_1,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, SPACE,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE
};

/* 13: Bump of Death */
unsigned short level13[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  PATH,  PATH,  BUMP, SKULL,  BUMP, SKULL,  BUMP, STONE, STONE,   BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  BUMP, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  BUMP, STONE,
  STONE, START,  PATH, SKULL,  BUMP, SKULL,  BUMP, SKULL, STONE, STONE,   BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  PATH,  BUMP, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, DICE1,  DICE2, DICE3, DICE4, DICE5, DICE6,  BUMP,  PATH,  BUMP, STONE,
  STONE,  GOAL,  PATH, SKULL,  BUMP, SKULL,  BUMP, SKULL, STONE, STONE,   BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  PATH,  BUMP, STONE,
  STONE,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,   PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  BUMP, STONE,
  STONE,  PATH,  PATH,  BUMP, SKULL,  BUMP, SKULL,  BUMP, STONE, STONE,   BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  BUMP,  BUMP, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE
};

/* 14: Stormy Monday */
unsigned short level14[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, STONE,
  STONE, SPACE, SPACE, SPACE,  PATH,  PATH,  PATH, WIPPL,  PATH,  PATH,   PATH,  PATH,  PATH, WIPPL,  PATH,  PATH,  PATH, SPACE, STONE,
  STONE, SPACE, SPACE, SPACE,  PATH, SPACE,  PATH, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  PATH, SPACE, STONE,
  STONE, SPACE, SPACE, SPACE,  PATH,  VENT,  PATH, SPACE, SPACE, SPACE,  SPACE, SPACE, SPACE, SPACE, SPACE, SPACE,  PATH, SPACE, STONE,
  STONE, SPACE, SPACE, SPACE,  PATH, SPACE,  PATH, SPACE, SPACE, SPACE,  SPACE,  PATH,  PATH,  PATH, SPACE, SPACE,  PATH, SPACE, STONE,
  STONE, SPACE, SPACE, SPACE,  PATH,  PATH,  PATH, SPACE, SPACE, SPACE,  SPACE,  PATH,  PATH,  PATH, SPACE, SPACE,  PATH, SPACE, STONE,
  STONE, SPACE, SPACE, SPACE,  PATH,  PATH,  PATH, SPACE, SPACE, SPACE,  SPACE,  PATH, SPACE,   KH1, SPACE, SPACE,  PATH, SPACE, STONE,
  STONE, SPACE, SPACE, SPACE, SPACE,   OWU, SPACE, SPACE, SPACE, SPACE,  SPACE,  PATH, SPACE, SPACE, SPACE, SPACE, WIPPO, SPACE, STONE,
  STONE, SPACE, SPACE, SPACE, SPACE,  PATH, SPACE, SPACE, SPACE, SPACE,  SPACE,  PATH, SPACE, SPACE, SPACE, SPACE,  PATH, SPACE, STONE,
  STONE, SPACE, SPACE, SPACE,  PATH,  PATH, SPACE, SPACE, SPACE, SPACE,  SPACE,  PATH, SPACE,  GOAL,  PATH,  PATH,  PATH, SPACE, STONE,
  STONE, SPACE, SPACE,  PATH,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE,  SPACE,  PATH, SPACE, SPACE, SPACE, SPACE, SPACE, SPACE, STONE,
  STONE, SPACE,  VENT,  PATH,  PATH, SPACE,  PATH,   OWL,  PATH,  PATH,  WIPPR,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, SPACE, SPACE,  PATH, SPACE, SPACE,  PATH, SPACE, VENT1,  PATH,  SPACE,  PATH, SPACE, SPACE,  PATH,  PATH,  PATH,  PATH, STONE,
  STONE, SPACE, SPACE,  PATH, SPACE, SPACE,  PATH, SPACE, SPACE,  PATH,  SPACE,  PATH,   KEY, SPACE,  PATH,  PATH, START,  PATH, STONE,
  STONE, SPACE, SPACE,  PATH,  PATH,  PATH,  PATH, SPACE, SPACE,  PATH,  SPACE, SPACE, SPACE, SPACE,  DOC3,  PATH,  PATH,  PATH, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE
};

/* 15: Cold Shots */
unsigned short level15[]={
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE,
  STONE,  BUMP,   ICE,   ICE,  BUMP,  BUMP,   ICE,   ICE,  BUMP, STONE,
  STONE,   ICE, START,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE, STONE,
  STONE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE, STONE,
  STONE,  BUMP,   ICE,   ICE,  BUMP,  BUMP,   ICE,   ICE,  BUMP, STONE,
  STONE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE, STONE,
  STONE,   ICE,   ICE,   ICE,   ICE,   ICE,   ICE,  GOAL,   ICE, STONE,
  STONE,  BUMP,   ICE,   ICE,  BUMP,  BUMP,   ICE,   ICE,  BUMP, STONE,
  STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE, STONE
};

unsigned short *level[]={ 
  level0,  /* rolling home */
  level1,  /* in the basement */
  level2,  /* playground */
  level3,  /* bouncin' */
  level4,  /* round'n round */
  level5,  /* Offroad */
  level6,  /* Hit Me */
  level7,  /* Slippery Slide */
  level8,  /* Sokoban */
  level9,  /* auto reverse */
  level10, /* The Maze */
  level11, /* Happy New Year */
  level12, /* Casino */
  level13, /* Bump of Death */
  level14, /* Stormy Monday */
  level15  /* Cold Shots */
};

/* width:  10,19,28,37 */
/* height:  9,17,25,33 */

int level_size[][2]={
  {10, 9},  /* 0  */
  {28, 9},  /* 1  */
  {10,17},  /* 2  */
  {10, 9},  /* 3  */
  {19,17},  /* 4  */
  {19,17},  /* 5  */
  {10, 9},  /* 6  */
  {10, 9},  /* 7  */
  {19, 9},  /* 8  */
  {28,17},  /* 9  */
  {37,33},  /* 10 */
  {19, 9},  /* 11 */
  {19,17},  /* 12 */
  {19, 9},  /* 13 */
  {19,17},  /* 14 */
  {10, 9}   /* 15 */
};

char *level_name[]={"Rolling home",
		    "In the Basement",
		    "Playground",
		    "Bouncin'",
		    "Round'n Round",
		    "Offroad",
		    "Hit Me",
		    "Slippery Slide",
		    "Sokoban",
		    "Auto Reverse",
		    "The Maze",
		    "Happy New Year",
		    "Casino",
		    "Bump of Death",
		    "Stormy Monday",
		    "Cold Shots" };

char *message[]={
/* doc0 */  "Welcome to the first level of Mulg. It is your job to guide your marble to the tile marked with the '+' sign.",
/* doc1 */  "Congratulations, you just made the first level, now go for the second ...",
/* doc2 */  "Use the switches to open the doors.",
/* doc3 */  "Believe me: This level is playable!"
};


