/*
 * Simple http (web) server.
 * Jim Rees University of Michigan April 1998
 */

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <System/DataMgr.h>
#include <UI/UIAll.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/unix_string.h>

#include "httpd.h"

int send_memo_index(int fd)
{
    int i, n;
    DmOpenRef MemoDB;
    char title[42], *mp, *doctype;
    VoidHand hp;

    MemoDB = DmOpenDatabaseByTypeCreator('DATA', 'memo', dmModeReadOnly);
    if (!MemoDB) {
	send_404(fd, "/memo/");
	return;
    }

    wrstr(fd, html0, "text/html");
    wrs(fd, "<h1>Memos</h1>\nMemos:<ul>\n");

    for (n = 0; ; n++) {
	hp = DmQueryRecord(MemoDB, n);
	if (!hp)
	    break;
	mp = (char *) MemHandleLock(hp);

	/* assume html docs start with a tag */
	if (mp[0] == '<') {
	    doctype = "html";
	    sprintf(title, "%d.%s", n, doctype);
	} else {
	    doctype = "plain";
	    get_memo_title(mp, title);
	}

	MemPtrUnlock((VoidHand) mp);
	wrstr(fd, "<li> %d. <a href=\"/memo/%d.%s\">%s</a>\n", n + 1, n, doctype, title);
    }

    DmCloseDatabase(MemoDB);
    wrs(fd, "</ul><p>\n");
    wrs(fd, html_go_home);
}

send_memo_file(int fd, char *url)
{
    int n;
    DmOpenRef MemoDB;
    char doctype[20], subtype[8], *cp;
    VoidHand hp;

    MemoDB = DmOpenDatabaseByTypeCreator('DATA', 'memo', dmModeReadOnly);
    if (!MemoDB)
	goto notfound;

    if (sscanf(url, "/memo/%d.%6s", &n, subtype) != 2)
	goto notfound;

    sprintf(doctype, "text/%s", subtype);

    hp = DmQueryRecord(MemoDB, n);
    if (!hp)
	goto notfound;

    /* mime type info is encoded in the url for now */
    wrstr(fd, html0, doctype);

    cp = (char *) MemHandleLock(hp);
    wrs(fd, cp);
    MemPtrUnlock((VoidHand) cp);
    wrs(fd, "\n");
    DmCloseDatabase(MemoDB);
    return;

 notfound:
    if (MemoDB)
	DmCloseDatabase(MemoDB);
    send_404(fd, url);
    return;
}

get_memo_title(char *mp, char *title)
{
    char *cp0, *cp1;

    /* copy memo title, first line or up to 40 chars */
    for (cp0 = mp, cp1 = title; *cp0 && *cp0 != '\n' && *cp0 != '\r' && cp0 - mp < 40; )
	*cp1++ = *cp0++;
    *cp1 = '\0';
}

/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
