#ifndef PREFDB_H
#define PREFDB_H


#define kLastLength 10


/**********************/
/***** Structures *****/
/**********************/
struct PrefDBRecord
{
	ULong	modState;
	char	keymap;
	char	keyClick;
	ULong	lastTime;
	char	lastKeyDown;
	char	lastChar;
	char	smartArrow;
	int		shortcutPending;
	char	lastChars[kLastLength+1];
};
typedef struct PrefDBRecord PrefDBRecord;


DmOpenRef OpenPrefDB( void );
void ClosePrefDB( DmOpenRef dmref );
void ReadPrefDB( DmOpenRef dmref, PrefDBRecord* into );
void WritePrefDB( DmOpenRef dmref, PrefDBRecord* from );

UInt GetSerPortID( void );
void SetSerPortID( UInt serPortID );
ULong GetModState( void );
void SetModState( ULong modState );
char GetKeymap( void );
void SetKeymap( char keymap );
char GetKeyClick( void );
void SetKeyClick( char keyClick );
ULong GetLastTime( void );
void SetLastTime( ULong lastTime );
void GetLastKeyDown( ULong *theTime, char *theChar );
void SetLastKeyDown( ULong theTime, char theChar );
char GetLastChar( void );
void SetLastChar( char smartArrow );
char GetSmartArrow( void );
void SetSmartArrow( char smartArrow );
int GetShortcutPending( void );
void SetShortcutPending( int shortcutPending );
char* GetLastChars( PrefDBRecord* rec );

#endif // PREFDB_H
