#!/usr/local/bin/perl
#  $Revision: 0.1 $
#  Tatsuya Aoyagi (aoyagi@cs.uec.ac.jp)
#  $Id: maketrap.perl,v 0.1 1997/08/06 11:27:46 aoyagi Exp aoyagi $
#
# usage: maketrap trapno ...
#
# trapno is in ether decimal(123), octal (0123), or hex (0x123) in the standard C notation.

$id = 1000;
foreach $trapno (@ARGV) {
    $trapno = oct($trapno) if $trapno =~ /^0/;
    maketrap($trapno,$id);
    $id++;
}

sub maketrap {
    my ($trapno,$id) = @_;
    my ($filename);

    $filename = 'TRAP'.sprintf("%04x",$id).'.trap';
    unless (open(F,">$filename")) {
	print STDERR "can't open $filename\n";
	return;
    }
    binmode(F);
    print F pack("n",$trapno);
    close(F);
}
