/********************/
/***** KeyCodes *****/
/********************/
#define LShiftDn -72
#define LShiftUp 56
#define RShiftDn -68
#define RShiftUp 60
#define CapsDn -71
#define CapsUp 57
#define CtlDn -69
#define CtlUp 59
#define OptDn -70
#define OptUp 58
#define AppDn -73
#define AppUp 55

#define LArrowDn -5
#define RArrowDn -4
#define DArrowDn -3
#define UArrowDn -2

#define LArrowUp 123
#define RArrowUp 124
#define DArrowUp 125
#define UArrowUp 126



/***************************/
/***** Character Codes *****/
/***************************/
#define BackSpaceChar 8
#define PageUpChar 11
#define PageDnChar 12
#define EnterChar '\n'
#define LArrowChar 28
#define RArrowChar 29

#define BulletChar 149
#define TMChar 153				// Trademark
#define ShortcutChar 158
#define UpsideDownBang 161
#define PoundChar 163			// British Pound Symbol
#define YenChar 165				// Yen Symbol
#define SectionChar 167			// Stylized S section symbol
#define CopyrightChar 169		// Copyright Symbol
#define RegChar 174				// Registered Trademark
#define DegreeChar 176			// Degree Symbol
#define MuChar 181
#define PilcrowChar 182			// Paragraph Symbol

#define UpsideDownQuestion 191
#define CapitalAGrave 192
#define CapitalAAigu 193
#define CapitalACircon 194
#define CapitalATilde 195
#define CapitalATrema 196
#define CapitalADot 197
#define CapitalAEChar 198		// A and E squished together
#define CapitalCCedillaChar 199	// C with a tail
#define CapitalEGrave 200
#define CapitalEAigu 201
#define CapitalECircon 202
#define CapitalETrema 203
#define CapitalIGrave 204
#define CapitalIAigu 205
#define CapitalICircon 206
#define CapitalITrema 207

#define CapitalNTilde 209
#define CapitalOGrave 210
#define CapitalOAigu 211
#define CapitalOCircon 212
#define CapitalOTilde 213
#define CapitalOTrema 214

#define CapitalUGrave 217
#define CapitalUAigu 218
#define CapitalUCircon 219
#define CapitalUTrema 220

#define BetaChar 223
#define AGrave 224
#define AAigu 225
#define ACircon 226
#define ATilde 227
#define ATrema 228
#define ADot 229
#define AEChar 230			// A and E squished together
#define CCedillaChar 231	// C with a tail
#define EGrave 232
#define EAigu 233
#define ECircon 234
#define ETrema 235
#define IGrave 236
#define IAigu 237
#define ICircon 238
#define ITrema 239
#define NTilde 241
#define OGrave 242
#define OAigu 243
#define OCircon 244
#define OTilde 245
#define OTrema 246
#define DivideChar 247			// Division Symbol
#define NoughtChar 248
#define UGrave 249
#define UAigu 250
#define UCircon 251
#define UTrema 252

#define NextFieldChar 259
#define CommandStrokeChar 262
#define PrevFieldChar 268

#define MenuChar 261
#define AppsChar 264
#define FindChar 266
#define CalcChar 267
#define KeyboardChar 272
#define HWKey1Char 516
#define HWKey2Char 517
#define HWKey3Char 518
#define HWKey4Char 519
#define PowerChar 520


/* New character codes
` - 145
' - 146
`` - 147
'' - 148
cents - 162
Integral/Script F - 131

Menu - 261,0,8
Apps - 264,0,8
Find - 266,0,8
Calculator - 267,0,8
Full Screen Stroke - 270/271,0,8
Keyboard - 272,0,8
Numbers - 273,0,8
Auto-Off - 276

HW1 - 516,0,8
HW2 - 517,0,8
HW3 - 518,0,8
HW4 - 519,0,8
Power - 520,0,8
HotSync - 521,0,8
*/


static const char DecodeTblDvorak[] = 
{ 
BackSpaceChar, // 77
'`', // 78
' ', // 79
'\t', // 80
'v', // 81
'm', // 82
'b', // 83
'z', // 84
'w', // 85
'\\', // 86
's', // 87
't', // 88
'-', // 89
'h', // 90
'n', // 91
EnterChar, // 92
'l', // 93
'c', // 94
'/', // 95
'g', // 96
'r', // 97
'=', // 98
'0', // 99
'8', // 100
'[', // 101
'7', // 102
'9', // 103
']', // 104
'5', // 105
'6', // 106
'4', // 107
'3', // 108
'2', // 109
'1', // 110
'y', // 111
'f', // 112
'p', // 113
'.', // 114
',', // 115
'\'', // 116
'x', // 117
0, // 118 - no char
'k', // 119
'j', // 120
'q', // 121
';', // 122
'i', // 123
'd', // 124
'u', // 125
'e', // 126
'o', // 127
'a' // 128
};


static const char DecodeTblShfDvorak[] = 
{ 
BackSpaceChar, // 77
'~', // 78
' ', // 79
'\t', // 80
'V', // 81
'M', // 82
'B', // 83
'Z', // 84
'W', // 85
'|', // 86
'S', // 87
'T', // 88
'_', // 89
'H', // 90
'N', // 91
EnterChar, // 92
'L', // 93
'C', // 94
'?', // 95
'G', // 96
'R', // 97
'+', // 98
')', // 99
'*', // 100
'{', // 101
'&', // 102
'(', // 103
'}', // 104
'%', // 105
'^', // 106
'$', // 107
'#', // 108
'@', // 109
'!', // 110
'Y', // 111
'F', // 112
'P', // 113
'>', // 114
'<', // 115
'"', // 116
'X', // 117
0, // 118 - no char
'K', // 119
'J', // 120
'Q', // 121
':', // 122
'I', // 123
'D', // 124
'U', // 125
'E', // 126
'O', // 127
'A' // 128
};


static const char DecodeTblOptDvorak[] = 
{ 
BackSpaceChar, // 77
0, // 78
0, // 79
0, // 80
0, // 81
0, // 82
BetaChar, // 83
ShortcutChar, // 84
0, // 85
0, // 86
SectionChar, // 87
TMChar, // 88
0, // 89
0, // 90
0, // 91
0, // 92
0, // 93
CCedillaChar, // 94
DivideChar, // 95
CopyrightChar, // 96
RegChar, // 97
0, // 98
0, // 99
0, // 100
0, // 101
0, // 102
0, // 103
0, // 104
0, // 105
0, // 106
0, // 107
0, // 108
0, // 109
0, // 110
YenChar, // 111
0, // 112
PoundChar, // 113
0, // 114
0, // 115
0, // 116
0, // 117
0, // 118 - no char
0, // 119
0, // 120
BulletChar, // 121
0, // 122
0, // 123
DegreeChar, // 124
MuChar, // 125
0, // 126
NoughtChar, // 127
AEChar // 128
};





static const char DecodeTblQWERTY[] = 
{ 
BackSpaceChar, // 77
'`', // 78
' ', // 79
'\t', // 80
'.', // 81
'm', // 82
'n', // 83
'/', // 84
',', // 85
'\\', // 86
';', // 87
'k', // 88
'\'', // 89
'j', // 90
'l', // 91
EnterChar, // 92
'p', // 93
'i', // 94
'[', // 95
'u', // 96
'o', // 97
']', // 98
'0', // 99
'8', // 100
'-', // 101
'7', // 102
'9', // 103
'=', // 104
'5', // 105
'6', // 106
'4', // 107
'3', // 108
'2', // 109
'1', // 110
't', // 111
'y', // 112
'r', // 113
'e', // 114
'w', // 115
'q', // 116
'b', // 117
0, // 118 - no char
'v', // 119
'c', // 120
'x', // 121
'z', // 122
'g', // 123
'h', // 124
'f', // 125
'd', // 126
's', // 127
'a' // 128
};


static const char DecodeTblShfQWERTY[] = 
{ 
BackSpaceChar, // 77
'~', // 78
' ', // 79
'\t', // 80
'>', // 81
'M', // 82
'N', // 83
'?', // 84
'<', // 85
'|', // 86
':', // 87
'K', // 88
'"', // 89
'J', // 90
'L', // 91
EnterChar, // 92
'P', // 93
'I', // 94
'{', // 95
'U', // 96
'O', // 97
'}', // 98
')', // 99
'*', // 100
'_', // 101
'&', // 102
'(', // 103
'+', // 104
'%', // 105
'^', // 106
'$', // 107
'#', // 108
'@', // 109
'!', // 110
'T', // 111
'Y', // 112
'R', // 113
'E', // 114
'W', // 115
'Q', // 116
'B', // 117
0, // 118 - no char
'V', // 119
'C', // 120
'X', // 121
'Z', // 122
'G', // 123
'H', // 124
'F', // 125
'D', // 126
'S', // 127
'A' // 128
};


static const char DecodeTblOptQWERTY[] = 
{ 
BackSpaceChar, // 77
0, // 78
0, // 79
0, // 80
0, // 81
0, // 82
0, // 83
DivideChar, // 84
0, // 85
0, // 86
0, // 87
0, // 88
0, // 89
0, // 90
0, // 91
PilcrowChar, // 92
PoundChar, // 93
0, // 94
0, // 95
MuChar, // 96
NoughtChar, // 97
0, // 98
0, // 99
0, // 100
0, // 101
0, // 102
0, // 103
0, // 104
0, // 105
0, // 106
0, // 107
0, // 108
0, // 109
0, // 110
TMChar, // 111
YenChar, // 112
RegChar, // 113
0, // 114
0, // 115
BulletChar, // 116
BetaChar, // 117
0, // 118 - no char
0, // 119
CCedillaChar, // 120
0, // 121
ShortcutChar, // 122
CopyrightChar, // 123
0, // 124
0, // 125
DegreeChar, // 126
SectionChar, // 127
AEChar // 128
};
