/*
 * DB: Database Program for Pilot
 * Copyright (C) 1998  by Tom Dyas (tdyas@vger.rutgers.edu)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "enum.h"
#include "callback.h"
#include "db.h"

static Boolean
AppHandleEvent(EventPtr event)
{
    Word formID;
    FormPtr form;

    if (event->eType == frmLoadEvent) {
	formID = event->data.frmLoad.formID;
	form = FrmInitForm(formID);
	FrmSetActiveForm(form);
	switch (formID) {
	case formID_Chooser:
	    FrmSetEventHandler(form, (FormEventHandlerPtr) ChooserHandleEvent);
	    break;
	case formID_DesignView:
	    FrmSetEventHandler(form, (FormEventHandlerPtr) DesignViewHandleEvent);
	    break;
	case formID_DesignView_SelectField:
	    FrmSetEventHandler(form, (FormEventHandlerPtr) SelectFieldHandleEvent);
	    break;
	case formID_ListView:
	    FrmSetEventHandler(form, (FormEventHandlerPtr) ListViewHandleEvent);
	    break;
	case formID_EditView:
	    FrmSetEventHandler(form, (FormEventHandlerPtr) EditViewHandleEvent);
	    break;
	case formID_ListPropView:
	    FrmSetEventHandler(form, (FormEventHandlerPtr) ListPropViewHandleEvent);
	    break;
	default:
	    ErrDisplay("unknown form ID");
	    return false;
	}
	return true;
    }
    return false;
}

static void
EventLoop(void)
{
    Word err;
    EventType event;

    do {
	EvtGetEvent(&event, evtWaitForever);

	if (!SysHandleEvent(&event))
	    if (!MenuHandleEvent((void *)0, &event, &err))
		if (!AppHandleEvent(&event))
		    FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);
}

static void
StopApplication(void)
{
    FrmCloseAllForms();
    if (CurrentDB)
	CloseDatabase();
}

DWord
PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
    if (cmd == sysAppLaunchCmdNormalLaunch) {
	FrmGotoForm(formID_Chooser);
	EventLoop();
	StopApplication();
    }
    return 0;
}
