/*
 * DB: Database I/O code
 * Copyright (C) 1998  by Tom Dyas (tdyas@vger.rutgers.edu)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "db.h"

DmOpenRef CurrentDB;
DBInfoType dbInfo;

void
OpenDatabase(UInt cardNo, LocalID dbID)
{
    LocalID appInfoID;
    DBAppInfoPtr appInfoPtr;

    ErrFatalDisplayIf(CurrentDB != 0, "DB already open");
    CurrentDB = DmOpenDatabase(cardNo, dbID, dmModeReadWrite);
    ErrFatalDisplayIf(CurrentDB == 0, "unable to open DB");

    /* Retrieve the app info block and copy to local storage. */
    appInfoID = DmGetAppInfoID(CurrentDB);
    appInfoPtr = MemLocalIDToLockedPtr(appInfoID, cardNo);
    MemMove(&dbInfo, &(appInfoPtr->dbinfo), sizeof(DBInfoType));
    MemPtrUnlock(appInfoPtr);
}

void
CloseDatabase(void)
{
    ErrFatalDisplayIf(CurrentDB == 0, "DB already closed");
    DmCloseDatabase(CurrentDB);
    CurrentDB = 0;
}

void
CreateDatabase(CharPtr name, DBInfoPtr info)
{
    Err err;
    VoidHand appInfoHand;
    LocalID dbID, appInfoID;
    DmOpenRef db;
    DBAppInfoPtr appInfo;

    err = DmCreateDatabase(0, name, 'TKD3', DBTypeID, false);
    if (err)
	return;

    dbID = DmFindDatabase(0, name);

    db = DmOpenDatabase(0, dbID, dmModeReadWrite);
    if (db == 0)
	return;

    /* Create an application information block for this database. */
    appInfoHand = DmNewHandle(db, sizeof(DBAppInfoType));
    appInfoID = MemHandleToLocalID(appInfoHand);
    appInfo = MemLocalIDToLockedPtr(appInfoID, 0);
    DmWrite(appInfo, 0, info, sizeof(DBInfoType));
    MemPtrUnlock(appInfo);

    DmSetDatabaseInfo(0, dbID, 0, 0, 0, 0, 0, 0, 0, &appInfoID, 0, 0, 0);
    DmCloseDatabase(db);
}

static void
UnpackRecord(VoidPtr packed, DBRecordPtr unpacked)
{
    CharPtr rec = packed;
    Word i;

    for (i = 0; i < dbInfo.numFields; i++) {
	unpacked->field[i] = rec;
	rec += StrLen(rec) + 1;
    }
}

void
PackRecord(DBRecordPtr unpacked, VoidPtr packed)
{
    Word i;
    ULong offset = 0;

    for (i = 0; i < dbInfo.numFields; i++) {
	DmWrite(packed, offset, unpacked->field[i],
		StrLen(unpacked->field[i]) + 1);
	offset += StrLen(unpacked->field[i]) + 1;
    }
}

Err
GetRecord(Word index, DBRecordPtr unpacked, VoidHand * handleP)
{
    VoidHand handle;
    VoidPtr packed;

    handle = DmQueryRecord(CurrentDB, index);
    ErrFatalDisplayIf(handle == 0, "handle is NULL");
    packed = MemHandleLock(handle);
    ErrFatalDisplayIf(packed == 0, "packed is NULL");
    UnpackRecord(packed, unpacked);
    if (handleP) {
	*handleP = handle;
    }
    return 0;
}
