# NAME

App::Greple::xlate — модуль поддержки перевода для greple

# SYNOPSIS

    greple -Mxlate::deepl --xlate pattern target-file

    greple -Mxlate::gpt4 --xlate pattern target-file

    greple -Mxlate::gpt5 --xlate pattern target-file

    greple -Mxlate --xlate-engine gpt5 --xlate pattern target-file

# VERSION

Version 0.9922

# DESCRIPTION

**Greple** **xlate** модуль находит нужные текстовые блоки и заменяет их переведенным текстом. В настоящее время модули DeepL (`deepl.pm`), ChatGPT 4.1 (`gpt4.pm`) и GPT-5 (`gpt5.pm`) реализованы как серверные движки.

Если вы хотите переводить обычные текстовые блоки в документе, написанном в стиле pod языка Perl, используйте команду **greple** с модулями `xlate::deepl` и `perl` следующим образом:

    greple -Mxlate::deepl -Mperl --pod --re '^([\w\pP].*\n)+' --all foo.pm

В этой команде строка шаблона `^([\w\pP].*\n)+` означает последовательные строки, начинающиеся с буквенно-цифрового символа и знака пунктуации. Эта команда показывает подсвеченную область для перевода. Опция **--all** используется для вывода всего текста.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/select-area.png">
    </p>
</div>

Затем добавьте опцию `--xlate` для перевода выбранной области. После этого будут найдены нужные разделы и заменены выводом команды **deepl**.

По умолчанию исходный и переведенный текст выводятся в формате «маркер конфликта», совместимом с [git(1)](http://man.he.net/man1/git). Используя формат `ifdef`, вы можете легко получить нужную часть командой [unifdef(1)](http://man.he.net/man1/unifdef). Формат вывода можно указать опцией **--xlate-format**.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/format-conflict.png">
    </p>
</div>

Если вы хотите перевести весь текст, используйте опцию **--match-all**. Это сокращение для указания шаблона `(?s).+`, который соответствует всему тексту.

Данные в формате маркеров конфликтов можно просматривать в поколоночном виде командой [sdif](https://metacpan.org/pod/App%3A%3Asdif) с опцией `-V`. Поскольку не имеет смысла сравнивать построчно, рекомендуется опция `--no-cdif`. Если вам не нужно раскрашивание текста, укажите `--no-textcolor` (или `--no-tc`).

    sdif -V --no-filename --no-tc --no-cdif data_shishin.deepl-EN-US.cm

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/sdif-cm-view.png">
    </p>
</div>

# NORMALIZATION

Обработка выполняется в заданных единицах, но в случае последовательности из нескольких строк непустого текста они преобразуются вместе в одну строку. Эта операция выполняется следующим образом:

- Удалите пробелы в начале и в конце каждой строки.
- Если строка заканчивается полноширинным знаком препинания, объедините с следующей строкой.
- Если строка заканчивается полноширинным символом и следующая строка начинается полноширинным символом, объедините строки.
- Если либо конец, либо начало строки не является полноширинным символом, объедините их, вставив пробел.

Данные кэша управляются на основе нормализованного текста, поэтому даже если вносятся изменения, не влияющие на результаты нормализации, кэшированные данные перевода останутся эффективными.

Этот процесс нормализации выполняется только для первого (0-го) и четных шаблонов. Таким образом, если указаны два шаблона, как показано ниже, текст, соответствующий первому шаблону, будет обработан после нормализации, а к тексту, соответствующему второму шаблону, процесс нормализации применяться не будет.

    greple -Mxlate -E normalized -E not-normalized

Поэтому используйте первый шаблон для текста, который должен обрабатываться путем объединения нескольких строк в одну, а второй — для предварительно форматированного текста. Если в первом шаблоне нет текста для совпадения, используйте шаблон, который ни с чем не совпадает, например `(?!)`.

# MASKING

Иногда встречаются части текста, которые не нужно переводить. Например, теги в файлах Markdown. DeepL рекомендует в таких случаях преобразовать исключаемую часть текста в XML‑теги, выполнить перевод, а затем восстановить её после завершения перевода. Для поддержки этого можно указать части, которые следует маскировать от перевода.

    --xlate-setopt maskfile=MASKPATTERN

Каждая строка файла \`MASKPATTERN\` будет интерпретироваться как регулярное выражение, соответствующие ему строки будут переведены и восстановлены после обработки. Строки, начинающиеся с `#`, игнорируются.

Сложный шаблон можно записывать на нескольких строках с экранированным обратной косой чертой переводом строки.

То, как текст преобразуется при маскировании, можно увидеть с опцией **--xlate-mask**.

Этот интерфейс является экспериментальным и может измениться в будущем.

# OPTIONS

- **--xlate**
- **--xlate-color**
- **--xlate-fold**
- **--xlate-fold-width**=_n_ (Default: 70)

    Запустить процесс перевода для каждой совпавшей области.

    Без этой опции **greple** работает как обычная команда поиска. Так вы можете проверить, какая часть файла будет подвергнута переводу, прежде чем запускать фактическую работу.

    Результат команды выводится в стандартный вывод, поэтому при необходимости перенаправьте в файл или рассмотрите использование модуля [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate).

    Опция **--xlate** вызывает опцию **--xlate-color** с опцией **--color=never**.

    С опцией **--xlate-fold** преобразованный текст переносится по указанной ширине. Ширина по умолчанию — 70 и может быть задана опцией **--xlate-fold-width**. Четыре столбца зарезервированы для операции run‑in, поэтому каждая строка может содержать максимум 74 символа.

- **--xlate-engine**=_engine_

    Указывает, какой использовать движок перевода. Если вы укажете модуль движка напрямую, например `-Mxlate::deepl`, эту опцию можно не использовать.

    В настоящее время доступны следующие движки

    - **deepl**: DeepL API
    - **gpt3**: gpt-3.5-turbo
    - **gpt4**: gpt-4.1
    - **gpt4o**: gpt-4o-mini

        Интерфейс **gpt-4o** нестабилен и на данный момент не гарантирует корректную работу.

    - **gpt5**: gpt-5

- **--xlate-labor**
- **--xlabor**

    Вместо вызова движка перевода предполагается, что вы выполните работу вручную. После подготовки текста к переводу он копируется в буфер обмена. Ожидается, что вы вставите его в форму, скопируете результат в буфер обмена и нажмёте Enter.

- **--xlate-to** (Default: `EN-US`)

    Укажите целевой язык. Доступные языки можно получить командой `deepl languages` при использовании движка **DeepL**.

- **--xlate-format**=_format_ (Default: `conflict`)

    Укажите формат вывода для исходного и переведённого текста.

    Следующие форматы, кроме `xtxt`, предполагают, что часть для перевода представляет собой набор строк. Фактически возможно переводить только часть строки, но указание формата, отличного от `xtxt`, не даст осмысленных результатов.

    - **conflict**, **cm**

        Исходный и преобразованный текст выводятся в формате конфликтных маркеров [git(1)](http://man.he.net/man1/git).

            <<<<<<< ORIGINAL
            original text
            =======
            translated Japanese text
            >>>>>>> JA

        Вы можете восстановить исходный файл следующей командой [sed(1)](http://man.he.net/man1/sed).

            sed -e '/^<<<<<<< /d' -e '/^=======$/,/^>>>>>>> /d'

    - **colon**, _:::::::_

        Исходный и переведённый текст выводятся в стиле пользовательского контейнера markdown.

            ::::::: ORIGINAL
            original text
            :::::::
            ::::::: JA
            translated Japanese text
            :::::::

        Приведённый выше текст будет преобразован в HTML следующим образом.

            <div class="ORIGINAL">
            original text
            </div>
            <div class="JA">
            translated Japanese text
            </div>

        Количество двоеточий по умолчанию — 7. Если указать последовательность двоеточий, такую как `:::::`, она будет использована вместо 7 двоеточий.

    - **ifdef**

        Исходный и преобразованный текст выводятся в формате [cpp(1)](http://man.he.net/man1/cpp) `#ifdef`.

            #ifdef ORIGINAL
            original text
            #endif
            #ifdef JA
            translated Japanese text
            #endif

        Вы можете получить только японский текст с помощью команды **unifdef**:

            unifdef -UORIGINAL -DJA foo.ja.pm

    - **space**
    - **space+**

        Исходный и преобразованный текст выводятся, разделённые одной пустой строкой. Для `space+` после преобразованного текста также выводится перевод строки.

    - **xtxt**

        Если формат — `xtxt` (переведённый текст) или неизвестный, выводится только переведённый текст.

- **--xlate-maxlen**=_chars_ (Default: 0)

    Укажите максимальную длину текста, отправляемого в API за один раз. Значение по умолчанию установлено для бесплатного сервиса DeepL: 128K для API (**--xlate**) и 5000 для интерфейса буфера обмена (**--xlate-labor**). Вы можете изменить эти значения при использовании Pro-сервиса.

- **--xlate-maxline**=_n_ (Default: 0)

    Укажите максимальное количество строк текста, отправляемых в API за один раз.

    Установите значение 1, если хотите переводить по одной строке за раз. Этот параметр имеет приоритет над опцией `--xlate-maxlen`.

- **--xlate-prompt**=_text_

    Укажите пользовательский промпт, отправляемый в движок перевода. Эта опция доступна только при использовании движков ChatGPT (gpt3, gpt4, gpt4o). Вы можете настроить поведение перевода, предоставив конкретные инструкции модели ИИ. Если промпт содержит `%s`, он будет заменён названием целевого языка.

- **--xlate-context**=_text_

    Укажите дополнительную контекстную информацию, передаваемую движку перевода. Эту опцию можно указывать несколько раз для передачи нескольких контекстных строк. Контекст помогает движку перевода понимать фон и выдавать более точные переводы.

- **--xlate-glossary**=_glossary_

    Укажите идентификатор глоссария для использования при переводе. Эта опция доступна только при использовании движка DeepL. Идентификатор глоссария должен быть получен в вашем аккаунте DeepL и обеспечивает единообразный перевод специальных терминов.

- **--**\[**no-**\]**xlate-progress** (Default: True)

    Смотрите результат перевода в реальном времени в выводе STDERR.

- **--xlate-stripe**

    Используйте модуль [App::Greple::stripe](https://metacpan.org/pod/App%3A%3AGreple%3A%3Astripe) для подсветки совпавших частей в виде зебры. Это полезно, когда совпавшие части идут вплотную друг к другу.

    Палитра цветов переключается в зависимости от фонового цвета терминала. Если хотите указать явно, используйте **--xlate-stripe-light** или **--xlate-stripe-dark**.

- **--xlate-mask**

    Выполнить маскирование и вывести преобразованный текст как есть, без восстановления.

- **--match-all**

    Установить весь текст файла как целевую область.

- **--lineify-cm**
- **--lineify-colon**

    В форматах `cm` и `colon` вывод разбивается и форматируется построчно. Поэтому, если требуется перевести только часть строки, ожидаемый результат получить нельзя. Эти фильтры исправляют вывод, искажённый переводом части строки, приводя его к нормальному построчному виду.

    В текущей реализации, если переводятся несколько частей одной строки, они выводятся как независимые строки.

# CACHE OPTIONS

Модуль **xlate** может кэшировать переводы для каждого файла и читать их перед выполнением, чтобы устранить накладные расходы на обращение к серверу. С стратегией кэширования по умолчанию `auto` кэш поддерживается только если для целевого файла существует кэш-файл.

Используйте **--xlate-cache=clear** для инициализации управления кэшем или очистки всех существующих кэш-данных. После выполнения с этой опцией новый кэш-файл будет создан, если его ещё нет, и впоследствии будет автоматически поддерживаться.

- --xlate-cache=_strategy_
    - `auto` (Default)

        Поддерживать кэш-файл, если он существует.

    - `create`

        Создать пустой кэш-файл и выйти.

    - `always`, `yes`, `1`

        В любом случае поддерживать кеш, если целевой объект — обычный файл.

    - `clear`

        Сначала очистите данные кеша.

    - `never`, `no`, `0`

        Никогда не используйте файл кеша, даже если он существует.

    - `accumulate`

        По умолчанию неиспользуемые данные удаляются из файла кеша. Если вы не хотите их удалять и хотите сохранить в файле, используйте `accumulate`.
- **--xlate-update**

    Эта опция принудительно обновляет файл кеша, даже если в этом нет необходимости.

# COMMAND LINE INTERFACE

Вы можете легко использовать этот модуль из командной строки с помощью команды `xlate`, включенной в дистрибутив. См. страницу руководства `xlate` для использования.

Команда `xlate` поддерживает длинные параметры в стиле GNU, такие как `--to-lang`, `--from-lang`, `--engine` и `--file`. Используйте `xlate -h` для просмотра всех доступных параметров.

Команда `xlate` работает совместно со средой Docker, поэтому, даже если у вас ничего не установлено, вы можете использовать её при наличии Docker. Используйте опцию `-D` или `-C`.

Операции Docker обрабатываются скриптом `dozo`, который также можно использовать как отдельную команду. Скрипт `dozo` поддерживает конфигурационный файл `.dozorc` для постоянных настроек контейнера.

Кроме того, поскольку предоставлены makefile-файлы для различных стилей документов, перевод на другие языки возможен без специальной настройки. Используйте опцию `-M`.

Вы также можете комбинировать опции Docker и `make`, чтобы запускать `make` в среде Docker.

Запуск вида `xlate -C` откроет оболочку с примонтированным текущим рабочим репозиторием git.

Подробности см. в японской статье в разделе ["SEE ALSO"](#see-also).

# EMACS

Загрузите файл `xlate.el`, включённый в репозиторий, чтобы использовать команду `xlate` из редактора Emacs. Функция `xlate-region` переводит заданный регион. Язык по умолчанию — `EN-US`, а язык можно указать, вызывая её с префиксным аргументом.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/emacs.png">
    </p>
</div>

# ENVIRONMENT

- DEEPL\_AUTH\_KEY

    Установите свой ключ аутентификации для сервиса DeepL.

- OPENAI\_API\_KEY

    Ключ аутентификации OpenAI.

# INSTALL

## CPANMINUS

    $ cpanm App::Greple::xlate

## TOOLS

Необходимо установить инструменты командной строки для DeepL и ChatGPT.

[https://github.com/DeepLcom/deepl-python](https://github.com/DeepLcom/deepl-python)

[https://github.com/tecolicom/App-gpty](https://github.com/tecolicom/App-gpty)

# SEE ALSO

[App::Greple::xlate](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate)

[App::Greple::xlate::deepl](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Adeepl)

[App::Greple::xlate::gpt4](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Agpt4)

[App::Greple::xlate::gpt5](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Agpt5)

- [https://hub.docker.com/r/tecolicom/xlate](https://hub.docker.com/r/tecolicom/xlate)

    Образ контейнера Docker.

- [https://github.com/tecolicom/getoptlong](https://github.com/tecolicom/getoptlong)

    Библиотека `getoptlong.sh` используется для разбора опций в скриптах `xlate` и `dozo`.

- [https://github.com/DeepLcom/deepl-python](https://github.com/DeepLcom/deepl-python)

    Библиотека DeepL на Python и утилита CLI.

- [https://github.com/openai/openai-python](https://github.com/openai/openai-python)

    Библиотека OpenAI для Python

- [https://github.com/tecolicom/App-gpty](https://github.com/tecolicom/App-gpty)

    Интерфейс командной строки OpenAI

- [App::Greple](https://metacpan.org/pod/App%3A%3AGreple)

    См. руководство **greple** для подробностей о целевом шаблоне текста. Используйте опции **--inside**, **--outside**, **--include**, **--exclude** для ограничения области сопоставления.

- [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate)

    Вы можете использовать модуль `-Mupdate` для изменения файлов по результатам команды **greple**.

- [App::sdif](https://metacpan.org/pod/App%3A%3Asdif)

    Используйте **sdif** для отображения формата маркера конфликта рядом с опцией **-V**.

- [App::Greple::stripe](https://metacpan.org/pod/App%3A%3AGreple%3A%3Astripe)

    Модуль Greple **stripe** используется опцией **--xlate-stripe**.

## ARTICLES

- [https://qiita.com/kaz-utashiro/items/1c1a51a4591922e18250](https://qiita.com/kaz-utashiro/items/1c1a51a4591922e18250)

    Модуль Greple для перевода и замены только необходимых частей с помощью API DeepL (на японском)

- [https://qiita.com/kaz-utashiro/items/a5e19736416ca183ecf6](https://qiita.com/kaz-utashiro/items/a5e19736416ca183ecf6)

    Генерация документов на 15 языках с модулем API DeepL (на японском)

- [https://qiita.com/kaz-utashiro/items/1b9e155d6ae0620ab4dd](https://qiita.com/kaz-utashiro/items/1b9e155d6ae0620ab4dd)

    Среда Docker для автоматического перевода с API DeepL (на японском)

# AUTHOR

Kazumasa Utashiro

# LICENSE

Copyright © 2023-2025 Kazumasa Utashiro.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
