package
	Schema; # Hide from PAUSE. This is just an example.

our $VERSION =  0;



#CHECK LIST:
# Pay attention when column is renamed: you probably should use RENAME instead
# of DROP/ADD

use strict;
use warnings;

# based on the DBIx::Class Schema base class
use base qw/ DBIx::Class::Schema /;



# This will load any classes within
# Schema::Result and Schema::ResultSet (if any)
__PACKAGE__->load_namespaces(
	default_resultset_class =>  'ResultSet'
);



1;

=encoding utf8

=head1 NAME

Schema - Example DBIx::Class schema used by the D distribution

=head1 SYNOPSIS

  # DbAccess configuration (example)
  {
    DbAccess => {
      schema => 'Schema',
      # ... DSN/USER/PASS or DRVR/NAME/HOST/PORT ...
    }
  }

=head1 DESCRIPTION

This module is an example L<DBIx::Class::Schema> base class shipped with the
distribution.

It is intentionally minimal and is marked as an example (hidden from PAUSE).
Real applications are expected to provide their own schema classes.

=head1 METHODS

=head2 load_namespaces

This schema uses C<load_namespaces> and sets C<default_resultset_class> to
L<Schema::ResultSet>.

=head1 SEE ALSO

L<D>, L<DBIx::Class::Schema>, L<Schema::Result>, L<Schema::ResultSet>

=cut
