package Daje::Workflow::Config;
use v5.40;
use Mojo::Base -base;

# NAME
# ====
#
# Daje::Workflow::Config - Loads the JSON based configs and put them in a hash
#
# SYNOPSIS
# ========
#
#    use Daje::Workflow::Config;
#
#    # Single file
#    my $config = Daje::Workflow::Config->new(
#       path => "path",
#    )->load($filename);
#
#    my $parameter = "key";
#
#    my $value = $config->param($parameter);
#
#    my $parameter = "key1.key2";
#
#    my $value = $config->param($parameter);
#
# DESCRIPTION
# ===========
#
# Daje::Config is loading workflows from JSON files in a set folder
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

our $VERSION = "0.02";

use Daje::Config;
use Mojo::File;

has 'path' => "";
has 'config';
has 'error' => '';

sub load($self, $filename) {

    try {
        my $config = Daje::Config->new(
            path => $self->path,
        )->load($filename);
        my $path = Mojo::File->new($self->path . $filename);
        my $tag = substr($path->basename(), 0, index($path->basename(), '.json'));
        $self->config($config->{$tag});
    } catch($e) {
        $self->error($e);
    };

    return $self;
}

sub param($self, $parameter) {
    my $result = "";

    if (index($parameter,'.') == -1) {
        try {
            $result = $self->config->{$parameter};
        }
        catch ($e) {
            $self->error($e);
        };
    } else {
        try {
            while (index($parameter,'.') > -1) {
                my $key = substr($parameter, 0, index($parameter, '.'));
                $result = $self->config->{$key};
                $parameter = substr($parameter, rindex($parameter, '.') + 1);
            }
            $result = $result->{$parameter};
        } catch($e) {
            $self->error($e);
        }
    }

    return $result;
}


1;
__END__









#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Config - Loads the JSON based configs and put them in a hash



=head1 SYNOPSIS


   use Daje::Workflow::Config;

   # Single file
   my $config = Daje::Workflow::Config->new(
      path => "path",
   )->load($filename);

   my $parameter = "key";

   my $value = $config->param($parameter);

   my $parameter = "key1.key2";

   my $value = $config->param($parameter);



=head1 DESCRIPTION


Daje::Config is loading workflows from JSON files in a set folder



=head1 REQUIRES

L<Mojo::File> 

L<Daje::Config> 

L<Mojo::Base> 

L<v5.40> 


=head1 METHODS

=head2 load($self,

 load($self,();

=head2 param($self,

 param($self,();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

