package config::Manual;
# Используется только для документирования, т.к. config занят и в поиске не участвует

1;

__END__

=encoding utf-8

=head1 NAME

config - Perl module constant configurator

=head1 SYNOPSIS

File lib/My/Query.pm:

	package My::Query;
	
	use config DB_NAME => "mizericordia";
	use config DB_HOST => "192.168.0.1";
	
	use config {
	    DB_USER => "root",
	    DB_PASSWORD => "pass",
	};
	
	our $connect = "mysql://" . DB_USER . ":" . DB_PASSWORD . "\@" . DB_HOST . "/" . DB_NAME;
	
	1;

.config.pm file:

	package config;
	
	config 'My::Query' => (
	    DB_HOST => "mydb.com",
	);
	
	1;

What should happen:

	use lib 'lib';
	use My::Query;
	
	$My::Query::connect # \> mysql://root:pass@mydb.com/mizericordia

=head1 DESCRIPTION

C<use config> creates a constant in the same way as C<use constant>, but takes the value from the project's local config file if one is specified there.

The config file B<./.config.pm> is located in the root directory of the project.

The current directory in the project must correspond to the project root.

Since the C<config.pm> pragma module is overridden on <metacpan.org> by the C<config.pod> file from the C<WordNet-Similarity> package, this manual (C<config::Manual>) is used.

=head1 METHODS

=head2 import ($name, [$value])

	# Одна константа
	use config A => 10;
	
	# Много констант:
	use config {
	    B => 3,
	    C => 4,
	};
	
	A # => 10
	B # => 3
	C # => 4
	
	# И в рантайме:
	config->import('D' => 5);
	
	D() # => 5
	
	# Без параметров:
	use config;

=head2 config MODULE => (...)

The function is used in the config file (B<./.config.pm>) to configure Perl modules. For config it should start with C<package config;>.

	config::config 'main' => (
	    D => 10,
	    X => 12,
	);
	
	config->import('X' => 15);
	
	D() # => 5
	X() # => 12

=head1 AUTHOR

Yaroslav O. Kosmina L<mailto:dart@cpan.org>

=head1 LICENSE

⚖ B<Perl5>

=head1 COPYRIGHT

The config module is copyright (c) 2023 Yaroslav O. Kosmina. Rusland. All rights reserved.
